/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.https;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.string.ModifiableString;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.https.HttpsResponseHandler;
import de.rub.nds.tlsattacker.core.https.header.ContentLengthHeader;
import de.rub.nds.tlsattacker.core.https.header.DateHeader;
import de.rub.nds.tlsattacker.core.https.header.ExpiresHeader;
import de.rub.nds.tlsattacker.core.https.header.GenericHttpsHeader;
import de.rub.nds.tlsattacker.core.https.header.HostHeader;
import de.rub.nds.tlsattacker.core.https.header.HttpsHeader;
import de.rub.nds.tlsattacker.core.https.header.LocationHeader;
import de.rub.nds.tlsattacker.core.https.header.TokenBindingHeader;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

public class HttpsResponseMessage
extends ProtocolMessage {
    private ModifiableString responseProtocol;
    private ModifiableString responseStatusCode;
    private ModifiableString responseContent;
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=GenericHttpsHeader.class, name="HttpsHeader"), @XmlElement(type=ContentLengthHeader.class, name="ContentLengthHeader"), @XmlElement(type=DateHeader.class, name="DateHeader"), @XmlElement(type=ExpiresHeader.class, name="ExpiresHeader"), @XmlElement(type=LocationHeader.class, name="LocationHeader"), @XmlElement(type=HostHeader.class, name="HostHeader"), @XmlElement(type=TokenBindingHeader.class, name="TokenBindingHeader")})
    @HoldsModifiableVariable
    private List<HttpsHeader> header;

    public HttpsResponseMessage() {
        this.protocolMessageType = ProtocolMessageType.APPLICATION_DATA;
        this.header = new LinkedList<HttpsHeader>();
    }

    public HttpsResponseMessage(Config config) {
        this.protocolMessageType = ProtocolMessageType.APPLICATION_DATA;
        this.header = new LinkedList<HttpsHeader>();
        this.header.add(new GenericHttpsHeader("Content-Type", "text/html; charset=UTF-8"));
        this.header.add(new LocationHeader());
        this.header.add(new ContentLengthHeader());
        this.header.add(new DateHeader());
        this.header.add(new ExpiresHeader());
        this.header.add(new GenericHttpsHeader("Cache-Control", "private, max-age=0"));
        this.header.add(new GenericHttpsHeader("Server", "GSE"));
    }

    public ModifiableString getResponseProtocol() {
        return this.responseProtocol;
    }

    public void setResponseProtocol(ModifiableString responseProtocol) {
        this.responseProtocol = responseProtocol;
    }

    public void setResponseProtocol(String responseProtocol) {
        this.responseProtocol = ModifiableVariableFactory.safelySetValue((ModifiableString)this.responseProtocol, (String)responseProtocol);
    }

    public ModifiableString getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseStatusCode(ModifiableString responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public void setResponseStatusCode(String responseStatusCode) {
        this.responseStatusCode = ModifiableVariableFactory.safelySetValue((ModifiableString)this.responseStatusCode, (String)responseStatusCode);
    }

    public ModifiableString getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(ModifiableString responseContent) {
        this.responseContent = responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = ModifiableVariableFactory.safelySetValue((ModifiableString)this.responseContent, (String)responseContent);
    }

    public List<HttpsHeader> getHeader() {
        return this.header;
    }

    public void setHeader(List<HttpsHeader> header) {
        this.header = header;
    }

    @Override
    public String toCompactString() {
        return "HttpsResponseMessage";
    }

    @Override
    public HttpsResponseHandler getHandler(TlsContext context) {
        return new HttpsResponseHandler(context);
    }
}

