/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.internal.QuotaProjectIdHidingCredentials;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.api.pathtemplate.PathTemplate;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.Tuple;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.storage.GrpcRetryAlgorithmManager;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.OpenTelemetryBootstrappingUtils;
import com.google.cloud.storage.ResponseContentLifecycleHandle;
import com.google.cloud.storage.ResponseContentLifecycleManager;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageFactory;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.XGoogApiClientHeaderProvider;
import com.google.cloud.storage.spi.StorageRpcFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeByteOperations;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StorageClient;
import com.google.storage.v2.StorageSettings;
import com.google.storage.v2.stub.GrpcStorageCallableFactory;
import com.google.storage.v2.stub.GrpcStorageStub;
import com.google.storage.v2.stub.StorageStub;
import com.google.storage.v2.stub.StorageStubSettings;
import io.grpc.ClientInterceptor;
import io.grpc.Detachable;
import io.grpc.HasByteBuffer;
import io.grpc.KnownLength;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.threeten.bp.Duration;

@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
public final class GrpcStorageOptions
extends StorageOptions
implements Retrying.RetryingDependencies {
    private static final long serialVersionUID = -4499446543857945349L;
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");
    private static final String DEFAULT_HOST = "https://storage.googleapis.com";
    private final GrpcRetryAlgorithmManager retryAlgorithmManager;
    private final java.time.Duration terminationAwaitDuration;
    private final boolean attemptDirectPath;
    private final boolean enableGrpcClientMetrics;
    private final boolean grpcClientMetricsManuallyEnabled;
    private final GrpcInterceptorProvider grpcInterceptorProvider;
    private final BlobWriteSessionConfig blobWriteSessionConfig;

    private GrpcStorageOptions(Builder builder, GrpcStorageDefaults serviceDefaults) {
        super(builder, serviceDefaults);
        this.retryAlgorithmManager = new GrpcRetryAlgorithmManager((StorageRetryStrategy)MoreObjects.firstNonNull((Object)builder.storageRetryStrategy, (Object)serviceDefaults.getStorageRetryStrategy()));
        this.terminationAwaitDuration = (java.time.Duration)MoreObjects.firstNonNull((Object)builder.terminationAwaitDuration, (Object)serviceDefaults.getTerminationAwaitDurationJavaTime());
        this.attemptDirectPath = builder.attemptDirectPath;
        this.enableGrpcClientMetrics = builder.enableGrpcClientMetrics;
        this.grpcClientMetricsManuallyEnabled = builder.grpcMetricsManuallyEnabled;
        this.grpcInterceptorProvider = builder.grpcInterceptorProvider;
        this.blobWriteSessionConfig = builder.blobWriteSessionConfig;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    @InternalApi
    GrpcRetryAlgorithmManager getRetryAlgorithmManager() {
        return this.retryAlgorithmManager;
    }

    @InternalApi
    java.time.Duration getTerminationAwaitDuration() {
        return this.terminationAwaitDuration;
    }

    @InternalApi
    StorageSettings getStorageSettings() throws IOException {
        return (StorageSettings)this.resolveSettingsAndOpts().x();
    }

    private Tuple<StorageSettings, UnifiedOpts.Opts<UnifiedOpts.UserProject>> resolveSettingsAndOpts() throws IOException {
        String quotaProjectId;
        NoCredentialsProvider credentialsProvider;
        String endpoint = this.getHost();
        URI uri = URI.create(endpoint);
        String scheme = uri.getScheme();
        int port = uri.getPort();
        switch (scheme) {
            case "http": {
                endpoint = String.format("%s:%s", uri.getHost(), port > 0 ? port : 80);
                break;
            }
            case "https": {
                endpoint = String.format("%s:%s", uri.getHost(), port > 0 ? port : 443);
            }
        }
        UnifiedOpts.Opts<Object> defaultOpts = UnifiedOpts.Opts.empty();
        Preconditions.checkState((this.credentials != null ? 1 : 0) != 0, (Object)"Unable to resolve credentials");
        if (this.credentials instanceof NoCredentials) {
            credentialsProvider = NoCredentialsProvider.create();
        } else {
            boolean foundQuotaProject;
            block21: {
                foundQuotaProject = false;
                if (this.credentials.hasRequestMetadata()) {
                    try {
                        Map requestMetadata = this.credentials.getRequestMetadata(uri);
                        for (Map.Entry e : requestMetadata.entrySet()) {
                            List value;
                            String key = (String)e.getKey();
                            if (!"x-goog-user-project".equals(key.trim().toLowerCase(Locale.ENGLISH)) || (value = (List)e.getValue()).isEmpty()) continue;
                            foundQuotaProject = true;
                            defaultOpts = UnifiedOpts.Opts.from(UnifiedOpts.userProject((String)value.get(0)));
                            break;
                        }
                    }
                    catch (IllegalStateException e) {
                        if (e.getMessage().startsWith("OAuth2Credentials")) break block21;
                        throw e;
                    }
                }
            }
            credentialsProvider = foundQuotaProject ? FixedCredentialsProvider.create((Credentials)new QuotaProjectIdHidingCredentials(this.credentials)) : FixedCredentialsProvider.create((Credentials)this.credentials);
        }
        boolean isTm = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(ste -> ste.getClassName().startsWith("com.google.cloud.storage.transfermanager"));
        Object internalHeaderProvider = StorageSettings.defaultApiClientHeaderProviderBuilder().setClientLibToken(ServiceOptions.getGoogApiClientLibName(), this.getLibraryVersion()).build();
        if (isTm) {
            internalHeaderProvider = XGoogApiClientHeaderProvider.of((HeaderProvider)internalHeaderProvider, (ImmutableList<String>)ImmutableList.of((Object)"gccl-gcs-cmd/tm"));
        }
        StorageSettings.Builder builder = (StorageSettings.Builder)((StorageSettings.Builder)((StorageSettings.Builder)new GapicStorageSettingsBuilder(StorageSettings.newBuilder().build()).setInternalHeaderProvider((HeaderProvider)internalHeaderProvider).setEndpoint(endpoint)).setCredentialsProvider((CredentialsProvider)credentialsProvider)).setClock(this.getClock());
        if (this.getUniverseDomain() != null) {
            builder.setUniverseDomain(this.getUniverseDomain());
        }
        if ((quotaProjectId = this.getQuotaProjectId()) != null && !quotaProjectId.isEmpty()) {
            defaultOpts = UnifiedOpts.Opts.from(UnifiedOpts.userProject(quotaProjectId));
        }
        builder.setHeaderProvider(this.getMergedHeaderProvider((HeaderProvider)new NoHeaderProvider()));
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(endpoint).setAllowNonDefaultServiceAccount(true).setAttemptDirectPath(this.attemptDirectPath);
        if (!NoopGrpcInterceptorProvider.INSTANCE.equals(this.grpcInterceptorProvider)) {
            channelProviderBuilder.setInterceptorProvider(this.grpcInterceptorProvider);
        }
        if (this.attemptDirectPath) {
            channelProviderBuilder.setAttemptDirectPathXds();
        }
        if (scheme.equals("http")) {
            channelProviderBuilder.setChannelConfigurator(ManagedChannelBuilder::usePlaintext);
        }
        if (this.enableGrpcClientMetrics) {
            OpenTelemetryBootstrappingUtils.enableGrpcMetrics(channelProviderBuilder, endpoint, this.getProjectId(), this.getUniverseDomain(), !this.grpcClientMetricsManuallyEnabled);
        }
        builder.setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build());
        RetrySettings baseRetrySettings = this.getRetrySettings();
        RetrySettings readRetrySettings = baseRetrySettings.toBuilder().setLogicalTimeout(java.time.Duration.ofDays(28L)).build();
        java.time.Duration totalTimeout = baseRetrySettings.getTotalTimeoutDuration();
        Set startResumableWriteRetryableCodes = builder.startResumableWriteSettings().getRetryableCodes();
        builder.applyToAllUnaryMethods(input -> {
            input.setSimpleTimeoutNoRetriesDuration(totalTimeout);
            return null;
        });
        builder.startResumableWriteSettings().setRetrySettings(baseRetrySettings).setRetryableCodes(startResumableWriteRetryableCodes);
        builder.readObjectSettings().setRetrySettings(readRetrySettings).setRetryableCodes(Collections.emptySet()).setIdleTimeoutDuration(totalTimeout);
        return Tuple.of((Object)builder.build(), defaultOpts);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.retryAlgorithmManager, this.terminationAwaitDuration, this.attemptDirectPath, this.enableGrpcClientMetrics, this.grpcInterceptorProvider, this.blobWriteSessionConfig, this.baseHashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrpcStorageOptions)) {
            return false;
        }
        GrpcStorageOptions that = (GrpcStorageOptions)o;
        return this.attemptDirectPath == that.attemptDirectPath && this.enableGrpcClientMetrics == that.enableGrpcClientMetrics && Objects.equals(this.retryAlgorithmManager, that.retryAlgorithmManager) && Objects.equals(this.terminationAwaitDuration, that.terminationAwaitDuration) && Objects.equals(this.grpcInterceptorProvider, that.grpcInterceptorProvider) && Objects.equals(this.blobWriteSessionConfig, that.blobWriteSessionConfig) && this.baseEquals(that);
    }

    public static Builder newBuilder() {
        return new Builder().setHost(DEFAULT_HOST);
    }

    public static GrpcStorageOptions getDefaultInstance() {
        return GrpcStorageOptions.newBuilder().build();
    }

    public static GrpcStorageDefaults defaults() {
        return GrpcStorageDefaults.INSTANCE;
    }

    protected boolean shouldRefreshService(Storage cachedService) {
        if (cachedService instanceof GrpcStorageImpl) {
            GrpcStorageImpl service = (GrpcStorageImpl)cachedService;
            return service.isClosed();
        }
        return super.shouldRefreshService((Service)cachedService);
    }

    public static final class Builder
    extends StorageOptions.Builder {
        private StorageRetryStrategy storageRetryStrategy;
        private java.time.Duration terminationAwaitDuration;
        private boolean attemptDirectPath = GrpcStorageDefaults.INSTANCE.isAttemptDirectPath();
        private boolean enableGrpcClientMetrics = GrpcStorageDefaults.INSTANCE.isEnableGrpcClientMetrics();
        private GrpcInterceptorProvider grpcInterceptorProvider = GrpcStorageDefaults.INSTANCE.grpcInterceptorProvider();
        private BlobWriteSessionConfig blobWriteSessionConfig = GrpcStorageDefaults.INSTANCE.getDefaultStorageWriterConfig();
        private boolean grpcMetricsManuallyEnabled = false;

        Builder() {
        }

        Builder(StorageOptions options) {
            super(options);
            GrpcStorageOptions gso = (GrpcStorageOptions)options;
            this.storageRetryStrategy = gso.getRetryAlgorithmManager().retryStrategy;
            this.terminationAwaitDuration = gso.getTerminationAwaitDuration();
            this.attemptDirectPath = gso.attemptDirectPath;
            this.enableGrpcClientMetrics = gso.enableGrpcClientMetrics;
            this.grpcInterceptorProvider = gso.grpcInterceptorProvider;
            this.blobWriteSessionConfig = gso.blobWriteSessionConfig;
        }

        @ObsoleteApi(value="Use setTerminationAwaitJavaTimeDuration(java.time.Duration) instead")
        public Builder setTerminationAwaitDuration(Duration terminationAwaitDuration) {
            return this.setTerminationAwaitJavaTimeDuration(TimeConversionUtils.toJavaTimeDuration((Duration)terminationAwaitDuration));
        }

        public Builder setTerminationAwaitJavaTimeDuration(java.time.Duration terminationAwaitDuration) {
            this.terminationAwaitDuration = Objects.requireNonNull(terminationAwaitDuration, "terminationAwaitDuration must be non null");
            return this;
        }

        public Builder setAttemptDirectPath(boolean attemptDirectPath) {
            this.attemptDirectPath = attemptDirectPath;
            return this;
        }

        public Builder setEnableGrpcClientMetrics(boolean enableGrpcClientMetrics) {
            this.enableGrpcClientMetrics = enableGrpcClientMetrics;
            if (enableGrpcClientMetrics) {
                this.grpcMetricsManuallyEnabled = true;
            }
            return this;
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only gRPC transport is allowed.");
            }
            super.setTransportOptions(transportOptions);
            return this;
        }

        @Override
        public Builder setStorageRetryStrategy(StorageRetryStrategy storageRetryStrategy) {
            this.storageRetryStrategy = Objects.requireNonNull(storageRetryStrategy, "storageRetryStrategy must be non null");
            return this;
        }

        protected Builder self() {
            return this;
        }

        public Builder setServiceFactory(ServiceFactory<Storage, StorageOptions> serviceFactory) {
            super.setServiceFactory(serviceFactory);
            return this;
        }

        public Builder setClock(ApiClock clock) {
            super.setClock(clock);
            return this;
        }

        public Builder setProjectId(String projectId) {
            super.setProjectId(projectId);
            return this;
        }

        public Builder setHost(String host) {
            super.setHost(host);
            return this;
        }

        public Builder setCredentials(Credentials credentials) {
            super.setCredentials(credentials);
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        public Builder setServiceRpcFactory(ServiceRpcFactory<StorageOptions> serviceRpcFactory) {
            throw new UnsupportedOperationException("GrpcStorageOptions does not support setting a custom instance of ServiceRpcFactory");
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            super.setHeaderProvider(headerProvider);
            return this;
        }

        public Builder setClientLibToken(String clientLibToken) {
            super.setClientLibToken(clientLibToken);
            return this;
        }

        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        public Builder setGrpcInterceptorProvider(@NonNull GrpcInterceptorProvider grpcInterceptorProvider) {
            Objects.requireNonNull(grpcInterceptorProvider, "grpcInterceptorProvider must be non null");
            this.grpcInterceptorProvider = grpcInterceptorProvider;
            return this;
        }

        @Override
        @BetaApi
        public Builder setBlobWriteSessionConfig(@NonNull BlobWriteSessionConfig blobWriteSessionConfig) {
            Objects.requireNonNull(blobWriteSessionConfig, "blobWriteSessionConfig must be non null");
            Preconditions.checkArgument((boolean)(blobWriteSessionConfig instanceof BlobWriteSessionConfig.GrpcCompatible), (Object)"The provided instance of BlobWriteSessionConfig is not compatible with gRPC transport.");
            this.blobWriteSessionConfig = blobWriteSessionConfig;
            return this;
        }

        @Override
        public GrpcStorageOptions build() {
            GrpcStorageOptions options = new GrpcStorageOptions(this, GrpcStorageOptions.defaults());
            if (options.getUniverseDomain() != null) {
                this.setHost("https://storage." + options.getUniverseDomain());
                return new GrpcStorageOptions(this, GrpcStorageOptions.defaults());
            }
            return options;
        }
    }

    public static final class GrpcStorageDefaults
    extends StorageOptions.StorageDefaults {
        static final GrpcStorageDefaults INSTANCE = new GrpcStorageDefaults();
        static final StorageFactory STORAGE_FACTORY = new GrpcStorageFactory();
        static final StorageRpcFactory STORAGE_RPC_FACTORY = new GrpcStorageRpcFactory();
        static final GrpcInterceptorProvider INTERCEPTOR_PROVIDER = NoopGrpcInterceptorProvider.access$800();

        private GrpcStorageDefaults() {
        }

        public StorageFactory getDefaultServiceFactory() {
            return STORAGE_FACTORY;
        }

        public StorageRpcFactory getDefaultRpcFactory() {
            return STORAGE_RPC_FACTORY;
        }

        public GrpcTransportOptions getDefaultTransportOptions() {
            return GrpcTransportOptions.newBuilder().build();
        }

        public StorageRetryStrategy getStorageRetryStrategy() {
            return StorageRetryStrategy.getDefaultStorageRetryStrategy();
        }

        @ObsoleteApi(value="Use getTerminationAwaitDurationJavaTime() instead")
        public Duration getTerminationAwaitDuration() {
            return TimeConversionUtils.toThreetenDuration((java.time.Duration)this.getTerminationAwaitDurationJavaTime());
        }

        public java.time.Duration getTerminationAwaitDurationJavaTime() {
            return java.time.Duration.ofMinutes(1L);
        }

        public boolean isAttemptDirectPath() {
            return true;
        }

        public boolean isEnableGrpcClientMetrics() {
            return true;
        }

        public GrpcInterceptorProvider grpcInterceptorProvider() {
            return INTERCEPTOR_PROVIDER;
        }

        public BlobWriteSessionConfig getDefaultStorageWriterConfig() {
            return BlobWriteSessionConfigs.getDefault();
        }
    }

    private static final class GapicStorageSettingsBuilder
    extends StorageSettings.Builder {
        private GapicStorageSettingsBuilder(StorageSettings settings) {
            super(settings);
        }

        protected StorageSettings.Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            return (StorageSettings.Builder)super.setInternalHeaderProvider(internalHeaderProvider);
        }
    }

    private static final class NoopGrpcInterceptorProvider
    implements GrpcInterceptorProvider,
    Serializable {
        private static long serialVersionUID = -8523033236999805349L;
        private static final NoopGrpcInterceptorProvider INSTANCE = new NoopGrpcInterceptorProvider();

        private NoopGrpcInterceptorProvider() {
        }

        public List<ClientInterceptor> getInterceptors() {
            return ImmutableList.of();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class ZeroCopyReadinessChecker {
        private static final boolean isZeroCopyReady;

        ZeroCopyReadinessChecker() {
        }

        public static boolean isReady() {
            return isZeroCopyReady;
        }

        static {
            boolean detachableClassExists = false;
            try {
                String knownLengthClassName = KnownLength.class.getName();
                String detachableClassName = knownLengthClassName.substring(0, knownLengthClassName.lastIndexOf(46) + 1) + "Detachable";
                Class<?> detachableClass = Class.forName(detachableClassName);
                detachableClassExists = detachableClass != null;
            }
            catch (ClassNotFoundException knownLengthClassName) {
                // empty catch block
            }
            boolean unsafeByteOperationsClassExists = false;
            try {
                String messageLiteClassName = MessageLite.class.getName();
                String unsafeByteOperationsClassName = messageLiteClassName.substring(0, messageLiteClassName.lastIndexOf(46) + 1) + "UnsafeByteOperations";
                Class<?> unsafeByteOperationsClass = Class.forName(unsafeByteOperationsClassName);
                unsafeByteOperationsClassExists = unsafeByteOperationsClass != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            isZeroCopyReady = detachableClassExists && unsafeByteOperationsClassExists;
        }
    }

    @VisibleForTesting
    static class ReadObjectResponseZeroCopyMessageMarshaller
    implements MethodDescriptor.PrototypeMarshaller<ReadObjectResponse>,
    ResponseContentLifecycleManager,
    Closeable {
        private final Map<ReadObjectResponse, InputStream> unclosedStreams;
        private final Parser<ReadObjectResponse> parser;
        private final MethodDescriptor.PrototypeMarshaller<ReadObjectResponse> baseMarshaller;

        ReadObjectResponseZeroCopyMessageMarshaller(ReadObjectResponse defaultInstance) {
            this.parser = defaultInstance.getParserForType();
            this.baseMarshaller = (MethodDescriptor.PrototypeMarshaller)ProtoUtils.marshaller((Message)defaultInstance);
            this.unclosedStreams = Collections.synchronizedMap(new IdentityHashMap());
        }

        public Class<ReadObjectResponse> getMessageClass() {
            return this.baseMarshaller.getMessageClass();
        }

        public ReadObjectResponse getMessagePrototype() {
            return (ReadObjectResponse)this.baseMarshaller.getMessagePrototype();
        }

        public InputStream stream(ReadObjectResponse value) {
            return this.baseMarshaller.stream((Object)value);
        }

        public ReadObjectResponse parse(InputStream stream) {
            CodedInputStream cis = null;
            try {
                if (stream instanceof KnownLength && stream instanceof Detachable && stream instanceof HasByteBuffer && ((HasByteBuffer)stream).byteBufferSupported()) {
                    int size = stream.available();
                    stream = ((Detachable)stream).detach();
                    stream.mark(size);
                    ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
                    while (stream.available() != 0) {
                        ByteBuffer buffer = ((HasByteBuffer)stream).getByteBuffer();
                        byteStrings.add(UnsafeByteOperations.unsafeWrap((ByteBuffer)buffer));
                        stream.skip(buffer.remaining());
                    }
                    stream.reset();
                    cis = ByteString.copyFrom(byteStrings).newCodedInput();
                    cis.enableAliasing(true);
                    cis.setSizeLimit(Integer.MAX_VALUE);
                }
            }
            catch (IOException e) {
                throw Status.INTERNAL.withDescription("Error parsing input stream for ReadObject").withCause((Throwable)e).asRuntimeException();
            }
            if (cis != null) {
                ReadObjectResponse message;
                try {
                    message = this.parseFrom(cis);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence for ReadObject").withCause((Throwable)ipbe).asRuntimeException();
                }
                this.unclosedStreams.put(message, stream);
                return message;
            }
            return (ReadObjectResponse)this.baseMarshaller.parse(stream);
        }

        private ReadObjectResponse parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
            ReadObjectResponse message = (ReadObjectResponse)this.parser.parseFrom(stream);
            try {
                stream.checkLastTagWas(0);
                return message;
            }
            catch (InvalidProtocolBufferException e) {
                e.setUnfinishedMessage((MessageLite)message);
                throw e;
            }
        }

        @Override
        public ResponseContentLifecycleHandle get(ReadObjectResponse response) {
            InputStream stream = this.unclosedStreams.remove(response);
            return new ResponseContentLifecycleHandle(response, stream);
        }

        @Override
        public void close() throws IOException {
            ReadObjectResponseZeroCopyMessageMarshaller.closeAllStreams(this.unclosedStreams.values());
        }

        @VisibleForTesting
        static void closeAllStreams(Iterable<InputStream> inputStreams) throws IOException {
            Iterator<InputStream> iterator = inputStreams.iterator();
            IOException ioException = null;
            while (iterator.hasNext()) {
                InputStream next = iterator.next();
                try {
                    next.close();
                }
                catch (IOException e) {
                    if (ioException == null) {
                        ioException = e;
                        continue;
                    }
                    if (ioException == e) continue;
                    ioException.addSuppressed(e);
                }
            }
            if (ioException != null) {
                throw ioException;
            }
        }
    }

    private static final class InternalZeroCopyGrpcStorageStub
    extends GrpcStorageStub
    implements AutoCloseable {
        private final ReadObjectResponseZeroCopyMessageMarshaller getObjectMediaResponseMarshaller = new ReadObjectResponseZeroCopyMessageMarshaller(ReadObjectResponse.getDefaultInstance());
        private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> serverStreamingCallable;

        private InternalZeroCopyGrpcStorageStub(StorageStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
            super(settings, clientContext, callableFactory);
            MethodDescriptor readObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.storage.v2.Storage/ReadObject").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadObjectRequest.getDefaultInstance())).setResponseMarshaller((MethodDescriptor.Marshaller)this.getObjectMediaResponseMarshaller).build();
            GrpcCallSettings readObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readObjectMethodDescriptor).setParamsExtractor(request -> {
                RequestParamsBuilder builder = RequestParamsBuilder.create();
                builder.add(request.getBucket(), "bucket", PathTemplate.create((String)"{bucket=**}"));
                return builder.build();
            }).build();
            this.serverStreamingCallable = callableFactory.createServerStreamingCallable(readObjectTransportSettings, settings.readObjectSettings(), clientContext);
        }

        public ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable() {
            return this.serverStreamingCallable;
        }
    }

    private static final class InternalStorageClient
    extends StorageClient {
        private InternalStorageClient(InternalZeroCopyGrpcStorageStub stub) {
            super((StorageStub)stub);
        }

        public void shutdownNow() {
            try {
                this.getStub().getObjectMediaResponseMarshaller.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                super.shutdownNow();
            }
        }

        public InternalZeroCopyGrpcStorageStub getStub() {
            return (InternalZeroCopyGrpcStorageStub)super.getStub();
        }
    }

    @InternalApi
    @Deprecated
    public static class GrpcStorageRpcFactory
    implements StorageRpcFactory {
        @InternalApi
        @Deprecated
        public GrpcStorageRpcFactory() {
        }

        public ServiceRpc create(StorageOptions options) {
            throw new IllegalStateException("No supported for grpc");
        }
    }

    @InternalApi
    public static class GrpcStorageFactory
    implements StorageFactory {
        @InternalApi
        @Deprecated
        public GrpcStorageFactory() {
        }

        public Storage create(StorageOptions options) {
            if (options instanceof GrpcStorageOptions) {
                GrpcStorageOptions grpcStorageOptions = (GrpcStorageOptions)options;
                try {
                    Tuple t = grpcStorageOptions.resolveSettingsAndOpts();
                    StorageSettings storageSettings = (StorageSettings)t.x();
                    UnifiedOpts.Opts defaultOpts = (UnifiedOpts.Opts)t.y();
                    if (ZeroCopyReadinessChecker.isReady()) {
                        StorageStubSettings stubSettings = (StorageStubSettings)storageSettings.getStubSettings();
                        ClientContext clientContext = ClientContext.create((StubSettings)stubSettings);
                        GrpcStorageCallableFactory grpcStorageCallableFactory = new GrpcStorageCallableFactory();
                        InternalZeroCopyGrpcStorageStub stub = new InternalZeroCopyGrpcStorageStub(stubSettings, clientContext, (GrpcStubCallableFactory)grpcStorageCallableFactory);
                        InternalStorageClient client = new InternalStorageClient(stub);
                        return new GrpcStorageImpl(grpcStorageOptions, client, stub.getObjectMediaResponseMarshaller, grpcStorageOptions.blobWriteSessionConfig.createFactory(Clock.systemUTC()), defaultOpts);
                    }
                    StorageClient client = StorageClient.create((StorageSettings)storageSettings);
                    return new GrpcStorageImpl(grpcStorageOptions, client, ResponseContentLifecycleManager.noop(), grpcStorageOptions.blobWriteSessionConfig.createFactory(Clock.systemUTC()), defaultOpts);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to instantiate gRPC com.google.cloud.storage.Storage client.", e);
                }
            }
            throw new IllegalArgumentException("Only GrpcStorageOptions supported");
        }
    }
}

