/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableAlignment;
import jalview.DrawableSequence;
import jalview.ScoreSequence;
import jalview.SeqPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class SeqCanvas
extends Canvas {
    DrawableAlignment da;
    Image img;
    Graphics gg;
    int imgWidth;
    int imgHeight;
    int fontStyle = 0;
    int fontSize = 10;
    String fontName = "Courier";
    public Font f = new Font(this.fontName, this.fontStyle, this.fontSize);
    int charWidth = 8;
    int charHeight = 8;
    boolean showScores = true;
    int pady = 2;
    int oldstartx;
    int oldstarty;
    int oldendx;
    int oldendy;
    boolean paintFlag = false;
    boolean boxFlag = true;
    boolean textFlag = true;
    boolean colourText = false;
    int startx;
    int starty;
    int endx;
    int endy;
    Color lightBlue = new Color(175, 175, 255);
    Color midBlue = new Color(110, 110, 255);
    String colourFlag = "PID";
    boolean badResidues = false;
    boolean colourSelected = false;
    protected SeqPanel seqPanel;

    public SeqCanvas(SeqPanel seqPanel) {
        this.seqPanel = seqPanel;
        this.da = seqPanel.align;
    }

    public void setFont(Font font) {
        this.f = font;
        if (this.gg != null) {
            FontMetrics fontMetrics = this.gg.getFontMetrics(font);
            if (this.seqPanel.fastDraw) {
                this.f = new Font("Courier", font.getStyle(), font.getSize());
                this.charWidth = fontMetrics.charWidth('W');
                this.charHeight = this.setCharHeight(fontMetrics, this.showScores);
                return;
            }
            this.charWidth = fontMetrics.charWidth('W') + 2;
            this.charHeight = this.setCharHeight(fontMetrics, this.showScores);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.img == null || this.imgWidth != this.size().width || this.imgHeight != this.size().height || this.paintFlag) {
            this.imgWidth = this.size().width;
            this.imgHeight = this.size().height;
            this.img = this.createImage(this.imgWidth, this.imgHeight);
            this.gg = this.img.getGraphics();
            this.gg.setFont(this.f);
            this.seqPanel.alignPanel.idPanel.idCanvas.f = this.f;
            this.seqPanel.alignPanel.scalePanel.scaleCanvas.f = this.f;
            FontMetrics fontMetrics = this.gg.getFontMetrics(this.f);
            this.charWidth = this.seqPanel.fastDraw ? fontMetrics.charWidth('W') : fontMetrics.charWidth('W') + 2;
            this.charHeight = this.setCharHeight(fontMetrics, this.showScores);
            this.seqPanel.setScrollValues(this.seqPanel.offx, this.seqPanel.offy);
            this.paintFlag = false;
            this.oldstartx = -1;
            this.oldendx = -1;
            this.oldstarty = -1;
            this.oldendy = -1;
        }
        this.startx = this.seqPanel.offx;
        this.starty = this.seqPanel.offy;
        this.endx = this.getEndx();
        this.endy = this.getEndy();
        if (this.endx > this.seqPanel.align.maxLength) {
            this.startx = this.startx - this.endx + this.seqPanel.align.maxLength;
            this.endx = this.seqPanel.align.maxLength;
        }
        if (this.starty < 0) {
            this.starty = 0;
        }
        if (this.startx < 0) {
            this.startx = 0;
        }
        long l = System.currentTimeMillis();
        if (this.oldendx == -1) {
            this.fillBackground(this.gg, Color.white, 0, 0, this.imgWidth, this.imgHeight);
            this.drawPanel(this.gg, this.startx, this.endx, this.starty, this.endy);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        } else if (this.oldstartx < this.startx) {
            n = (this.startx - this.oldstartx) * this.charWidth;
            int n2 = (this.oldendx - this.startx) * this.charWidth;
            this.gg.copyArea(n, 0, n2, this.da.getHeight(this.starty, this.endy), -n, 0);
            this.drawPanel(this.gg, this.oldendx, this.endx, this.starty, this.endy);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
        } else if (this.oldstartx > this.startx) {
            n = (this.oldstartx - this.startx) * this.charWidth;
            int n3 = (this.endx - this.oldstartx) * this.charWidth;
            this.gg.copyArea(0, 0, n3, this.da.getHeight(this.starty, this.endy), n, 0);
            this.drawPanel(this.gg, this.startx, this.oldstartx, this.starty, this.endy);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
        } else if (this.oldstarty < this.starty) {
            n = this.da.getHeight(this.oldstarty, this.starty);
            int n4 = this.da.getHeight(this.starty, this.oldendy);
            this.gg.copyArea(0, n, (this.endx - this.startx) * this.charWidth, n4, 0, -n);
            this.drawPanel(this.gg, this.startx, this.endx, this.oldendy, this.endy);
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        } else if (this.oldstarty > this.starty) {
            n = this.da.getHeight(this.endy, this.oldendy);
            int n5 = this.da.getHeight(this.oldstarty, this.endy);
            this.gg.copyArea(0, 0, (this.endx - this.startx) * this.charWidth, n5, 0, n);
            this.drawPanel(this.gg, this.startx, this.endx, this.starty, this.oldstarty);
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        }
        long l2 = System.currentTimeMillis();
        if (this.seqPanel.alignPanel.parent instanceof AlignFrame) {
            ((AlignFrame)this.seqPanel.alignPanel.parent).redraw.setText("Redraw time = " + (l2 - l) + " ms");
        }
        graphics.drawImage(this.img, 0, 0, this);
    }

    public void drawPanel(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setFont(this.f);
        this.fillBackground(graphics, Color.white, (n - this.startx) * this.charWidth, this.da.getHeight(this.starty, n3), (n2 - n) * this.charWidth, this.da.getHeight(n3, n4));
        int n5 = n3;
        while (n5 < n4) {
            ((DrawableSequence)this.seqPanel.align.sequences[n5]).drawSequence(graphics, n, n2, (n - this.startx) * this.charWidth, this.da.getHeight(this.starty, n5), this.charWidth, this.da.ds[n5].charHeight, this.showScores);
            ++n5;
        }
    }

    public boolean keyDown(Event event, int n) {
        return this.seqPanel.alignPanel.idPanel.keyDown(event, n);
    }

    public int getEndy() {
        int n = 0;
        int n2 = this.starty;
        int n3 = this.starty;
        while (n < this.size().height && n2 < this.da.ds.length && this.da.ds[n2] != null) {
            n += this.da.ds[n2].charHeight;
            ++n2;
        }
        if (n < this.size().height) {
            n3 = this.da.size;
            n = this.size().height;
            while (n > 0 && n3 > 0) {
                n -= this.da.ds[n3 - 1].charHeight;
                --n3;
            }
            if (n <= 0) {
                ++n3;
            }
        } else {
            --n2;
        }
        this.endy = this.starty + this.size().height / this.charHeight;
        if (this.endy >= this.seqPanel.align.size) {
            this.starty = this.starty - this.endy + this.seqPanel.align.size;
            this.endy = this.seqPanel.align.size;
        }
        if (this.starty < 0) {
            this.starty = 0;
        }
        this.starty = n3;
        if (this.starty < 0) {
            this.starty = 0;
        }
        return n2;
    }

    public int getEndx() {
        return this.startx + this.size().width / this.charWidth;
    }

    public int setCharHeight(FontMetrics fontMetrics, boolean bl) {
        int n = fontMetrics.getHeight();
        if (this.seqPanel.align instanceof DrawableAlignment) {
            DrawableAlignment drawableAlignment = this.seqPanel.align;
            int n2 = 0;
            while (n2 < drawableAlignment.ds.length && drawableAlignment.ds[n2] != null) {
                drawableAlignment.ds[n2].charHeight = drawableAlignment.ds[n2] instanceof ScoreSequence ? n * 3 : (bl ? n * 2 : n);
                ++n2;
            }
        }
        if (bl) {
            return fontMetrics.getHeight() * 2;
        }
        return fontMetrics.getHeight();
    }

    public void fillBackground(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void setFont(int n, int n2) {
        this.fontStyle = n;
        this.fontSize = n2;
        this.f = new Font(this.fontName, this.fontStyle, this.fontSize);
        this.setFont(this.f);
    }

    public int getIndex(int n) {
        int n2 = 0;
        int n3 = this.starty;
        while (n3 <= this.endy) {
            int n4;
            if (n3 < this.da.ds.length && this.da.ds[n3] != null) {
                n4 = n2 + this.da.ds[n3].charHeight;
                if (n >= n2 && n <= n4) {
                    return n3;
                }
            } else {
                return -1;
            }
            n2 = n4;
            ++n3;
        }
        return -1;
    }
}

