/*
 *      Copyright (C) 2014-2016 Jean-Luc Barriere
 *
 *  This file is part of Noson
 *
 *  Noson is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Noson is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SONOSTYPES_H
#define	SONOSTYPES_H

#include "local_config.h"
#include <stdint.h>
#include <vector>

#include "digitalitem.h"

namespace NSROOT
{
  extern const char* libVersionString();
  extern int libVersionMajor();
  extern int libVersionMinor();
  extern int libVersionPatch();

  typedef void (*EventCB)(void*);

  typedef enum
  {
    SVCEvent_TransportChanged        = 0x01,
    SVCEvent_RenderingControlChanged = 0x02,
    SVCEvent_ContentDirectoryChanged = 0x04,
    SVCEvent_ZGTopologyChanged       = 0x08,
    SVCEvent_AlarmClockChanged       = 0x10,
  } SVCEventMask_t;

  typedef enum
  {
    PlayMode_NORMAL           = 0,
    PlayMode_REPEAT_ALL       = 1,
    PlayMode_SHUFFLE,
    PlayMode_SHUFFLE_NOREPEAT,
    PlayMode_REPEAT_ONE,
    PlayMode_unknown,
  } PlayMode_t;

  extern const char* PlayModeTable[PlayMode_unknown + 1];

  typedef enum
  {
    TransportState_STOPPED          = 0,
    TransportState_PLAYING          = 1,
    TransportState_PAUSED_PLAYBACK,
    TransportState_TRANSITIONING,
    TransportState_NO_MEDIA_PRESENT,
    TransportState_RECORDING,
    TransportState_PAUSED_RECORDING,
  } TransportState_t;

  typedef enum
  {
    Protocol_xRinconQueue    = 0,
    Protocol_xRinconStream   = 1,
    Protocol_xRinconMP3Radio,
    Protocol_xRinconPlaylist,
    Protocol_xRinconCpcontainer,
    Protocol_xSonosHtaStream,
    Protocol_xSonosHttp,
    Protocol_xSonosSpotify,
    Protocol_xSonosMms,
    Protocol_xSonosApiStream,
    Protocol_xSonosApiRadio,
    Protocol_xSonosApiRTRecent,
    Protocol_xFileCifs,
    Protocol_xRincon,
    Protocol_httpGet,
    Protocol_file,
    Protocol_aac,
    Protocol_http,
    Protocol_unknown,
  } Protocol_t;

  extern const char* ProtocolTable[Protocol_unknown + 1];

  typedef enum
  {
    ServiceDesc_default,
    ServiceDesc_unknown,
  } ServiceDesc_t;

  extern const char* ServiceDescTable[ServiceDesc_unknown + 1];

  class AVTProperty
  {
  public:
    AVTProperty()
    : EventSEQ(0)
    , NumberOfTracks(0)
    , CurrentTrack(0)
    , CurrentSection(0) { }

    virtual ~AVTProperty();

    unsigned EventSEQ;
    std::string EventSID;
    std::string TransportState;                // PLAYING, STOPPED
    std::string CurrentPlayMode;               // NORMAL
    std::string CurrentCrossfadeMode;          // 0
    unsigned NumberOfTracks;                   // 13
    unsigned CurrentTrack;                     // 9
    unsigned CurrentSection;                   // 0
    std::string CurrentTrackURI;               // x-file-cifs://server/share/music/track.flac
    std::string CurrentTrackDuration;          // 0:03:14
    DigitalItemPtr CurrentTrackMetaData;
    std::string r_NextTrackURI;                // x-file-cifs://server/share/music/track.flac
    DigitalItemPtr r_NextTrackMetaData;
    std::string r_EnqueuedTransportURI;        // x-rincon-playlist:XXXX#A:ALBUMARTIST/artist/album
    DigitalItemPtr r_EnqueuedTransportURIMetaData;
    std::string PlaybackStorageMedium;         // NETWORK
    std::string AVTransportURI;                // x-rincon-queue:XX:XXXX
    DigitalItemPtr AVTransportURIMetaData;
    std::string NextAVTransportURI;
    std::string NextAVTransportURIMetaData;
    std::string CurrentTransportActions;       // Set, Play, Stop, Pause, Seek, Next, Previous
    std::string r_CurrentValidPlayModes;       // SHUFFLE,REPEAT,CROSSFADE
    std::string r_MuseSessions;
    std::string TransportStatus;               // OK
    std::string r_SleepTimerGeneration;        // 0
    std::string r_AlarmRunning;                // 0
    std::string r_AlarmIDRunning;
    std::string r_AlarmLoggedStartTime;
    std::string r_AlarmState;
    std::string r_SnoozeRunning;               // 0
    std::string r_RestartPending;              // 0
    std::string PossiblePlaybackStorageMedia;  // NONE, NETWORK

    // NOT IMPLEMENTED
    //std::string TransportPlaySpeed
    //std::string CurrentMediaDuration
    //std::string RecordStorageMedium
    //std::string PossibleRecordStorageMedia
    //std::string RecordMediumWriteStatus
    //std::string CurrentRecordQualityMode
    //std::string PossibleRecordQualityModes
  };

  class ContentProperty
  {
  public:
    ContentProperty()
    : EventSEQ(0)
    , ShareIndexInProgress(false) { }

    virtual ~ContentProperty();

    unsigned EventSEQ;
    std::string EventSID;
    std::string SystemUpdateID;
    bool ShareIndexInProgress;
    std::string ShareIndexLastError;
    std::vector<std::pair<std::string, unsigned> > ContainerUpdateIDs;
    std::string UserRadioUpdateID;
    std::string SavedQueuesUpdateID;
    std::string ShareListUpdateID;
    std::string RecentlyPlayedUpdateID;
    std::string RadioFavoritesUpdateID;
    std::string RadioLocationUpdateID;
    std::string FavoritesUpdateID;
    std::string FavoritePresetsUpdateID;
  };

  class RCSProperty
  {
  public:
    RCSProperty()
    : EventSEQ(0)
    , VolumeMaster(0)
    , VolumeLF(0)
    , VolumeRF(0)
    , MuteMaster(0)
    , MuteLF(0)
    , MuteRF(0)
    , NightMode(0)
    , SubGain(0)
    , Treble(0)
    , Bass(0)
    , OutputFixed(0)
    , LoudnessMaster(0)
    , VolumeDecibelMaster(0)
    , VolumeDecibelLF(0)
    , VolumeDecibelRF(0)
    { }

    virtual ~RCSProperty();

    unsigned EventSEQ;
    std::string EventSID;
    int VolumeMaster;
    int VolumeLF;
    int VolumeRF;
    int MuteMaster;
    int MuteLF;
    int MuteRF;
    int NightMode;
    int SubGain;
    int Treble;
    int Bass;
    int OutputFixed;
    int LoudnessMaster;
    int VolumeDecibelMaster;
    int VolumeDecibelLF;
    int VolumeDecibelRF;
  };

  class SRProperty
  {
  public:
    SRProperty() {}

    virtual ~SRProperty();

    std::string uuid;
    std::string subordinateName;
    RCSProperty property;
  };

}

#endif	/* SONOSTYPES_H */

