'''OpenGL extension OES.get_program_binary

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.get_program_binary to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces two new commands.  GetProgramBinaryOES empowers an
	application to use the GL itself as an offline compiler.  The resulting
	program binary can be reloaded into the GL via ProgramBinaryOES.  This is a
	very useful path for applications that wish to remain portable by shipping
	pure GLSL source shaders, yet would like to avoid the cost of compiling
	their shaders at runtime.  Instead an application can supply its GLSL source
	shaders during first application run, or even during installation.  The
	application then compiles and links its shaders and reads back the program
	binaries.  On subsequent runs, only the program binaries need be supplied!
	Though the level of optimization may not be identical -- the offline shader
	compiler may have the luxury of more aggressive optimization at its
	disposal -- program binaries generated online by the GL are interchangeable
	with those generated offline by an SDK tool.
	
	Note that an implementation supporting this extension need not include an
	online compiler.  That is, it is not required to support loading GLSL shader
	sources via the ShaderSource command.  A query of boolean value
	SHADER_COMPILER can be used to determine if an implementation supports a
	shader compiler.  If not, the GetProgramBinaryOES command is rendered
	virtually useless, but the ProgramBinaryOES command may still be used by
	vendor extensions as a standard method for loading offline-compiled program
	binaries.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/get_program_binary.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.get_program_binary import *
from OpenGL.raw.GLES2.OES.get_program_binary import _EXTENSION_NAME

def glInitGetProgramBinaryOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glGetProgramBinaryOES.binary size not checked against bufSize
glGetProgramBinaryOES=wrapper.wrapper(glGetProgramBinaryOES).setInputArraySize(
    'binary', None
).setInputArraySize(
    'binaryFormat', 1
).setInputArraySize(
    'length', 1
)
# INPUT glProgramBinaryOES.binary size not checked against length
glProgramBinaryOES=wrapper.wrapper(glProgramBinaryOES).setInputArraySize(
    'binary', None
)
### END AUTOGENERATED SECTION