/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.map;

import com.googlecode.d2j.map.InheritanceTree;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AsmInheritanceClassVisitor
extends ClassVisitor {
    final InheritanceTree tree;
    InheritanceTree.Clz clz;

    public AsmInheritanceClassVisitor(InheritanceTree tree) {
        super(262144);
        this.tree = tree;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.clz = this.tree.addClz(access, "L" + name + ";");
        if (superName != null) {
            this.clz.relateSuper("L" + superName + ";");
        }
        if (interfaces != null) {
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.clz.relateInterface("L" + s + ";");
                ++n2;
            }
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.clz.addField(access, name, desc);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type[] aT = Type.getArgumentTypes((String)desc);
        String[] aS = new String[aT.length];
        int i = 0;
        while (i < aT.length) {
            aS[i] = aT[i].getDescriptor();
            ++i;
        }
        this.clz.addMethod(access, name, aS, Type.getReturnType((String)desc).getDescriptor());
        return null;
    }
}

