/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.xfire.aegis.XMLClassMetaInfoManager;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.DefaultServiceConfiguration;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.jdom.Element;

public class AegisServiceConfiguration
extends DefaultServiceConfiguration {
    private final XMLClassMetaInfoManager manager = new XMLClassMetaInfoManager();
    private Map classes = new HashMap();

    public AegisServiceConfiguration() {
    }

    public AegisServiceConfiguration(ObjectServiceFactory serviceFactory) {
        this.setServiceFactory(serviceFactory);
    }

    public String getOperationName(ServiceInfo service, Method method) {
        String opName = null;
        MethodInfo methodInfo = this.getMethodInfo(service.getServiceClass(), method);
        if (methodInfo != null) {
            opName = methodInfo.getMappedName();
        }
        return opName != null ? opName : super.getOperationName(service, method);
    }

    public String getAction(OperationInfo op) {
        String action = null;
        MethodInfo methodInfo = this.getMethodInfo(op.getService().getServiceClass(), op.getMethod());
        if (methodInfo != null) {
            action = methodInfo.getAction();
        }
        return action != null ? action : super.getAction(op);
    }

    public Boolean isHeader(Method method, int j) {
        MethodInfo methodInfo = this.getMethodInfo(method.getDeclaringClass(), method);
        ParamInfo param = methodInfo.getParam(j);
        if (param == null) {
            return super.isHeader(method, j);
        }
        return param.isHeader();
    }

    private BeanInfo parseBeanElement(Class clazz) {
        BeanInfo beanInfo = new BeanInfo();
        beanInfo.setClazz(clazz);
        Element mapping = this.manager.findMapping(clazz, null);
        if (mapping == null) {
            return beanInfo;
        }
        List methods = mapping.getChildren("method");
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo methodInfo = new MethodInfo();
            Element methodEl = (Element)methods.get(i);
            methodInfo.setName(methodEl.getAttributeValue("name"));
            methodInfo.setMappedName(methodEl.getAttributeValue("mappedName"));
            methodInfo.setAction(methodEl.getAttributeValue("action"));
            beanInfo.addMethod(methodInfo);
            List params = methodEl.getChildren("parameter");
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                Element paramEl = (Element)iter.next();
                ParamInfo param = new ParamInfo();
                param.setHeader("true".equals(paramEl.getAttributeValue("header")));
                param.setIndex(Integer.parseInt(paramEl.getAttributeValue("index")));
                methodInfo.addParam(param);
            }
        }
        return beanInfo;
    }

    private BeanInfo getBeanInfo(Class clazz) {
        BeanInfo info = (BeanInfo)this.classes.get(clazz);
        if (info == null) {
            info = this.parseBeanElement(clazz);
        }
        return info;
    }

    private MethodInfo getMethodInfo(Class clazz, Method method) {
        BeanInfo beanInfo = this.getBeanInfo(clazz);
        return beanInfo.getMethod(method.getName());
    }

    private class ParamInfo {
        private int index;
        private boolean isHeader;

        private ParamInfo() {
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isHeader() {
            return this.isHeader;
        }

        public void setHeader(boolean isHeader) {
            this.isHeader = isHeader;
        }
    }

    private class MethodInfo {
        private String name;
        private String mappedName;
        private String action;
        private Map params = new HashMap();

        private MethodInfo() {
        }

        public String getAction() {
            return this.action;
        }

        public ParamInfo getParam(int j) {
            return (ParamInfo)this.params.get(j);
        }

        public void addParam(ParamInfo param) {
            this.params.put(param.getIndex(), param);
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMappedName() {
            return this.mappedName;
        }

        public void setMappedName(String mappedName) {
            this.mappedName = mappedName;
        }
    }

    private class BeanInfo {
        private Map methods = new HashMap();
        private Class clazz;

        private BeanInfo() {
        }

        public MethodInfo getMethod(String name) {
            return (MethodInfo)this.methods.get(name);
        }

        public void addMethod(MethodInfo method) {
            this.methods.put(method.getName(), method);
        }

        public Class getClazz() {
            return this.clazz;
        }

        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }
    }
}

