/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.context;

import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;

abstract class AbstractDynamicClientCRUDContext
implements ClientCRUDContext {
    private final JsonWebToken token;
    private ClientModel authenticatedClient;
    private UserModel authenticatedUser;

    public AbstractDynamicClientCRUDContext(KeycloakSession session, JsonWebToken token, RealmModel realm) {
        this.token = token;
        if (token == null) {
            return;
        }
        if (token.getIssuedFor() != null) {
            this.authenticatedClient = realm.getClientByClientId(token.getIssuedFor());
        }
        if (token.getSubject() != null) {
            this.authenticatedUser = session.users().getUserById(realm, token.getSubject());
        }
    }

    @Override
    public ClientModel getAuthenticatedClient() {
        return this.authenticatedClient;
    }

    @Override
    public UserModel getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    @Override
    public JsonWebToken getToken() {
        return this.token;
    }
}

