/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.client.clienttype.ClientTypeManager;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientTypesRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientTypesResource {
    protected static final Logger logger = Logger.getLogger(ClientTypesResource.class);
    protected final ClientTypeManager manager;
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public ClientTypesResource(ClientTypeManager manager, RealmModel realm, AdminPermissionEvaluator auth) {
        this.manager = manager;
        this.auth = auth;
        this.realm = realm;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="List all client types available in the current realm", description="This endpoint returns a list of both global and realm level client types and the attributes they set")
    public ClientTypesRepresentation getClientTypes() {
        this.auth.realm().requireViewRealm();
        try {
            return this.manager.getClientTypes(this.realm);
        }
        catch (ClientTypeException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BadRequestException((Throwable)((Object)ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST)));
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Update a client type", description="This endpoint allows you to update a realm level client type")
    @APIResponse(responseCode="204", description="No Content")
    public Response updateClientTypes(ClientTypesRepresentation clientTypes) {
        this.auth.realm().requireManageRealm();
        try {
            this.manager.updateClientTypes(this.realm, clientTypes);
        }
        catch (ClientTypeException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        return Response.noContent().build();
    }
}

