/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Alignment;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Conservation {
    Vector sequences;
    int start;
    int end;
    Vector total = new Vector();
    String consString = "";
    DrawableSequence consSequence;
    Hashtable propHash;
    int threshold;
    Hashtable[] freqs;
    String name = "";

    public Conservation(String string, Hashtable[] hashtableArray, Hashtable hashtable, int n, Vector vector, int n2, int n3) {
        this.name = string;
        this.freqs = hashtableArray;
        this.propHash = hashtable;
        this.threshold = n;
        this.sequences = vector;
        this.start = n2;
        this.end = n3;
    }

    public void calculate() {
        int n = this.start;
        while (n <= this.end) {
            Object object;
            Hashtable hashtable = null;
            hashtable = new Hashtable();
            Hashtable<Object, Integer> hashtable2 = null;
            hashtable2 = new Hashtable<Object, Integer>();
            int n2 = 0;
            while (n2 < this.sequences.size()) {
                if (this.sequences.elementAt(n2) instanceof Sequence) {
                    Sequence sequence = (Sequence)this.sequences.elementAt(n2);
                    if (sequence.getSequence().length() > n) {
                        object = sequence.getSequence().substring(n, n + 1);
                        if (hashtable2.containsKey(object)) {
                            int n3 = (Integer)hashtable2.get(object);
                            hashtable2.put(object, new Integer(++n3));
                        } else {
                            hashtable2.put(object, new Integer(1));
                        }
                    } else if (hashtable2.containsKey("-")) {
                        int n4 = (Integer)hashtable2.get("-");
                        hashtable2.put("-", new Integer(++n4));
                    } else {
                        hashtable2.put("-", new Integer(1));
                    }
                }
                ++n2;
            }
            int n5 = this.threshold * this.sequences.size() / 100;
            object = hashtable2.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if ((Integer)hashtable2.get(string) <= n5) continue;
                Enumeration enumeration = this.propHash.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Hashtable hashtable3 = (Hashtable)this.propHash.get(string2);
                    if (!hashtable.containsKey(string2)) {
                        if (hashtable3.containsKey(string)) {
                            hashtable.put(string2, hashtable3.get(string));
                            continue;
                        }
                        hashtable.put(string2, hashtable3.get("-"));
                        continue;
                    }
                    if (((Integer)hashtable.get(string2)).equals((Integer)hashtable3.get(string))) continue;
                    hashtable.put(string2, new Integer(-1));
                }
            }
            this.total.addElement(hashtable);
            ++n;
        }
    }

    public int countGaps(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.sequences.size()) {
            String string = ((Sequence)this.sequences.elementAt((int)n3)).sequence.substring(n, n + 1);
            if (string.equals(" ") || string.equals(".") || string.equals("-")) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public void verdict(boolean bl, float f) {
        String string = "";
        int n = this.start;
        while (n <= this.end) {
            int n2 = this.countGaps(n);
            float f2 = (float)n2 * 100.0f / (float)this.sequences.size();
            if (f > f2) {
                Hashtable hashtable = (Hashtable)this.total.elementAt(n);
                int n3 = 0;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Integer n4 = (Integer)hashtable.get(string2);
                    if (bl) {
                        if (n4 != 1) continue;
                        ++n3;
                        continue;
                    }
                    if (n4 == -1) continue;
                    ++n3;
                }
                string = n3 < 10 ? String.valueOf(string) + String.valueOf(n3) : String.valueOf(string) + "*";
            } else {
                string = String.valueOf(string) + "-";
            }
            ++n;
        }
        this.consSequence = new DrawableSequence(this.name, string, this.start, this.end);
    }

    public static void main(String[] stringArray) {
        Object object;
        Sequence[] sequenceArray = null;
        sequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read(stringArray[0], "File", stringArray[1]));
        AlignFrame alignFrame = new AlignFrame(null, (DrawableSequence[])sequenceArray);
        alignFrame.resize(700, 500);
        alignFrame.show();
        Vector<Sequence> vector = new Vector<Sequence>();
        int n = 0;
        while (n < sequenceArray.length) {
            vector.addElement(sequenceArray[n]);
            ++n;
        }
        Alignment alignment = new Alignment(sequenceArray);
        alignment.percentIdentity();
        DrawableSequence[] drawableSequenceArray = new DrawableSequence[20];
        int n2 = 0;
        Enumeration enumeration = ResidueProperties.propHash.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
            hashtable.put((String)object, (Hashtable)ResidueProperties.propHash.get(object));
            Conservation conservation = new Conservation((String)object, alignment.cons, hashtable, 3, vector, 0, sequenceArray[0].getSequence().length() - 1);
            conservation.calculate();
            conservation.verdict(false, 20.0f);
            drawableSequenceArray[n2++] = conservation.consSequence;
        }
        object = new Conservation("All", alignment.cons, ResidueProperties.propHash, 3, vector, 0, sequenceArray[0].getSequence().length() - 1);
        ((Conservation)object).calculate();
        ((Conservation)object).verdict(false, 20.0f);
        drawableSequenceArray[n2++] = ((Conservation)object).consSequence;
        alignFrame.ap.seqPanel.align.addSequence(drawableSequenceArray);
        int n3 = 0;
        while (n3 < n2) {
            System.out.println(">" + drawableSequenceArray[n3].getName() + "\n" + drawableSequenceArray[n3].getSequence());
            ++n3;
        }
        System.exit(0);
    }
}

