/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.value;

import com.android.tools.smali.dexlib2.base.value.BaseAnnotationEncodedValue;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedAnnotationElement;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeSet;
import com.android.tools.smali.dexlib2.dexbacked.value.DexBackedEncodedValue;
import java.util.Set;

public class DexBackedAnnotationEncodedValue
extends BaseAnnotationEncodedValue {
    public final DexBackedDexFile dexFile;
    public final String type;
    private final int elementCount;
    private final int elementsOffset;

    public DexBackedAnnotationEncodedValue(DexBackedDexFile dexFile, DexReader reader) {
        this.dexFile = dexFile;
        this.type = (String)dexFile.getTypeSection().get(reader.readSmallUleb128());
        this.elementCount = reader.readSmallUleb128();
        this.elementsOffset = reader.getOffset();
        DexBackedAnnotationEncodedValue.skipElements(reader, this.elementCount);
    }

    public static void skipFrom(DexReader reader) {
        reader.skipUleb128();
        int elementCount = reader.readSmallUleb128();
        DexBackedAnnotationEncodedValue.skipElements(reader, elementCount);
    }

    private static void skipElements(DexReader reader, int elementCount) {
        for (int i = 0; i < elementCount; ++i) {
            reader.skipUleb128();
            DexBackedEncodedValue.skipFrom(reader);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Set<? extends DexBackedAnnotationElement> getElements() {
        return new VariableSizeSet<DexBackedAnnotationElement>(this.dexFile.getDataBuffer(), this.elementsOffset, this.elementCount){

            @Override
            protected DexBackedAnnotationElement readNextItem(DexReader dexReader, int index) {
                return new DexBackedAnnotationElement(DexBackedAnnotationEncodedValue.this.dexFile, dexReader);
            }
        };
    }
}

