/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.MondrianXMLReader;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.CubePane;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.SchemaEditPanel;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.architect.swingui.olap.VirtualCubePane;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ImportSchemaAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(ImportSchemaAction.class);
    private static final int HORIZONTAL_OFFSET = 10;
    private static final int VERTICAL_OFFSET = 50;
    private static final Point INITIAL_POINT = new Point(50, 50);

    public ImportSchemaAction(ArchitectSwingSession session) {
        super(session, "Import Schema...", "Imports an OLAP schema");
    }

    public ImportSchemaAction(ArchitectFrame frame) {
        super(frame, "Import Schema...", "Imports an OLAP schema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(this.getSession().getRecentMenu().getMostRecentFile());
        chooser.addChoosableFileFilter(SPSUtils.XML_FILE_FILTER);
        int returnVal = chooser.showOpenDialog(this.frame);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            MondrianModel.Schema loadedSchema = null;
            try {
                OLAPObject olapObj = MondrianXMLReader.importXML(f);
                if (!(olapObj instanceof MondrianModel.Schema)) {
                    throw new IllegalStateException("File parse failed to return a schema object!");
                }
                loadedSchema = (MondrianModel.Schema)olapObj;
                this.getSession().getWorkspace().begin("Importing OLAP schema");
                try {
                    final OLAPSession osession = new OLAPSession(loadedSchema);
                    osession.setDatabase(this.getSession().getTargetDatabase());
                    this.getSession().getOLAPRootObject().addChild((SPObject)osession);
                    OLAPEditSession editSession = this.getSession().getOLAPEditSession(osession);
                    this.addGUIComponents(editSession);
                    final JFrame frame = editSession.getFrame();
                    frame.setLocationRelativeTo(this.getSession().getArchitectFrame());
                    frame.setVisible(true);
                    this.getSession().getWorkspace().commit();
                    final SchemaEditPanel schemaEditPanel = new SchemaEditPanel(this.getSession(), loadedSchema);
                    Callable<Boolean> okCall = new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return schemaEditPanel.applyChanges();
                        }
                    };
                    Callable<Boolean> cancelCall = new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            frame.dispose();
                            ImportSchemaAction.this.getSession().getOLAPRootObject().removeOLAPSession(osession);
                            return true;
                        }
                    };
                    JDialog schemaEditDialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)schemaEditPanel, (Component)frame, (String)"New Schema Properties", (String)DataEntryPanelBuilder.OK_BUTTON_LABEL, (Callable)okCall, (Callable)cancelCall);
                    schemaEditDialog.setLocationRelativeTo(frame);
                    schemaEditDialog.setVisible(true);
                }
                catch (Exception ex) {
                    this.getSession().getWorkspace().rollback("Failed to get a list of databases: " + ex.toString());
                    ASUtils.showExceptionDialogNoReport(this.getSession().getArchitectFrame(), "Failed to get list of databases.", ex);
                }
                catch (Throwable ex) {
                    this.getSession().getWorkspace().rollback("Failed to import schema: " + ex.toString());
                    throw new RuntimeException(ex);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to parse " + f.getName() + "."));
                ASUtils.showExceptionDialog(this.getSession(), "Could not read xml schema file.", ex);
            }
            finally {
                this.getSession().getRecentMenu().putRecentFileName(f.getAbsolutePath());
            }
        }
    }

    private void addGUIComponents(OLAPEditSession editSession) {
        PlayPen pp = editSession.getOlapPlayPen();
        MondrianModel.Schema schema = editSession.getOlapSession().getSchema();
        HashMap<String, DimensionPane> dimPaneMap = new HashMap<String, DimensionPane>();
        HashMap<String, CubePane> cubePaneMap = new HashMap<String, CubePane>();
        HashMap<String, VirtualCubePane> vCubePaneMap = new HashMap<String, VirtualCubePane>();
        int dimMaxHeight = 0;
        int cubeMaxHeight = 0;
        int vCubeMaxHeight = 0;
        for (OLAPObject child : schema.getChildren(OLAPObject.class)) {
            if (child instanceof MondrianModel.Dimension) {
                MondrianModel.Dimension dim = (MondrianModel.Dimension)child;
                DimensionPane dimPane = new DimensionPane(dim, pp.getContentPane());
                dimPaneMap.put(OLAPUtil.nameFor(dim), dimPane);
                dimMaxHeight = Math.max(dimMaxHeight, dimPane.getPreferredSize().height);
                continue;
            }
            if (child instanceof MondrianModel.Cube) {
                MondrianModel.Cube cube = (MondrianModel.Cube)child;
                CubePane cubePane = new CubePane(cube, pp.getContentPane());
                cubePaneMap.put(OLAPUtil.nameFor(cube), cubePane);
                cubeMaxHeight = Math.max(cubeMaxHeight, cubePane.getPreferredSize().height);
                continue;
            }
            if (child instanceof MondrianModel.VirtualCube) {
                MondrianModel.VirtualCube vCube = (MondrianModel.VirtualCube)child;
                VirtualCubePane vCubePane = new VirtualCubePane(vCube, pp.getContentPane());
                vCubePaneMap.put(OLAPUtil.nameFor(vCube), vCubePane);
                vCubeMaxHeight = Math.max(vCubeMaxHeight, vCubePane.getPreferredSize().height);
                continue;
            }
            logger.warn((Object)("Unsupported gui component, skipping over: " + (Object)((Object)child)));
        }
        Point p = new Point(INITIAL_POINT);
        for (DimensionPane dimPane : dimPaneMap.values()) {
            pp.addPlayPenComponent(dimPane, p);
            p.translate(dimPane.getPreferredSize().width + 10, 0);
        }
        p.setLocation(ImportSchemaAction.INITIAL_POINT.x, p.y + dimMaxHeight + 50);
        for (CubePane cubePane : cubePaneMap.values()) {
            pp.addPlayPenComponent(cubePane, p);
            p.translate(cubePane.getPreferredSize().width + 10, 0);
        }
        p.setLocation(ImportSchemaAction.INITIAL_POINT.x, p.y + cubeMaxHeight + 50);
        for (VirtualCubePane vCubePane : vCubePaneMap.values()) {
            pp.addPlayPenComponent(vCubePane, p);
            p.translate(vCubePane.getPreferredSize().width + 10, 0);
        }
        for (OLAPObject child : schema.getChildren(OLAPObject.class)) {
            if (child instanceof MondrianModel.VirtualCube) {
                MondrianModel.VirtualCube vCube = (MondrianModel.VirtualCube)child;
                if (vCube.getCubeUsage() == null) continue;
                for (MondrianModel.CubeUsage cubeUsage : vCube.getCubeUsage().getCubeUsages()) {
                    CubePane cubePane = (CubePane)cubePaneMap.get(cubeUsage.getCubeName());
                    VirtualCubePane vCubePane = (VirtualCubePane)vCubePaneMap.get(OLAPUtil.nameFor(vCube));
                    UsageComponent uc = new UsageComponent(pp.getContentPane(), cubeUsage, cubePane, vCubePane);
                    pp.getContentPane().addChild((SPObject)uc, pp.getContentPane().getChildren().size());
                }
                continue;
            }
            if (!(child instanceof MondrianModel.Cube)) continue;
            MondrianModel.Cube cube = (MondrianModel.Cube)child;
            for (MondrianModel.CubeDimension dim : cube.getDimensions()) {
                if (!(dim instanceof MondrianModel.DimensionUsage)) continue;
                MondrianModel.DimensionUsage dimUsage = (MondrianModel.DimensionUsage)dim;
                DimensionPane dimPane = (DimensionPane)dimPaneMap.get(dimUsage.getSource());
                CubePane cubePane = (CubePane)cubePaneMap.get(OLAPUtil.nameFor(cube));
                UsageComponent uc = new UsageComponent(pp.getContentPane(), dimUsage, dimPane, cubePane);
                pp.getContentPane().addChild((SPObject)uc, pp.getContentPane().getChildren().size());
            }
        }
    }
}

