/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.BufferChangedListener;

public class Log4jStringAppender
implements Appender {
    private Layout layout;
    private Filter filter;
    private String name;
    private StringBuffer buffer = new StringBuffer();
    private int nrLines = 0;
    private int maxNrLines = -1;
    private List<BufferChangedListener> bufferChangedListeners = new ArrayList<BufferChangedListener>();

    public String toString() {
        return this.buffer.toString();
    }

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void close() {
    }

    public void doAppend(LoggingEvent event) {
        String line = this.layout.format(event) + Const.CR;
        this.buffer.append(line);
        ++this.nrLines;
        if (this.maxNrLines > 0 && this.nrLines > this.maxNrLines) {
            this.buffer.delete(0, line.length());
            --this.nrLines;
        }
        for (BufferChangedListener listener : this.bufferChangedListeners) {
            listener.contentWasAdded(this.buffer, line, this.nrLines);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public int getMaxNrLines() {
        return this.maxNrLines;
    }

    public void setMaxNrLines(int maxNrLines) {
        this.maxNrLines = maxNrLines;
    }

    public int getNrLines() {
        return this.nrLines;
    }

    public void addBufferChangedListener(BufferChangedListener bufferChangedListener) {
        this.bufferChangedListeners.add(bufferChangedListener);
    }

    public void removeBufferChangedListener(BufferChangedListener bufferChangedListener) {
        this.bufferChangedListeners.remove(bufferChangedListener);
    }

    public void setNrLines(int nrLines) {
        this.nrLines = nrLines;
    }
}

