/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import org.jboss.galleon.universe.UniverseSpec;

public class FeaturePackLocation {
    public static final char BUILD_START = '#';
    public static final char CHANNEL_START = ':';
    public static final char FREQUENCY_START = '/';
    public static final char UNIVERSE_LOCATION_END = ')';
    public static final char UNIVERSE_LOCATION_START = '(';
    public static final char UNIVERSE_START = '@';
    private final UniverseSpec universeSpec;
    private final String producer;
    private final String channel;
    private final String frequency;
    private final String build;
    private ProducerSpec producerSpec;
    private ChannelSpec channelSpec;
    private FPID fpid;
    private final int hash;

    /*
     * Enabled aggressive block sorting
     */
    public static FeaturePackLocation fromString(String str) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        int buildSep = str.lastIndexOf(35);
        if (buildSep < 0) {
            buildSep = str.length();
        }
        int universeEnd = buildSep;
        int channelNameEnd = buildSep;
        int producerEnd = 0;
        block6: while (universeEnd > 0) {
            switch (str.charAt(--universeEnd)) {
                case '/': {
                    channelNameEnd = universeEnd;
                    break;
                }
                case '@': {
                    producerEnd = universeEnd;
                    universeEnd = buildSep;
                }
                case ':': {
                    break block6;
                }
                case ')': {
                    ++universeEnd;
                    break block6;
                }
            }
        }
        if (producerEnd == 0) {
            while (producerEnd < universeEnd && str.charAt(producerEnd) != '@') {
                ++producerEnd;
            }
            if (producerEnd == 0) {
                producerEnd = Math.min(channelNameEnd, buildSep);
            } else if (producerEnd == universeEnd && channelNameEnd == str.length()) {
                String[] parts = null;
                int partI = 1;
                int lastColon = -1;
                for (int i = 1; i < producerEnd; ++i) {
                    if (str.charAt(i) != ':') continue;
                    if (parts == null) {
                        parts = new String[5];
                        parts[0] = str.substring(0, i);
                        parts[4] = str.substring(universeEnd + 1, channelNameEnd);
                        lastColon = i;
                        continue;
                    }
                    parts[partI++] = str.substring(lastColon + 1, i);
                    lastColon = i;
                }
                if (parts != null) {
                    String string2;
                    parts[partI] = str.substring(lastColon + 1, producerEnd);
                    UniverseSpec universeSpec = new UniverseSpec("maven");
                    String string3 = parts[0];
                    String string4 = parts[1];
                    String string5 = parts[2] == null ? "" : parts[2];
                    if (partI != 3) {
                        string2 = "zip";
                        return new FeaturePackLocation(universeSpec, string3 + ":" + string4 + ":" + string5 + ":" + string2, null, null, parts[4]);
                    }
                    string2 = parts[3];
                    return new FeaturePackLocation(universeSpec, string3 + ":" + string4 + ":" + string5 + ":" + string2, null, null, parts[4]);
                }
            }
        }
        UniverseSpec universeSpec = universeEnd == 0 || producerEnd == universeEnd ? null : UniverseSpec.fromString(str.substring(producerEnd + 1, universeEnd));
        String string6 = str.substring(0, producerEnd);
        String string7 = universeEnd == 0 || universeEnd == channelNameEnd ? null : str.substring(universeEnd + 1, channelNameEnd);
        String string8 = channelNameEnd == buildSep ? null : str.substring(channelNameEnd + 1, buildSep);
        if (buildSep == str.length()) {
            string = null;
            return new FeaturePackLocation(universeSpec, string6, string7, string8, string);
        }
        string = str.substring(buildSep + 1);
        return new FeaturePackLocation(universeSpec, string6, string7, string8, string);
    }

    private static String toString(UniverseSpec universeSpec, String producer, String channel, String frequency, String build) {
        StringBuilder buf = new StringBuilder();
        buf.append(producer);
        if (universeSpec != null) {
            if (universeSpec.getLocation() == null && build != null && universeSpec.getFactory().equals("maven")) {
                int lastColon = producer.lastIndexOf(58);
                if (lastColon > 0 && producer.endsWith("zip")) {
                    if (producer.charAt(lastColon - 1) == ':') {
                        --lastColon;
                    }
                    buf.setLength(lastColon);
                }
                return buf.append(':').append(build).toString();
            }
            buf.append('@').append(universeSpec);
        }
        if (channel != null) {
            buf.append(':').append(channel);
        }
        if (frequency != null) {
            buf.append('/').append(frequency);
        }
        if (build != null) {
            buf.append('#').append(build);
        }
        return buf.toString();
    }

    public FeaturePackLocation(UniverseSpec universeSpec, String producer, String channelName, String frequency, String build) {
        this.universeSpec = universeSpec;
        this.producer = producer;
        this.channel = channelName;
        this.frequency = frequency;
        this.build = build;
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (build == null ? 0 : build.hashCode());
        hash = 31 * hash + (this.channel == null ? 0 : this.channel.hashCode());
        hash = 31 * hash + (frequency == null ? 0 : frequency.hashCode());
        hash = 31 * hash + producer.hashCode();
        this.hash = hash = 31 * hash + (universeSpec == null ? 0 : universeSpec.hashCode());
    }

    public boolean hasUniverse() {
        return this.universeSpec != null;
    }

    public UniverseSpec getUniverse() {
        return this.universeSpec;
    }

    public String getProducerName() {
        return this.producer;
    }

    public String getChannelName() {
        return this.channel;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public boolean hasBuild() {
        return this.build != null;
    }

    public String getBuild() {
        return this.build;
    }

    public ProducerSpec getProducer() {
        return this.producerSpec == null ? (this.producerSpec = new ProducerSpec()) : this.producerSpec;
    }

    public ChannelSpec getChannel() {
        return this.channelSpec == null ? (this.channelSpec = new ChannelSpec()) : this.channelSpec;
    }

    public FPID getFPID() {
        return this.fpid == null ? (this.fpid = new FPID()) : this.fpid;
    }

    public FeaturePackLocation replaceUniverse(UniverseSpec universe) {
        return new FeaturePackLocation(universe, this.producer, this.channel, this.frequency, this.build);
    }

    public FeaturePackLocation replaceBuild(String build) {
        return new FeaturePackLocation(this.universeSpec, this.producer, this.channel, this.frequency, build);
    }

    public boolean isMavenCoordinates() {
        return this.universeSpec != null && this.universeSpec.getLocation() == null && "maven".equals(this.universeSpec.getFactory());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackLocation other = (FeaturePackLocation)obj;
        if (this.build == null ? other.build != null : !this.build.equals(other.build)) {
            return false;
        }
        if (this.channel == null ? other.channel != null : !this.channel.equals(other.channel)) {
            return false;
        }
        if (this.frequency == null ? other.frequency != null : !this.frequency.equals(other.frequency)) {
            return false;
        }
        if (this.producer == null ? other.producer != null : !this.producer.equals(other.producer)) {
            return false;
        }
        return !(this.universeSpec == null ? other.universeSpec != null : !this.universeSpec.equals(other.universeSpec));
    }

    public String toString() {
        return FeaturePackLocation.toString(this.universeSpec, this.producer, this.channel, this.frequency, this.build);
    }

    public class ProducerSpec {
        private final int hash;

        private ProducerSpec() {
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + FeaturePackLocation.this.producer.hashCode();
            this.hash = hash = 31 * hash + (FeaturePackLocation.this.universeSpec == null ? 0 : FeaturePackLocation.this.universeSpec.hashCode());
        }

        public UniverseSpec getUniverse() {
            return FeaturePackLocation.this.universeSpec;
        }

        public String getName() {
            return FeaturePackLocation.this.producer;
        }

        public FeaturePackLocation getLocation() {
            return FeaturePackLocation.this;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProducerSpec other = (ProducerSpec)obj;
            Object otherField = other.getName();
            if (FeaturePackLocation.this.producer == null ? otherField != null : !FeaturePackLocation.this.producer.equals(otherField)) {
                return false;
            }
            otherField = other.getUniverse();
            return !(FeaturePackLocation.this.universeSpec == null ? otherField != null : !FeaturePackLocation.this.universeSpec.equals(otherField));
        }

        public String toString() {
            return FeaturePackLocation.toString(FeaturePackLocation.this.universeSpec, FeaturePackLocation.this.producer, null, null, null);
        }
    }

    public class ChannelSpec {
        private final int hash;

        private ChannelSpec() {
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + (FeaturePackLocation.this.channel == null ? 0 : FeaturePackLocation.this.channel.hashCode());
            hash = 31 * hash + FeaturePackLocation.this.producer.hashCode();
            this.hash = hash = 31 * hash + (FeaturePackLocation.this.universeSpec == null ? 0 : FeaturePackLocation.this.universeSpec.hashCode());
        }

        public UniverseSpec getUniverse() {
            return FeaturePackLocation.this.universeSpec;
        }

        public String getProducer() {
            return FeaturePackLocation.this.producer;
        }

        public String getName() {
            return FeaturePackLocation.this.channel;
        }

        public FeaturePackLocation getLocation() {
            return FeaturePackLocation.this;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChannelSpec other = (ChannelSpec)obj;
            Object otherField = other.getName();
            if (FeaturePackLocation.this.channel == null ? otherField != null : !FeaturePackLocation.this.channel.equals(otherField)) {
                return false;
            }
            otherField = other.getProducer();
            if (FeaturePackLocation.this.producer == null ? otherField != null : !FeaturePackLocation.this.producer.equals(otherField)) {
                return false;
            }
            otherField = other.getUniverse();
            return !(FeaturePackLocation.this.universeSpec == null ? otherField != null : !FeaturePackLocation.this.universeSpec.equals(otherField));
        }

        public String toString() {
            return FeaturePackLocation.toString(FeaturePackLocation.this.universeSpec, FeaturePackLocation.this.producer, FeaturePackLocation.this.channel, null, null);
        }
    }

    public class FPID {
        private final int hash;

        private FPID() {
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + this.getChannel().hashCode();
            this.hash = hash = 31 * hash + (FeaturePackLocation.this.build == null ? 0 : FeaturePackLocation.this.build.hashCode());
        }

        public UniverseSpec getUniverse() {
            return FeaturePackLocation.this.universeSpec;
        }

        public ProducerSpec getProducer() {
            return FeaturePackLocation.this.getProducer();
        }

        public ChannelSpec getChannel() {
            return FeaturePackLocation.this.getChannel();
        }

        public String getBuild() {
            return FeaturePackLocation.this.build;
        }

        public FeaturePackLocation getLocation() {
            return FeaturePackLocation.this;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FPID other = (FPID)obj;
            Object thisField = this.getChannel();
            Object otherField = other.getChannel();
            if (thisField == null ? otherField != null : !thisField.equals(otherField)) {
                return false;
            }
            thisField = this.getBuild();
            otherField = other.getBuild();
            return !(thisField == null ? otherField != null : !thisField.equals(otherField));
        }

        public String toString() {
            return FeaturePackLocation.toString(FeaturePackLocation.this.universeSpec, FeaturePackLocation.this.producer, FeaturePackLocation.this.channel, null, FeaturePackLocation.this.build);
        }
    }
}

