/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri2.Capability;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Error;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQProvider;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQProvider;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.ForceMute;
import org.jitsi.xmpp.extensions.colibri2.InitialLastNProvider;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.JingleIQProvider;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class IqProviderUtils {
    private static final Logger logger = new LoggerImpl(IqProviderUtils.class.getName());
    private static boolean providersRegistered = false;

    public static void parseExtensions(XmlPullParser parser, int initialDepth, IQ iq) throws XmlPullParserException, IOException, SmackParsingException {
        for (ExtensionElement ext : IqProviderUtils.parseExtensions(parser, initialDepth)) {
            iq.addExtension(ext);
        }
    }

    public static List<ExtensionElement> parseExtensions(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackParsingException {
        ArrayList<ExtensionElement> ret = new ArrayList<ExtensionElement>();
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            switch (eventType) {
                case START_ELEMENT: {
                    String tagName = parser.getName();
                    String namespace = parser.getNamespace();
                    ExtensionElement extension = IqProviderUtils.parseExtension(parser, tagName, namespace);
                    if (extension == null) break;
                    ret.add(extension);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return ret;
                }
            }
        }
    }

    private static ExtensionElement parseExtension(XmlPullParser parser, String name, String namespace) throws XmlPullParserException, IOException, SmackParsingException {
        ExtensionElement extension;
        ExtensionElementProvider<ExtensionElement> extensionProvider = ProviderManager.getExtensionProvider(name, namespace);
        if (extensionProvider == null) {
            logger.warn(() -> "Should parse {" + namespace + "}:" + name + ", but found no extension provider");
            IqProviderUtils.throwAway(parser, name);
            extension = null;
        } else {
            extension = (ExtensionElement)extensionProvider.parse(parser);
        }
        return extension;
    }

    private static void throwAway(XmlPullParser parser, String name) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        while (XmlPullParser.Event.END_ELEMENT != parser.next() || !name.equals(parser.getName()) || parser.getDepth() != initialDepth) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProviders() {
        Class<IqProviderUtils> clazz = IqProviderUtils.class;
        synchronized (IqProviderUtils.class) {
            if (!providersRegistered) {
                IqProviderUtils.doRegisterProviders();
                providersRegistered = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void doRegisterProviders() {
        ProviderManager.addIQProvider("conference-modify", "jitsi:colibri2", new ConferenceModifyIQProvider());
        ProviderManager.addIQProvider("conference-modified", "jitsi:colibri2", new ConferenceModifiedIQProvider());
        ProviderManager.addExtensionProvider("endpoint", "jitsi:colibri2", new Colibri2Endpoint.Provider());
        ProviderManager.addExtensionProvider("relay", "jitsi:colibri2", new Colibri2Relay.Provider());
        ProviderManager.addExtensionProvider("endpoints", "jitsi:colibri2", new DefaultPacketExtensionProvider<Endpoints>(Endpoints.class));
        ProviderManager.addExtensionProvider("sources", "jitsi:colibri2", new DefaultPacketExtensionProvider<Sources>(Sources.class));
        ProviderManager.addExtensionProvider("media-source", "jitsi:colibri2", new MediaSource.Provider());
        ProviderManager.addExtensionProvider("media", "jitsi:colibri2", new Media.Provider());
        ProviderManager.addExtensionProvider("transport", "jitsi:colibri2", new DefaultPacketExtensionProvider<Transport>(Transport.class));
        ProviderManager.addExtensionProvider("parameter", "http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class));
        new JingleIQProvider();
        ProviderManager.addExtensionProvider("force-mute", "jitsi:colibri2", new ForceMute.Provider());
        ProviderManager.addExtensionProvider("initial-last-n", "jitsi:colibri2", new InitialLastNProvider());
        ProviderManager.addExtensionProvider("capability", "jitsi:colibri2", new Capability.Provider());
        ProviderManager.addExtensionProvider("sctp", "jitsi:colibri2", new Sctp.Provider());
        ProviderManager.addExtensionProvider("error", "jitsi:colibri2", new Colibri2Error.Provider());
    }
}

