/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jitsi.srtp.crypto.SrtpCipher;

public class SrtpCipherCtr
extends SrtpCipher {
    private SecretKeySpec key = null;

    public SrtpCipherCtr(Cipher cipher) {
        super(cipher);
    }

    @Override
    public void init(byte[] key, byte[] saltKey) {
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new IllegalArgumentException("Invalid key length");
        }
        this.key = this.getSecretKey(key);
    }

    @Override
    public void setIV(byte[] iv, int opmode) throws GeneralSecurityException {
        if (iv.length != this.cipher.getBlockSize()) {
            throw new IllegalArgumentException("iv.length != BLKLEN");
        }
        this.cipher.init(opmode, (Key)this.key, new IvParameterSpec(iv));
    }

    @Override
    public void processAAD(byte[] data, int off, int len) {
        throw new IllegalStateException("CTR mode does not accept AAD");
    }

    @Override
    public int process(byte[] data, int off, int len) throws GeneralSecurityException {
        return this.cipher.doFinal(data, off, len, data, off);
    }
}

