/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TCPInterceptor
extends JFrame {
    private JTabbedPane notebook = new JTabbedPane();
    private static int STATE_COLUMN = 0;
    private static int TIME_COLUMN = 1;
    private static int INHOST_COLUMN = 2;
    private static int OUTHOST_COLUMN = 3;
    private static int REQ_COLUMN = 4;
    private static ResourceBundle messages = null;

    public TCPInterceptor(int listenPort, String targetHost, int targetPort) {
        super(TCPInterceptor.getMessage("tcpint00", "TCPInterceptor"));
        this.getContentPane().add(this.notebook);
        new AdminPage(this.notebook, TCPInterceptor.getMessage("admin00", "Admin"));
        if (listenPort != 0) {
            Listener l = null;
            l = targetHost == null ? new Listener(this.notebook, null, listenPort, targetHost, targetPort, true) : new Listener(this.notebook, null, listenPort, targetHost, targetPort, false);
            this.notebook.setSelectedIndex(1);
            l.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (l.HTTPProxyHost != null && l.HTTPProxyHost.equals("")) {
                l.HTTPProxyHost = null;
            }
            if (l.HTTPProxyHost != null) {
                String tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                l.HTTPProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
            }
        }
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent event) {
        switch (event.getID()) {
            case 201: {
                this.exit();
                break;
            }
            default: {
                super.processWindowEvent(event);
            }
        }
    }

    private static String fixContentLengthHeaders(String text) {
        if (text.startsWith("POST ") || text.startsWith("GET ")) {
            String headers;
            int pos1;
            int pos3 = text.indexOf("\n\n");
            if (pos3 == -1) {
                pos3 = text.indexOf("\r\n\r\n");
                if (pos3 != -1) {
                    pos3 += 4;
                }
            } else {
                pos3 += 2;
            }
            if ((pos1 = (headers = text.substring(0, pos3)).indexOf("Content-Length:")) != -1) {
                int newLen = text.length() - pos3;
                int pos2 = headers.indexOf("\n", pos1);
                text = headers.substring(0, pos1) + "Content-Length: " + newLen + "\n" + headers.substring(pos2 + 1) + text.substring(pos3);
            }
        } else {
            System.err.println("Error - asked to fix content length for a bad request (no POST or GET)");
        }
        return text;
    }

    private void exit() {
        System.exit(0);
    }

    public void setInputPort(int port) {
    }

    public void setOutputHostPort(char hostName, int port) {
    }

    public static void main(String[] args) {
        try {
            if (args.length == 3) {
                int p1 = Integer.parseInt(args[0]);
                int p2 = Integer.parseInt(args[2]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new TCPInterceptor(p1, args[1], p2);
            } else if (args.length == 1) {
                int p1 = Integer.parseInt(args[0]);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new TCPInterceptor(p1, null, 0);
            } else if (args.length != 0) {
                System.err.println(TCPInterceptor.getMessage("usage00", "Usage:") + " TCPInterceptor [listenPort targetHost targetPort]\n");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new TCPInterceptor(8080, "localhost", 8888);
            }
        }
        catch (Throwable exp) {
            exp.printStackTrace();
        }
    }

    public static String getMessage(String key, String defaultMsg) {
        try {
            if (messages == null) {
                TCPInterceptor.initializeMessages();
            }
            return messages.getString(key);
        }
        catch (Throwable t) {
            return defaultMsg;
        }
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("org.apache.axis.utils.TCPInterceptor");
    }

    class Listener
    extends JPanel {
        public Socket inputSocket = null;
        public Socket outputSocket = null;
        public JTextField portField = null;
        public JTextField hostField = null;
        public JTextField tPortField = null;
        public JCheckBox isProxyBox = null;
        public JCheckBox holdRequestBox = null;
        public JCheckBox holdResponseBox = null;
        public JButton stopButton = null;
        public JButton removeButton = null;
        public JButton removeAllButton = null;
        public JCheckBox xmlFormatBox = null;
        public JButton saveButton = null;
        public JButton resendButton = null;
        public JButton sendButton = null;
        public JButton switchButton = null;
        public JButton closeButton = null;
        public JTable connectionTable = null;
        public DefaultTableModel tableModel = null;
        public JSplitPane outPane = null;
        public ServerSocket sSocket = null;
        public SocketWaiter sw = null;
        public JPanel leftPanel = null;
        public JPanel rightPanel = null;
        public JTabbedPane notebook = null;
        public String HTTPProxyHost = null;
        public int HTTPProxyPort = 80;
        public final Vector connections = new Vector();

        public Listener(JTabbedPane _notebook, String name, int listenPort, String host, int targetPort, boolean isProxy) {
            this.notebook = _notebook;
            if (name == null) {
                name = TCPInterceptor.getMessage("port01", "Port") + " " + listenPort;
            }
            this.setLayout(new BorderLayout());
            JPanel top = new JPanel();
            top.setLayout(new BoxLayout(top, 0));
            top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String start = TCPInterceptor.getMessage("start00", "Start");
            this.stopButton = new JButton(start);
            top.add(this.stopButton);
            top.add(Box.createRigidArea(new Dimension(5, 0)));
            top.add(new JLabel("  " + TCPInterceptor.getMessage("listenPort01", "Listen Port:") + " ", 4));
            this.portField = new JTextField("" + listenPort, 4);
            top.add(this.portField);
            top.add(new JLabel("  " + TCPInterceptor.getMessage("host00", "Host:"), 4));
            this.hostField = new JTextField(host, 30);
            top.add(this.hostField);
            top.add(new JLabel("  " + TCPInterceptor.getMessage("port02", "Port:") + " ", 4));
            this.tPortField = new JTextField("" + targetPort, 4);
            top.add(this.tPortField);
            top.add(Box.createRigidArea(new Dimension(5, 0)));
            this.isProxyBox = new JCheckBox(TCPInterceptor.getMessage("proxy00", "Proxy"));
            top.add(this.isProxyBox);
            this.holdRequestBox = new JCheckBox(TCPInterceptor.getMessage("holdRequest", "Hold Request"));
            top.add(this.holdRequestBox);
            this.holdResponseBox = new JCheckBox(TCPInterceptor.getMessage("holdResponse", "Hold Response"));
            top.add(this.holdResponseBox);
            this.isProxyBox.addChangeListener(new BasicButtonListener(this.isProxyBox){

                public void stateChanged(ChangeEvent event) {
                    JCheckBox box = (JCheckBox)event.getSource();
                    boolean state = box.isSelected();
                    Listener.this.tPortField.setEnabled(!state);
                    Listener.this.hostField.setEnabled(!state);
                }
            });
            this.isProxyBox.setSelected(isProxy);
            this.portField.setEditable(false);
            this.portField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.hostField.setEditable(false);
            this.hostField.setMaximumSize(new Dimension(85, Short.MAX_VALUE));
            this.tPortField.setEditable(false);
            this.tPortField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (TCPInterceptor.getMessage("stop00", "Stop").equals(event.getActionCommand())) {
                        Listener.this.stop();
                    }
                    if (start.equals(event.getActionCommand())) {
                        Listener.this.start();
                    }
                }
            });
            this.add((Component)top, "North");
            this.tableModel = new DefaultTableModel(new String[]{TCPInterceptor.getMessage("state00", "State"), TCPInterceptor.getMessage("time00", "Time"), TCPInterceptor.getMessage("requestHost00", "Request Host"), TCPInterceptor.getMessage("targetHost", "Target Host"), TCPInterceptor.getMessage("request00", "Request...")}, 0);
            this.connectionTable = new JTable(1, 2);
            this.connectionTable.setModel(this.tableModel);
            this.connectionTable.setSelectionMode(2);
            TableColumn col = this.connectionTable.getColumnModel().getColumn(STATE_COLUMN);
            col.setMaxWidth(col.getPreferredWidth() / 2);
            col = this.connectionTable.getColumnModel().getColumn(REQ_COLUMN);
            col.setPreferredWidth(col.getPreferredWidth() * 2);
            ListSelectionModel sel = this.connectionTable.getSelectionModel();
            this.tableModel.addRow(new Object[]{"---", TCPInterceptor.getMessage("mostRecent00", "Most Recent"), "---", "---", "---"});
            JPanel tablePane = new JPanel();
            tablePane.setLayout(new BorderLayout());
            JScrollPane tableScrollPane = new JScrollPane(this.connectionTable);
            tablePane.add((Component)tableScrollPane, "Center");
            JPanel buttons = new JPanel();
            buttons.setLayout(new BoxLayout(buttons, 0));
            buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String removeSelected = TCPInterceptor.getMessage("removeSelected00", "Remove Selected");
            this.removeButton = new JButton(removeSelected);
            buttons.add(this.removeButton);
            buttons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String removeAll = TCPInterceptor.getMessage("removeAll00", "Remove All");
            this.removeAllButton = new JButton(removeAll);
            buttons.add(this.removeAllButton);
            tablePane.add((Component)buttons, "South");
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (removeSelected.equals(event.getActionCommand())) {
                        Listener.this.remove();
                    }
                }
            });
            this.removeAllButton.setEnabled(false);
            this.removeAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (removeAll.equals(event.getActionCommand())) {
                        Listener.this.removeAll();
                    }
                }
            });
            JPanel pane2 = new JPanel();
            pane2.setLayout(new BorderLayout());
            this.leftPanel = new JPanel();
            this.leftPanel.setAlignmentX(0.0f);
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
            this.leftPanel.add(new JLabel("  " + TCPInterceptor.getMessage("request01", "Request")));
            this.leftPanel.add(new JLabel(" " + TCPInterceptor.getMessage("wait01", "Waiting for connection")));
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.rightPanel.add(new JLabel("  " + TCPInterceptor.getMessage("response00", "Response")));
            this.rightPanel.add(new JLabel(""));
            this.outPane = new JSplitPane(0, this.leftPanel, this.rightPanel);
            this.outPane.setDividerSize(4);
            pane2.add((Component)this.outPane, "Center");
            JPanel bottomButtons = new JPanel();
            bottomButtons.setLayout(new BoxLayout(bottomButtons, 0));
            bottomButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.xmlFormatBox = new JCheckBox(TCPInterceptor.getMessage("xmlFormat00", "XML Format"));
            bottomButtons.add(this.xmlFormatBox);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String save = TCPInterceptor.getMessage("save00", "Save");
            this.saveButton = new JButton(save);
            bottomButtons.add(this.saveButton);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String resend = TCPInterceptor.getMessage("resend00", "Resend");
            this.resendButton = new JButton(resend);
            bottomButtons.add(this.resendButton);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            String sendStr = TCPInterceptor.getMessage("send", "Send");
            this.sendButton = new JButton(sendStr);
            bottomButtons.add(this.sendButton);
            bottomButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            final String switchStr = TCPInterceptor.getMessage("switch00", "Switch Layout");
            this.switchButton = new JButton(switchStr);
            bottomButtons.add(this.switchButton);
            bottomButtons.add(Box.createHorizontalGlue());
            final String close = TCPInterceptor.getMessage("close00", "Close");
            this.closeButton = new JButton(close);
            bottomButtons.add(this.closeButton);
            pane2.add((Component)bottomButtons, "South");
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (save.equals(event.getActionCommand())) {
                        Listener.this.save();
                    }
                }
            });
            this.resendButton.setEnabled(false);
            this.resendButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (resend.equals(event.getActionCommand())) {
                        Listener.this.resend();
                    }
                }
            });
            this.switchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (switchStr.equals(event.getActionCommand())) {
                        int v = Listener.this.outPane.getOrientation();
                        if (v == 0) {
                            Listener.this.outPane.setOrientation(1);
                        } else {
                            Listener.this.outPane.setOrientation(0);
                        }
                        Listener.this.outPane.setDividerLocation(0.5);
                    }
                }
            });
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (close.equals(event.getActionCommand())) {
                        Listener.this.close();
                    }
                }
            });
            JSplitPane pane1 = new JSplitPane(0);
            pane1.setDividerSize(4);
            pane1.setTopComponent(tablePane);
            pane1.setBottomComponent(pane2);
            pane1.setDividerLocation(150);
            this.add((Component)pane1, "Center");
            sel.setSelectionInterval(0, 0);
            this.outPane.setDividerLocation(150);
            this.notebook.addTab(name, this);
            sel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent event) {
                    if (event.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel m = (ListSelectionModel)event.getSource();
                    int divLoc = Listener.this.outPane.getDividerLocation();
                    if (m.isSelectionEmpty()) {
                        Listener.this.setLeft(new JLabel(" " + TCPInterceptor.getMessage("wait00", "Waiting for Connection...")));
                        Listener.this.setRight(new JLabel(""));
                        Listener.this.removeButton.setEnabled(false);
                        Listener.this.removeAllButton.setEnabled(false);
                        Listener.this.saveButton.setEnabled(false);
                        Listener.this.resendButton.setEnabled(false);
                        Listener.this.sendButton.setEnabled(false);
                    } else {
                        int row = m.getLeadSelectionIndex();
                        if (row == 0) {
                            if (Listener.this.connections.size() == 0) {
                                Listener.this.setLeft(new JLabel(" " + TCPInterceptor.getMessage("wait00", "Waiting for connection...")));
                                Listener.this.setRight(new JLabel(""));
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(false);
                                Listener.this.saveButton.setEnabled(false);
                                Listener.this.resendButton.setEnabled(false);
                                Listener.this.sendButton.setEnabled(false);
                            } else {
                                Connection conn = (Connection)Listener.this.connections.lastElement();
                                Listener.this.setLeft(conn.inputScroll);
                                Listener.this.setRight(conn.outputScroll);
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(true);
                                Listener.this.saveButton.setEnabled(true);
                                Listener.this.resendButton.setEnabled(true);
                            }
                        } else {
                            Connection conn = (Connection)Listener.this.connections.get(row - 1);
                            Listener.this.setLeft(conn.inputScroll);
                            Listener.this.setRight(conn.outputScroll);
                            Listener.this.removeButton.setEnabled(true);
                            Listener.this.removeAllButton.setEnabled(true);
                            Listener.this.saveButton.setEnabled(true);
                            Listener.this.resendButton.setEnabled(true);
                        }
                    }
                    Listener.this.outPane.setDividerLocation(divLoc);
                }
            });
            this.start();
        }

        public void setLeft(Component left) {
            this.leftPanel.removeAll();
            this.leftPanel.add(left);
        }

        public void setRight(Component right) {
            this.rightPanel.removeAll();
            this.rightPanel.add(right);
        }

        public void start() {
            int port = Integer.parseInt(this.portField.getText());
            this.portField.setText("" + port);
            int i = this.notebook.indexOfComponent(this);
            this.notebook.setTitleAt(i, TCPInterceptor.getMessage("port01", "Port") + " " + port);
            int tmp = Integer.parseInt(this.tPortField.getText());
            this.tPortField.setText("" + tmp);
            this.sw = new SocketWaiter(this, port);
            this.stopButton.setText(TCPInterceptor.getMessage("stop00", "Stop"));
            this.portField.setEditable(false);
            this.hostField.setEditable(false);
            this.tPortField.setEditable(false);
            this.isProxyBox.setEnabled(false);
        }

        public void close() {
            this.stop();
            this.notebook.remove(this);
        }

        public void stop() {
            try {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection conn = (Connection)this.connections.get(i);
                    conn.halt();
                }
                this.sw.halt();
                this.stopButton.setText(TCPInterceptor.getMessage("start00", "Start"));
                this.portField.setEditable(true);
                this.hostField.setEditable(true);
                this.tPortField.setEditable(true);
                this.isProxyBox.setEnabled(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void remove() {
            int top;
            ListSelectionModel lsm = this.connectionTable.getSelectionModel();
            int bot = lsm.getMinSelectionIndex();
            for (int i = top = lsm.getMaxSelectionIndex(); i >= bot; --i) {
                ((Connection)this.connections.get(i - 1)).remove();
            }
            if (bot > this.connections.size()) {
                bot = this.connections.size();
            }
            lsm.setSelectionInterval(bot, bot);
        }

        public void removeAll() {
            ListSelectionModel lsm = this.connectionTable.getSelectionModel();
            lsm.clearSelection();
            while (this.connections.size() > 0) {
                ((Connection)this.connections.get(0)).remove();
            }
            lsm.setSelectionInterval(0, 0);
        }

        public void save() {
            JFileChooser dialog = new JFileChooser(".");
            int rc = dialog.showSaveDialog(this);
            if (rc == 0) {
                try {
                    File file = dialog.getSelectedFile();
                    FileOutputStream out = new FileOutputStream(file);
                    ListSelectionModel lsm = this.connectionTable.getSelectionModel();
                    rc = lsm.getLeadSelectionIndex();
                    if (rc == 0) {
                        rc = this.connections.size();
                    }
                    Connection conn = (Connection)this.connections.get(rc - 1);
                    rc = Integer.parseInt(this.portField.getText());
                    out.write(new String(TCPInterceptor.getMessage("listenPort01", "Listen Port:") + " " + rc + "\n").getBytes());
                    out.write(new String(TCPInterceptor.getMessage("targetHost01", "Target Host:") + " " + this.hostField.getText() + "\n").getBytes());
                    rc = Integer.parseInt(this.tPortField.getText());
                    out.write(new String(TCPInterceptor.getMessage("targetPort01", "Target Port:") + " " + rc + "\n").getBytes());
                    out.write(new String("==== " + TCPInterceptor.getMessage("request01", "Request") + " ====\n").getBytes());
                    out.write(conn.inputText.getText().getBytes());
                    out.write(new String("==== " + TCPInterceptor.getMessage("response00", "Response") + " ====\n").getBytes());
                    out.write(conn.outputText.getText().getBytes());
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void resend() {
            try {
                ListSelectionModel lsm = this.connectionTable.getSelectionModel();
                int rc = lsm.getLeadSelectionIndex();
                if (rc == 0) {
                    rc = this.connections.size();
                }
                Connection conn = (Connection)this.connections.get(rc - 1);
                if (rc > 0) {
                    lsm.clearSelection();
                    lsm.setSelectionInterval(0, 0);
                }
                ByteArrayInputStream in = null;
                String text = conn.inputText.getText();
                text = TCPInterceptor.fixContentLengthHeaders(text);
                in = new ByteArrayInputStream(text.getBytes());
                new Connection(this, in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Connection
    extends Thread {
        Listener listener;
        boolean active;
        String fromHost;
        String time;
        JTextArea inputText = null;
        JScrollPane inputScroll = null;
        JTextArea outputText = null;
        JScrollPane outputScroll = null;
        Socket inSocket = null;
        Socket outSocket = null;
        Thread clientThread = null;
        Thread serverThread = null;
        SocketRR requestSocketRR = null;
        SocketRR ResponseSocketRR = null;
        InputStream inputStream = null;
        String HTTPProxyHost = null;
        int HTTPProxyPort = 80;

        public Connection(Listener l) {
            this.listener = l;
            this.HTTPProxyHost = l.HTTPProxyHost;
            this.HTTPProxyPort = l.HTTPProxyPort;
        }

        public Connection(Listener l, Socket s) {
            this(l);
            this.inSocket = s;
            this.start();
        }

        public Connection(Listener l, InputStream in) {
            this(l);
            this.inputStream = in;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] b;
                this.active = true;
                this.HTTPProxyHost = System.getProperty("http.proxyHost");
                if (this.HTTPProxyHost != null && this.HTTPProxyHost.equals("")) {
                    this.HTTPProxyHost = null;
                }
                if (this.HTTPProxyHost != null) {
                    String tmp = System.getProperty("http.proxyPort");
                    if (tmp != null && tmp.equals("")) {
                        tmp = null;
                    }
                    this.HTTPProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
                }
                this.fromHost = this.inSocket != null ? this.inSocket.getInetAddress().getHostName() : "resend";
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");
                this.time = df.format(new Date());
                int count = this.listener.connections.size();
                this.listener.tableModel.insertRow(count + 1, new Object[]{TCPInterceptor.getMessage("active00", "Active"), this.time, this.fromHost, this.listener.hostField.getText(), ""});
                this.listener.connections.add(this);
                this.inputText = new JTextArea(null, null, 20, 80);
                this.inputScroll = new JScrollPane(this.inputText);
                this.outputText = new JTextArea(null, null, 20, 80);
                this.outputScroll = new JScrollPane(this.outputText);
                ListSelectionModel lsm = this.listener.connectionTable.getSelectionModel();
                if (count == 0 || lsm.getLeadSelectionIndex() == 0) {
                    this.listener.outPane.setVisible(false);
                    int divLoc = this.listener.outPane.getDividerLocation();
                    this.listener.setLeft(this.inputScroll);
                    this.listener.setRight(this.outputScroll);
                    this.listener.removeButton.setEnabled(false);
                    this.listener.removeAllButton.setEnabled(true);
                    this.listener.saveButton.setEnabled(true);
                    this.listener.resendButton.setEnabled(true);
                    this.listener.outPane.setDividerLocation(divLoc);
                    this.listener.outPane.setVisible(true);
                }
                String targetHost = this.listener.hostField.getText();
                int targetPort = Integer.parseInt(this.listener.tPortField.getText());
                InputStream inSocketInputStream = this.inputStream;
                OutputStream inSocketOutputStream = null;
                InputStream tmpIn2 = null;
                OutputStream tmpOut2 = null;
                if (inSocketInputStream == null) {
                    inSocketInputStream = this.inSocket.getInputStream();
                }
                if (this.inSocket != null) {
                    inSocketOutputStream = this.inSocket.getOutputStream();
                }
                String bufferedData = null;
                StringBuffer buf = null;
                int index = this.listener.connections.indexOf(this);
                if (this.listener.isProxyBox.isSelected() || this.HTTPProxyHost != null) {
                    int len;
                    b = new byte[1];
                    buf = new StringBuffer();
                    while ((len = inSocketInputStream.read(b, 0, 1)) != -1) {
                        String s = new String(b);
                        buf.append(s);
                        if (b[0] != 10) continue;
                    }
                    bufferedData = buf.toString();
                    this.inputText.append(bufferedData);
                    if (bufferedData.startsWith("GET ") || bufferedData.startsWith("POST ")) {
                        URL url;
                        int start = bufferedData.indexOf(32) + 1;
                        while (bufferedData.charAt(start) == ' ') {
                            ++start;
                        }
                        int end = bufferedData.indexOf(32, start);
                        String urlString = bufferedData.substring(start, end);
                        if (urlString.charAt(0) == '/') {
                            urlString = urlString.substring(1);
                        }
                        if (this.listener.isProxyBox.isSelected()) {
                            url = new URL(urlString);
                            targetHost = url.getHost();
                            targetPort = url.getPort();
                            if (targetPort == -1) {
                                targetPort = 80;
                            }
                            this.listener.tableModel.setValueAt(targetHost, index + 1, OUTHOST_COLUMN);
                            bufferedData = bufferedData.substring(0, start) + url.getFile() + bufferedData.substring(end);
                        } else {
                            url = new URL("http://" + targetHost + ":" + targetPort + "/" + urlString);
                            this.listener.tableModel.setValueAt(targetHost, index + 1, OUTHOST_COLUMN);
                            bufferedData = bufferedData.substring(0, start) + url.toExternalForm() + bufferedData.substring(end);
                            targetHost = this.HTTPProxyHost;
                            targetPort = this.HTTPProxyPort;
                        }
                    }
                } else {
                    String s1;
                    int len;
                    byte[] b1 = new byte[1];
                    buf = new StringBuffer();
                    String lastLine = null;
                    while ((len = inSocketInputStream.read(b1, 0, 1)) != -1) {
                        s1 = new String(b1);
                        buf.append(s1);
                        if (b1[0] != 10) continue;
                        String line = buf.toString();
                        buf.setLength(0);
                        if (line.startsWith("Host: ")) {
                            String newHost = "Host: " + targetHost + "\r\n";
                            bufferedData = bufferedData.concat(newHost);
                            break;
                        }
                        bufferedData = bufferedData == null ? line : bufferedData.concat(line);
                        if (line.equals("\r\n") || "\n".equals(lastLine) && line.equals("\n")) break;
                        lastLine = line;
                    }
                    if (bufferedData != null) {
                        this.inputText.append(bufferedData);
                        int idx = bufferedData.length() < 50 ? bufferedData.length() : 50;
                        s1 = bufferedData.substring(0, idx);
                        int i = s1.indexOf(10);
                        if (i > 0) {
                            s1 = s1.substring(0, i - 1);
                        }
                        s1 = s1 + "                           " + "                       ";
                        s1 = s1.substring(0, 51);
                        this.listener.tableModel.setValueAt(s1, index + 1, REQ_COLUMN);
                    }
                }
                if (targetPort == -1) {
                    targetPort = 80;
                }
                this.outSocket = new Socket(targetHost, targetPort);
                tmpIn2 = this.outSocket.getInputStream();
                tmpOut2 = this.outSocket.getOutputStream();
                if (!this.listener.holdRequestBox.isSelected() && bufferedData != null) {
                    b = bufferedData.getBytes();
                    tmpOut2.write(b);
                }
                boolean format = this.listener.xmlFormatBox.isSelected();
                this.requestSocketRR = new SocketRR(this, this.inSocket, inSocketInputStream, this.outSocket, tmpOut2, this.inputText, format, this.listener.tableModel, index + 1, "request:", this.listener.holdRequestBox.isSelected(), this.listener.sendButton);
                this.ResponseSocketRR = new SocketRR(this, this.outSocket, tmpIn2, this.inSocket, inSocketOutputStream, this.outputText, format, null, 0, "response:", this.listener.holdResponseBox.isSelected(), this.listener.sendButton);
                while (this.requestSocketRR != null || this.ResponseSocketRR != null) {
                    if (null != this.requestSocketRR && this.requestSocketRR.isDone()) {
                        if (index >= 0 && this.ResponseSocketRR != null) {
                            this.listener.tableModel.setValueAt(TCPInterceptor.getMessage("resp00", "Resp"), 1 + index, STATE_COLUMN);
                        }
                        this.requestSocketRR = null;
                    }
                    if (null != this.ResponseSocketRR && this.ResponseSocketRR.isDone()) {
                        if (index >= 0 && this.requestSocketRR != null) {
                            this.listener.tableModel.setValueAt(TCPInterceptor.getMessage("req00", "Req"), 1 + index, STATE_COLUMN);
                        }
                        this.ResponseSocketRR = null;
                    }
                    Connection connection = this;
                    synchronized (connection) {
                        this.wait(1000L);
                    }
                }
                this.active = false;
                if (index >= 0) {
                    this.listener.tableModel.setValueAt(TCPInterceptor.getMessage("done00", "Done"), 1 + index, STATE_COLUMN);
                }
            }
            catch (Exception e) {
                StringWriter st = new StringWriter();
                PrintWriter wr = new PrintWriter(st);
                int index = this.listener.connections.indexOf(this);
                if (index >= 0) {
                    this.listener.tableModel.setValueAt(TCPInterceptor.getMessage("error00", "Error"), 1 + index, STATE_COLUMN);
                }
                e.printStackTrace(wr);
                wr.close();
                this.outputText.append(st.toString());
                this.halt();
            }
        }

        synchronized void wakeUp() {
            this.notifyAll();
        }

        public void halt() {
            try {
                if (this.requestSocketRR != null) {
                    this.requestSocketRR.halt();
                }
                if (this.ResponseSocketRR != null) {
                    this.ResponseSocketRR.halt();
                }
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                this.inSocket = null;
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.outSocket = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void remove() {
            int index = -1;
            try {
                this.halt();
                index = this.listener.connections.indexOf(this);
                this.listener.tableModel.removeRow(index + 1);
                this.listener.connections.remove(index);
            }
            catch (Exception e) {
                System.err.println("index:=" + index + this);
                e.printStackTrace();
            }
        }
    }

    class SocketRR
    extends Thread {
        Socket inSocket = null;
        Socket outSocket = null;
        JTextArea textArea;
        JButton sendXMLButton;
        InputStream in = null;
        OutputStream out = null;
        boolean xmlFormat;
        volatile boolean done = false;
        TableModel tableModel = null;
        int tableIndex = 0;
        String type = null;
        Connection myConnection = null;
        boolean holdXMLUntilEdited = false;

        public SocketRR(Connection c, Socket inputSocket, InputStream inputStream, Socket outputSocket, OutputStream outputStream, JTextArea _textArea, boolean format, TableModel tModel, int index, String type, boolean hold, JButton send) {
            this.inSocket = inputSocket;
            this.in = inputStream;
            this.outSocket = outputSocket;
            this.out = outputStream;
            this.textArea = _textArea;
            this.xmlFormat = format;
            this.tableModel = tModel;
            this.tableIndex = index;
            this.type = type;
            this.myConnection = c;
            this.holdXMLUntilEdited = hold;
            this.sendXMLButton = send;
            this.start();
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String tmpStr;
                byte[] buffer = new byte[32768];
                byte[] tmpbuffer = new byte[65536];
                int saved = 0;
                int reqSaved = 0;
                int tabWidth = 3;
                boolean atMargin = true;
                if (this.tableModel != null && !"".equals(tmpStr = (String)this.tableModel.getValueAt(this.tableIndex, REQ_COLUMN))) {
                    reqSaved = tmpStr.length();
                }
                if (this.holdXMLUntilEdited) {
                    this.sendXMLButton.addActionListener(new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent e) {
                            try {
                                SocketRR.this.sendXMLButton.setEnabled(false);
                                String text = SocketRR.this.textArea.getText();
                                text = TCPInterceptor.fixContentLengthHeaders(text);
                                SocketRR.this.textArea.setText(text);
                                byte[] buffer = text.getBytes();
                                SocketRR.this.out.write(buffer, 0, buffer.length);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            finally {
                                SocketRR.this.finishUp();
                            }
                        }
                    });
                }
                this.readWriteLoop(buffer, saved, reqSaved, tmpbuffer, tabWidth);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.holdXMLUntilEdited) {
                    this.finishUp();
                }
            }
        }

        private void readWriteLoop(byte[] buffer, int saved, int reqSaved, byte[] tmpbuffer, int tabWidth) throws IOException {
            block2: while (!this.done) {
                int len = buffer.length;
                if (len == 0) {
                    len = buffer.length;
                }
                if (saved + len > buffer.length) {
                    len = buffer.length - saved;
                }
                int len1 = 0;
                while (len1 == 0) {
                    try {
                        len1 = this.in.read(buffer, saved, len);
                    }
                    catch (Exception ex) {
                        if (this.done && saved == 0) break block2;
                        len1 = -1;
                        break;
                    }
                }
                if ((len = len1) == -1 && saved == 0) break;
                if (len == -1) {
                    this.done = true;
                }
                if (!this.holdXMLUntilEdited && this.out != null && len > 0) {
                    this.out.write(buffer, saved, len);
                }
                if (this.tableModel != null && reqSaved < 50) {
                    String old = (String)this.tableModel.getValueAt(this.tableIndex, REQ_COLUMN);
                    if ((old = old + new String(buffer, saved, len)).length() > 50) {
                        old = old.substring(0, 50);
                    }
                    reqSaved = old.length();
                    int i = old.indexOf(10);
                    if (i > 0) {
                        old = old.substring(0, i - 1);
                        reqSaved = 50;
                    }
                    this.tableModel.setValueAt(old, this.tableIndex, REQ_COLUMN);
                }
                if (this.xmlFormat) {
                    saved = this.xmlFormatTextArea(saved, len, buffer, tmpbuffer, tabWidth);
                } else {
                    this.textArea.append(new String(buffer, 0, len));
                }
                if (!this.holdXMLUntilEdited) continue;
                this.sendXMLButton.setEnabled(true);
            }
        }

        private int xmlFormatTextArea(int saved, int len, byte[] buffer, byte[] tmpbuffer, int tabWidth) {
            int i;
            boolean inXML = false;
            int bufferLen = saved;
            if (len != -1) {
                bufferLen += len;
            }
            int i2 = 0;
            int thisIndent = -1;
            int nextIndent = -1;
            int previousIndent = -1;
            saved = 0;
            for (int i1 = 0; i1 < bufferLen; ++i1) {
                boolean atMargin;
                if (len != -1 && i1 + 1 == bufferLen) {
                    if (buffer[i1] > 32) {
                        tmpbuffer[i2++] = buffer[i1];
                        saved = 0;
                        break;
                    }
                    saved = 1;
                    break;
                }
                thisIndent = -1;
                if (buffer[i1] == 60 && buffer[i1 + 1] != 47) {
                    previousIndent = nextIndent++;
                    thisIndent = nextIndent;
                    inXML = true;
                }
                if (buffer[i1] == 60 && buffer[i1 + 1] == 47) {
                    if (previousIndent > nextIndent) {
                        thisIndent = nextIndent;
                    }
                    --nextIndent;
                    inXML = true;
                }
                if (buffer[i1] == 47 && buffer[i1 + 1] == 62) {
                    --nextIndent;
                    inXML = true;
                }
                if (thisIndent != -1) {
                    if (thisIndent > 0) {
                        tmpbuffer[i2++] = 10;
                    }
                    for (i = tabWidth * thisIndent; i > 0; --i) {
                        tmpbuffer[i2++] = 32;
                    }
                }
                boolean bl = atMargin = buffer[i1] == 10 || buffer[i1] == 13;
                if (inXML && atMargin) continue;
                tmpbuffer[i2++] = buffer[i1];
            }
            String text = new String(tmpbuffer, 0, i2);
            this.textArea.append(text);
            for (i = 0; i < saved; ++i) {
                buffer[i] = buffer[bufferLen - saved + i];
            }
            return saved;
        }

        private void finishUp() {
            this.done = true;
            try {
                if (this.out != null) {
                    this.out.flush();
                    if (null != this.outSocket) {
                        this.outSocket.shutdownOutput();
                    } else {
                        this.out.close();
                    }
                    this.out = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.in != null) {
                    if (this.inSocket != null) {
                        this.inSocket.shutdownInput();
                    } else {
                        this.in.close();
                    }
                    this.in = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myConnection.wakeUp();
        }

        public void halt() {
            try {
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.inSocket = null;
                this.outSocket = null;
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                this.in = null;
                this.out = null;
                this.done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class SocketWaiter
    extends Thread {
        ServerSocket sSocket = null;
        Listener listener;
        int port;
        boolean pleaseStop = false;

        public SocketWaiter(Listener l, int p) {
            this.listener = l;
            this.port = p;
            this.start();
        }

        public void run() {
            block4: {
                try {
                    this.listener.setLeft(new JLabel(TCPInterceptor.getMessage("wait00", " Waiting for Connection...")));
                    this.listener.repaint();
                    this.sSocket = new ServerSocket(this.port);
                    while (true) {
                        Socket inSocket = this.sSocket.accept();
                        if (!this.pleaseStop) {
                            new Connection(this.listener, inSocket);
                            inSocket = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exp) {
                    if ("socket closed".equals(exp.getMessage())) break block4;
                    JLabel tmp = new JLabel(exp.toString());
                    tmp.setForeground(Color.red);
                    this.listener.setLeft(tmp);
                    this.listener.setRight(new JLabel(""));
                    this.listener.stop();
                }
            }
        }

        public void halt() {
            try {
                this.pleaseStop = true;
                new Socket("127.0.0.1", this.port);
                if (this.sSocket != null) {
                    this.sSocket.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AdminPage
    extends JPanel {
        public JRadioButton listenerButton;
        public JRadioButton proxyButton;
        public JLabel hostLabel;
        public JLabel tportLabel;
        public JTextField port;
        public JTextField host;
        public JTextField tport;
        public JTabbedPane noteb;
        public JCheckBox HTTPProxyBox;
        public JTextField HTTPProxyHost;
        public JTextField HTTPProxyPort;
        public JLabel HTTPProxyHostLabel;
        public JLabel HTTPProxyPortLabel;

        public AdminPage(JTabbedPane notebook, String name) {
            JPanel mainPane = null;
            JButton addButton = null;
            this.setLayout(new BorderLayout());
            this.noteb = notebook;
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            mainPane = new JPanel(layout);
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add((Component)new JLabel(TCPInterceptor.getMessage("newTCP00", "Create a new TCP/IP Monitor...") + " "), c);
            mainPane.add(Box.createRigidArea(new Dimension(1, 5)), c);
            JPanel tmpPanel = new JPanel(new GridBagLayout());
            c.anchor = 17;
            c.gridwidth = 1;
            tmpPanel.add((Component)new JLabel(TCPInterceptor.getMessage("listenPort00", "Listen Port #") + " "), c);
            c.anchor = 17;
            c.gridwidth = 0;
            this.port = new JTextField(4);
            tmpPanel.add((Component)this.port, c);
            mainPane.add((Component)tmpPanel, c);
            mainPane.add(Box.createRigidArea(new Dimension(1, 5)), c);
            ButtonGroup btns = new ButtonGroup();
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add((Component)new JLabel(TCPInterceptor.getMessage("actAs00", "Act as a...")), c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String listener = TCPInterceptor.getMessage("listener00", "Listener");
            this.listenerButton = new JRadioButton(listener);
            mainPane.add((Component)this.listenerButton, c);
            btns.add(this.listenerButton);
            this.listenerButton.setSelected(true);
            this.listenerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (listener.equals(event.getActionCommand())) {
                        boolean state = AdminPage.this.listenerButton.isSelected();
                        AdminPage.this.tport.setEnabled(state);
                        AdminPage.this.host.setEnabled(state);
                        AdminPage.this.hostLabel.setForeground(state ? Color.black : Color.gray);
                        AdminPage.this.tportLabel.setForeground(state ? Color.black : Color.gray);
                    }
                }
            });
            c.anchor = 17;
            c.gridwidth = 1;
            mainPane.add(Box.createRigidArea(new Dimension(25, 0)));
            this.hostLabel = new JLabel(TCPInterceptor.getMessage("targetHostname00", "Target Hostname") + " ");
            mainPane.add((Component)this.hostLabel, c);
            c.anchor = 17;
            c.gridwidth = 0;
            this.host = new JTextField(30);
            mainPane.add((Component)this.host, c);
            c.anchor = 17;
            c.gridwidth = 1;
            mainPane.add(Box.createRigidArea(new Dimension(25, 0)));
            this.tportLabel = new JLabel(TCPInterceptor.getMessage("targetPort00", "Target Port #") + " ");
            mainPane.add((Component)this.tportLabel, c);
            c.anchor = 17;
            c.gridwidth = 0;
            this.tport = new JTextField(4);
            mainPane.add((Component)this.tport, c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String proxy = TCPInterceptor.getMessage("proxy00", "Proxy");
            this.proxyButton = new JRadioButton(proxy);
            mainPane.add((Component)this.proxyButton, c);
            btns.add(this.proxyButton);
            this.proxyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (proxy.equals(event.getActionCommand())) {
                        boolean state = AdminPage.this.proxyButton.isSelected();
                        AdminPage.this.tport.setEnabled(!state);
                        AdminPage.this.host.setEnabled(!state);
                        AdminPage.this.hostLabel.setForeground(state ? Color.gray : Color.black);
                        AdminPage.this.tportLabel.setForeground(state ? Color.gray : Color.black);
                    }
                }
            });
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add(Box.createRigidArea(new Dimension(1, 10)), c);
            JPanel opts = new JPanel(new GridBagLayout());
            opts.setBorder(new TitledBorder(TCPInterceptor.getMessage("options00", "Options")));
            c.anchor = 17;
            c.gridwidth = 0;
            mainPane.add((Component)opts, c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String proxySupport = TCPInterceptor.getMessage("proxySupport00", "HTTP Proxy Support");
            this.HTTPProxyBox = new JCheckBox(proxySupport);
            opts.add((Component)this.HTTPProxyBox, c);
            c.anchor = 17;
            c.gridwidth = 1;
            this.HTTPProxyHostLabel = new JLabel(TCPInterceptor.getMessage("hostname00", "Hostname") + " ");
            opts.add((Component)this.HTTPProxyHostLabel, c);
            this.HTTPProxyHostLabel.setForeground(Color.gray);
            c.anchor = 17;
            c.gridwidth = 0;
            this.HTTPProxyHost = new JTextField(30);
            opts.add((Component)this.HTTPProxyHost, c);
            this.HTTPProxyHost.setEnabled(false);
            c.anchor = 17;
            c.gridwidth = 1;
            this.HTTPProxyPortLabel = new JLabel(TCPInterceptor.getMessage("port00", "Port #") + " ");
            opts.add((Component)this.HTTPProxyPortLabel, c);
            this.HTTPProxyPortLabel.setForeground(Color.gray);
            c.anchor = 17;
            c.gridwidth = 0;
            this.HTTPProxyPort = new JTextField(4);
            opts.add((Component)this.HTTPProxyPort, c);
            this.HTTPProxyPort.setEnabled(false);
            this.HTTPProxyBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (proxySupport.equals(event.getActionCommand())) {
                        boolean b = AdminPage.this.HTTPProxyBox.isSelected();
                        Color color = b ? Color.black : Color.gray;
                        AdminPage.this.HTTPProxyHost.setEnabled(b);
                        AdminPage.this.HTTPProxyPort.setEnabled(b);
                        AdminPage.this.HTTPProxyHostLabel.setForeground(color);
                        AdminPage.this.HTTPProxyPortLabel.setForeground(color);
                    }
                }
            });
            String tmp = System.getProperty("http.proxyHost");
            if (tmp != null && tmp.equals("")) {
                tmp = null;
            }
            this.HTTPProxyBox.setSelected(tmp != null);
            this.HTTPProxyHost.setEnabled(tmp != null);
            this.HTTPProxyPort.setEnabled(tmp != null);
            this.HTTPProxyHostLabel.setForeground(tmp != null ? Color.black : Color.gray);
            this.HTTPProxyPortLabel.setForeground(tmp != null ? Color.black : Color.gray);
            if (tmp != null) {
                this.HTTPProxyBox.setSelected(true);
                this.HTTPProxyHost.setText(tmp);
                tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                if (tmp == null) {
                    tmp = "80";
                }
                this.HTTPProxyPort.setText(tmp);
            }
            mainPane.add(Box.createRigidArea(new Dimension(1, 10)), c);
            c.anchor = 17;
            c.gridwidth = 0;
            final String add = TCPInterceptor.getMessage("add00", "Add");
            addButton = new JButton(add);
            mainPane.add((Component)addButton, c);
            this.add((Component)new JScrollPane(mainPane), "Center");
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (add.equals(event.getActionCommand())) {
                        Listener l = null;
                        int lPort = Integer.parseInt(AdminPage.this.port.getText());
                        String tHost = AdminPage.this.host.getText();
                        int tPort = 0;
                        String text = AdminPage.this.tport.getText();
                        if (text != null && !text.equals("")) {
                            tPort = Integer.parseInt(text);
                        }
                        l = new Listener(AdminPage.this.noteb, null, lPort, tHost, tPort, AdminPage.this.proxyButton.isSelected());
                        text = AdminPage.this.HTTPProxyHost.getText();
                        if ("".equals(text)) {
                            text = null;
                        }
                        l.HTTPProxyHost = text;
                        text = AdminPage.this.HTTPProxyPort.getText();
                        if ("".equals(text)) {
                            text = null;
                        }
                        if (text != null) {
                            l.HTTPProxyPort = Integer.parseInt(text);
                        }
                        AdminPage.this.port.setText(null);
                        AdminPage.this.host.setText(null);
                        AdminPage.this.tport.setText(null);
                    }
                }
            });
            notebook.addTab(name, this);
            notebook.repaint();
            notebook.setSelectedIndex(notebook.getTabCount() - 1);
        }
    }
}

