/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.lock;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.plugins.lock.AbstractLockStrategy;
import org.apache.ivy.plugins.lock.DeleteOnExitHook;
import org.apache.ivy.util.Message;

public abstract class FileBasedLockStrategy
extends AbstractLockStrategy {
    private FileLocker locker;
    private long timeout = 120000L;
    private Map currentLockCounters = new HashMap();

    protected FileBasedLockStrategy() {
        this(new CreateFileLocker(false), false);
    }

    protected FileBasedLockStrategy(boolean bl) {
        this(new CreateFileLocker(bl), bl);
    }

    protected FileBasedLockStrategy(FileLocker fileLocker, boolean bl) {
        super(bl);
        this.locker = fileLocker;
    }

    protected boolean acquireLock(File file) throws InterruptedException {
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("acquiring lock on " + file);
        }
        long l = System.currentTimeMillis();
        do {
            FileBasedLockStrategy fileBasedLockStrategy = this;
            synchronized (fileBasedLockStrategy) {
                if (this.hasLock(file)) {
                    int n = this.incrementLock(file);
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("reentrant lock acquired on " + file + " in " + (System.currentTimeMillis() - l) + "ms - hold locks = " + n);
                    }
                    return true;
                }
                if (this.locker.tryLock(file)) {
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("lock acquired on " + file + " in " + (System.currentTimeMillis() - l) + "ms");
                    }
                    this.incrementLock(file);
                    return true;
                }
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - l < this.timeout);
        return false;
    }

    protected void releaseLock(File file) {
        FileBasedLockStrategy fileBasedLockStrategy = this;
        synchronized (fileBasedLockStrategy) {
            int n = this.decrementLock(file);
            if (n == 0) {
                this.locker.unlock(file);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("lock released on " + file);
                }
            } else if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("reentrant lock released on " + file + " - hold locks = " + n);
            }
            return;
        }
    }

    private static void debugLocking(String string) {
        Message.info(Thread.currentThread() + " " + System.currentTimeMillis() + " " + string);
    }

    private boolean hasLock(File comparable) {
        return (comparable = (Integer)this.currentLockCounters.get(comparable)) != null && (Integer)comparable > 0;
    }

    private int incrementLock(File file) {
        Integer n = (Integer)this.currentLockCounters.get(file);
        int n2 = n == null ? 1 : n + 1;
        this.currentLockCounters.put(file, n2);
        return n2;
    }

    private int decrementLock(File file) {
        Integer n = (Integer)this.currentLockCounters.get(file);
        int n2 = n == null ? 0 : n - 1;
        this.currentLockCounters.put(file, n2);
        return n2;
    }

    public static class CreateFileLocker
    implements FileLocker {
        private boolean debugLocking;

        public CreateFileLocker(boolean bl) {
            this.debugLocking = bl;
        }

        @Override
        public boolean tryLock(File file) {
            try {
                if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
                    if (file.createNewFile()) {
                        DeleteOnExitHook.add(file);
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("file creation failed " + file);
                    }
                }
            }
            catch (IOException iOException) {
                Message.verbose("file creation failed due to an exception: " + iOException.getMessage() + " (" + file + ")");
            }
            return false;
        }

        @Override
        public void unlock(File file) {
            file.delete();
            DeleteOnExitHook.remove(file);
        }
    }

    public static interface FileLocker {
        public boolean tryLock(File var1);

        public void unlock(File var1);
    }
}

