/*	$OpenBSD: if_bnxtreg.h,v 1.6 2024/09/01 03:08:56 jsg Exp $	*/
/*-
 *   BSD LICENSE
 *
 *   Copyright (c) 2016 Broadcom, All Rights Reserved.
 *   The term Broadcom refers to Broadcom Limited and/or its subsidiaries
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/****************************************************************************
 *
 * Description: Definition of HSI data structures
 *
 * Date:  08/31/17 17:55:46
 *
 * Note:  This file is scripted generated by hsi_decode.py.
 *	DO NOT modify this file manually !!!!
 *
 ****************************************************************************/
#ifndef _HSI_STRUCT_DEF_EXTERNAL_H_
#define _HSI_STRUCT_DEF_EXTERNAL_H_
/* HSI and HWRM Specification 1.8.1 */
#define HWRM_VERSION_MAJOR	1
#define HWRM_VERSION_MINOR	8
#define HWRM_VERSION_UPDATE	1

#define HWRM_VERSION_RSVD	7

#define HWRM_VERSION_STR	"1.8.1.7"
/*
 * Following is the signature for HWRM message field that indicates not
 * applicable (All F's). Need to cast it the size of the field if needed.
 */
#define HWRM_NA_SIGNATURE	((uint32_t)(-1))
#define HWRM_MAX_REQ_LEN	(128)  /* hwrm_func_buf_rgtr */
#define HWRM_MAX_RESP_LEN	(272)  /* hwrm_selftest_qlist */
#define HW_HASH_INDEX_SIZE	0x80	/* 7 bit indirection table index. */
#define HW_HASH_KEY_SIZE	40
#define HWRM_RESP_VALID_KEY	1 /* valid key for HWRM response */
#define ROCE_SP_HSI_VERSION_MAJOR	1
#define ROCE_SP_HSI_VERSION_MINOR	8
#define ROCE_SP_HSI_VERSION_UPDATE	1

#define ROCE_SP_HSI_VERSION_STR	"1.8.1"
/*
 * Following is the signature for ROCE_SP_HSI message field that indicates not
 * applicable (All F's). Need to cast it the size of the field if needed.
 */
#define ROCE_SP_HSI_NA_SIGNATURE	((uint32_t)(-1))
/*
 * Note: The Host Software Interface (HSI) and Hardware Resource Manager (HWRM)
 * specification describes the data structures used in Ethernet packet or RDMA
 * message data transfers as well as an abstract interface for managing Ethernet
 * NIC hardware resources.
 */
/* Ethernet Data path Host Structures */
/*
 * Description: The following three sections document the host structures used
 * between device and software drivers for communicating Ethernet packets.
 */
/* BD Ring Structures */
/*
 * Description: This structure is used to inform the NIC of a location for and
 * an aggregation buffer that will be used for packet data that is received. An
 * aggregation buffer creates a different kind of completion operation for a
 * packet where a variable number of BDs may be used to place the packet in the
 * host. RX Rings that have aggregation buffers are known as aggregation rings
 * and must contain only aggregation buffers.
 */
/*
 * Note: BD Ring structures are written by the driver to TX Rings and RX Rings
 * to indicate to the chip there is more buffer space in the host that needs to
 * be transmitted or is available for receive data.
 */
/* BD Base (8 bytes) */

struct bd_base {
	uint8_t type;
	/* This value identifies the type of buffer descriptor. */
	#define BD_BASE_TYPE_MASK				UINT32_C(0x3f)
	#define BD_BASE_TYPE_SFT				0
	/*
	 * Indicates that this BD is 16B long and is used for normal L2
	 * packet transmission.
	 */
	#define BD_BASE_TYPE_TX_BD_SHORT			UINT32_C(0x0)
	/*
	 * Indicates that this BD is 1BB long and is an empty TX BD. Not
	 * valid for use by the driver.
	 */
	#define BD_BASE_TYPE_TX_BD_EMPTY			UINT32_C(0x1)
	/*
	 * Indicates that this BD is 16B long and is an RX Producer (ie.
	 * empty) buffer descriptor.
	 */
	#define BD_BASE_TYPE_RX_PROD_PKT			UINT32_C(0x4)
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * Buffer BD.
	 */
	#define BD_BASE_TYPE_RX_PROD_BFR			UINT32_C(0x5)
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * Assembly Buffer Descriptor.
	 */
	#define BD_BASE_TYPE_RX_PROD_AGG			UINT32_C(0x6)
	/*
	 * Indicates that this BD is 32B long and is used for normal L2
	 * packet transmission.
	 */
	#define BD_BASE_TYPE_TX_BD_LONG			UINT32_C(0x10)
	uint8_t unused_1[7];
} __attribute__((packed));

/* Short TX BD (16 bytes) */

struct tx_bd_short {
	uint16_t flags_type;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs of a
	 * packet.
	 */
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_SHORT_TYPE_MASK				UINT32_C(0x3f)
	#define TX_BD_SHORT_TYPE_SFT				0
	/*
	 * Indicates that this BD is 16B long and is used for normal L2
	 * packet transmission.
	 */
	#define TX_BD_SHORT_TYPE_TX_BD_SHORT			UINT32_C(0x0)
	/*
	 * If set to 1, the packet ends with the data in the buffer pointed to
	 * by this descriptor. This flag must be valid on every BD.
	 */
	#define TX_BD_SHORT_FLAGS_PACKET_END			UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for this
	 * transmit packet unless there is an error in its processing. If this
	 * bit is set to 0, then the packet will be completed normally. This bit
	 * must be valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_NO_CMPL			UINT32_C(0x80)
	/*
	 * This value indicates how many 16B BD locations are consumed in the
	 * ring by this packet. A value of 1 indicates that this BD is the only
	 * BD (and that the it is a short BD). A value of 3 indicates either 3
	 * short BDs or 1 long BD and one short BD in the packet. A value of 0
	 * indicates that there are 32 BD locations in the packet (the maximum).
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_BD_CNT_MASK			UINT32_C(0x1f00)
	#define TX_BD_SHORT_FLAGS_BD_CNT_SFT			8
	/*
	 * This value is a hint for the length of the entire packet. It is used
	 * by the chip to optimize internal processing. The packet will be
	 * dropped if the hint is too short. This field is valid only on the
	 * first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_LHINT_MASK			UINT32_C(0x6000)
	#define TX_BD_SHORT_FLAGS_LHINT_SFT			13
	/* indicates packet length < 512B */
	#define TX_BD_SHORT_FLAGS_LHINT_LT512			(UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
	#define TX_BD_SHORT_FLAGS_LHINT_LT1K			(UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
	#define TX_BD_SHORT_FLAGS_LHINT_LT2K			(UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
	#define TX_BD_SHORT_FLAGS_LHINT_GTE2K			(UINT32_C(0x3) << 13)
	#define TX_BD_SHORT_FLAGS_LHINT_LAST	TX_BD_SHORT_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer Index
	 * after the buffer associated with this descriptor has been transferred
	 * via DMA to NIC memory from host memory. An interrupt may or may not
	 * be generated according to the state of the interrupt avoidance
	 * mechanisms. If this bit is set to 0, then the Consumer Index is only
	 * updated as soon as one of the host interrupt coalescing conditions
	 * has been met. This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_COAL_NOW			UINT32_C(0x8000)
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs of a
	 * packet.
	 */
	#define TX_BD_SHORT_FLAGS_MASK				UINT32_C(0xffc0)
	#define TX_BD_SHORT_FLAGS_SFT				6
	uint16_t len;
	/*
	 * This is the length of the host physical buffer this BD describes in
	 * bytes. This field must be valid on all BDs of a packet.
	 */
	uint32_t opaque;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD. This field must be valid on the first BD of a packet.
	 */
	uint64_t addr;
	/*
	 * This is the host physical address for the portion of the packet
	 * described by this TX BD. This value must be valid on all BDs of a
	 * packet.
	 */
} __attribute__((packed));

/* Long TX BD (32 bytes split to 2 16-byte struct) */

struct tx_bd_long {
	uint16_t flags_type;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs of a
	 * packet.
	 */
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_LONG_TYPE_MASK				UINT32_C(0x3f)
	#define TX_BD_LONG_TYPE_SFT				0
	/*
	 * Indicates that this BD is 32B long and is used for normal L2
	 * packet transmission.
	 */
	#define TX_BD_LONG_TYPE_TX_BD_LONG			UINT32_C(0x10)
	/*
	 * If set to 1, the packet ends with the data in the buffer pointed to
	 * by this descriptor. This flag must be valid on every BD.
	 */
	#define TX_BD_LONG_FLAGS_PACKET_END			UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for this
	 * transmit packet unless there is an error in its processing. If this
	 * bit is set to 0, then the packet will be completed normally. This bit
	 * must be valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_NO_CMPL			UINT32_C(0x80)
	/*
	 * This value indicates how many 16B BD locations are consumed in the
	 * ring by this packet. A value of 1 indicates that this BD is the only
	 * BD (and that the it is a short BD). A value of 3 indicates either 3
	 * short BDs or 1 long BD and one short BD in the packet. A value of 0
	 * indicates that there are 32 BD locations in the packet (the maximum).
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_BD_CNT_MASK			UINT32_C(0x1f00)
	#define TX_BD_LONG_FLAGS_BD_CNT_SFT			8
	/*
	 * This value is a hint for the length of the entire packet. It is used
	 * by the chip to optimize internal processing. The packet will be
	 * dropped if the hint is too short. This field is valid only on the
	 * first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_LHINT_MASK			UINT32_C(0x6000)
	#define TX_BD_LONG_FLAGS_LHINT_SFT			13
	/* indicates packet length < 512B */
	#define TX_BD_LONG_FLAGS_LHINT_LT512			(UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
	#define TX_BD_LONG_FLAGS_LHINT_LT1K			(UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
	#define TX_BD_LONG_FLAGS_LHINT_LT2K			(UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
	#define TX_BD_LONG_FLAGS_LHINT_GTE2K			(UINT32_C(0x3) << 13)
	#define TX_BD_LONG_FLAGS_LHINT_LAST	TX_BD_LONG_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer Index
	 * after the buffer associated with this descriptor has been transferred
	 * via DMA to NIC memory from host memory. An interrupt may or may not
	 * be generated according to the state of the interrupt avoidance
	 * mechanisms. If this bit is set to 0, then the Consumer Index is only
	 * updated as soon as one of the host interrupt coalescing conditions
	 * has been met. This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_COAL_NOW			UINT32_C(0x8000)
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs of a
	 * packet.
	 */
	#define TX_BD_LONG_FLAGS_MASK				UINT32_C(0xffc0)
	#define TX_BD_LONG_FLAGS_SFT				6
	uint16_t len;
	/*
	 * This is the length of the host physical buffer this BD describes in
	 * bytes. This field must be valid on all BDs of a packet.
	 */
	uint32_t opaque;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD. This field must be valid on the first BD of a packet.
	 */
	uint64_t addr;
	/*
	 * This is the host physical address for the portion of the packet
	 * described by this TX BD. This value must be valid on all BDs of a
	 * packet.
	 */
} __attribute__((packed));

/* last 16 bytes of Long TX BD */

struct tx_bd_long_hi {
	uint16_t lflags;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Their value on other BDs of the packet will be ignored.
	 */
	/*
	 * If set to 1, the controller replaces the TCP/UPD checksum fields of
	 * normal TCP/UPD checksum, or the inner TCP/UDP checksum field of the
	 * encapsulated TCP/UDP packets with the hardware calculated TCP/UDP
	 * checksum for the packet associated with this descriptor. The flag is
	 * ignored if the LSO flag is set. This bit must be valid on the first
	 * BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_TCP_UDP_CHKSUM		UINT32_C(0x1)
	/*
	 * If set to 1, the controller replaces the IP checksum of the normal
	 * packets, or the inner IP checksum of the encapsulated packets with
	 * the hardware calculated IP checksum for the packet associated with
	 * this descriptor. This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_IP_CHKSUM			UINT32_C(0x2)
	/*
	 * If set to 1, the controller will not append an Ethernet CRC to the
	 * end of the frame. This bit must be valid on the first BD of a packet.
	 * Packet must be 64B or longer when this flag is set. It is not useful
	 * to use this bit with any form of TX offload such as CSO or LSO. The
	 * intent is that the packet from the host already has a valid Ethernet
	 * CRC on the packet.
	 */
	#define TX_BD_LONG_LFLAGS_NOCRC				UINT32_C(0x4)
	/*
	 * If set to 1, the device will record the time at which the packet was
	 * actually transmitted at the TX MAC. This bit must be valid on the
	 * first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_STAMP				UINT32_C(0x8)
	/*
	 * If set to 1, The controller replaces the tunnel IP checksum field
	 * with hardware calculated IP checksum for the IP header of the packet
	 * associated with this descriptor. For outer UDP checksum, global outer
	 * UDP checksum TE_NIC register needs to be enabled. If the global outer
	 * UDP checksum TE_NIC register bit is set, outer UDP checksum will be
	 * calculated for the following cases: 1. Packets with tcp_udp_chksum
	 * flag set to offload checksum for inner packet AND the inner packet is
	 * TCP/UDP. If the inner packet is ICMP for example (non-TCP/UDP), even
	 * if the tcp_udp_chksum is set, the outer UDP checksum will not be
	 * calculated. 2. Packets with lso flag set which implies inner TCP
	 * checksum calculation as part of LSO operation.
	 */
	#define TX_BD_LONG_LFLAGS_T_IP_CHKSUM			UINT32_C(0x10)
	/*
	 * If set to 1, the device will treat this packet with LSO(Large Send
	 * Offload) processing for both normal or encapsulated packets, which is
	 * a form of TCP segmentation. When this bit is 1, the hdr_size and mss
	 * fields must be valid. The driver doesn't need to set t_ip_chksum,
	 * ip_chksum, and tcp_udp_chksum flags since the controller will replace
	 * the appropriate checksum fields for segmented packets. When this bit
	 * is 1, the hdr_size and mss fields must be valid.
	 */
	#define TX_BD_LONG_LFLAGS_LSO				UINT32_C(0x20)
	/*
	 * If set to zero when LSO is '1', then the IPID will be treated as a
	 * 16b number and will be wrapped if it exceeds a value of 0xffff. If
	 * set to one when LSO is '1', then the IPID will be treated as a 15b
	 * number and will be wrapped if it exceeds a value 0f 0x7fff.
	 */
	#define TX_BD_LONG_LFLAGS_IPID_FMT			UINT32_C(0x40)
	/*
	 * If set to zero when LSO is '1', then the IPID of the tunnel IP header
	 * will not be modified during LSO operations. If set to one when LSO is
	 * '1', then the IPID of the tunnel IP header will be incremented for
	 * each subsequent segment of an LSO operation. The flag is ignored if
	 * the LSO packet is a normal (non-tunneled) TCP packet.
	 */
	#define TX_BD_LONG_LFLAGS_T_IPID			UINT32_C(0x80)
	/*
	 * If set to '1', then the RoCE ICRC will be appended to the packet.
	 * Packet must be a valid RoCE format packet.
	 */
	#define TX_BD_LONG_LFLAGS_ROCE_CRC			UINT32_C(0x100)
	/*
	 * If set to '1', then the FCoE CRC will be appended to the packet.
	 * Packet must be a valid FCoE format packet.
	 */
	#define TX_BD_LONG_LFLAGS_FCOE_CRC			UINT32_C(0x200)
	uint16_t hdr_size;
	/*
	 * When LSO is '1', this field must contain the offset of the TCP
	 * payload from the beginning of the packet in as 16b words. In case of
	 * encapsulated/tunneling packet, this field contains the offset of the
	 * inner TCP payload from beginning of the packet as 16-bit words. This
	 * value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_HDR_SIZE_MASK			UINT32_C(0x1ff)
	#define TX_BD_LONG_HDR_SIZE_SFT				0
	uint32_t mss;
	/*
	 * This is the MSS value that will be used to do the LSO processing. The
	 * value is the length in bytes of the TCP payload for each segment
	 * generated by the LSO operation. This value must be valid on the first
	 * BD of a packet.
	 */
	#define TX_BD_LONG_MSS_MASK				UINT32_C(0x7fff)
	#define TX_BD_LONG_MSS_SFT				0
	uint16_t unused_2;
	uint16_t cfa_action;
	/*
	 * This value selects a CFA action to perform on the packet. Set this
	 * value to zero if no CFA action is desired. This value must be valid
	 * on the first BD of a packet.
	 */
	uint32_t cfa_meta;
	/*
	 * This value is action meta-data that defines CFA edit operations that
	 * are done in addition to any action editing.
	 */
	/* When key=1, This is the VLAN tag VID value. */
	#define TX_BD_LONG_CFA_META_VLAN_VID_MASK		UINT32_C(0xfff)
	#define TX_BD_LONG_CFA_META_VLAN_VID_SFT		0
	/* When key=1, This is the VLAN tag DE value. */
	#define TX_BD_LONG_CFA_META_VLAN_DE			UINT32_C(0x1000)
	/* When key=1, This is the VLAN tag PRI value. */
	#define TX_BD_LONG_CFA_META_VLAN_PRI_MASK		UINT32_C(0xe000)
	#define TX_BD_LONG_CFA_META_VLAN_PRI_SFT		13
	/* When key=1, This is the VLAN tag TPID select value. */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_MASK		UINT32_C(0x70000)
	#define TX_BD_LONG_CFA_META_VLAN_TPID_SFT		16
	/* 0x88a8 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID88A8		(UINT32_C(0x0) << 16)
	/* 0x8100 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID8100		(UINT32_C(0x1) << 16)
	/* 0x9100 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9100		(UINT32_C(0x2) << 16)
	/* 0x9200 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9200		(UINT32_C(0x3) << 16)
	/* 0x9300 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9300		(UINT32_C(0x4) << 16)
	/* Value programmed in CFA VLANTPID register. */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPIDCFG		(UINT32_C(0x5) << 16)
	#define TX_BD_LONG_CFA_META_VLAN_TPID_LAST	TX_BD_LONG_CFA_META_VLAN_TPID_TPIDCFG
	/* When key=1, This is the VLAN tag TPID select value. */
	#define TX_BD_LONG_CFA_META_VLAN_RESERVED_MASK		UINT32_C(0xff80000)
	#define TX_BD_LONG_CFA_META_VLAN_RESERVED_SFT		19
	/*
	 * This field identifies the type of edit to be performed on the packet.
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_CFA_META_KEY_MASK			UINT32_C(0xf0000000)
	#define TX_BD_LONG_CFA_META_KEY_SFT			28
	/* No editing */
	#define TX_BD_LONG_CFA_META_KEY_NONE			(UINT32_C(0x0) << 28)
	/*
	 * - meta[17:16] - TPID select value (0 = 0x8100). - meta[15:12]
	 * - PRI/DE value. - meta[11:0] - VID value.
	 */
	#define TX_BD_LONG_CFA_META_KEY_VLAN_TAG		(UINT32_C(0x1) << 28)
	#define TX_BD_LONG_CFA_META_KEY_LAST	TX_BD_LONG_CFA_META_KEY_VLAN_TAG
} __attribute__((packed));

/* Empty TX BD (16 bytes) */

struct tx_bd_empty {
	uint8_t type;
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_EMPTY_TYPE_MASK				UINT32_C(0x3f)
	#define TX_BD_EMPTY_TYPE_SFT				0
	/*
	 * Indicates that this BD is 1BB long and is an empty TX BD. Not
	 * valid for use by the driver.
	 */
	#define TX_BD_EMPTY_TYPE_TX_BD_EMPTY			UINT32_C(0x1)
	uint8_t unused_1[3];
	uint8_t unused_2;
	uint8_t unused_3[3];
	uint64_t unused_4;
} __attribute__((packed));

/* RX Producer Packet BD (16 bytes) */

struct rx_prod_pkt_bd {
	uint16_t flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_PKT_BD_TYPE_MASK			UINT32_C(0x3f)
	#define RX_PROD_PKT_BD_TYPE_SFT				0
	/*
	 * Indicates that this BD is 16B long and is an RX Producer (ie.
	 * empty) buffer descriptor.
	 */
	#define RX_PROD_PKT_BD_TYPE_RX_PROD_PKT		UINT32_C(0x4)
	/*
	 * If set to 1, the packet will be placed at the address plus 2B. The 2
	 * Bytes of padding will be written as zero.
	 */
	/*
	 * This is intended to be used when the host buffer is cache-line
	 * aligned to produce packets that are easy to parse in host memory
	 * while still allowing writes to be cache line aligned.
	 */
	#define RX_PROD_PKT_BD_FLAGS_SOP_PAD			UINT32_C(0x40)
	/*
	 * If set to 1, the packet write will be padded out to the nearest
	 * cache-line with zero value padding.
	 */
	/*
	 * If receive buffers start/end on cache-line boundaries, this feature
	 * will ensure that all data writes on the PCI bus start/end on cache
	 * line boundaries.
	 */
	#define RX_PROD_PKT_BD_FLAGS_EOP_PAD			UINT32_C(0x80)
	/*
	 * This value is the number of additional buffers in the ring that
	 * describe the buffer space to be consumed for the this packet. If the
	 * value is zero, then the packet must fit within the space described by
	 * this BD. If this value is 1 or more, it indicates how many additional
	 * "buffer" BDs are in the ring immediately following this BD to be used
	 * for the same network packet. Even if the packet to be placed does not
	 * need all the additional buffers, they will be consumed anyway.
	 */
	#define RX_PROD_PKT_BD_FLAGS_BUFFERS_MASK		UINT32_C(0x300)
	#define RX_PROD_PKT_BD_FLAGS_BUFFERS_SFT		8
	#define RX_PROD_PKT_BD_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_PROD_PKT_BD_FLAGS_SFT			6
	uint16_t len;
	/*
	 * This is the length in Bytes of the host physical buffer where data
	 * for the packet may be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous to
	 * ensure that the buffers provided end on a host cache line.
	 */
	uint32_t opaque;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with this
	 * receive buffer set.
	 */
	uint64_t addr;
	/*
	 * This is the host physical address where data for the packet may by
	 * placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous to
	 * ensure that the buffers provide start on a host cache line.
	 */
} __attribute__((packed));

/* RX Producer Buffer BD (16 bytes) */

struct rx_prod_bfr_bd {
	uint16_t flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_BFR_BD_TYPE_MASK			UINT32_C(0x3f)
	#define RX_PROD_BFR_BD_TYPE_SFT				0
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * Buffer BD.
	 */
	#define RX_PROD_BFR_BD_TYPE_RX_PROD_BFR		UINT32_C(0x5)
	#define RX_PROD_BFR_BD_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_PROD_BFR_BD_FLAGS_SFT			6
	uint16_t len;
	/*
	 * This is the length in Bytes of the host physical buffer where data
	 * for the packet may be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous to
	 * ensure that the buffers provided end on a host cache line.
	 */
	uint32_t opaque;
	/* This field is not used. */
	uint64_t addr;
	/*
	 * This is the host physical address where data for the packet may by
	 * placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous to
	 * ensure that the buffers provide start on a host cache line.
	 */
} __attribute__((packed));

/* RX Producer Aggregation BD (16 bytes) */

struct rx_prod_agg_bd {
	uint16_t flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_AGG_BD_TYPE_MASK			UINT32_C(0x3f)
	#define RX_PROD_AGG_BD_TYPE_SFT				0
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * Assembly Buffer Descriptor.
	 */
	#define RX_PROD_AGG_BD_TYPE_RX_PROD_AGG		UINT32_C(0x6)
	/*
	 * If set to 1, the packet write will be padded out to the nearest
	 * cache-line with zero value padding.
	 */
	/*
	 * If receive buffers start/end on cache-line boundaries, this feature
	 * will ensure that all data writes on the PCI bus end on cache line
	 * boundaries.
	 */
	#define RX_PROD_AGG_BD_FLAGS_EOP_PAD			UINT32_C(0x40)
	#define RX_PROD_AGG_BD_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_PROD_AGG_BD_FLAGS_SFT			6
	uint16_t len;
	/*
	 * This is the length in Bytes of the host physical buffer where data
	 * for the packet may be placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous to
	 * ensure that the buffers provided end on a host cache line.
	 */
	uint32_t opaque;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with this
	 * receive assembly buffer.
	 */
	uint64_t addr;
	/*
	 * This is the host physical address where data for the packet may by
	 * placed in host memory.
	 */
	/*
	 * While this is a Byte resolution value, it is often advantageous to
	 * ensure that the buffers provide start on a host cache line.
	 */
} __attribute__((packed));

/* Completion Ring Structures */
/* Note: This structure is used by the HWRM to communicate HWRM Error. */
/* Base Completion Record (16 bytes) */

struct cmpl_base {
	uint16_t type;
	/* unused is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define CMPL_BASE_TYPE_MASK				UINT32_C(0x3f)
	#define CMPL_BASE_TYPE_SFT				0
	/* TX L2 completion: Completion of TX packet. Length = 16B */
	#define CMPL_BASE_TYPE_TX_L2				UINT32_C(0x0)
	/* RX L2 completion: Completion of and L2 RX packet. Length = 32B */
	#define CMPL_BASE_TYPE_RX_L2				UINT32_C(0x11)
	/*
	 * RX Aggregation Buffer completion : Completion of an L2
	 * aggregation buffer in support of TPA, HDS, or Jumbo packet
	 * completion. Length = 16B
	 */
	#define CMPL_BASE_TYPE_RX_AGG				UINT32_C(0x12)
	/*
	 * RX L2 TPA Start Completion: Completion at the beginning of a
	 * TPA operation. Length = 32B
	 */
	#define CMPL_BASE_TYPE_RX_TPA_START			UINT32_C(0x13)
	/*
	 * RX L2 TPA End Completion: Completion at the end of a TPA
	 * operation. Length = 32B
	 */
	#define CMPL_BASE_TYPE_RX_TPA_END			UINT32_C(0x15)
	/*
	 * Statistics Ejection Completion: Completion of statistics data
	 * ejection buffer. Length = 16B
	 */
	#define CMPL_BASE_TYPE_STAT_EJECT			UINT32_C(0x1a)
	/* HWRM Command Completion: Completion of an HWRM command. */
	#define CMPL_BASE_TYPE_HWRM_DONE			UINT32_C(0x20)
	/* Forwarded HWRM Request */
	#define CMPL_BASE_TYPE_HWRM_FWD_REQ			UINT32_C(0x22)
	/* Forwarded HWRM Response */
	#define CMPL_BASE_TYPE_HWRM_FWD_RESP			UINT32_C(0x24)
	/* HWRM Asynchronous Event Information */
	#define CMPL_BASE_TYPE_HWRM_ASYNC_EVENT		UINT32_C(0x2e)
	/* CQ Notification */
	#define CMPL_BASE_TYPE_CQ_NOTIFICATION			UINT32_C(0x30)
	/* SRQ Threshold Event */
	#define CMPL_BASE_TYPE_SRQ_EVENT			UINT32_C(0x32)
	/* DBQ Threshold Event */
	#define CMPL_BASE_TYPE_DBQ_EVENT			UINT32_C(0x34)
	/* QP Async Notification */
	#define CMPL_BASE_TYPE_QP_EVENT			UINT32_C(0x38)
	/* Function Async Notification */
	#define CMPL_BASE_TYPE_FUNC_EVENT			UINT32_C(0x3a)
	/* unused is 10 b */
	uint16_t info1;
	/* info1 is 16 b */
	uint32_t info2;
	/* info2 is 32 b */
	uint32_t info3_v;
	/* info3 is 31 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define CMPL_BASE_V					UINT32_C(0x1)
	/* info3 is 31 b */
	#define CMPL_BASE_INFO3_MASK				UINT32_C(0xfffffffe)
	#define CMPL_BASE_INFO3_SFT				1
	uint32_t info4;
	/* info4 is 32 b */
} __attribute__((packed));

/* TX Completion Record (16 bytes) */

struct tx_cmpl {
	uint16_t flags_type;
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define TX_CMPL_TYPE_MASK				UINT32_C(0x3f)
	#define TX_CMPL_TYPE_SFT				0
	/* TX L2 completion: Completion of TX packet. Length = 16B */
	#define TX_CMPL_TYPE_TX_L2				UINT32_C(0x0)
	/*
	 * When this bit is '1', it indicates a packet that has an error of some
	 * type. Type of error is indicated in error_flags.
	 */
	#define TX_CMPL_FLAGS_ERROR				UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet completed was
	 * transmitted using the push acceleration data provided by the driver.
	 * When this bit is '0', it indicates that the packet had not push
	 * acceleration data written or was executed as a normal packet even
	 * though push data was provided.
	 */
	#define TX_CMPL_FLAGS_PUSH				UINT32_C(0x80)
	#define TX_CMPL_FLAGS_MASK				UINT32_C(0xffc0)
	#define TX_CMPL_FLAGS_SFT				6
	uint16_t unused_0;
	/* unused1 is 16 b */
	uint32_t opaque;
	/*
	 * This is a copy of the opaque field from the first TX BD of this
	 * transmitted packet.
	 */
	uint16_t errors_v;
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define TX_CMPL_V					UINT32_C(0x1)
	/*
	 * This error indicates that there was some sort of problem with the BDs
	 * for the packet.
	 */
	#define TX_CMPL_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define TX_CMPL_ERRORS_BUFFER_ERROR_SFT			1
	/* No error */
	#define TX_CMPL_ERRORS_BUFFER_ERROR_NO_ERROR		(UINT32_C(0x0) << 1)
	/* Bad Format: BDs were not formatted correctly. */
	#define TX_CMPL_ERRORS_BUFFER_ERROR_BAD_FMT		(UINT32_C(0x2) << 1)
	#define TX_CMPL_ERRORS_BUFFER_ERROR_LAST	TX_CMPL_ERRORS_BUFFER_ERROR_BAD_FMT
	/*
	 * When this bit is '1', it indicates that the length of the packet was
	 * zero. No packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_ZERO_LENGTH_PKT			UINT32_C(0x10)
	/*
	 * When this bit is '1', it indicates that the packet was longer than
	 * the programmed limit in TDI. No packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_EXCESSIVE_BD_LENGTH		UINT32_C(0x20)
	/*
	 * When this bit is '1', it indicates that one or more of the BDs
	 * associated with this packet generated a PCI error. This probably
	 * means the address was not valid.
	 */
	#define TX_CMPL_ERRORS_DMA_ERROR			UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet was longer than
	 * indicated by the hint. No packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_HINT_TOO_SHORT			UINT32_C(0x80)
	/*
	 * When this bit is '1', it indicates that the packet was dropped due to
	 * Poison TLP error on one or more of the TLPs in the PXP completion.
	 */
	#define TX_CMPL_ERRORS_POISON_TLP_ERROR			UINT32_C(0x100)
	#define TX_CMPL_ERRORS_MASK				UINT32_C(0xfffe)
	#define TX_CMPL_ERRORS_SFT				1
	uint16_t unused_1;
	/* unused2 is 16 b */
	uint32_t unused_2;
	/* unused3 is 32 b */
} __attribute__((packed));

/* RX Packet Completion Record (32 bytes split to 2 16-byte struct) */

struct rx_pkt_cmpl {
	uint16_t flags_type;
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define RX_PKT_CMPL_TYPE_MASK				UINT32_C(0x3f)
	#define RX_PKT_CMPL_TYPE_SFT				0
	/* RX L2 completion: Completion of and L2 RX packet. Length = 32B */
	#define RX_PKT_CMPL_TYPE_RX_L2				UINT32_C(0x11)
	/*
	 * When this bit is '1', it indicates a packet that has an error of some
	 * type. Type of error is indicated in error_flags.
	 */
	#define RX_PKT_CMPL_FLAGS_ERROR				UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_SFT			7
	/* Normal: Packet was placed using normal algorithm. */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_NORMAL		(UINT32_C(0x0) << 7)
	/* Jumbo: Packet was placed using jumbo algorithm. */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation: Packet was placed using Header/Data
	 * separation algorithm. The separation location is indicated by
	 * the itype field.
	 */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_LAST	RX_PKT_CMPL_FLAGS_PLACEMENT_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_PKT_CMPL_FLAGS_RSS_VALID			UINT32_C(0x400)
	/* unused is 1 b */
	#define RX_PKT_CMPL_FLAGS_UNUSED			UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the packet
	 * was.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_MASK			UINT32_C(0xf000)
	#define RX_PKT_CMPL_FLAGS_ITYPE_SFT			12
	/* Not Known: Indicates that the packet type was not known. */
	#define RX_PKT_CMPL_FLAGS_ITYPE_NOT_KNOWN		(UINT32_C(0x0) << 12)
	/*
	 * IP Packet: Indicates that the packet was an IP packet, but
	 * further classification was not possible.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_IP			(UINT32_C(0x1) << 12)
	/*
	 * TCP Packet: Indicates that the packet was IP and TCP. This
	 * indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_TCP			(UINT32_C(0x2) << 12)
	/*
	 * UDP Packet: Indicates that the packet was IP and UDP. This
	 * indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_UDP			(UINT32_C(0x3) << 12)
	/*
	 * FCoE Packet: Indicates that the packet was recognized as a
	 * FCoE. This also indicates that the payload_offset field is
	 * valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_FCOE			(UINT32_C(0x4) << 12)
	/*
	 * RoCE Packet: Indicates that the packet was recognized as a
	 * RoCE. This also indicates that the payload_offset field is
	 * valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_ROCE			(UINT32_C(0x5) << 12)
	/*
	 * ICMP Packet: Indicates that the packet was recognized as
	 * ICMP. This indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_ICMP			(UINT32_C(0x7) << 12)
	/*
	 * PtP packet wo/timestamp: Indicates that the packet was
	 * recognized as a PtP packet.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_PTP_WO_TIMESTAMP	(UINT32_C(0x8) << 12)
	/*
	 * PtP packet w/timestamp: Indicates that the packet was
	 * recognized as a PtP packet and that a timestamp was taken for
	 * the packet.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP	(UINT32_C(0x9) << 12)
	#define RX_PKT_CMPL_FLAGS_ITYPE_LAST	RX_PKT_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP
	#define RX_PKT_CMPL_FLAGS_MASK				UINT32_C(0xffc0)
	#define RX_PKT_CMPL_FLAGS_SFT				6
	uint16_t len;
	/*
	 * This is the length of the data for the packet stored in the buffer(s)
	 * identified by the opaque value. This includes the packet BD and any
	 * associated buffer BDs. This does not include the length of any
	 * data places in aggregation BDs.
	 */
	uint32_t opaque;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint8_t agg_bufs_v1;
	/* unused1 is 2 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define RX_PKT_CMPL_V1					UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this packet. If the
	 * value is zero, then the packet is completely contained in the buffer
	 * space provided for the packet in the RX ring.
	 */
	#define RX_PKT_CMPL_AGG_BUFS_MASK			UINT32_C(0x3e)
	#define RX_PKT_CMPL_AGG_BUFS_SFT			1
	/* unused1 is 2 b */
	uint8_t rss_hash_type;
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}. The
	 * value of tuple_extrac_op provides the information about what fields
	 * the hash was computed on. * 0: The RSS hash was computed over source
	 * IP address, destination IP address, source port, and destination port
	 * of inner IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose. * 1: The RSS hash was computed over source
	 * IP address and destination IP address of inner IP header. Note: For
	 * non-tunneled packets, the packet headers are considered inner packet
	 * headers for the RSS hash computation purpose. * 2: The RSS hash was
	 * computed over source IP address, destination IP address, source port,
	 * and destination port of IP and TCP or UDP headers of outer tunnel
	 * headers. Note: For non-tunneled packets, this value is not
	 * applicable. * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers. Note:
	 * For non-tunneled packets, this value is not applicable. Note that
	 * 4-tuples values listed above are applicable for layer 4 protocols
	 * supported and enabled for RSS in the hardware, HWRM firmware, and
	 * drivers. For example, if RSS hash is supported and enabled for TCP
	 * traffic only, then the values of tuple_extract_op corresponding to
	 * 4-tuples are only valid for TCP traffic.
	 */
	uint8_t payload_offset;
	/*
	 * This value indicates the offset in bytes from the beginning of the
	 * packet where the inner payload starts. This value is valid for TCP,
	 * UDP, FCoE, and RoCE packets. A value of zero indicates that header is
	 * 256B into the packet.
	 */
	uint8_t unused_1;
	/* unused2 is 8 b */
	uint32_t rss_hash;
	/*
	 * This value is the RSS hash value calculated for the packet based on
	 * the mode bits and key value in the VNIC.
	 */
} __attribute__((packed));

/* last 16 bytes of RX Packet Completion Record */

struct rx_pkt_cmpl_hi {
	uint32_t flags2;
	/*
	 * This indicates that the ip checksum was calculated for the inner
	 * packet and that the ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_CMPL_FLAGS2_IP_CS_CALC			UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was calculated for
	 * the inner packet and that the l4_cs_error field indicates if there
	 * was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_L4_CS_CALC			UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the tunnel
	 * header and that the t_ip_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_CMPL_FLAGS2_T_IP_CS_CALC			UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was calculated for the tunnel
	 * packet and that the t_l4_cs_error field indicates if there was an
	 * error.
	 */
	#define RX_PKT_CMPL_FLAGS2_T_L4_CS_CALC			UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_MASK		UINT32_C(0xf0)
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_SFT		4
	/* No metadata information. Value is zero. */
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_NONE		(UINT32_C(0x0) << 4)
	/*
	 * The metadata field contains the VLAN tag and TPID value. -
	 * metadata[11:0] contains the vlan VID value. - metadata[12]
	 * contains the vlan DE value. - metadata[15:13] contains the
	 * vlan PRI value. - metadata[31:16] contains the vlan TPID
	 * value.
	 */
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_VLAN		(UINT32_C(0x1) << 4)
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_LAST	RX_PKT_CMPL_FLAGS2_META_FORMAT_VLAN
	/*
	 * This field indicates the IP type for the inner-most IP header. A
	 * value of '0' indicates IPv4. A value of '1' indicates IPv6. This
	 * value is only valid if itype indicates a packet with an IP header.
	 */
	#define RX_PKT_CMPL_FLAGS2_IP_TYPE			UINT32_C(0x100)
	uint32_t metadata;
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_PKT_CMPL_METADATA_VID_MASK			UINT32_C(0xfff)
	#define RX_PKT_CMPL_METADATA_VID_SFT			0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_PKT_CMPL_METADATA_DE				UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_PKT_CMPL_METADATA_PRI_MASK			UINT32_C(0xe000)
	#define RX_PKT_CMPL_METADATA_PRI_SFT			13
	/* When meta_format=1, this value is the VLAN TPID. */
	#define RX_PKT_CMPL_METADATA_TPID_MASK			UINT32_C(0xffff0000)
	#define RX_PKT_CMPL_METADATA_TPID_SFT			16
	uint16_t errors_v2;
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define RX_PKT_CMPL_V2					UINT32_C(0x1)
	/*
	 * This error indicates that there was some sort of problem with the BDs
	 * for the packet that was found after part of the packet was already
	 * placed. The packet should be treated as invalid.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_MASK		UINT32_C(0xe)
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_SFT		1
	/* No buffer error */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER	(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit: Packet did not fit into packet buffer provided.
	 * For regular placement, this means the packet did not fit in
	 * the buffer provided. For HDS and jumbo placement, this means
	 * that the packet could not be placed into 7 physical buffers
	 * or less.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_DID_NOT_FIT	(UINT32_C(0x1) << 1)
	/*
	 * Not On Chip: All BDs needed for the packet were not on-chip
	 * when the packet arrived.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_NOT_ON_CHIP	(UINT32_C(0x2) << 1)
	/* Bad Format: BDs were not formatted correctly. */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT	(UINT32_C(0x3) << 1)
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_LAST	RX_PKT_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT
	/* This indicates that there was an error in the IP header checksum. */
	#define RX_PKT_CMPL_ERRORS_IP_CS_ERROR			UINT32_C(0x10)
	/*
	 * This indicates that there was an error in the TCP, UDP or ICMP
	 * checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_L4_CS_ERROR			UINT32_C(0x20)
	/*
	 * This indicates that there was an error in the tunnel IP header
	 * checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_T_IP_CS_ERROR		UINT32_C(0x40)
	/* This indicates that there was an error in the tunnel UDP checksum. */
	#define RX_PKT_CMPL_ERRORS_T_L4_CS_ERROR		UINT32_C(0x80)
	/*
	 * This indicates that there was a CRC error on either an FCoE or RoCE
	 * packet. The itype indicates the packet type.
	 */
	#define RX_PKT_CMPL_ERRORS_CRC_ERROR			UINT32_C(0x100)
	/*
	 * This indicates that there was an error in the tunnel portion of the
	 * packet when this field is non-zero.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_MASK		UINT32_C(0xe00)
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_SFT		9
	/*
	 * No additional error occurred on the tunnel portion of the
	 * packet of the packet does not have a tunnel.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_NO_ERROR	(UINT32_C(0x0) << 9)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 in the tunnel header.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION   (UINT32_C(0x1) << 9)
	/*
	 * Indicates that header length is out of range in the tunnel
	 * header. Valid for IPv4.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN   (UINT32_C(0x2) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the PPPoE header length for a tunnel PPPoE packet.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_TUNNEL_TOTAL_ERROR (UINT32_C(0x3) << 9)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the tunnel l3 header length. Valid for IPv4, or IPv6
	 * tunnel packet packets.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR   (UINT32_C(0x4) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the tunnel UDP header length for a tunnel UDP
	 * packet that is not fragmented.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR  (UINT32_C(0x5) << 9)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check have
	 * failed (e.g. TTL = 0) in the tunnel header. Valid for IPv4,
	 * and IPv6.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL	(UINT32_C(0x6) << 9)
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_LAST	RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL
	/*
	 * This indicates that there was an error in the inner portion of the
	 * packet when this field is non-zero.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_MASK		UINT32_C(0xf000)
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_SFT		12
	/*
	 * No additional error occurred on the tunnel portion of the
	 * packet of the packet does not have a tunnel.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_NO_ERROR		(UINT32_C(0x0) << 12)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 or that option other than
	 * VFT was parsed on FCoE packet.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_VERSION	(UINT32_C(0x1) << 12)
	/*
	 * indicates that header length is out of range. Valid for IPv4
	 * and RoCE
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN	(UINT32_C(0x2) << 12)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check have
	 * failed (e.g. TTL = 0). Valid for IPv4, and IPv6
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_TTL	(UINT32_C(0x3) << 12)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the l3 header length. Valid for IPv4, IPv6 packet or RoCE
	 * packets.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_IP_TOTAL_ERROR	(UINT32_C(0x4) << 12)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the UDP header length for a UDP packet that is not
	 * fragmented.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR	(UINT32_C(0x5) << 12)
	/*
	 * Indicates that TCP header length > IP payload. Valid for TCP
	 * packets only.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN	(UINT32_C(0x6) << 12)
	/* Indicates that TCP header length < 5. Valid for TCP. */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL (UINT32_C(0x7) << 12)
	/*
	 * Indicates that TCP option headers result in a TCP header size
	 * that does not match data offset in TCP header. Valid for TCP.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN	(UINT32_C(0x8) << 12)
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_LAST	RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN
	#define RX_PKT_CMPL_ERRORS_MASK				UINT32_C(0xfffe)
	#define RX_PKT_CMPL_ERRORS_SFT				1
	uint16_t cfa_code;
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint32_t reorder;
	/*
	 * This value holds the reordering sequence number for the packet. If
	 * the reordering sequence is not valid, then this value is zero. The
	 * reordering domain for the packet is in the bottom 8 to 10b of the
	 * rss_hash value. The bottom 20b of this value contain the ordering
	 * domain value for the packet.
	 */
	#define RX_PKT_CMPL_REORDER_MASK			UINT32_C(0xffffff)
	#define RX_PKT_CMPL_REORDER_SFT				0
} __attribute__((packed));

/* RX L2 TPA Start Completion Record (32 bytes split to 2 16-byte struct) */

struct rx_tpa_start_cmpl {
	uint16_t flags_type;
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define RX_TPA_START_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_TPA_START_CMPL_TYPE_SFT			0
	/*
	 * RX L2 TPA Start Completion: Completion at the beginning of a
	 * TPA operation. Length = 32B
	 */
	#define RX_TPA_START_CMPL_TYPE_RX_TPA_START		UINT32_C(0x13)
	/* This bit will always be '0' for TPA start completions. */
	#define RX_TPA_START_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Jumbo: TPA Packet was placed using jumbo algorithm. This
	 * means that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer will
	 * be filled before moving to the next aggregation buffer.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_JUMBO	(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation: Packet was placed using Header/Data
	 * separation algorithm. The separation location is indicated by
	 * the itype field.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * GRO/Jumbo: Packet will be placed using GRO/Jumbo where the
	 * first packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two aggregation
	 * buffers unless it starts at the beginning of an aggregation
	 * buffer.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_JUMBO	(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation: Packet will be placed using
	 * GRO/HDS where the header is in the first packet. Payload of
	 * each packet will be placed such that any one packet does not
	 * span two aggregation buffers unless it starts at the
	 * beginning of an aggregation buffer.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_LAST	RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_TPA_START_CMPL_FLAGS_RSS_VALID		UINT32_C(0x400)
	/* unused is 1 b */
	#define RX_TPA_START_CMPL_FLAGS_UNUSED			UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the packet
	 * was.
	 */
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_SFT		12
	/* TCP Packet: Indicates that the packet was IP and TCP. */
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_TCP		(UINT32_C(0x2) << 12)
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_LAST	RX_TPA_START_CMPL_FLAGS_ITYPE_TCP
	#define RX_TPA_START_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_TPA_START_CMPL_FLAGS_SFT			6
	uint16_t len;
	/*
	 * This value indicates the amount of packet data written to the buffer
	 * the opaque field in this completion corresponds to.
	 */
	uint32_t opaque;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint8_t v1;
	/* unused1 is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define RX_TPA_START_CMPL_V1				UINT32_C(0x1)
	/* unused1 is 7 b */
	uint8_t rss_hash_type;
	/*
	 * This is the RSS hash type for the packet. The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}. The
	 * value of tuple_extrac_op provides the information about what fields
	 * the hash was computed on. * 0: The RSS hash was computed over source
	 * IP address, destination IP address, source port, and destination port
	 * of inner IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose. * 1: The RSS hash was computed over source
	 * IP address and destination IP address of inner IP header. Note: For
	 * non-tunneled packets, the packet headers are considered inner packet
	 * headers for the RSS hash computation purpose. * 2: The RSS hash was
	 * computed over source IP address, destination IP address, source port,
	 * and destination port of IP and TCP or UDP headers of outer tunnel
	 * headers. Note: For non-tunneled packets, this value is not
	 * applicable. * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers. Note:
	 * For non-tunneled packets, this value is not applicable. Note that
	 * 4-tuples values listed above are applicable for layer 4 protocols
	 * supported and enabled for RSS in the hardware, HWRM firmware, and
	 * drivers. For example, if RSS hash is supported and enabled for TCP
	 * traffic only, then the values of tuple_extract_op corresponding to
	 * 4-tuples are only valid for TCP traffic.
	 */
	uint16_t agg_id;
	/*
	 * This is the aggregation ID that the completion is associated with.
	 * Use this number to correlate the TPA start completion with the TPA
	 * end completion.
	 */
	/* unused2 is 9 b */
	/*
	 * This is the aggregation ID that the completion is associated with.
	 * Use this number to correlate the TPA start completion with the TPA
	 * end completion.
	 */
	#define RX_TPA_START_CMPL_AGG_ID_MASK			UINT32_C(0xfe00)
	#define RX_TPA_START_CMPL_AGG_ID_SFT			9
	uint32_t rss_hash;
	/*
	 * This value is the RSS hash value calculated for the packet based on
	 * the mode bits and key value in the VNIC.
	 */
} __attribute__((packed));

/* last 16 bytes of RX L2 TPA Start Completion Record */

struct rx_tpa_start_cmpl_hi {
	uint32_t flags2;
	/*
	 * This indicates that the ip checksum was calculated for the inner
	 * packet and that the sum passed for all segments included in the
	 * aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_IP_CS_CALC		UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was calculated for
	 * the inner packet and that the sum passed for all segments included in
	 * the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_L4_CS_CALC		UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the tunnel
	 * header and that the sum passed for all segments included in the
	 * aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_T_IP_CS_CALC		UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was calculated for the tunnel
	 * packet and that the sum passed for all segments included in the
	 * aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_T_L4_CS_CALC		UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_MASK	UINT32_C(0xf0)
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_SFT	4
	/* No metadata information. Value is zero. */
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_NONE	(UINT32_C(0x0) << 4)
	/*
	 * The metadata field contains the VLAN tag and TPID value. -
	 * metadata[11:0] contains the vlan VID value. - metadata[12]
	 * contains the vlan DE value. - metadata[15:13] contains the
	 * vlan PRI value. - metadata[31:16] contains the vlan TPID
	 * value.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_VLAN	(UINT32_C(0x1) << 4)
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_LAST	RX_TPA_START_CMPL_FLAGS2_META_FORMAT_VLAN
	/*
	 * This field indicates the IP type for the inner-most IP header. A
	 * value of '0' indicates IPv4. A value of '1' indicates IPv6.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_IP_TYPE		UINT32_C(0x100)
	uint32_t metadata;
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_TPA_START_CMPL_METADATA_VID_MASK		UINT32_C(0xfff)
	#define RX_TPA_START_CMPL_METADATA_VID_SFT		0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_TPA_START_CMPL_METADATA_DE			UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_TPA_START_CMPL_METADATA_PRI_MASK		UINT32_C(0xe000)
	#define RX_TPA_START_CMPL_METADATA_PRI_SFT		13
	/* When meta_format=1, this value is the VLAN TPID. */
	#define RX_TPA_START_CMPL_METADATA_TPID_MASK		UINT32_C(0xffff0000)
	#define RX_TPA_START_CMPL_METADATA_TPID_SFT		16
	uint16_t v2;
	/* unused4 is 15 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define RX_TPA_START_CMPL_V2				UINT32_C(0x1)
	/* unused4 is 15 b */
	uint16_t cfa_code;
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint32_t inner_l4_size_inner_l3_offset_inner_l2_offset_outer_l3_offset;
	/*
	 * This is the size in bytes of the inner most L4 header. This can be
	 * subtracted from the payload_offset to determine the start of the
	 * inner most L4 header.
	 */
	/*
	 * This is the offset from the beginning of the packet in bytes for the
	 * outer L3 header. If there is no outer L3 header, then this value is
	 * zero.
	 */
	#define RX_TPA_START_CMPL_OUTER_L3_OFFSET_MASK		UINT32_C(0x1ff)
	#define RX_TPA_START_CMPL_OUTER_L3_OFFSET_SFT		0
	/*
	 * This is the offset from the beginning of the packet in bytes for the
	 * inner most L2 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L2_OFFSET_MASK		UINT32_C(0x3fe00)
	#define RX_TPA_START_CMPL_INNER_L2_OFFSET_SFT		9
	/*
	 * This is the offset from the beginning of the packet in bytes for the
	 * inner most L3 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L3_OFFSET_MASK		UINT32_C(0x7fc0000)
	#define RX_TPA_START_CMPL_INNER_L3_OFFSET_SFT		18
	/*
	 * This is the size in bytes of the inner most L4 header. This can be
	 * subtracted from the payload_offset to determine the start of the
	 * inner most L4 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L4_SIZE_MASK		UINT32_C(0xf8000000)
	#define RX_TPA_START_CMPL_INNER_L4_SIZE_SFT		27
} __attribute__((packed));

/* RX TPA End Completion Record (32 bytes split to 2 16-byte struct) */

struct rx_tpa_end_cmpl {
	uint16_t flags_type;
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define RX_TPA_END_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define RX_TPA_END_CMPL_TYPE_SFT			0
	/*
	 * RX L2 TPA End Completion: Completion at the end of a TPA
	 * operation. Length = 32B
	 */
	#define RX_TPA_END_CMPL_TYPE_RX_TPA_END		UINT32_C(0x15)
	/*
	 * When this bit is '1', it indicates a packet that has an error of some
	 * type. Type of error is indicated in error_flags.
	 */
	#define RX_TPA_END_CMPL_FLAGS_ERROR			UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_MASK		UINT32_C(0x380)
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_SFT		7
	/*
	 * Jumbo: TPA Packet was placed using jumbo algorithm. This
	 * means that the first buffer will be filled with data before
	 * moving to aggregation buffers. Each aggregation buffer will
	 * be filled before moving to the next aggregation buffer.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_JUMBO		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation: Packet was placed using Header/Data
	 * separation algorithm. The separation location is indicated by
	 * the itype field.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_HDS		(UINT32_C(0x2) << 7)
	/*
	 * GRO/Jumbo: Packet will be placed using GRO/Jumbo where the
	 * first packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two aggregation
	 * buffers unless it starts at the beginning of an aggregation
	 * buffer.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_JUMBO	(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation: Packet will be placed using
	 * GRO/HDS where the header is in the first packet. Payload of
	 * each packet will be placed such that any one packet does not
	 * span two aggregation buffers unless it starts at the
	 * beginning of an aggregation buffer.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_HDS	(UINT32_C(0x6) << 7)
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_LAST	RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_HDS
	/* unused is 2 b */
	#define RX_TPA_END_CMPL_FLAGS_UNUSED_MASK		UINT32_C(0xc00)
	#define RX_TPA_END_CMPL_FLAGS_UNUSED_SFT		10
	/*
	 * This value indicates what the inner packet determined for the packet
	 * was. - 2 TCP Packet Indicates that the packet was IP and TCP. This
	 * indicates that the ip_cs field is valid and that the tcp_udp_cs field
	 * is valid and contains the TCP checksum. This also indicates that the
	 * payload_offset field is valid.
	 */
	#define RX_TPA_END_CMPL_FLAGS_ITYPE_MASK		UINT32_C(0xf000)
	#define RX_TPA_END_CMPL_FLAGS_ITYPE_SFT			12
	#define RX_TPA_END_CMPL_FLAGS_MASK			UINT32_C(0xffc0)
	#define RX_TPA_END_CMPL_FLAGS_SFT			6
	uint16_t len;
	/*
	 * This value is zero for TPA End completions. There is no data in the
	 * buffer that corresponds to the opaque value in this completion.
	 */
	uint32_t opaque;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint8_t agg_bufs_v1;
	/* unused1 is 1 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define RX_TPA_END_CMPL_V1				UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this aggregation
	 * packet. If the value is zero, then the packet is completely contained
	 * in the buffer space provided in the aggregation start completion.
	 */
	#define RX_TPA_END_CMPL_AGG_BUFS_MASK			UINT32_C(0x7e)
	#define RX_TPA_END_CMPL_AGG_BUFS_SFT			1
	/* unused1 is 1 b */
	uint8_t tpa_segs;
	/* This value is the number of segments in the TPA operation. */
	uint8_t payload_offset;
	/*
	 * This value indicates the offset in bytes from the beginning of the
	 * packet where the inner payload starts. This value is valid for TCP,
	 * UDP, FCoE, and RoCE packets. A value of zero indicates an offset of
	 * 256 bytes.
	 */
	uint8_t agg_id;
	/*
	 * This is the aggregation ID that the completion is associated with.
	 * Use this number to correlate the TPA start completion with the TPA
	 * end completion.
	 */
	/* unused2 is 1 b */
	/*
	 * This is the aggregation ID that the completion is associated with.
	 * Use this number to correlate the TPA start completion with the TPA
	 * end completion.
	 */
	#define RX_TPA_END_CMPL_AGG_ID_MASK			UINT32_C(0xfe)
	#define RX_TPA_END_CMPL_AGG_ID_SFT			1
	uint32_t tsdelta;
	/*
	 * For non-GRO packets, this value is the timestamp delta between
	 * earliest and latest timestamp values for TPA packet. If packets were
	 * not time stamped, then delta will be zero. For GRO packets, this
	 * field is zero except for the following sub-fields. - tsdelta[31]
	 * Timestamp present indication. When '0', no Timestamp option is in the
	 * packet. When '1', then a Timestamp option is present in the packet.
	 */
} __attribute__((packed));

/* last 16 bytes of RX TPA End Completion Record */

struct rx_tpa_end_cmpl_hi {
	uint32_t tpa_dup_acks;
	/* unused3 is 28 b */
	/*
	 * This value is the number of duplicate ACKs that have been received as
	 * part of the TPA operation.
	 */
	#define RX_TPA_END_CMPL_TPA_DUP_ACKS_MASK		UINT32_C(0xf)
	#define RX_TPA_END_CMPL_TPA_DUP_ACKS_SFT		0
	/* unused3 is 28 b */
	uint16_t tpa_seg_len;
	/*
	 * This value is the valid when TPA completion is active. It indicates
	 * the length of the longest segment of the TPA operation for LRO mode
	 * and the length of the first segment in GRO mode. This value may be
	 * used by GRO software to re-construct the original packet stream from
	 * the TPA packet. This is the length of all but the last segment for
	 * GRO. In LRO mode this value may be used to indicate MSS size to the
	 * stack.
	 */
	uint16_t unused_3;
	/* unused4 is 16 b */
	uint16_t errors_v2;
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define RX_TPA_END_CMPL_V2				UINT32_C(0x1)
	/*
	 * This error indicates that there was some sort of problem with the BDs
	 * for the packet that was found after part of the packet was already
	 * placed. The packet should be treated as invalid.
	 */
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_MASK	UINT32_C(0xe)
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_SFT		1
	/*
	 * This error occurs when there is a fatal HW problem in the
	 * chip only. It indicates that there were not BDs on chip but
	 * that there was adequate reservation. provided by the TPA
	 * block.
	 */
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_NOT_ON_CHIP   (UINT32_C(0x2) << 1)
	/*
	 * This error occurs when TPA block was not configured to
	 * reserve adequate BDs for TPA operations on this RX ring. All
	 * data for the TPA operation was not placed. This error can
	 * also be generated when the number of segments is not
	 * programmed correctly in TPA and the 33 total aggregation
	 * buffers allowed for the TPA operation has been exceeded.
	 */
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_RSV_ERROR	(UINT32_C(0x4) << 1)
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_LAST	RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_RSV_ERROR
	#define RX_TPA_END_CMPL_ERRORS_MASK			UINT32_C(0xfffe)
	#define RX_TPA_END_CMPL_ERRORS_SFT			1
	uint16_t unused_4;
	/* unused5 is 16 b */
	uint32_t start_opaque;
	/*
	 * This is the opaque value that was completed for the TPA start
	 * completion that corresponds to this TPA end completion.
	 */
} __attribute__((packed));

/* RX Aggregation Buffer Completion Record (16 bytes) */

struct rx_abuf_cmpl {
	uint16_t type;
	/* unused is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define RX_ABUF_CMPL_TYPE_MASK				UINT32_C(0x3f)
	#define RX_ABUF_CMPL_TYPE_SFT				0
	/*
	 * RX Aggregation Buffer completion : Completion of an L2
	 * aggregation buffer in support of TPA, HDS, or Jumbo packet
	 * completion. Length = 16B
	 */
	#define RX_ABUF_CMPL_TYPE_RX_AGG			UINT32_C(0x12)
	/* unused is 10 b */
	uint16_t len;
	/*
	 * This is the length of the data for the packet stored in this
	 * aggregation buffer identified by the opaque value. This does not
	 * include the length of any data placed in other aggregation BDs or in
	 * the packet or buffer BDs. This length does not include any space
	 * added due to hdr_offset register during HDS placement mode.
	 */
	uint32_t opaque;
	/*
	 * This is a copy of the opaque field from the RX BD this aggregation
	 * buffer corresponds to.
	 */
	uint32_t v;
	/* unused2 is 31 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define RX_ABUF_CMPL_V					UINT32_C(0x1)
	/* unused2 is 31 b */
	uint32_t unused_2;
	/* unused3 is 32 b */
} __attribute__((packed));

/* Statistics Ejection Buffer Completion Record (16 bytes) */

struct eject_cmpl {
	uint16_t type;
	/* unused is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define EJECT_CMPL_TYPE_MASK				UINT32_C(0x3f)
	#define EJECT_CMPL_TYPE_SFT				0
	/*
	 * Statistics Ejection Completion: Completion of statistics data
	 * ejection buffer. Length = 16B
	 */
	#define EJECT_CMPL_TYPE_STAT_EJECT			UINT32_C(0x1a)
	/* unused is 10 b */
	uint16_t len;
	/* This is the length of the statistics data stored in this buffer. */
	uint32_t opaque;
	/*
	 * This is a copy of the opaque field from the RX BD this ejection
	 * buffer corresponds to.
	 */
	uint32_t v;
	/* unused2 is 31 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define EJECT_CMPL_V					UINT32_C(0x1)
	/* unused2 is 31 b */
	uint32_t unused_2;
	/* unused3 is 32 b */
} __attribute__((packed));

/* HWRM Completion Record (16 bytes) */

struct hwrm_cmpl {
	uint16_t type;
	/* unused is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_CMPL_TYPE_MASK				UINT32_C(0x3f)
	#define HWRM_CMPL_TYPE_SFT				0
	/* HWRM Command Completion: Completion of an HWRM command. */
	#define HWRM_CMPL_TYPE_HWRM_DONE			UINT32_C(0x20)
	/* unused is 10 b */
	uint16_t sequence_id;
	/* This is the sequence_id of the HWRM command that has completed. */
	uint32_t unused_1;
	/* unused2 is 32 b */
	uint32_t v;
	/* unused3 is 31 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_CMPL_V					UINT32_C(0x1)
	/* unused3 is 31 b */
	uint32_t unused_3;
	/* unused4 is 32 b */
} __attribute__((packed));

/* HWRM Forwarded Request (16 bytes) */

struct hwrm_fwd_req_cmpl {
	uint16_t req_len_type;
	/* Length of forwarded request in bytes. */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_FWD_REQ_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define HWRM_FWD_REQ_CMPL_TYPE_SFT			0
	/* Forwarded HWRM Request */
	#define HWRM_FWD_REQ_CMPL_TYPE_HWRM_FWD_REQ		UINT32_C(0x22)
	/* Length of forwarded request in bytes. */
	#define HWRM_FWD_REQ_CMPL_REQ_LEN_MASK			UINT32_C(0xffc0)
	#define HWRM_FWD_REQ_CMPL_REQ_LEN_SFT			6
	uint16_t source_id;
	/*
	 * Source ID of this request. Typically used in forwarding requests and
	 * responses. 0x0 - 0xFFF8 - Used for function ids 0xFFF8 - 0xFFFE -
	 * Reserved for internal processors 0xFFFF - HWRM
	 */
	uint32_t unused_0;
	/* unused1 is 32 b */
	uint64_t req_buf_addr_v;
	/* Address of forwarded request. */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_FWD_REQ_CMPL_V				UINT32_C(0x1)
	/* Address of forwarded request. */
	#define HWRM_FWD_REQ_CMPL_REQ_BUF_ADDR_MASK		UINT32_C(0xfffffffe)
	#define HWRM_FWD_REQ_CMPL_REQ_BUF_ADDR_SFT		1
} __attribute__((packed));

/* HWRM Forwarded Response (16 bytes) */

struct hwrm_fwd_resp_cmpl {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_FWD_RESP_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define HWRM_FWD_RESP_CMPL_TYPE_SFT			0
	/* Forwarded HWRM Response */
	#define HWRM_FWD_RESP_CMPL_TYPE_HWRM_FWD_RESP		UINT32_C(0x24)
	/* unused1 is 10 b */
	uint16_t source_id;
	/*
	 * Source ID of this response. Typically used in forwarding requests and
	 * responses. 0x0 - 0xFFF8 - Used for function ids 0xFFF8 - 0xFFFE -
	 * Reserved for internal processors 0xFFFF - HWRM
	 */
	uint16_t resp_len;
	/* Length of forwarded response in bytes. */
	uint16_t unused_1;
	/* unused2 is 16 b */
	uint64_t resp_buf_addr_v;
	/* Address of forwarded response. */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_FWD_RESP_CMPL_V				UINT32_C(0x1)
	/* Address of forwarded response. */
	#define HWRM_FWD_RESP_CMPL_RESP_BUF_ADDR_MASK		UINT32_C(0xfffffffe)
	#define HWRM_FWD_RESP_CMPL_RESP_BUF_ADDR_SFT		1
} __attribute__((packed));

#define GET_EVENT_ID(x) \
	((x) == 0x30 ? "VF_FLR": \
	((x) == 0x20 ? "PF_DRVR_UNLOAD": \
	((x) == 0x10 ? "FUNC_DRVR_UNLOAD": \
	((x) == 0xff ? "HWRM_ERROR": \
	((x) == 0x32 ? "PF_VF_COMM_STATUS_CHANGE": \
	((x) == 0x33 ? "VF_CFG_CHANGE": \
	((x) == 0x11 ? "FUNC_DRVR_LOAD": \
	((x) == 0x31 ? "VF_MAC_ADDR_CHANGE": \
	((x) == 0x34 ? "LLFC_PFC_CHANGE": \
	((x) == 0x4 ? "PORT_CONN_NOT_ALLOWED": \
	((x) == 0x5 ? "LINK_SPEED_CFG_NOT_ALLOWED": \
	((x) == 0x6 ? "LINK_SPEED_CFG_CHANGE": \
	((x) == 0x7 ? "PORT_PHY_CFG_CHANGE": \
	((x) == 0x0 ? "LINK_STATUS_CHANGE": \
	((x) == 0x1 ? "LINK_MTU_CHANGE": \
	((x) == 0x2 ? "LINK_SPEED_CHANGE": \
	((x) == 0x3 ? "DCB_CONFIG_CHANGE": \
	((x) == 0x12 ? "FUNC_FLR_PROC_CMPLT": \
	((x) == 0x21 ? "PF_DRVR_LOAD": \
	"Unknown event_id")))))))))))))))))))

/* HWRM Asynchronous Event Completion Record (16 bytes) */

struct hwrm_async_event_cmpl {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_MASK			UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_SFT			0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_HWRM_ASYNC_EVENT	UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Link status changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_STATUS_CHANGE UINT32_C(0x0)
	/* Link MTU changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_MTU_CHANGE	UINT32_C(0x1)
	/* Link speed changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CHANGE  UINT32_C(0x2)
	/* DCB Configuration changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DCB_CONFIG_CHANGE  UINT32_C(0x3)
	/* Port connection not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PORT_CONN_NOT_ALLOWED UINT32_C(0x4)
	/* Link speed configuration was not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED UINT32_C(0x5)
	/* Link speed configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CFG_CHANGE UINT32_C(0x6)
	/* Port PHY configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PORT_PHY_CFG_CHANGE UINT32_C(0x7)
	/* Function driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_DRVR_UNLOAD   UINT32_C(0x10)
	/* Function driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_DRVR_LOAD	UINT32_C(0x11)
	/* Function FLR related processing has completed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_FLR_PROC_CMPLT UINT32_C(0x12)
	/* PF driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_DRVR_UNLOAD	UINT32_C(0x20)
	/* PF driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_DRVR_LOAD	UINT32_C(0x21)
	/* VF Function Level Reset (FLR) */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_FLR		UINT32_C(0x30)
	/* VF MAC Address Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_MAC_ADDR_CHANGE UINT32_C(0x31)
	/* PF-VF communication channel status change. */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_VF_COMM_STATUS_CHANGE UINT32_C(0x32)
	/* VF Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_CFG_CHANGE	UINT32_C(0x33)
	/* LLFC/PFC Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LLFC_PFC_CHANGE	UINT32_C(0x34)
	/* HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HWRM_ERROR	UINT32_C(0xff)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_V				UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_OPAQUE_MASK		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_OPAQUE_SFT		1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for link status change (16 bytes) */

struct hwrm_async_event_cmpl_link_status_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_SFT  0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Link status changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_ID_LINK_STATUS_CHANGE UINT32_C(0x0)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* Indicates link status change */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE UINT32_C(0x1)
	/*
	 * If this bit set to 0, then it indicates that the link was up
	 * and it went down.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_DOWN (UINT32_C(0x0) << 0)
	/*
	 * If this bit is set to 1, then it indicates that the link was
	 * down and it went up.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_UP (UINT32_C(0x1) << 0)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_LAST	HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_UP
	/* Indicates the physical port this link status change occur */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_MASK UINT32_C(0xe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_SFT 1
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff0)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_ID_SFT 4
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for link MTU change (16 bytes) */

struct hwrm_async_event_cmpl_link_mtu_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Link MTU changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_ID_LINK_MTU_CHANGE UINT32_C(0x1)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_V		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_OPAQUE_MASK  UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_OPAQUE_SFT   1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* The new MTU of the link in bytes. */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_DATA1_NEW_MTU_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_DATA1_NEW_MTU_SFT 0
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for link speed change (16 bytes) */

struct hwrm_async_event_cmpl_link_speed_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_MASK  UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_SFT   0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Link speed changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_ID_LINK_SPEED_CHANGE UINT32_C(0x2)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/*
	 * When this bit is '1', the link was forced to the force_link_speed
	 * value.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_FORCE UINT32_C(0x1)
	/* The new link speed in 100 Mbps units. */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_MASK UINT32_C(0xfffe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_SFT 1
	/* 100Mb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100MB (UINT32_C(0x1) << 1)
	/* 1Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_1GB (UINT32_C(0xa) << 1)
	/* 2Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_2GB (UINT32_C(0x14) << 1)
	/* 2.5Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_2_5GB (UINT32_C(0x19) << 1)
	/* 10Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_10GB (UINT32_C(0x64) << 1)
	/* 20Mb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_20GB (UINT32_C(0xc8) << 1)
	/* 25Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_25GB (UINT32_C(0xfa) << 1)
	/* 40Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_40GB (UINT32_C(0x190) << 1)
	/* 50Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_50GB (UINT32_C(0x1f4) << 1)
	/* 100Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100GB (UINT32_C(0x3e8) << 1)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_LAST	HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100GB
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_PORT_ID_SFT 16
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for DCB Config change (16 bytes) */

struct hwrm_async_event_cmpl_dcb_config_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_MASK  UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_SFT   0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* DCB Configuration changed */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_ID_DCB_CONFIG_CHANGE UINT32_C(0x3)
	uint32_t event_data2;
	/* Event specific data */
	/* ETS configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_ETS UINT32_C(0x1)
	/* PFC configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_PFC UINT32_C(0x2)
	/* APP configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_APP UINT32_C(0x4)
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_PORT_ID_SFT 0
	/* Priority recommended for RoCE traffic */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_MASK UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_SFT 16
	/* none is 255 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_NONE (UINT32_C(0xff) << 16)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_LAST	HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_NONE
	/* Priority recommended for L2 traffic */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_MASK UINT32_C(0xff000000)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_SFT 24
	/* none is 255 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_NONE (UINT32_C(0xff) << 24)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_LAST	HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_NONE
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for port connection not allowed (16 bytes) */

struct hwrm_async_event_cmpl_port_conn_not_allowed {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_SFT 0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Port connection not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_ID_PORT_CONN_NOT_ALLOWED UINT32_C(0x4)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_PORT_ID_SFT 0
	/*
	 * This value indicates the current port level enforcement policy for
	 * the optics module when there is an optical module mismatch and port
	 * is not connected.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_MASK UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_SFT 16
	/* No enforcement */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_NONE (UINT32_C(0x0) << 16)
	/* Disable Transmit side Laser. */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_DISABLETX (UINT32_C(0x1) << 16)
	/* Raise a warning message. */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_WARNINGMSG (UINT32_C(0x2) << 16)
	/* Power down the module. */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_PWRDOWN (UINT32_C(0x3) << 16)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_LAST	HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_PWRDOWN
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for link speed config not allowed (16 bytes) */

struct hwrm_async_event_cmpl_link_speed_cfg_not_allowed {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_SFT 0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Link speed configuration was not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED UINT32_C(0x5)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_V UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_DATA1_PORT_ID_SFT 0
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for link speed configuration change (16 bytes) */

struct hwrm_async_event_cmpl_link_speed_cfg_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_SFT 0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Link speed configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_ID_LINK_SPEED_CFG_CHANGE UINT32_C(0x6)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_PORT_ID_SFT 0
	/*
	 * If set to 1, it indicates that the supported link speeds
	 * configuration on the port has changed. If set to 0, then there is no
	 * change in supported link speeds configuration.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_SUPPORTED_LINK_SPEEDS_CHANGE UINT32_C(0x10000)
	/*
	 * If set to 1, it indicates that the link speed configuration on the
	 * port has become illegal or invalid. If set to 0, then the link speed
	 * configuration on the port is legal or valid.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_ILLEGAL_LINK_SPEED_CFG UINT32_C(0x20000)
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for port PHY configuration change (16 bytes) */

struct hwrm_async_event_cmpl_port_phy_cfg_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_SFT 0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Port PHY configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_ID_PORT_PHY_CFG_CHANGE UINT32_C(0x7)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PORT_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PORT_ID_SFT 0
	/*
	 * If set to 1, it indicates that the FEC configuration on the port has
	 * changed. If set to 0, then there is no change in FEC configuration.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_FEC_CFG_CHANGE UINT32_C(0x10000)
	/*
	 * If set to 1, it indicates that the EEE configuration on the port has
	 * changed. If set to 0, then there is no change in EEE configuration on
	 * the port.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_EEE_CFG_CHANGE UINT32_C(0x20000)
	/*
	 * If set to 1, it indicates that the pause configuration on the PHY has
	 * changed. If set to 0, then there is no change in the pause
	 * configuration on the PHY.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PAUSE_CFG_CHANGE UINT32_C(0x40000)
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for Function Driver Unload (16 bytes) */

struct hwrm_async_event_cmpl_func_drvr_unload {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_MASK   UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Function driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_ID_FUNC_DRVR_UNLOAD UINT32_C(0x10)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_OPAQUE_SFT  1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_SFT 0
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for Function Driver load (16 bytes) */

struct hwrm_async_event_cmpl_func_drvr_load {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Function driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_ID_FUNC_DRVR_LOAD UINT32_C(0x11)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_V		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_OPAQUE_MASK   UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_OPAQUE_SFT	1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_DATA1_FUNC_ID_SFT 0
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record to indicate completion of FLR related processing (16 bytes) */

struct hwrm_async_event_cmpl_func_flr_proc_cmplt {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_SFT 0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* Function FLR related processing has completed */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_ID_FUNC_FLR_PROC_CMPLT UINT32_C(0x12)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_DATA1_FUNC_ID_SFT 0
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for PF Driver Unload (16 bytes) */

struct hwrm_async_event_cmpl_pf_drvr_unload {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* PF driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_ID_PF_DRVR_UNLOAD UINT32_C(0x20)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_V		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_OPAQUE_MASK   UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_OPAQUE_SFT	1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* PF ID */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_SFT 0
	/* Indicates the physical port this pf belongs to */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_PORT_MASK UINT32_C(0x70000)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_PORT_SFT 16
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for PF Driver load (16 bytes) */

struct hwrm_async_event_cmpl_pf_drvr_load {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* PF driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_ID_PF_DRVR_LOAD UINT32_C(0x21)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_V		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_OPAQUE_MASK	UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_OPAQUE_SFT	1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* PF ID */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_FUNC_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_FUNC_ID_SFT 0
	/* Indicates the physical port this pf belongs to */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_PORT_MASK UINT32_C(0x70000)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_PORT_SFT 16
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for VF FLR (16 bytes) */

struct hwrm_async_event_cmpl_vf_flr {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_MASK		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_SFT		0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* VF Function Level Reset (FLR) */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_ID_VF_FLR	UINT32_C(0x30)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_V			UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_OPAQUE_MASK	UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_OPAQUE_SFT		1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* VF ID */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_VF_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_VF_ID_SFT 0
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for VF MAC Addr change (16 bytes) */

struct hwrm_async_event_cmpl_vf_mac_addr_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_SFT  0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* VF MAC Address Change */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_ID_VF_MAC_ADDR_CHANGE UINT32_C(0x31)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_V	UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* VF ID */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_DATA1_VF_ID_MASK UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_DATA1_VF_ID_SFT 0
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for PF-VF communication status change (16 bytes) */

struct hwrm_async_event_cmpl_pf_vf_comm_status_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_MASK UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_SFT 0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* PF-VF communication channel status change. */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_ID_PF_VF_COMM_STATUS_CHANGE UINT32_C(0x32)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_V   UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_OPAQUE_SFT 1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/*
	 * If this bit is set to 1, then it indicates that the PF-VF
	 * communication was lost and it is established. If this bit set to 0,
	 * then it indicates that the PF-VF communication was established and it
	 * is lost.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_DATA1_COMM_ESTABLISHED UINT32_C(0x1)
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for VF configuration change (16 bytes) */

struct hwrm_async_event_cmpl_vf_cfg_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* VF Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_ID_VF_CFG_CHANGE UINT32_C(0x33)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_V		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_OPAQUE_MASK	UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_OPAQUE_SFT	1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/*
	 * Each flag provided in this field indicates a specific VF
	 * configuration change. At least one of these flags shall be set to 1
	 * when an asynchronous event completion of this type is provided by the
	 * HWRM.
	 */
	/*
	 * If this bit is set to 1, then the value of MTU was changed on this
	 * VF. If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_MTU_CHANGE UINT32_C(0x1)
	/*
	 * If this bit is set to 1, then the value of MRU was changed on this
	 * VF. If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_MRU_CHANGE UINT32_C(0x2)
	/*
	 * If this bit is set to 1, then the value of default MAC address was
	 * changed on this VF. If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_DFLT_MAC_ADDR_CHANGE UINT32_C(0x4)
	/*
	 * If this bit is set to 1, then the value of default VLAN was changed
	 * on this VF. If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_DFLT_VLAN_CHANGE UINT32_C(0x8)
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for llfc pfc status change (16 bytes) */

struct hwrm_async_event_cmpl_llfc_pfc_change {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* LLFC/PFC Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_ID_LLFC_PFC_CHANGE UINT32_C(0x34)
	uint32_t event_data2;
	/* Event specific data */
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_V		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_OPAQUE_MASK  UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_OPAQUE_SFT   1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* Indicates llfc pfc status change */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_MASK UINT32_C(0x3)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_SFT 0
	/* If this field set to 1, then it indicates that llfc is enabled. */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_LLFC (UINT32_C(0x1) << 0)
	/* If this field is set to 2, then it indicates that pfc is enabled. */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_PFC (UINT32_C(0x2) << 0)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_LAST	HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_PFC
	/* Indicates the physical port this llfc pfc change occur */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_MASK UINT32_C(0x1c)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_SFT 2
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_ID_MASK UINT32_C(0x1fffe0)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_ID_SFT 5
} __attribute__((packed));

/* HWRM Asynchronous Event Completion Record for HWRM Error (16 bytes) */

struct hwrm_async_event_cmpl_hwrm_error {
	uint16_t type;
	/* unused1 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_MASK	UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_SFT	0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_HWRM_ASYNC_EVENT UINT32_C(0x2e)
	/* unused1 is 10 b */
	uint16_t event_id;
	/* Identifiers of events. */
	/* HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_ID_HWRM_ERROR UINT32_C(0xff)
	uint32_t event_data2;
	/* Event specific data */
	/* Severity of HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_MASK UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_SFT 0
	/* Warning */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_WARNING UINT32_C(0x0)
	/* Non-fatal Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_NONFATAL UINT32_C(0x1)
	/* Fatal Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_FATAL UINT32_C(0x2)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_LAST	HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_FATAL
	uint8_t opaque_v;
	/* opaque is 7 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_V		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_OPAQUE_MASK	UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_OPAQUE_SFT	1
	uint8_t timestamp_lo;
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint16_t timestamp_hi;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint32_t event_data1;
	/* Event specific data */
	/* Time stamp for error event */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA1_TIMESTAMP UINT32_C(0x1)
} __attribute__((packed));

/* Door Bell Formats */
/*
 * Description: The backup version of the packet must be valid in the TX ring
 * before the push doorbell is written to the chip. The first 32b and the BD
 * portion of the push doorbell must be written in multiples of 32b units on the
 * PCI interface. The data portion of the push doorbell may be written in
 * multiples of 8b units on the PCI interface. A push update must contain
 * exactly one push packet. The backup version of the packet must start with a
 * long (32B) BD and the BDs must be less than or equal to 16x16B units long.
 */
/*
 * Note: This door bell format is used by the driver when it wants to push a
 * packet into the chip for super-fast transmission. This pushes a partial BD
 * and the packet data into the chip. If the chip has room, it will transmit the
 * packet. If the chip doesn't have room, it will read the BD and packet data
 * from host memory as a normal packet.
 */
/* TX Door Bell Format (4 bytes) */

struct tx_doorbell {
	uint32_t key_idx;
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '0' for TX door bell operations.
	 */
	/*
	 * BD Index of next BD that will be used to transmit data on the TX ring
	 * mapped to this door bell. NIC may read and process all BDs up to, but
	 * not including this index.
	 */
	#define TX_DOORBELL_IDX_MASK				UINT32_C(0xffffff)
	#define TX_DOORBELL_IDX_SFT				0
	/* reserved is 4 b */
	#define TX_DOORBELL_RESERVED_MASK			UINT32_C(0xf000000)
	#define TX_DOORBELL_RESERVED_SFT			24
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '0' for TX door bell operations.
	 */
	#define TX_DOORBELL_KEY_MASK				UINT32_C(0xf0000000)
	#define TX_DOORBELL_KEY_SFT				28
	/* TX Operation */
	#define TX_DOORBELL_KEY_TX				(UINT32_C(0x0) << 28)
} __attribute__((packed));

/* RX Door Bell Format (4 bytes) */

struct rx_doorbell {
	uint32_t key_idx;
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '1' for RX door bell operations.
	 */
	/*
	 * BD Index of next BD that will be used for an empty receive buffer on
	 * the RX ring mapped to this door bell. NIC may read and process all
	 * BDs up to, but not including this index.
	 */
	#define RX_DOORBELL_IDX_MASK				UINT32_C(0xffffff)
	#define RX_DOORBELL_IDX_SFT				0
	/* reserved is 4 b */
	#define RX_DOORBELL_RESERVED_MASK			UINT32_C(0xf000000)
	#define RX_DOORBELL_RESERVED_SFT			24
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '1' for RX door bell operations.
	 */
	#define RX_DOORBELL_KEY_MASK				UINT32_C(0xf0000000)
	#define RX_DOORBELL_KEY_SFT				28
	/* RX Operation */
	#define RX_DOORBELL_KEY_RX				(UINT32_C(0x1) << 28)
} __attribute__((packed));

/* CMP Door Bell Format (4 bytes) */

struct cmpl_doorbell {
	uint32_t key_mask_valid_idx;
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '2' for CMP door bell operations.
	 */
	/*
	 * BD Index of the most recently handed completion record on the
	 * completion ring mapped to this door bell. NIC may write this location
	 * again with a new completion.
	 */
	#define CMPL_DOORBELL_IDX_MASK				UINT32_C(0xffffff)
	#define CMPL_DOORBELL_IDX_SFT				0
	/* reserved is 2 b */
	#define CMPL_DOORBELL_RESERVED_MASK			UINT32_C(0x3000000)
	#define CMPL_DOORBELL_RESERVED_SFT			24
	/*
	 * This indicates if the BDIDX value is valid for this update when it is
	 * '1'. When it is '0', the BDIDX value should be ignored.
	 */
	#define CMPL_DOORBELL_IDX_VALID				UINT32_C(0x4000000)
	/*
	 * This bit indicates the new interrupt mask state for the interrupt
	 * associated with the BDIDX. A '1', means the interrupt is to be
	 * masked. A '0' indicates the interrupt is to be unmasked.
	 */
	#define CMPL_DOORBELL_MASK				UINT32_C(0x8000000)
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '2' for CMP door bell operations.
	 */
	#define CMPL_DOORBELL_KEY_MASK				UINT32_C(0xf0000000)
	#define CMPL_DOORBELL_KEY_SFT				28
	/* Completion Operation */
	#define CMPL_DOORBELL_KEY_CMPL				(UINT32_C(0x2) << 28)
} __attribute__((packed));

/* Status Door Bell Format (4 bytes) */

struct status_doorbell {
	uint32_t key_idx;
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '3' for Status door bell operations.
	 */
	/*
	 * BD Index of the status record for which space is now available to the
	 * NIC.
	 */
	/*
	 * While there is no actual BD associated with the index, the similar
	 * scheme is being used to communicate to the NIC that space is
	 * available for status completions.
	 */
	#define STATUS_DOORBELL_IDX_MASK			UINT32_C(0xffffff)
	#define STATUS_DOORBELL_IDX_SFT				0
	/* reserved is 4 b */
	#define STATUS_DOORBELL_RESERVED_MASK			UINT32_C(0xf000000)
	#define STATUS_DOORBELL_RESERVED_SFT			24
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is '3' for Status door bell operations.
	 */
	#define STATUS_DOORBELL_KEY_MASK			UINT32_C(0xf0000000)
	#define STATUS_DOORBELL_KEY_SFT				28
	/* Status Operation */
	#define STATUS_DOORBELL_KEY_STAT			(UINT32_C(0x3) << 28)
} __attribute__((packed));

/* Push w/32B BD Door Bell Format (32 bytes) */

struct push32_doorbell {
	uint32_t key_sz_idx;
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is 4 for push door bell operations.
	 */
	/*
	 * This is the BD Index of last BD of the push packet that will be used
	 * to transmit data on the TX ring mapped to this door bell.
	 */
	#define PUSH32_DOORBELL_IDX_MASK			UINT32_C(0xffffff)
	#define PUSH32_DOORBELL_IDX_SFT				0
	/*
	 * This is the number of 16B BDs spaces consumed in the TX Ring by the
	 * "backup" version of the packet being pushed. A value of 1 is invalid
	 * since backup must start with a long 32B BE. A value of 2 indicates
	 * just the first 32B BE. A value of 3 indicates 32B+16B BD. etc. A
	 * value of 0 indicates 16x16B BD spaces are consumed.
	 */
	#define PUSH32_DOORBELL_SZ_MASK				UINT32_C(0xf000000)
	#define PUSH32_DOORBELL_SZ_SFT				24
	/*
	 * This value indicates the type of door bell operation that is begin
	 * requested. This value is 4 for push door bell operations.
	 */
	#define PUSH32_DOORBELL_KEY_MASK			UINT32_C(0xf0000000)
	#define PUSH32_DOORBELL_KEY_SFT				28
	/* Push Operation */
	#define PUSH32_DOORBELL_KEY_PUSH			(UINT32_C(0x4) << 28)
	uint16_t flags_type;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs of a
	 * packet.
	 */
	/* This value identifies the type of buffer descriptor. */
	#define PUSH32_DOORBELL_TYPE_MASK			UINT32_C(0x3f)
	#define PUSH32_DOORBELL_TYPE_SFT			0
	/*
	 * Indicates that this BD is 32B long and is used for normal L2
	 * packet transmission.
	 */
	#define PUSH32_DOORBELL_TYPE_TX_BD_LONG		UINT32_C(0x10)
	/*
	 * If set to 1, the packet ends with the data in the buffer pointed to
	 * by this descriptor. This flag must be valid on every BD. This bit
	 * must be set on all push doorbells.
	 */
	#define PUSH32_DOORBELL_FLAGS_PACKET_END		UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for this
	 * transmit packet unless there is an error in its processing. If this
	 * bit is set to 0, then the packet will be completed normally. This bit
	 * must be valid only on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_NO_CMPL			UINT32_C(0x80)
	/*
	 * This value must match the sz field in the first 32b of the push
	 * operation except that if 16x16B BD locations are consumed in the ring
	 * by this packet, then this value must be 16 (not zero).
	 */
	#define PUSH32_DOORBELL_FLAGS_BD_CNT_MASK		UINT32_C(0x1f00)
	#define PUSH32_DOORBELL_FLAGS_BD_CNT_SFT		8
	/*
	 * This value is a hint for the length of the entire packet. It is used
	 * by the chip to optimize internal processing. The packet will be
	 * dropped if the hint is too short. This field is valid only on the
	 * first BD of a packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_LHINT_MASK		UINT32_C(0x6000)
	#define PUSH32_DOORBELL_FLAGS_LHINT_SFT			13
	/* indicates packet length < 512B */
	#define PUSH32_DOORBELL_FLAGS_LHINT_LT512		(UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
	#define PUSH32_DOORBELL_FLAGS_LHINT_LT1K		(UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
	#define PUSH32_DOORBELL_FLAGS_LHINT_LT2K		(UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
	#define PUSH32_DOORBELL_FLAGS_LHINT_GTE2K		(UINT32_C(0x3) << 13)
	#define PUSH32_DOORBELL_FLAGS_LHINT_LAST	PUSH32_DOORBELL_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer Index
	 * after the buffer associated with this descriptor has been transferred
	 * via DMA to NIC memory from host memory. An interrupt may or may not
	 * be generated according to the state of the interrupt avoidance
	 * mechanisms. If this bit is set to 0, then the Consumer Index is only
	 * updated as soon as one of the host interrupt coalescing conditions
	 * has been met. This bit must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_COAL_NOW			UINT32_C(0x8000)
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs of a
	 * packet.
	 */
	#define PUSH32_DOORBELL_FLAGS_MASK			UINT32_C(0xffc0)
	#define PUSH32_DOORBELL_FLAGS_SFT			6
	uint16_t len;
	/*
	 * This is the length of the host physical buffer this BD describes in
	 * bytes. This field must be valid on all BDs of a packet.
	 */
	uint32_t opaque;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD. This field must be valid on the first BD of a packet.
	 */
	uint16_t lflags;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Their value on other BDs of the packet will be ignored.
	 */
	/*
	 * If set to 1, the controller replaces the TCP/UPD checksum fields of
	 * normal TCP/UPD checksum, or the inner TCP/UDP checksum field of the
	 * encapsulated TCP/UDP packets with the hardware calculated TCP/UDP
	 * checksum for the packet associated with this descriptor. The flag is
	 * ignored if the LSO flag is set. This bit must be valid on the first
	 * BD of a packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_TCP_UDP_CHKSUM		UINT32_C(0x1)
	/*
	 * If set to 1, the controller replaces the IP checksum of the normal
	 * packets, or the inner IP checksum of the encapsulated packets with
	 * the hardware calculated IP checksum for the packet associated with
	 * this descriptor. This bit must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_IP_CHKSUM		UINT32_C(0x2)
	/*
	 * If set to 1, the controller will not append an Ethernet CRC to the
	 * end of the frame. This bit must be valid on the first BD of a packet.
	 * Packet must be 64B or longer when this flag is set. It is not useful
	 * to use this bit with any form of TX offload such as CSO or LSO. The
	 * intent is that the packet from the host already has a valid Ethernet
	 * CRC on the packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_NOCRC			UINT32_C(0x4)
	/*
	 * If set to 1, the device will record the time at which the packet was
	 * actually transmitted at the TX MAC. This bit must be valid on the
	 * first BD of a packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_STAMP			UINT32_C(0x8)
	/*
	 * If set to 1, The controller replaces the tunnel IP checksum field
	 * with hardware calculated IP checksum for the IP header of the packet
	 * associated with this descriptor. For outer UDP checksum, global outer
	 * UDP checksum TE_NIC register needs to be enabled. If the global outer
	 * UDP checksum TE_NIC register bit is set, outer UDP checksum will be
	 * calculated for the following cases: 1. Packets with tcp_udp_chksum
	 * flag set to offload checksum for inner packet AND the inner packet is
	 * TCP/UDP. If the inner packet is ICMP for example (non-TCP/UDP), even
	 * if the tcp_udp_chksum is set, the outer UDP checksum will not be
	 * calculated. 2. Packets with lso flag set which implies inner TCP
	 * checksum calculation as part of LSO operation.
	 */
	#define PUSH32_DOORBELL_LFLAGS_T_IP_CHKSUM		UINT32_C(0x10)
	/*
	 * If set to 1, the device will treat this packet with LSO(Large Send
	 * Offload) processing for both normal or encapsulated packets, which is
	 * a form of TCP segmentation. When this bit is 1, the hdr_size and mss
	 * fields must be valid. The driver doesn't need to set t_ip_chksum,
	 * ip_chksum, and tcp_udp_chksum flags since the controller will replace
	 * the appropriate checksum fields for segmented packets. When this bit
	 * is 1, the hdr_size and mss fields must be valid.
	 */
	#define PUSH32_DOORBELL_LFLAGS_LSO			UINT32_C(0x20)
	/*
	 * If set to zero when LSO is '1', then the IPID will be treated as a
	 * 16b number and will be wrapped if it exceeds a value of 0xffff. If
	 * set to one when LSO is '1', then the IPID will be treated as a 15b
	 * number and will be wrapped if it exceeds a value 0f 0x7fff.
	 */
	#define PUSH32_DOORBELL_LFLAGS_IPID_FMT			UINT32_C(0x40)
	/*
	 * If set to zero when LSO is '1', then the IPID of the tunnel IP header
	 * will not be modified during LSO operations. If set to one when LSO is
	 * '1', then the IPID of the tunnel IP header will be incremented for
	 * each subsequent segment of an LSO operation. The flag is ignored if
	 * the LSO packet is a normal (non-tunneled) TCP packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_T_IPID			UINT32_C(0x80)
	/*
	 * If set to '1', then the RoCE ICRC will be appended to the packet.
	 * Packet must be a valid RoCE format packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_ROCE_CRC			UINT32_C(0x100)
	/*
	 * If set to '1', then the FCoE CRC will be appended to the packet.
	 * Packet must be a valid FCoE format packet.
	 */
	#define PUSH32_DOORBELL_LFLAGS_FCOE_CRC			UINT32_C(0x200)
	uint16_t hdr_size;
	/*
	 * When LSO is '1', this field must contain the offset of the TCP
	 * payload from the beginning of the packet in as 16b words. In case of
	 * encapsulated/tunneling packet, this field contains the offset of the
	 * inner TCP payload from beginning of the packet as 16-bit words. This
	 * value must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_HDR_SIZE_MASK			UINT32_C(0x1ff)
	#define PUSH32_DOORBELL_HDR_SIZE_SFT			0
	uint32_t mss;
	/*
	 * This is the MSS value that will be used to do the LSO processing. The
	 * value is the length in bytes of the TCP payload for each segment
	 * generated by the LSO operation. This value must be valid on the first
	 * BD of a packet.
	 */
	#define PUSH32_DOORBELL_MSS_MASK			UINT32_C(0x7fff)
	#define PUSH32_DOORBELL_MSS_SFT				0
	uint16_t unused_2;
	uint16_t cfa_action;
	/*
	 * This value selects a CFA action to perform on the packet. Set this
	 * value to zero if no CFA action is desired. This value must be valid
	 * on the first BD of a packet.
	 */
	uint32_t cfa_meta;
	/*
	 * This value is action meta-data that defines CFA edit operations that
	 * are done in addition to any action editing.
	 */
	/* When key=1, This is the VLAN tag VID value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_VID_MASK		UINT32_C(0xfff)
	#define PUSH32_DOORBELL_CFA_META_VLAN_VID_SFT		0
	/* When key=1, This is the VLAN tag DE value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_DE		UINT32_C(0x1000)
	/* When key=1, This is the VLAN tag PRI value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_PRI_MASK		UINT32_C(0xe000)
	#define PUSH32_DOORBELL_CFA_META_VLAN_PRI_SFT		13
	/* When key=1, This is the VLAN tag TPID select value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_MASK		UINT32_C(0x70000)
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_SFT		16
	/* 0x88a8 */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID88A8	(UINT32_C(0x0) << 16)
	/* 0x8100 */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID8100	(UINT32_C(0x1) << 16)
	/* 0x9100 */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID9100	(UINT32_C(0x2) << 16)
	/* 0x9200 */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID9200	(UINT32_C(0x3) << 16)
	/* 0x9300 */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPID9300	(UINT32_C(0x4) << 16)
	/* Value programmed in CFA VLANTPID register. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPIDCFG	(UINT32_C(0x5) << 16)
	#define PUSH32_DOORBELL_CFA_META_VLAN_TPID_LAST	PUSH32_DOORBELL_CFA_META_VLAN_TPID_TPIDCFG
	/* When key=1, This is the VLAN tag TPID select value. */
	#define PUSH32_DOORBELL_CFA_META_VLAN_RESERVED_MASK	UINT32_C(0xff80000)
	#define PUSH32_DOORBELL_CFA_META_VLAN_RESERVED_SFT	19
	/*
	 * This field identifies the type of edit to be performed on the packet.
	 * This value must be valid on the first BD of a packet.
	 */
	#define PUSH32_DOORBELL_CFA_META_KEY_MASK		UINT32_C(0xf0000000)
	#define PUSH32_DOORBELL_CFA_META_KEY_SFT		28
	/* No editing */
	#define PUSH32_DOORBELL_CFA_META_KEY_NONE		(UINT32_C(0x0) << 28)
	/*
	 * - meta[17:16] - TPID select value (0 = 0x8100). - meta[15:12]
	 * - PRI/DE value. - meta[11:0] - VID value.
	 */
	#define PUSH32_DOORBELL_CFA_META_KEY_VLAN_TAG		(UINT32_C(0x1) << 28)
	#define PUSH32_DOORBELL_CFA_META_KEY_LAST	PUSH32_DOORBELL_CFA_META_KEY_VLAN_TAG
	uint32_t data[25];
	/*
	 * This is the data for the push packet. If the packet data does not fit
	 * in the first pass, data writing can continue at offset 4 of the
	 * doorbell for up to 4 additional passes for a total data size of 512B
	 * maximum.
	 */
} __attribute__((packed));

/* Doorbell Structures */
/*
 * Description: This is the RoCE 32b Doorbell format. The host writes this
 * message format directly to byte offset 8 of the appropriate doorbell page.
 */
/* 64b Doorbell Format (8 bytes) */

struct dbr_dbr {
	uint32_t index;
	/*
	 * This value is the index being written. For SQ, RQ, SRQ, this is the
	 * producer index and should be the queue index of the last WQE written
	 * plus 1. For CQ, this is the consumer index and should be the index of
	 * the last CQE processed plus 1.
	 */
	#define DBR_DBR_INDEX_MASK				UINT32_C(0xfffff)
	#define DBR_DBR_INDEX_SFT				0
	#define DBR_DBR_RESERVED12_MASK				UINT32_C(0xfff00000)
	#define DBR_DBR_RESERVED12_SFT				20
	uint32_t type_xid;
	/* This value identifies the type of doorbell being written. */
	/*
	 * This value identifies the resource that the doorbell is intended to
	 * notify. For SQ and RQ, this is the QPID. For SRQ, this is the SID.
	 * For CQ, this is the CID. Bits [19:16] of this values must be zero for
	 * a SID value.
	 */
	#define DBR_DBR_XID_MASK				UINT32_C(0xfffff)
	#define DBR_DBR_XID_SFT					0
	#define DBR_DBR_RESERVED8_MASK				UINT32_C(0xff00000)
	#define DBR_DBR_RESERVED8_SFT				20
	/* This value identifies the type of doorbell being written. */
	#define DBR_DBR_TYPE_MASK				UINT32_C(0xf0000000)
	#define DBR_DBR_TYPE_SFT				28
	/*
	 * This is a SQ producer index update. It indicates one or more
	 * new entries have been written to the SQ for the QPID
	 * indicated on the xID field.
	 */
	#define DBR_DBR_TYPE_SQ				(UINT32_C(0x0) << 28)
	/*
	 * This is a RQ producer index update. It indicates one or more
	 * new entries have been written to the RQ for the QPID
	 * indicated on the xID field.
	 */
	#define DBR_DBR_TYPE_RQ				(UINT32_C(0x1) << 28)
	/*
	 * This is a SRQ producer index update. It indicates one or more
	 * new entries have been written to the SRQ for the SID
	 * indicated on the xID field.
	 */
	#define DBR_DBR_TYPE_SRQ				(UINT32_C(0x2) << 28)
	/*
	 * This doorbell command arms the SRQ async event. The xID field
	 * must identify the SID that is begin armed. The index field is
	 * will set the arm threshold such that a notification will be
	 * generated if less than that number or SRQ entries are posted.
	 */
	#define DBR_DBR_TYPE_SRQ_ARM				(UINT32_C(0x3) << 28)
	/*
	 * This is a CQ consumer index update. It indicates one or more
	 * entries have been processed off the CQ indicated on the xID
	 * field.
	 */
	#define DBR_DBR_TYPE_CQ				(UINT32_C(0x4) << 28)
	/*
	 * this is a CQ consumer index update that also arms the CQ for
	 * solicited events.
	 */
	#define DBR_DBR_TYPE_CQ_ARMSE				(UINT32_C(0x5) << 28)
	/*
	 * This is a CQ consumer index update that also arms the CQ for
	 * any new CQE.
	 */
	#define DBR_DBR_TYPE_CQ_ARMALL				(UINT32_C(0x6) << 28)
	/*
	 * This is a CQ arm enable message. This message must be sent
	 * from the privileged driver before a new CQ_ARMSE or CQ_ARMALL
	 * message will be accepted. This doorbell can only be sent from
	 * the privileged (first) doorbell page of a function.
	 */
	#define DBR_DBR_TYPE_CQ_ARMENA				(UINT32_C(0x7) << 28)
	/*
	 * This doorbell command enables the SRQ async event to be
	 * armed. This message must be setn from the privileged driver
	 * before a new SRQ_ARM message will be accepted. The xID field
	 * must identify the SID that is begin enabled for arm. This
	 * doorbell can only be sent from the privileged (first)
	 * doorbell page of a function.
	 */
	#define DBR_DBR_TYPE_SRQ_ARMENA			(UINT32_C(0x8) << 28)
	/*
	 * This doorbell command indicates that the cutoff CQE has been
	 * processed and the driver is now processing completions from
	 * the new CQ. The index field for this doorbell type must be
	 * zero.
	 */
	#define DBR_DBR_TYPE_CQ_CUTOFF_ACK			(UINT32_C(0x9) << 28)
	/*
	 * This doorbell command is used during doorbell moderation to
	 * consume system BW and help prevent doorbell FIFO overflow.
	 * All other fields should be zero for NULL doorbell.
	 */
	#define DBR_DBR_TYPE_NULL				(UINT32_C(0xf) << 28)
} __attribute__((packed));

/* 32b Doorbell Format (4 bytes) */

struct dbr_dbr32 {
	uint32_t type_abs_incr_xid;
	/* This value identifies the type of doorbell being written. */
	/*
	 * This value identifies the resource that the doorbell is intended to
	 * notify. For SQ and RQ, this is the QPID. For SRQ, this is the SID.
	 * For CQ, this is the CID. Bits [19:16] of this values must be zero for
	 * a SID value.
	 */
	#define DBR_DBR32_XID_MASK				UINT32_C(0xfffff)
	#define DBR_DBR32_XID_SFT				0
	#define DBR_DBR32_RESERVED4_MASK			UINT32_C(0xf00000)
	#define DBR_DBR32_RESERVED4_SFT				20
	/*
	 * When abs=0, this value is the value to add to the appropriate index
	 * value. When abs=1, this value is the new value for the index.
	 * Absolute value is used when the queue is being wrapped. When abs=1,
	 * the incr value follows the same rules as the index value in the 64b
	 * doorbell.
	 */
	#define DBR_DBR32_INCR_MASK				UINT32_C(0xf000000)
	#define DBR_DBR32_INCR_SFT				24
	/* This value defines how the incr value will be interpreted. */
	#define DBR_DBR32_ABS					UINT32_C(0x10000000)
	/* This value identifies the type of doorbell being written. */
	#define DBR_DBR32_TYPE_MASK				UINT32_C(0xe0000000)
	#define DBR_DBR32_TYPE_SFT				29
	/*
	 * This is a SQ producer index update. It indicates one or more
	 * new entries have been written to the SQ for the QPID
	 * indicated on the xID field.
	 */
	#define DBR_DBR32_TYPE_SQ				(UINT32_C(0x0) << 29)
} __attribute__((packed));

/* SQ WQE Structures */
/*
 * Description: This is the Bind WQE structure. This WQE can perform either: *
 * type1 "bind memory window", if mw_type==Type1 * type2 "post send bind memory
 * window", if mw_type==Type2
 */
/* Base SQ WQE (8 bytes) */

struct sq_base {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/* Send */
	#define SQ_BASE_WQE_TYPE_SEND				UINT32_C(0x0)
	/*
	 * Send with Immediate Allowed only on reliable connection (RC)
	 * and unreliable datagram (UD) SQ's.
	 */
	#define SQ_BASE_WQE_TYPE_SEND_W_IMMEAD			UINT32_C(0x1)
	/*
	 * Send with Invalidate. Allowed only on reliable connection
	 * (RC) SQ's.
	 */
	#define SQ_BASE_WQE_TYPE_SEND_W_INVALID		UINT32_C(0x2)
	/* RDMA Write. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_BASE_WQE_TYPE_WRITE_WQE			UINT32_C(0x4)
	/*
	 * RDMA Write with Immediate. Allowed only on reliable
	 * connection (RC) SQ's.
	 */
	#define SQ_BASE_WQE_TYPE_WRITE_W_IMMEAD		UINT32_C(0x5)
	/* RDMA Read. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_BASE_WQE_TYPE_READ_WQE			UINT32_C(0x6)
	/*
	 * Atomic Compare/Swap. Allowed only on reliable connection (RC)
	 * SQ's.
	 */
	#define SQ_BASE_WQE_TYPE_ATOMIC_CS			UINT32_C(0x8)
	/* Atomic Fetch/Add. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_BASE_WQE_TYPE_ATOMIC_FA			UINT32_C(0xb)
	/* Local Invalidate. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_BASE_WQE_TYPE_LOCAL_INVALID			UINT32_C(0xc)
	/*
	 * FR-PMR (Fast Register Physical Memory Region) Allowed only on
	 * reliable connection (RC) SQ's.
	 */
	#define SQ_BASE_WQE_TYPE_FR_PMR			UINT32_C(0xd)
	/* Memory Bind Allowed only on reliable connection (RC) SQ's. */
	#define SQ_BASE_WQE_TYPE_BIND				UINT32_C(0xe)
	uint8_t unused_0[7];
} __attribute__((packed));

/* WQE SGE (16 bytes) */

struct sq_sge {
	uint64_t va_or_pa;
	/*
	 * The virtual address in local memory or a physical address when l_key
	 * value is a reserved value of a physical address. Driver configures
	 * this value in the chip and the chip compares l_key in SGEs with that
	 * reserved value, if equal it access the physical address specified.
	 * The chip however MUST verify that the QP allows the use reserved key.
	 */
	uint32_t l_key;
	/*
	 * Local Key associated with this registered MR; The 24 msb of the key
	 * used to index the MRW Table and the 8 lsb are compared with the 8
	 * bits key part stored in the MRWC. The PBL in the MRW Context is used
	 * to translate the above VA to physical address.
	 */
	uint32_t size;
	/*
	 * Size of SGE in bytes; Based on page size of the system the chip knows
	 * how many entries are in the PBL
	 */
} __attribute__((packed));

/* PSN Search Structure (8 bytes) */

struct sq_psn_search {
	uint32_t opcode_start_psn;
	/* The opcodes are software defined. */
	/* Start PSN. */
	#define SQ_PSN_SEARCH_START_PSN_MASK			UINT32_C(0xffffff)
	#define SQ_PSN_SEARCH_START_PSN_SFT			0
	/* The opcodes are software defined. */
	#define SQ_PSN_SEARCH_OPCODE_MASK			UINT32_C(0xff000000)
	#define SQ_PSN_SEARCH_OPCODE_SFT			24
	uint32_t flags_next_psn;
	/* Opcode specific flags. */
	/* Next PSN. Equal to the start PSN of the next WQE. */
	#define SQ_PSN_SEARCH_NEXT_PSN_MASK			UINT32_C(0xffffff)
	#define SQ_PSN_SEARCH_NEXT_PSN_SFT			0
	/* Opcode specific flags. */
	#define SQ_PSN_SEARCH_FLAGS_MASK			UINT32_C(0xff000000)
	#define SQ_PSN_SEARCH_FLAGS_SFT				24
} __attribute__((packed));

/* Send SQ WQE (40 bytes) */

struct sq_send {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/* Send */
	#define SQ_SEND_WQE_TYPE_SEND				UINT32_C(0x0)
	/*
	 * Send with Immediate Allowed only on reliable connection (RC)
	 * and unreliable datagram (UD) SQ's.
	 */
	#define SQ_SEND_WQE_TYPE_SEND_W_IMMEAD			UINT32_C(0x1)
	/*
	 * Send with Invalidate. Allowed only on reliable connection
	 * (RC) SQ's.
	 */
	#define SQ_SEND_WQE_TYPE_SEND_W_INVALID		UINT32_C(0x2)
	uint8_t flags;
	/*
	 * Set if completion signaling is requested. If this bit is 0, and the
	 * SQ is configured to support Unsignaled completion the controller
	 * should not generate a CQE unless there was an error. This refers to
	 * the CQE on the sender side. (The se flag refers to the receiver
	 * side).
	 */
	#define SQ_SEND_FLAGS_SIGNAL_COMP			UINT32_C(0x1)
	/*
	 * Indication to complete all previous RDMA Read or Atomic WQEs on the
	 * SQ before executing this WQE. This flag must be zero for a UD send.
	 */
	#define SQ_SEND_FLAGS_RD_OR_ATOMIC_FENCE		UINT32_C(0x2)
	/*
	 * For local invalidate request. Indicate to complete all previous SQ's
	 * WQEs before executing this WQE. This flag must be zero for a UD send.
	 */
	#define SQ_SEND_FLAGS_UC_FENCE				UINT32_C(0x4)
	/*
	 * Solicit event flag. Indication sent in BTH header to the receiver to
	 * generate a Completion Event Notification, i.e. CNQE. This bit should
	 * be set only in the last (or only) packet of the message.
	 */
	#define SQ_SEND_FLAGS_SE				UINT32_C(0x8)
	/*
	 * Indicate that inline data is posted to the SQ in the data area of
	 * this WQE.
	 */
	#define SQ_SEND_FLAGS_INLINE				UINT32_C(0x10)
	uint8_t wqe_size;
	/*
	 * The number of 16 bytes chunks of data including this first word of
	 * the request that are a valid part of the request. The valid 16 bytes
	 * units other than the WQE structure can be SGEs (Scatter Gather
	 * Elements) OR inline data. While this field defines the valid WQE
	 * size. The actual total WQE size is always 128B.
	 */
	uint8_t reserved8_1;
	uint32_t inv_key_or_imm_data;
	/*
	 * Either invalidate key (R_Key of the remote host) that will be send
	 * with IETH (Invalidate ETH) if wqe_type is of Send with Invalidate, or
	 * immediate value that will be sent with ImmDt header if wqe_type is
	 * Send with Immediate.
	 */
	uint32_t length;
	/* This field represents a 32-bit total data length, in bytes. */
	uint32_t q_key;
	/*
	 * When in the SQ of a UD QP, indicates the q_key to be used in the
	 * transmitted packet. However, if the most significant bit of this
	 * field is set, then the q_key will be taken from QP context, rather
	 * than from this field. When in the SQ of a non-UD QP, this field is
	 * reserved and should be filled with zeros.
	 */
	uint32_t dst_qp;
	/*
	 * When in the SQ of a UD QP, indicates the destination QP to be used in
	 * the transmitted packet. When in the SQ of a non-UD QP, this field is
	 * reserved and should be filled with zeros.
	 */
	#define SQ_SEND_DST_QP_MASK				UINT32_C(0xffffff)
	#define SQ_SEND_DST_QP_SFT				0
	#define SQ_SEND_RESERVED8_2_MASK			UINT32_C(0xff000000)
	#define SQ_SEND_RESERVED8_2_SFT				24
	uint32_t avid;
	/* This field is reserved for future expansion of the AVID. */
	/*
	 * If the serv_type is 'UD', then this field supplies the AVID (Address
	 * Vector ID).
	 */
	#define SQ_SEND_AVID_MASK				UINT32_C(0xfffff)
	#define SQ_SEND_AVID_SFT				0
	/* This field is reserved for future expansion of the AVID. */
	#define SQ_SEND_RESERVED_AVID_MASK			UINT32_C(0xfff00000)
	#define SQ_SEND_RESERVED_AVID_SFT			20
	uint64_t reserved64;
	uint32_t data[24];
	/*
	 * When inline=0, then this area is filled with from 1 to 6 SGEs based
	 * on the wqe_size field. When inline=1, this area is filled with
	 * payload data for the send based on the length_or_AVID field. Bits
	 * [7:0] of word 0 hold the first byte to go out on the wire.
	 */
} __attribute__((packed));

/* Send Raw Ethernet and QP1 SQ WQE (40 bytes) */

struct sq_send_raweth_qp1 {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/* Send */
	#define SQ_SEND_RAWETH_QP1_WQE_TYPE_SEND		UINT32_C(0x0)
	uint8_t flags;
	/*
	 * Set if completion signaling is requested. If this bit is 0, and the
	 * SQ is configured to support Unsignaled completion the controller
	 * should not generate a CQE unless there was an error. This refers to
	 * the CQE on the sender side. (The se flag refers to the receiver
	 * side).
	 */
	#define SQ_SEND_RAWETH_QP1_FLAGS_SIGNAL_COMP		UINT32_C(0x1)
	/* This flag must be zero for a Raweth or QP1 send. */
	#define SQ_SEND_RAWETH_QP1_FLAGS_RD_OR_ATOMIC_FENCE	UINT32_C(0x2)
	/* This flag must be zero for a Raweth or QP1 send. */
	#define SQ_SEND_RAWETH_QP1_FLAGS_UC_FENCE		UINT32_C(0x4)
	/* This flag must be zero for a Raweth or QP1 send. */
	#define SQ_SEND_RAWETH_QP1_FLAGS_SE			UINT32_C(0x8)
	/*
	 * Indicate that inline data is posted to the SQ in the data area of
	 * this WQE.
	 */
	#define SQ_SEND_RAWETH_QP1_FLAGS_INLINE			UINT32_C(0x10)
	uint8_t wqe_size;
	/*
	 * The number of 16 bytes chunks of data including this first word of
	 * the request that are a valid part of the request. The valid 16 bytes
	 * units other than the WQE structure can be SGEs (Scatter Gather
	 * Elements) OR inline data. While this field defines the valid WQE
	 * size. The actual total WQE size is always 128B.
	 */
	uint8_t reserved8;
	uint16_t lflags;
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Their value on other BDs of the packet will be ignored.
	 */
	/*
	 * If set to 1, the controller replaces the TCP/UPD checksum fields of
	 * normal TCP/UPD checksum, or the inner TCP/UDP checksum field of the
	 * encapsulated TCP/UDP packets with the hardware calculated TCP/UDP
	 * checksum for the packet associated with this descriptor. This bit
	 * must be valid on the first BD of a packet.
	 */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_TCP_UDP_CHKSUM	UINT32_C(0x1)
	/*
	 * If set to 1, the controller replaces the IP checksum of the normal
	 * packets, or the inner IP checksum of the encapsulated packets with
	 * the hardware calculated IP checksum for the packet associated with
	 * this descriptor. This bit must be valid on the first BD of a packet.
	 */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_IP_CHKSUM		UINT32_C(0x2)
	/*
	 * If set to 1, the controller will not append an Ethernet CRC to the
	 * end of the frame. This bit must be valid on the first BD of a packet.
	 * Packet must be 64B or longer when this flag is set. It is not useful
	 * to use this bit with any form of TX offload such as CSO or LSO. The
	 * intent is that the packet from the host already has a valid Ethernet
	 * CRC on the packet.
	 */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_NOCRC			UINT32_C(0x4)
	/*
	 * If set to 1, the device will record the time at which the packet was
	 * actually transmitted at the TX MAC. This bit must be valid on the
	 * first BD of a packet.
	 */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_STAMP			UINT32_C(0x8)
	/*
	 * If set to 1, The controller replaces the tunnel IP checksum field
	 * with hardware calculated IP checksum for the IP header of the packet
	 * associated with this descriptor. In case of VXLAN, the controller
	 * also replaces the outer header UDP checksum with hardware calculated
	 * UDP checksum for the packet associated with this descriptor.
	 */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_T_IP_CHKSUM		UINT32_C(0x10)
	/* This bit is reserved and should be zero. */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_RESERVED1_1		UINT32_C(0x20)
	/* This bit is reserved and should be zero. */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_RESERVED1_2		UINT32_C(0x40)
	/* This bit is reserved and should be zero. */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_RESERVED1_3		UINT32_C(0x80)
	/*
	 * If set to '1', then the RoCE ICRC will be appended to the packet.
	 * Packet must be a valid RoCE format packet.
	 */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_ROCE_CRC		UINT32_C(0x100)
	/*
	 * If set to '1', then the FCoE CRC will be appended to the packet.
	 * Packet must be a valid FCoE format packet.
	 */
	#define SQ_SEND_RAWETH_QP1_LFLAGS_FCOE_CRC		UINT32_C(0x200)
	uint16_t cfa_action;
	/*
	 * This value selects a CFA action to perform on the packet. Set this
	 * value to zero if no CFA action is desired. This value must be valid
	 * on the first BD of a packet.
	 */
	uint32_t length;
	/*
	 * This field represents a 32-bit total data length, in bytes. Note,
	 * however, that the length cannot exceed the MTU.
	 */
	uint32_t reserved32_1;
	uint32_t cfa_meta;
	/*
	 * This value is action meta-data that defines CFA edit operations that
	 * are done in addition to any action editing.
	 */
	/* When key=1, This is the VLAN tag VID value. */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_VID_MASK	UINT32_C(0xfff)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_VID_SFT	0
	/* When key=1, This is the VLAN tag DE value. */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_DE		UINT32_C(0x1000)
	/* When key=1, This is the VLAN tag PRI value. */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_PRI_MASK	UINT32_C(0xe000)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_PRI_SFT	13
	/* When key=1, This is the VLAN tag TPID select value. */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_MASK	UINT32_C(0x70000)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_SFT	16
	/* 0x88a8 */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID88A8	(UINT32_C(0x0) << 16)
	/* 0x8100 */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID8100	(UINT32_C(0x1) << 16)
	/* 0x9100 */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID9100	(UINT32_C(0x2) << 16)
	/* 0x9200 */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID9200	(UINT32_C(0x3) << 16)
	/* 0x9300 */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPID9300	(UINT32_C(0x4) << 16)
	/* Value programmed in CFA VLANTPID register. */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPIDCFG	(UINT32_C(0x5) << 16)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_LAST	SQ_SEND_RAWETH_QP1_CFA_META_VLAN_TPID_TPIDCFG
	/* When key=1, This is the VLAN tag TPID select value. */
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_RESERVED_MASK	UINT32_C(0xff80000)
	#define SQ_SEND_RAWETH_QP1_CFA_META_VLAN_RESERVED_SFT	19
	/*
	 * This field identifies the type of edit to be performed on the packet.
	 * This value must be valid on the first BD of a packet.
	 */
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_MASK		UINT32_C(0xf0000000)
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_SFT		28
	/* No editing */
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_NONE		(UINT32_C(0x0) << 28)
	/*
	 * - meta[17:16] - TPID select value (0 = 0x8100). - meta[15:12]
	 * - PRI/DE value. - meta[11:0] - VID value.
	 */
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_VLAN_TAG	(UINT32_C(0x1) << 28)
	#define SQ_SEND_RAWETH_QP1_CFA_META_KEY_LAST	SQ_SEND_RAWETH_QP1_CFA_META_KEY_VLAN_TAG
	uint32_t reserved32_2;
	uint64_t reserved64;
	uint32_t data[24];
	/*
	 * When inline=0, then this area is filled with from 1 to 6 SGEs based
	 * on the wqe_size field. When inline=1, this area is filled with
	 * payload data for the send based on the length_or_AVID field. Bits
	 * [7:0] of word 0 hold the first byte to go out on the wire.
	 */
} __attribute__((packed));

/* RDMA SQ WQE (40 bytes) */

struct sq_rdma {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/* RDMA Write. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_RDMA_WQE_TYPE_WRITE_WQE			UINT32_C(0x4)
	/*
	 * RDMA Write with Immediate. Allowed only on reliable
	 * connection (RC) SQ's.
	 */
	#define SQ_RDMA_WQE_TYPE_WRITE_W_IMMEAD		UINT32_C(0x5)
	/* RDMA Read. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_RDMA_WQE_TYPE_READ_WQE			UINT32_C(0x6)
	uint8_t flags;
	/*
	 * Set if completion signaling is requested. If this bit is 0, and the
	 * SQ is configured to support Unsignaled completion the controller
	 * should not generate a CQE unless there was an error. This refer to
	 * CQE on the sender side (se_flag refer to the receiver side)
	 */
	#define SQ_RDMA_FLAGS_SIGNAL_COMP			UINT32_C(0x1)
	/*
	 * Indication to complete all previous RDMA Read or Atomic WQEs on the
	 * SQ before executing this WQE
	 */
	#define SQ_RDMA_FLAGS_RD_OR_ATOMIC_FENCE		UINT32_C(0x2)
	/*
	 * Unconditional fence. Indicate to complete all previous SQ's WQEs
	 * before executing this WQE.
	 */
	#define SQ_RDMA_FLAGS_UC_FENCE				UINT32_C(0x4)
	/*
	 * Solicit event. Indication sent in BTH header to the receiver to
	 * generate a Completion Event Notification, i.e. CNQE. This bit should
	 * be set only in the last (or only) packet of the message.
	 */
	#define SQ_RDMA_FLAGS_SE				UINT32_C(0x8)
	/*
	 * Indicate that inline data is posted to the SQ following this WQE.
	 * This bit may be 1 only for write operations.
	 */
	#define SQ_RDMA_FLAGS_INLINE				UINT32_C(0x10)
	uint8_t wqe_size;
	/*
	 * The number of 16 bytes chunks of data including this first wqe of the
	 * request that are a valid part of the request. The valid 16 bytes
	 * units other than the WQE structure can be SGEs (Scatter Gather
	 * Elements) OR inline data. While this field defines the valid WQE
	 * size. The actual total WQE size is always 128B.
	 */
	uint8_t reserved8;
	uint32_t imm_data;
	/*
	 * Immediate data - valid for RDMA Write with immediate and causes the
	 * controller to add immDt header with this value
	 */
	uint32_t length;
	/* Total data length in bytes */
	uint32_t reserved32_1;
	uint64_t remote_va;
	/* Remote VA sent to the destination QP */
	uint32_t remote_key;
	/*
	 * R_Key provided by remote node when the connection was established and
	 * placed in the RETH header. It identify the MRW on the remote host
	 */
	uint32_t reserved32_2;
	uint32_t data[24];
	/*
	 * When inline=0, then this area is filled with from 1 to 6 SGEs based
	 * on the wqe_size field. When inline=1, this area is filled with
	 * payload data for the write based on the length field. Bits [7:0] of
	 * word 0 hold the first byte to go out on the wire.
	 */
} __attribute__((packed));

/* Atomic SQ WQE (40 bytes) */

struct sq_atomic {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/*
	 * Atomic Compare/Swap. Allowed only on reliable connection (RC)
	 * SQ's.
	 */
	#define SQ_ATOMIC_WQE_TYPE_ATOMIC_CS			UINT32_C(0x8)
	/* Atomic Fetch/Add. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_ATOMIC_WQE_TYPE_ATOMIC_FA			UINT32_C(0xb)
	uint8_t flags;
	/*
	 * Set if completion signaling is requested. If this bit is 0, and the
	 * SQ is configured to support Unsignaled completion the controller
	 * should not generate a CQE unless there was an error. This refer to
	 * CQE on the sender side (se_flag refer to the receiver side)
	 */
	#define SQ_ATOMIC_FLAGS_SIGNAL_COMP			UINT32_C(0x1)
	/*
	 * Indication to complete all previous RDMA Read or Atomic WQEs on the
	 * SQ before executing this WQE
	 */
	#define SQ_ATOMIC_FLAGS_RD_OR_ATOMIC_FENCE		UINT32_C(0x2)
	/*
	 * Unconditional fence. Indicate to complete all previous SQ's WQEs
	 * before executing this WQE.
	 */
	#define SQ_ATOMIC_FLAGS_UC_FENCE			UINT32_C(0x4)
	/*
	 * Solicit event. Indication sent in BTH header to the receiver to
	 * generate a Completion Event Notification, i.e. CNQE. This bit should
	 * be set only in the last (or only) packet of the message.
	 */
	#define SQ_ATOMIC_FLAGS_SE				UINT32_C(0x8)
	/* NA for this WQE. */
	#define SQ_ATOMIC_FLAGS_INLINE				UINT32_C(0x10)
	uint16_t reserved16;
	uint32_t remote_key;
	/*
	 * R_Key provided by remote node when the connection was established and
	 * placed in the AETH header. It identify the MRW on the remote host
	 */
	uint64_t remote_va;
	/* Remote VA sent to the destination QP */
	uint64_t swap_data;
	/* Data value to be placed in remote host specified address */
	uint64_t cmp_data;
	/*
	 * Data value to be compared with the value in the remote host specified
	 * address
	 */
	uint32_t data[24];
	/*
	 * The first 16B of the data field must be filled with a single SGE.
	 * This will be used to store the return value from the Atomic Ack
	 * response. The size of the single SGE must be 8B.
	 */
} __attribute__((packed));

/* Local Invalidate SQ WQE (40 bytes) */

struct sq_localinvalidate {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/* Local Invalidate. Allowed only on reliable connection (RC) SQ's. */
	#define SQ_LOCALINVALIDATE_WQE_TYPE_LOCAL_INVALID	UINT32_C(0xc)
	uint8_t flags;
	/*
	 * Set if completion signaling is requested. If this bit is 0, and the
	 * SQ is configured to support Unsignaled completion the controller
	 * should not generate a CQE unless there was an error. This refer to
	 * CQE on the sender side (se_flag refer to the receiver side)
	 */
	#define SQ_LOCALINVALIDATE_FLAGS_SIGNAL_COMP		UINT32_C(0x1)
	/*
	 * Indication to complete all previous RDMA Read or Atomic WQEs on the
	 * SQ before executing this WQE
	 */
	#define SQ_LOCALINVALIDATE_FLAGS_RD_OR_ATOMIC_FENCE	UINT32_C(0x2)
	/*
	 * Unconditional fence. Indicate to complete all previous SQ's WQEs
	 * before executing this WQE.
	 */
	#define SQ_LOCALINVALIDATE_FLAGS_UC_FENCE		UINT32_C(0x4)
	/*
	 * Solicit event. Indication sent in BTH header to the receiver to
	 * generate a Completion Event Notification, i.e. CNQE. This bit should
	 * be set only in the last (or only) packet of the message.
	 */
	#define SQ_LOCALINVALIDATE_FLAGS_SE			UINT32_C(0x8)
	/* NA for this WQE */
	#define SQ_LOCALINVALIDATE_FLAGS_INLINE			UINT32_C(0x10)
	uint16_t reserved16;
	uint32_t inv_l_key;
	/*
	 * The local key for the MR/W to invalidate; 24 msb of the key are used
	 * to index the MRW table, 8 lsb are compared with the 8 bit key in the
	 * MRWC
	 */
	uint64_t reserved64;
	uint32_t reserved128[4];
	uint32_t data[24];
	/* The data field for local invalidate is not used. */
} __attribute__((packed));

/* FR-PMR SQ WQE (40 bytes) */

struct sq_fr_pmr {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/*
	 * FR-PMR (Fast Register Physical Memory Region) Allowed only on
	 * reliable connection (RC) SQ's.
	 */
	#define SQ_FR_PMR_WQE_TYPE_FR_PMR			UINT32_C(0xd)
	uint8_t flags;
	/*
	 * Set if completion signaling is requested. If this bit is 0, and the
	 * SQ is configured to support Unsignaled completion the controller
	 * should not generate a CQE unless there was an error. This refer to
	 * CQE on the sender side (se_flag refer to the receiver side)
	 */
	#define SQ_FR_PMR_FLAGS_SIGNAL_COMP			UINT32_C(0x1)
	/*
	 * Indication to complete all previous RDMA Read or Atomic WQEs on the
	 * SQ before executing this WQE
	 */
	#define SQ_FR_PMR_FLAGS_RD_OR_ATOMIC_FENCE		UINT32_C(0x2)
	/*
	 * Unconditional fence. Indicate to complete all previous SQ's WQEs
	 * before executing this WQE.
	 */
	#define SQ_FR_PMR_FLAGS_UC_FENCE			UINT32_C(0x4)
	/* Not Applicable for FR_PMR. Nothing is sent */
	#define SQ_FR_PMR_FLAGS_SE				UINT32_C(0x8)
	/* NA. */
	#define SQ_FR_PMR_FLAGS_INLINE				UINT32_C(0x10)
	uint8_t access_cntl;
	/*
	 * This is the new access control for the MR. '1' means the operation is
	 * allowed. '0' means operation is not allowed.
	 */
	/* Local Write Access */
	#define SQ_FR_PMR_ACCESS_CNTL_LOCAL_WRITE		UINT32_C(0x1)
	/* Remote Read Access */
	#define SQ_FR_PMR_ACCESS_CNTL_REMOTE_READ		UINT32_C(0x2)
	/* Remote Write Access */
	#define SQ_FR_PMR_ACCESS_CNTL_REMOTE_WRITE		UINT32_C(0x4)
	/* Remote Atomic Access */
	#define SQ_FR_PMR_ACCESS_CNTL_REMOTE_ATOMIC		UINT32_C(0x8)
	/* Window Binding Allowed */
	#define SQ_FR_PMR_ACCESS_CNTL_WINDOW_BIND		UINT32_C(0x10)
	uint8_t zero_based_page_size_log;
	/* 0 for 4KB page size, ... to 8GB */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_MASK			UINT32_C(0x1f)
	#define SQ_FR_PMR_PAGE_SIZE_LOG_SFT			0
	/* Page size is 4KB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_4K		UINT32_C(0x0)
	/* Page size is 8KB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_8K		UINT32_C(0x1)
	/* Page size is 64KB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_64K		UINT32_C(0x4)
	/* Page size is 256KB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_256K		UINT32_C(0x6)
	/* Page size is 1MB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_1M		UINT32_C(0x8)
	/* Page size is 2MB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_2M		UINT32_C(0x9)
	/* Page size is 4MB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_4M		UINT32_C(0xa)
	/* Page size is 1GB. */
	#define SQ_FR_PMR_PAGE_SIZE_LOG_PGSZ_1G		UINT32_C(0x12)
	/* Indicate the MR is ZBVA (Zero Base VA) */
	#define SQ_FR_PMR_ZERO_BASED				UINT32_C(0x20)
	#define SQ_FR_PMR_RESERVED2_MASK			UINT32_C(0xc0)
	#define SQ_FR_PMR_RESERVED2_SFT				6
	uint32_t l_key;
	/*
	 * Local Key; 24 msb of the key are used to index the MRW table, 8 lsb
	 * are assigned to the 8 bit key_lsb field in the MRWC.
	 */
	uint8_t length[5];
	/* Length in bytes of registered MR */
	uint8_t reserved8_1;
	uint8_t reserved8_2;
	uint8_t numlevels_pbl_page_size_log;
	/* Number of levels of PBL for translation */
	/* PBL page size. 0 for 4KB page size. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_MASK		UINT32_C(0x1f)
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_SFT			0
	/* Page size is 4KB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_4K		UINT32_C(0x0)
	/* Page size is 8KB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_8K		UINT32_C(0x1)
	/* Page size is 64KB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_64K		UINT32_C(0x4)
	/* Page size is 256KB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_256K		UINT32_C(0x6)
	/* Page size is 1MB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_1M		UINT32_C(0x8)
	/* Page size is 2MB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_2M		UINT32_C(0x9)
	/* Page size is 4MB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_4M		UINT32_C(0xa)
	/* Page size is 1GB. */
	#define SQ_FR_PMR_PBL_PAGE_SIZE_LOG_PGSZ_1G		UINT32_C(0x12)
	#define SQ_FR_PMR_RESERVED1				UINT32_C(0x20)
	/* Number of levels of PBL for translation */
	#define SQ_FR_PMR_NUMLEVELS_MASK			UINT32_C(0xc0)
	#define SQ_FR_PMR_NUMLEVELS_SFT				6
	/*
	 * A zero level PBL means that the VA is the physical address
	 * used for the operation. No translation is done by the PTU.
	 */
	#define SQ_FR_PMR_NUMLEVELS_PHYSICAL			(UINT32_C(0x0) << 6)
	/*
	 * A one layer translation is provided between the logical and
	 * physical address. The PBL points to a physical page that
	 * contains PBE values that point to actual pg_size physical
	 * pages.
	 */
	#define SQ_FR_PMR_NUMLEVELS_LAYER1			(UINT32_C(0x1) << 6)
	/*
	 * A two layer translation is provided between the logical and
	 * physical address. The PBL points to a physical page that
	 * contains PDE values that in turn point to pbl_pg_size
	 * physical pages that contain PBE values that point to actual
	 * physical pages.
	 */
	#define SQ_FR_PMR_NUMLEVELS_LAYER2			(UINT32_C(0x2) << 6)
	uint64_t pblptr;
	/* Pointer to the PBL, or PDL depending on number of levels */
	uint64_t va;
	/* Local Virtual Address */
	uint32_t data[24];
	/* The data field for FR-PRM is not used. */
} __attribute__((packed));

/* Bind SQ WQE (40 bytes) */

struct sq_bind {
	uint8_t wqe_type;
	/* This field defines the type of SQ WQE. */
	/* Memory Bind Allowed only on reliable connection (RC) SQ's. */
	#define SQ_BIND_WQE_TYPE_BIND				UINT32_C(0xe)
	uint8_t flags;
	/*
	 * Set if completion signaling is requested. If this bit is 0, and the
	 * SQ is configured to support Unsignaled completion the controller
	 * should not generate a CQE unless there was an error. This refer to
	 * CQE on the sender side (se_flag refer to the receiver side)
	 */
	#define SQ_BIND_FLAGS_SIGNAL_COMP			UINT32_C(0x1)
	/*
	 * Indication to complete all previous RDMA Read or Atomic WQEs on the
	 * SQ before executing this WQE
	 */
	#define SQ_BIND_FLAGS_RD_OR_ATOMIC_FENCE		UINT32_C(0x2)
	/*
	 * Unconditional fence. Indicate to complete all previous SQ's WQEs
	 * before executing this WQE.
	 */
	#define SQ_BIND_FLAGS_UC_FENCE				UINT32_C(0x4)
	/* NA, nothing is sent. */
	#define SQ_BIND_FLAGS_SE				UINT32_C(0x8)
	/* NA */
	#define SQ_BIND_FLAGS_INLINE				UINT32_C(0x10)
	uint8_t access_cntl;
	/*
	 * This is the new access control for the MR. '1' means the operation is
	 * allowed. '0' means operation is not allowed.
	 */
	/*
	 * Local Write Access. Local accesses are never allowed for memory
	 * windows, so this bit must always be zero in a bind WQE. If this bit
	 * is ever set, the bind will fail with an errored completion.
	 */
	#define SQ_BIND_ACCESS_CNTL_LOCAL_WRITE			UINT32_C(0x1)
	/* Remote Read Access */
	#define SQ_BIND_ACCESS_CNTL_REMOTE_READ			UINT32_C(0x2)
	/*
	 * Remote Write Access. Note that, if this bit is set, then the parent
	 * region to which the window is being bound must allow local writes. If
	 * this is not the case, then the bind will fail with an errored
	 * completion.
	 */
	#define SQ_BIND_ACCESS_CNTL_REMOTE_WRITE		UINT32_C(0x4)
	/*
	 * Remote Atomic Access. Note that, if this bit is set, then the parent
	 * region to which the window is being bound must allow local writes. If
	 * this is not the case, then the bind will fail with an errored
	 * completion.
	 */
	#define SQ_BIND_ACCESS_CNTL_REMOTE_ATOMIC		UINT32_C(0x8)
	/*
	 * Window Binding Allowed. It is never allowed to bind windows to
	 * windows, so this bit must always be zero in a bind WQE. If this bit
	 * is ever set, the bind will fail with an errored completion.
	 */
	#define SQ_BIND_ACCESS_CNTL_WINDOW_BIND			UINT32_C(0x10)
	uint8_t reserved8_1;
	/* reserved8_1 is 8 b */
	uint8_t mw_type_zero_based;
	/*
	 * If this bit is set, then the newly-bound memory window will be zero-
	 * based. If clear, then the newly-bound memory window will be non-zero-
	 * based.
	 */
	#define SQ_BIND_ZERO_BASED				UINT32_C(0x1)
	/*
	 * If type1 is specified, then this WQE performs a "bind memory window"
	 * operation on a type1 window. If type2 is specified, then this WQE
	 * performs a "post send bind memory window" operation on a type2
	 * window. Note that the bind WQE cannot change the type of the memory
	 * window. If a "bind memory window" operation is attempted on a memory
	 * window that was allocated as type2, then the bind will fail with an
	 * errored completion, as "bind memory window" is allowed only on type1
	 * memory windows. Similarly, if a "post send bind memory window"
	 * operation is attempted on a memory window that was allocated as
	 * type1, then the bind will fail with an errored completions, as "post
	 * send bind memory window" is allowed only on type2 memory windows.
	 */
	#define SQ_BIND_MW_TYPE					UINT32_C(0x2)
	/* Type 1 Bind Memory Window */
	#define SQ_BIND_MW_TYPE_TYPE1				(UINT32_C(0x0) << 1)
	/* Type 2 Post Send Bind Memory Window */
	#define SQ_BIND_MW_TYPE_TYPE2				(UINT32_C(0x1) << 1)
	#define SQ_BIND_RESERVED6_MASK				UINT32_C(0xfc)
	#define SQ_BIND_RESERVED6_SFT				2
	uint8_t reserved8_2;
	uint16_t reserved16;
	uint32_t parent_l_key;
	/*
	 * The L_Key of the parent MR; 24 msb of the key are used to index the
	 * MRW table, 8 lsb are compared with the 8 bit key in the MRWC.
	 */
	uint32_t l_key;
	/*
	 * Local Key; 24 msb of the key are used to index the memory window
	 * being bound in the MRW table, 8 lsb are assign to the 8 bit key_lsb
	 * field in the MRWC.
	 */
	uint64_t va;
	/* Local Virtual Address */
	uint8_t length[5];
	/*
	 * Length in bytes of registered MW; 40 bits as this is the max size of
	 * an MR/W
	 */
	uint8_t data_reserved24[99];
	/* The data field for Bind is not used. */
	#define SQ_BIND_RESERVED24_MASK				UINT32_C(0xffffff00)
	#define SQ_BIND_RESERVED24_SFT				8
	/* The data field for Bind is not used. */
	#define SQ_BIND_DATA_MASK				UINT32_C(0xffffffff)
	#define SQ_BIND_DATA_SFT				0
} __attribute__((packed));

/* RQ/SRQ WQE Structures */
/* Description: This is the RQ/SRQ WQE structure. */
/* RQ/SRQ WQE (40 bytes) */

struct rq_wqe {
	uint8_t wqe_type;
	/* wqe_type is 8 b */
	/* RQ/SRQ WQE. This WQE is used for posting buffers on an RQ or SRQ. */
	#define RQ_WQE_WQE_TYPE_RCV				UINT32_C(0x80)
	uint8_t flags;
	/* No flags supported for this WQE type. */
	uint8_t wqe_size;
	/*
	 * Specify the total number 16B chunks that make up the valid portion of
	 * the WQE. This includes the first chunk that is the WQE structure and
	 * up to 6 SGE structures. While the valid area is defined by the
	 * wqe_size field, the actual WQE size is fixed at 128B.
	 */
	uint8_t reserved8;
	uint32_t reserved32;
	uint64_t wr_id;
	/*
	 * Opaque value used by upper layer SW to identify the id of the WR
	 * which generated the WQE. Used in CQE. Valid in the first SGE of an
	 * SRQ WQE.
	 */
	#define RQ_WQE_WR_ID_MASK				UINT32_C(0xfffff)
	#define RQ_WQE_WR_ID_SFT				0
	#define RQ_WQE_RESERVED44_MASK				UINT32_C(0xfff00000)
	#define RQ_WQE_RESERVED44_SFT				20
	uint32_t reserved128[4];
	uint32_t data[24];
	/*
	 * The data field for RQ WQE is filled with from 1 to 6 SGE structures
	 * as defined by the wqe_size field.
	 */
} __attribute__((packed));

/* CQ CQE Structures */
/* Description: This is the Cutoff CQE structure. */
/* Base CQE (32 bytes) */

struct cq_base {
	uint64_t reserved64_1;
	uint64_t reserved64_2;
	uint64_t reserved64_3;
	uint8_t cqe_type_toggle;
	/*
	 * Indicate valid completion - written by the chip. Cumulus toggle this
	 * bit each time it finished consuming all PBL entries
	 */
	#define CQ_BASE_TOGGLE					UINT32_C(0x1)
	/* This field defines the type of SQ WQE. */
	#define CQ_BASE_CQE_TYPE_MASK				UINT32_C(0x1e)
	#define CQ_BASE_CQE_TYPE_SFT				1
	/*
	 * Requester completion - This is used for both RC and UD SQ
	 * completions.
	 */
	#define CQ_BASE_CQE_TYPE_REQ				(UINT32_C(0x0) << 1)
	/*
	 * Responder RC Completion - This is used for both RQ and SRQ
	 * completions for RC service QPs.
	 */
	#define CQ_BASE_CQE_TYPE_RES_RC			(UINT32_C(0x1) << 1)
	/*
	 * Responder UD Completion - This is used for both RQ and SRQ
	 * completion for UD service QPs.
	 */
	#define CQ_BASE_CQE_TYPE_RES_UD			(UINT32_C(0x2) << 1)
	/*
	 * Responder RawEth and QP1 Completion - This is used for RQ
	 * completion for RawEth service and QP1 service QPs.
	 */
	#define CQ_BASE_CQE_TYPE_RES_RAWETH_QP1		(UINT32_C(0x3) << 1)
	/*
	 * Terminal completion - This is used to indicate that no
	 * further completions will be made for this QP on this CQ.
	 */
	#define CQ_BASE_CQE_TYPE_TERMINAL			(UINT32_C(0xe) << 1)
	/* Cut off CQE; for CQ resize see CQ and SRQ Resize */
	#define CQ_BASE_CQE_TYPE_CUT_OFF			(UINT32_C(0xf) << 1)
	#define CQ_BASE_RESERVED3_MASK				UINT32_C(0xe0)
	#define CQ_BASE_RESERVED3_SFT				5
	uint8_t status;
	/* This field indicates the status for the CQE. */
	uint16_t reserved16;
	uint32_t reserved32;
} __attribute__((packed));

/* Requester CQ CQE (32 bytes) */

struct cq_req {
	uint64_t qp_handle;
	/*
	 * This is an application level ID used to identify the QP and its SQ
	 * and RQ.
	 */
	uint16_t sq_cons_idx;
	/*
	 * SQ Consumer Index - points to the entry just past the last WQE that
	 * has been completed by the chip. Wraps around at QPC.sq_size (i.e. the
	 * valid range of the SQ Consumer Index is 0 to (QPC.sq_size - 1)).
	 */
	uint16_t reserved16_1;
	uint32_t reserved32_2;
	uint64_t reserved64;
	uint8_t cqe_type_toggle;
	/*
	 * Indicate valid completion - written by the chip. Cumulus toggle this
	 * bit each time it finished consuming all PBL entries
	 */
	#define CQ_REQ_TOGGLE					UINT32_C(0x1)
	/* This field defines the type of SQ WQE. */
	#define CQ_REQ_CQE_TYPE_MASK				UINT32_C(0x1e)
	#define CQ_REQ_CQE_TYPE_SFT				1
	/*
	 * Requester completion - This is used for both RC and UD SQ
	 * completions.
	 */
	#define CQ_REQ_CQE_TYPE_REQ				(UINT32_C(0x0) << 1)
	#define CQ_REQ_RESERVED3_MASK				UINT32_C(0xe0)
	#define CQ_REQ_RESERVED3_SFT				5
	uint8_t status;
	/* This field indicates the status for the CQE. */
	/* OK is 0 */
	#define CQ_REQ_STATUS_OK				UINT32_C(0x0)
	/* BAD_RESPONSE_ERR is 1 */
	#define CQ_REQ_STATUS_BAD_RESPONSE_ERR			UINT32_C(0x1)
	/* LOCAL_LENGTH_ERR is 2 */
	#define CQ_REQ_STATUS_LOCAL_LENGTH_ERR			UINT32_C(0x2)
	/* LOCAL_QP_OPERATION_ERR is 3 */
	#define CQ_REQ_STATUS_LOCAL_QP_OPERATION_ERR		UINT32_C(0x3)
	/* LOCAL_PROTECTION_ERR is 4 */
	#define CQ_REQ_STATUS_LOCAL_PROTECTION_ERR		UINT32_C(0x4)
	/* MEMORY_MGT_OPERATION_ERR is 5 */
	#define CQ_REQ_STATUS_MEMORY_MGT_OPERATION_ERR		UINT32_C(0x5)
	/* REMOTE_INVALID_REQUEST_ERR is 6 */
	#define CQ_REQ_STATUS_REMOTE_INVALID_REQUEST_ERR	UINT32_C(0x6)
	/* REMOTE_ACCESS_ERR is 7 */
	#define CQ_REQ_STATUS_REMOTE_ACCESS_ERR		UINT32_C(0x7)
	/* REMOTE_OPERATION_ERR is 8 */
	#define CQ_REQ_STATUS_REMOTE_OPERATION_ERR		UINT32_C(0x8)
	/* RNR_NAK_RETRY_CNT_ERR is 9 */
	#define CQ_REQ_STATUS_RNR_NAK_RETRY_CNT_ERR		UINT32_C(0x9)
	/* TRANSPORT_RETRY_CNT_ERR is 10 */
	#define CQ_REQ_STATUS_TRANSPORT_RETRY_CNT_ERR		UINT32_C(0xa)
	/* WORK_REQUEST_FLUSHED_ERR is 11 */
	#define CQ_REQ_STATUS_WORK_REQUEST_FLUSHED_ERR		UINT32_C(0xb)
	uint16_t reserved16_2;
	uint32_t reserved32_1;
} __attribute__((packed));

/* Responder RC CQE (32 bytes) */

struct cq_res_rc {
	uint32_t length;
	/* The length of the message's payload in bytes, stored in the SGEs */
	uint32_t imm_data_or_inv_r_key;
	/*
	 * Immediate data in case the imm_flag set, R_Key to be invalidated in
	 * case inv_flag is set.
	 */
	uint64_t qp_handle;
	/*
	 * This is an application level ID used to identify the QP and its SQ
	 * and RQ.
	 */
	uint64_t mr_handle;
	/*
	 * Opaque value - valid when inv_flag is set. Used by driver to
	 * reference the buffer used to store PBL when the MR was fast
	 * registered. The driver can reclaim this buffer after an MR was
	 * remotely invalidated. The controller take that value from the MR
	 * referenced by R_Key
	 */
	uint8_t cqe_type_toggle;
	/*
	 * Indicate valid completion - written by the chip. Cumulus toggle this
	 * bit each time it finished consuming all PBL entries
	 */
	#define CQ_RES_RC_TOGGLE				UINT32_C(0x1)
	/* This field defines the type of SQ WQE. */
	#define CQ_RES_RC_CQE_TYPE_MASK				UINT32_C(0x1e)
	#define CQ_RES_RC_CQE_TYPE_SFT				1
	/*
	 * Responder RC Completion - This is used for both RQ and SRQ
	 * completions for RC service QPs.
	 */
	#define CQ_RES_RC_CQE_TYPE_RES_RC			(UINT32_C(0x1) << 1)
	#define CQ_RES_RC_RESERVED3_MASK			UINT32_C(0xe0)
	#define CQ_RES_RC_RESERVED3_SFT				5
	uint8_t status;
	/* This field indicates the status for the CQE. */
	/* OK is 0 */
	#define CQ_RES_RC_STATUS_OK				UINT32_C(0x0)
	/* LOCAL_ACCESS_ERROR is 1 */
	#define CQ_RES_RC_STATUS_LOCAL_ACCESS_ERROR		UINT32_C(0x1)
	/* LOCAL_LENGTH_ERR is 2 */
	#define CQ_RES_RC_STATUS_LOCAL_LENGTH_ERR		UINT32_C(0x2)
	/* LOCAL_PROTECTION_ERR is 3 */
	#define CQ_RES_RC_STATUS_LOCAL_PROTECTION_ERR		UINT32_C(0x3)
	/* LOCAL_QP_OPERATION_ERR is 4 */
	#define CQ_RES_RC_STATUS_LOCAL_QP_OPERATION_ERR	UINT32_C(0x4)
	/* MEMORY_MGT_OPERATION_ERR is 5 */
	#define CQ_RES_RC_STATUS_MEMORY_MGT_OPERATION_ERR	UINT32_C(0x5)
	/* REMOTE_INVALID_REQUEST_ERR is 6 */
	#define CQ_RES_RC_STATUS_REMOTE_INVALID_REQUEST_ERR	UINT32_C(0x6)
	/* WORK_REQUEST_FLUSHED_ERR is 7 */
	#define CQ_RES_RC_STATUS_WORK_REQUEST_FLUSHED_ERR	UINT32_C(0x7)
	/* HW_FLUSH_ERR is 8 */
	#define CQ_RES_RC_STATUS_HW_FLUSH_ERR			UINT32_C(0x8)
	uint16_t flags;
	/*
	 * This flag indicates that the completion is for a SRQ entry rather
	 * than for an RQ entry.
	 */
	#define CQ_RES_RC_FLAGS_SRQ				UINT32_C(0x1)
	/* CQE relates to RQ WQE. */
	#define CQ_RES_RC_FLAGS_SRQ_RQ				(UINT32_C(0x0) << 0)
	/* CQE relates to SRQ WQE. */
	#define CQ_RES_RC_FLAGS_SRQ_SRQ			(UINT32_C(0x1) << 0)
	#define CQ_RES_RC_FLAGS_SRQ_LAST	CQ_RES_RC_FLAGS_SRQ_SRQ
	/* Immediate data indicator */
	#define CQ_RES_RC_FLAGS_IMM				UINT32_C(0x2)
	/* R_Key invalidate indicator */
	#define CQ_RES_RC_FLAGS_INV				UINT32_C(0x4)
	#define CQ_RES_RC_FLAGS_RDMA				UINT32_C(0x8)
	/* CQE relates to an incoming Send request */
	#define CQ_RES_RC_FLAGS_RDMA_SEND			(UINT32_C(0x0) << 3)
	/* CQE relates to incoming RDMA Write request */
	#define CQ_RES_RC_FLAGS_RDMA_RDMA_WRITE		(UINT32_C(0x1) << 3)
	#define CQ_RES_RC_FLAGS_RDMA_LAST	CQ_RES_RC_FLAGS_RDMA_RDMA_WRITE
	uint32_t srq_or_rq_wr_id;
	/*
	 * Opaque value from RQ or SRQ WQE. Used by driver/lib to reference the
	 * WQE in order to claim the received data and reuse the WQE space
	 */
	#define CQ_RES_RC_SRQ_OR_RQ_WR_ID_MASK			UINT32_C(0xfffff)
	#define CQ_RES_RC_SRQ_OR_RQ_WR_ID_SFT			0
	#define CQ_RES_RC_RESERVED12_MASK			UINT32_C(0xfff00000)
	#define CQ_RES_RC_RESERVED12_SFT			20
} __attribute__((packed));

/* Responder UD CQE (32 bytes) */

struct cq_res_ud {
	uint32_t length;
	/* The length of the message's payload in bytes, stored in the SGEs */
	#define CQ_RES_UD_LENGTH_MASK				UINT32_C(0x3fff)
	#define CQ_RES_UD_LENGTH_SFT				0
	#define CQ_RES_UD_RESERVED18_MASK			UINT32_C(0xffffc000)
	#define CQ_RES_UD_RESERVED18_SFT			14
	uint32_t imm_data;
	/* Immediate data in case the imm_flag set. */
	uint64_t qp_handle;
	/*
	 * This is an application level ID used to identify the QP and its SQ
	 * and RQ.
	 */
	uint16_t src_mac[3];
	/*
	 * Source MAC address for the UD message placed in the WQE that is
	 * completed by this CQE.
	 */
	uint16_t src_qp_low;
	/* Lower 16b of the Source QP value from the DETH header. */
	uint8_t cqe_type_toggle;
	/*
	 * Indicate valid completion - written by the chip. Cumulus toggle this
	 * bit each time it finished consuming all PBL entries
	 */
	#define CQ_RES_UD_TOGGLE				UINT32_C(0x1)
	/* This field defines the type of SQ WQE. */
	#define CQ_RES_UD_CQE_TYPE_MASK				UINT32_C(0x1e)
	#define CQ_RES_UD_CQE_TYPE_SFT				1
	/*
	 * Responder UD Completion - This is used for both RQ and SRQ
	 * completion for UD service QPs.
	 */
	#define CQ_RES_UD_CQE_TYPE_RES_UD			(UINT32_C(0x2) << 1)
	#define CQ_RES_UD_RESERVED3_MASK			UINT32_C(0xe0)
	#define CQ_RES_UD_RESERVED3_SFT				5
	uint8_t status;
	/* This field indicates the status for the CQE. */
	/*
	 * This indicates that the completion is without error. All
	 * fields are valid.
	 */
	#define CQ_RES_UD_STATUS_OK				UINT32_C(0x0)
	/*
	 * This indicates that write access was not allowed for at least
	 * one of the SGEs in the WQE. This is a fatal error. Only the
	 * srq_or_rq_wr_id is field is valid.
	 */
	#define CQ_RES_UD_STATUS_LOCAL_ACCESS_ERROR		UINT32_C(0x1)
	/*
	 * This indicates that the packet was too long for the WQE
	 * provided on the SRQ/RQ. This is not a fatal error. All the
	 * fields are valid.
	 */
	#define CQ_RES_UD_STATUS_HW_LOCAL_LENGTH_ERR		UINT32_C(0x2)
	/* LOCAL_PROTECTION_ERR is 3 */
	#define CQ_RES_UD_STATUS_LOCAL_PROTECTION_ERR		UINT32_C(0x3)
	/* LOCAL_QP_OPERATION_ERR is 4 */
	#define CQ_RES_UD_STATUS_LOCAL_QP_OPERATION_ERR	UINT32_C(0x4)
	/* MEMORY_MGT_OPERATION_ERR is 5 */
	#define CQ_RES_UD_STATUS_MEMORY_MGT_OPERATION_ERR	UINT32_C(0x5)
	/* WORK_REQUEST_FLUSHED_ERR is 7 */
	#define CQ_RES_UD_STATUS_WORK_REQUEST_FLUSHED_ERR	UINT32_C(0x7)
	/* HW_FLUSH_ERR is 8 */
	#define CQ_RES_UD_STATUS_HW_FLUSH_ERR			UINT32_C(0x8)
	uint16_t flags;
	/*
	 * This flag indicates that the completion is for a SRQ entry rather
	 * than for an RQ entry.
	 */
	#define CQ_RES_UD_FLAGS_SRQ				UINT32_C(0x1)
	/* CQE relates to RQ WQE. */
	#define CQ_RES_UD_FLAGS_SRQ_RQ				(UINT32_C(0x0) << 0)
	/* CQE relates to SRQ WQE. */
	#define CQ_RES_UD_FLAGS_SRQ_SRQ			(UINT32_C(0x1) << 0)
	#define CQ_RES_UD_FLAGS_SRQ_LAST	CQ_RES_UD_FLAGS_SRQ_SRQ
	/* Immediate data indicator */
	#define CQ_RES_UD_FLAGS_IMM				UINT32_C(0x2)
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_MASK		UINT32_C(0xc)
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_SFT			2
	/* RoCEv1 Message */
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_V1			(UINT32_C(0x0) << 2)
	/* RoCEv2 IPv4 Message */
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_V2IPV4		(UINT32_C(0x2) << 2)
	/* RoCEv2 IPv6 Message */
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_V2IPV6		(UINT32_C(0x3) << 2)
	#define CQ_RES_UD_FLAGS_ROCE_IP_VER_LAST	CQ_RES_UD_FLAGS_ROCE_IP_VER_V2IPV6
	uint32_t src_qp_high_srq_or_rq_wr_id;
	/* Upper 8b of the Source QP value from the DETH header. */
	/*
	 * Opaque value from RQ or SRQ WQE. Used by driver/lib to reference the
	 * WQE in order to claim the received data and reuse the WQE space
	 */
	#define CQ_RES_UD_SRQ_OR_RQ_WR_ID_MASK			UINT32_C(0xfffff)
	#define CQ_RES_UD_SRQ_OR_RQ_WR_ID_SFT			0
	#define CQ_RES_UD_RESERVED4_MASK			UINT32_C(0xf00000)
	#define CQ_RES_UD_RESERVED4_SFT				20
	/* Upper 8b of the Source QP value from the DETH header. */
	#define CQ_RES_UD_SRC_QP_HIGH_MASK			UINT32_C(0xff000000)
	#define CQ_RES_UD_SRC_QP_HIGH_SFT			24
} __attribute__((packed));

/* Responder RawEth and QP1 CQE (32 bytes) */

struct cq_res_raweth_qp1 {
	uint16_t length;
	/* The length of the message's payload in bytes, stored in the SGEs */
	#define CQ_RES_RAWETH_QP1_LENGTH_MASK			UINT32_C(0x3fff)
	#define CQ_RES_RAWETH_QP1_LENGTH_SFT			0
	#define CQ_RES_RAWETH_QP1_RESERVED2_MASK		UINT32_C(0xc000)
	#define CQ_RES_RAWETH_QP1_RESERVED2_SFT			14
	uint16_t raweth_qp1_flags;
	/*
	 * When this bit is '1', it indicates a packet that has an error of some
	 * type. Type of error is indicated in raweth_qp1_errors.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ERROR	UINT32_C(0x1)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_RESERVED5_1_MASK UINT32_C(0x3e)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_RESERVED5_1_SFT 1
	/*
	 * This value indicates what the inner packet determined for the packet
	 * was.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_MASK	UINT32_C(0x3c0)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_SFT	6
	/* Not Known: Indicates that the packet type was not known. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_NOT_KNOWN (UINT32_C(0x0) << 6)
	/*
	 * IP Packet: Indicates that the packet was an IP packet, but
	 * further classification was not possible.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_IP	(UINT32_C(0x1) << 6)
	/*
	 * TCP Packet: Indicates that the packet was IP and TCP. This
	 * indicates that the raweth_qp1_payload_offset field is valid.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_TCP	(UINT32_C(0x2) << 6)
	/*
	 * UDP Packet: Indicates that the packet was IP and UDP. This
	 * indicates that the raweth_qp1_payload_offset field is valid.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_UDP	(UINT32_C(0x3) << 6)
	/*
	 * FCoE Packet: Indicates that the packet was recognized as a
	 * FCoE. This also indicates that the raweth_qp1_payload_offset
	 * field is valid.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_FCOE	(UINT32_C(0x4) << 6)
	/*
	 * RoCE Packet: Indicates that the packet was recognized as a
	 * RoCE. This also indicates that the raweth_qp1_payload_offset
	 * field is valid.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_ROCE	(UINT32_C(0x5) << 6)
	/*
	 * ICMP Packet: Indicates that the packet was recognized as
	 * ICMP. This indicates that the raweth_qp1_payload_offset field
	 * is valid.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_ICMP	(UINT32_C(0x7) << 6)
	/*
	 * PtP packet wo/timestamp: Indicates that the packet was
	 * recognized as a PtP packet.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_PTP_WO_TIMESTAMP (UINT32_C(0x8) << 6)
	/*
	 * PtP packet w/timestamp: Indicates that the packet was
	 * recognized as a PtP packet and that a timestamp was taken for
	 * the packet.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_PTP_W_TIMESTAMP (UINT32_C(0x9) << 6)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_LAST	CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_ITYPE_PTP_W_TIMESTAMP
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_MASK		UINT32_C(0x3ff)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS_SFT		0
	#define CQ_RES_RAWETH_QP1_RESERVED6_MASK		UINT32_C(0xfc00)
	#define CQ_RES_RAWETH_QP1_RESERVED6_SFT			10
	uint16_t raweth_qp1_errors;
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_RESERVED4_MASK UINT32_C(0xf)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_RESERVED4_SFT  0
	/* This indicates that there was an error in the IP header checksum. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_IP_CS_ERROR	UINT32_C(0x10)
	/*
	 * This indicates that there was an error in the TCP, UDP or ICMP
	 * checksum.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_L4_CS_ERROR	UINT32_C(0x20)
	/*
	 * This indicates that there was an error in the tunnel IP header
	 * checksum.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_IP_CS_ERROR  UINT32_C(0x40)
	/* This indicates that there was an error in the tunnel UDP checksum. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_L4_CS_ERROR  UINT32_C(0x80)
	/*
	 * This indicates that there was a CRC error on either an FCoE or RoCE
	 * packet. The itype indicates the packet type.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_CRC_ERROR	UINT32_C(0x100)
	/*
	 * This indicates that there was an error in the tunnel portion of the
	 * packet when this field is non-zero.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_MASK UINT32_C(0xe00)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_SFT 9
	/*
	 * No additional error occurred on the tunnel portion of the
	 * packet of the packet does not have a tunnel.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_NO_ERROR (UINT32_C(0x0) << 9)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 in the tunnel header.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION (UINT32_C(0x1) << 9)
	/*
	 * Indicates that header length is out of range in the tunnel
	 * header. Valid for IPv4.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN (UINT32_C(0x2) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the PPPoE header length for a tunnel PPPoE packet.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_TUNNEL_TOTAL_ERROR (UINT32_C(0x3) << 9)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the tunnel l3 header length. Valid for IPv4, or IPv6
	 * tunnel packet packets.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR (UINT32_C(0x4) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the tunnel UDP header length for a tunnel UDP
	 * packet that is not fragmented.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR (UINT32_C(0x5) << 9)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check have
	 * failed (e.g. TTL = 0) in the tunnel header. Valid for IPv4,
	 * and IPv6.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL (UINT32_C(0x6) << 9)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_LAST	CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL
	/*
	 * This indicates that there was an error in the inner portion of the
	 * packet when this field is non-zero.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_MASK UINT32_C(0xf000)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_SFT  12
	/*
	 * No additional error occurred on the tunnel portion of the
	 * packet of the packet does not have a tunnel.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_NO_ERROR (UINT32_C(0x0) << 12)
	/*
	 * Indicates that IP header version does not match expectation
	 * from L2 Ethertype for IPv4 and IPv6 or that option other than
	 * VFT was parsed on FCoE packet.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L3_BAD_VERSION (UINT32_C(0x1) << 12)
	/*
	 * indicates that header length is out of range. Valid for IPv4
	 * and RoCE
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN (UINT32_C(0x2) << 12)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check have
	 * failed (e.g. TTL = 0). Valid for IPv4, and IPv6
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L3_BAD_TTL (UINT32_C(0x3) << 12)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the l3 header length. Valid for IPv4, IPv6 packet or RoCE
	 * packets.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_IP_TOTAL_ERROR (UINT32_C(0x4) << 12)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the UDP header length for a UDP packet that is not
	 * fragmented.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR (UINT32_C(0x5) << 12)
	/*
	 * Indicates that TCP header length > IP payload. Valid for TCP
	 * packets only.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN (UINT32_C(0x6) << 12)
	/* Indicates that TCP header length < 5. Valid for TCP. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL (UINT32_C(0x7) << 12)
	/*
	 * Indicates that TCP option headers result in a TCP header size
	 * that does not match data offset in TCP header. Valid for TCP.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN (UINT32_C(0x8) << 12)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_LAST	CQ_RES_RAWETH_QP1_RAWETH_QP1_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN
	uint16_t raweth_qp1_cfa_code;
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint64_t qp_handle;
	/*
	 * This is an application level ID used to identify the QP and its SQ
	 * and RQ.
	 */
	uint32_t raweth_qp1_flags2;
	/*
	 * This indicates that the ip checksum was calculated for the inner
	 * packet and that the ip_cs_error field indicates if there was an
	 * error.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_IP_CS_CALC	UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was calculated for
	 * the inner packet and that the l4_cs_error field indicates if there
	 * was an error.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_L4_CS_CALC	UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the tunnel
	 * header and that the t_ip_cs_error field indicates if there was an
	 * error.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_T_IP_CS_CALC   UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was calculated for the tunnel
	 * packet and that the t_l4_cs_error field indicates if there was an
	 * error.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_T_L4_CS_CALC   UINT32_C(0x8)
	/* This value indicates what format the raweth_qp1_metadata field is. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_MASK UINT32_C(0xf0)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_SFT 4
	/* No metadata information. Value is zero. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_NONE (UINT32_C(0x0) << 4)
	/*
	 * The raweth_qp1_metadata field contains the VLAN tag and TPID
	 * value. - raweth_qp1_metadata[11:0] contains the vlan VID
	 * value. - raweth_qp1_metadata[12] contains the vlan DE value.
	 * - raweth_qp1_metadata[15:13] contains the vlan PRI value. -
	 * raweth_qp1_metadata[31:16] contains the vlan TPID value.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_VLAN (UINT32_C(0x1) << 4)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_LAST	CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_META_FORMAT_VLAN
	/*
	 * This field indicates the IP type for the inner-most IP header. A
	 * value of '0' indicates IPv4. A value of '1' indicates IPv6. This
	 * value is only valid if itype indicates a packet with an IP header.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_FLAGS2_IP_TYPE	UINT32_C(0x100)
	uint32_t raweth_qp1_metadata;
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	/* When meta_format=1, this value is the VLAN VID. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_VID_MASK	UINT32_C(0xfff)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_VID_SFT	0
	/* When meta_format=1, this value is the VLAN DE. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_DE	UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_PRI_MASK	UINT32_C(0xe000)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_PRI_SFT	13
	/* When meta_format=1, this value is the VLAN TPID. */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_TPID_MASK	UINT32_C(0xffff0000)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_METADATA_TPID_SFT	16
	uint8_t cqe_type_toggle;
	/*
	 * Indicate valid completion - written by the chip. Cumulus toggle this
	 * bit each time it finished consuming all PBL entries
	 */
	#define CQ_RES_RAWETH_QP1_TOGGLE			UINT32_C(0x1)
	/* This field defines the type of SQ WQE. */
	#define CQ_RES_RAWETH_QP1_CQE_TYPE_MASK			UINT32_C(0x1e)
	#define CQ_RES_RAWETH_QP1_CQE_TYPE_SFT			1
	/*
	 * Responder RawEth and QP1 Completion - This is used for RQ
	 * completion for RawEth service and QP1 service QPs.
	 */
	#define CQ_RES_RAWETH_QP1_CQE_TYPE_RES_RAWETH_QP1	(UINT32_C(0x3) << 1)
	#define CQ_RES_RAWETH_QP1_RESERVED3_MASK		UINT32_C(0xe0)
	#define CQ_RES_RAWETH_QP1_RESERVED3_SFT			5
	uint8_t status;
	/* This field indicates the status for the CQE. */
	/*
	 * This indicates that the completion is without error. All
	 * fields are valid.
	 */
	#define CQ_RES_RAWETH_QP1_STATUS_OK			UINT32_C(0x0)
	/*
	 * This indicates that write access was not allowed for at least
	 * one of the SGEs in the WQE. This is a fatal error. Only the
	 * srq_or_rq_wr_id is field is valid.
	 */
	#define CQ_RES_RAWETH_QP1_STATUS_LOCAL_ACCESS_ERROR	UINT32_C(0x1)
	/*
	 * This indicates that the packet was too long for the WQE
	 * provided on the RQ. This is not a fatal error. All the fields
	 * are valid.
	 */
	#define CQ_RES_RAWETH_QP1_STATUS_HW_LOCAL_LENGTH_ERR	UINT32_C(0x2)
	/* LOCAL_PROTECTION_ERR is 3 */
	#define CQ_RES_RAWETH_QP1_STATUS_LOCAL_PROTECTION_ERR	UINT32_C(0x3)
	/* LOCAL_QP_OPERATION_ERR is 4 */
	#define CQ_RES_RAWETH_QP1_STATUS_LOCAL_QP_OPERATION_ERR   UINT32_C(0x4)
	/* MEMORY_MGT_OPERATION_ERR is 5 */
	#define CQ_RES_RAWETH_QP1_STATUS_MEMORY_MGT_OPERATION_ERR UINT32_C(0x5)
	/* WORK_REQUEST_FLUSHED_ERR is 7 */
	#define CQ_RES_RAWETH_QP1_STATUS_WORK_REQUEST_FLUSHED_ERR UINT32_C(0x7)
	/* HW_FLUSH_ERR is 8 */
	#define CQ_RES_RAWETH_QP1_STATUS_HW_FLUSH_ERR		UINT32_C(0x8)
	uint16_t flags;
	/*
	 * This flag indicates that the completion is for a SRQ entry rather
	 * than for an RQ entry.
	 */
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ			UINT32_C(0x1)
	/* CQE relates to RQ WQE. */
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ_RQ			UINT32_C(0x0)
	/* CQE relates to SRQ WQE. */
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ_SRQ		UINT32_C(0x1)
	#define CQ_RES_RAWETH_QP1_FLAGS_SRQ_LAST	CQ_RES_RAWETH_QP1_FLAGS_SRQ_SRQ
	uint32_t raweth_qp1_payload_offset_srq_or_rq_wr_id;
	/*
	 * This value indicates the offset in bytes from the beginning of the
	 * packet where the inner payload starts. This value is valid for TCP,
	 * UDP, FCoE, and RoCE packets. A value of zero indicates an offset of
	 * 256 bytes.
	 */
	/*
	 * Opaque value from RQ or SRQ WQE. Used by driver/lib to reference the
	 * WQE in order to claim the received data and reuse the WQE space
	 */
	#define CQ_RES_RAWETH_QP1_SRQ_OR_RQ_WR_ID_MASK		UINT32_C(0xfffff)
	#define CQ_RES_RAWETH_QP1_SRQ_OR_RQ_WR_ID_SFT		0
	#define CQ_RES_RAWETH_QP1_RESERVED4_MASK		UINT32_C(0xf00000)
	#define CQ_RES_RAWETH_QP1_RESERVED4_SFT			20
	/*
	 * This value indicates the offset in bytes from the beginning of the
	 * packet where the inner payload starts. This value is valid for TCP,
	 * UDP, FCoE, and RoCE packets. A value of zero indicates an offset of
	 * 256 bytes.
	 */
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_PAYLOAD_OFFSET_MASK   UINT32_C(0xff000000)
	#define CQ_RES_RAWETH_QP1_RAWETH_QP1_PAYLOAD_OFFSET_SFT	24
} __attribute__((packed));

/* Terminal CQE (32 bytes) */

struct cq_terminal {
	uint64_t qp_handle;
	/*
	 * This is an application level ID used to identify the QP and its SQ
	 * and RQ.
	 */
	uint16_t sq_cons_idx;
	/*
	 * Final SQ Consumer Index value. Any additional SQ WQEs will have to be
	 * completed by the user provider.
	 */
	uint16_t rq_cons_idx;
	/*
	 * Final RQ Consumer Index value. Any additional RQ WQEs will have to be
	 * completed by the user provider.
	 */
	uint32_t reserved32_1;
	uint64_t reserved64_3;
	uint8_t cqe_type_toggle;
	/*
	 * Indicate valid completion - written by the chip. Cumulus toggle this
	 * bit each time it finished consuming all PBL entries
	 */
	#define CQ_TERMINAL_TOGGLE				UINT32_C(0x1)
	/* This field defines the type of SQ WQE. */
	#define CQ_TERMINAL_CQE_TYPE_MASK			UINT32_C(0x1e)
	#define CQ_TERMINAL_CQE_TYPE_SFT			1
	/*
	 * Terminal completion - This is used to indicate that no
	 * further completions will be made for this QP on this CQ.
	 */
	#define CQ_TERMINAL_CQE_TYPE_TERMINAL			(UINT32_C(0xe) << 1)
	#define CQ_TERMINAL_RESERVED3_MASK			UINT32_C(0xe0)
	#define CQ_TERMINAL_RESERVED3_SFT			5
	uint8_t status;
	/* This field indicates the status for the CQE. */
	/* OK is 0 */
	#define CQ_TERMINAL_STATUS_OK				UINT32_C(0x0)
	uint16_t reserved16;
	uint32_t reserved32_2;
} __attribute__((packed));

/* Cutoff CQE (32 bytes) */

struct cq_cutoff {
	uint64_t reserved64_1;
	uint64_t reserved64_2;
	uint64_t reserved64_3;
	uint8_t cqe_type_toggle;
	/*
	 * Indicate valid completion - written by the chip. Cumulus toggle this
	 * bit each time it finished consuming all PBL entries
	 */
	#define CQ_CUTOFF_TOGGLE				UINT32_C(0x1)
	/* This field defines the type of SQ WQE. */
	#define CQ_CUTOFF_CQE_TYPE_MASK				UINT32_C(0x1e)
	#define CQ_CUTOFF_CQE_TYPE_SFT				1
	/* Cut off CQE; for CQ resize see CQ and SRQ Resize */
	#define CQ_CUTOFF_CQE_TYPE_CUT_OFF			(UINT32_C(0xf) << 1)
	#define CQ_CUTOFF_RESERVED3_MASK			UINT32_C(0xe0)
	#define CQ_CUTOFF_RESERVED3_SFT				5
	uint8_t status;
	/* This field indicates the status for the CQE. */
	/* OK is 0 */
	#define CQ_CUTOFF_STATUS_OK				UINT32_C(0x0)
	uint16_t reserved16;
	uint32_t reserved32;
} __attribute__((packed));

/* Notification Queue (NQ) Structures */
/*
 * Description: This completion indicates that the DBQ has reached the
 * programmed threshold value.
 */
/* Base NQ Record (16 bytes) */

struct nq_base {
	uint16_t info10_type;
	/* info10 is 10 b */
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define NQ_BASE_TYPE_MASK				UINT32_C(0x3f)
	#define NQ_BASE_TYPE_SFT				0
	/* CQ Notification */
	#define NQ_BASE_TYPE_CQ_NOTIFICATION			UINT32_C(0x30)
	/* SRQ Threshold Event */
	#define NQ_BASE_TYPE_SRQ_EVENT				UINT32_C(0x32)
	/* DBQ Threshold Event */
	#define NQ_BASE_TYPE_DBQ_EVENT				UINT32_C(0x34)
	/* QP Async Notification */
	#define NQ_BASE_TYPE_QP_EVENT				UINT32_C(0x38)
	/* Function Async Notification */
	#define NQ_BASE_TYPE_FUNC_EVENT			UINT32_C(0x3a)
	/* info10 is 10 b */
	#define NQ_BASE_INFO10_MASK				UINT32_C(0xffc0)
	#define NQ_BASE_INFO10_SFT				6
	uint16_t info16;
	/* info16 is 16 b */
	uint32_t info32;
	/* info32 is 32 b */
	uint64_t info63_v;
	/* info63 is 63 b */
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define NQ_BASE_V					UINT32_C(0x1)
	/* info63 is 63 b */
	#define NQ_BASE_INFO63_MASK				UINT32_C(0xfffffffe)
	#define NQ_BASE_INFO63_SFT				1
} __attribute__((packed));

/* Completion Queue Notification (16 bytes) */

struct nq_cn {
	uint16_t type;
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define NQ_CN_TYPE_MASK					UINT32_C(0x3f)
	#define NQ_CN_TYPE_SFT					0
	/* CQ Notification */
	#define NQ_CN_TYPE_CQ_NOTIFICATION			UINT32_C(0x30)
	#define NQ_CN_RESERVED9_MASK				UINT32_C(0xffc0)
	#define NQ_CN_RESERVED9_SFT				6
	uint16_t reserved16;
	uint32_t cq_handle_low;
	/*
	 * This is an application level ID used to identify the CQ. This field
	 * carries the lower 32b of the value.
	 */
	uint32_t v;
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define NQ_CN_V						UINT32_C(0x1)
	#define NQ_CN_RESERVED31_MASK				UINT32_C(0xfffffffe)
	#define NQ_CN_RESERVED31_SFT				1
	uint32_t cq_handle_high;
	/*
	 * This is an application level ID used to identify the CQ. This field
	 * carries the upper 32b of the value.
	 */
} __attribute__((packed));

/* SRQ Event Notification (16 bytes) */

struct nq_srq_event {
	uint8_t type;
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define NQ_SRQ_EVENT_TYPE_MASK				UINT32_C(0x3f)
	#define NQ_SRQ_EVENT_TYPE_SFT				0
	/* SRQ Threshold Event */
	#define NQ_SRQ_EVENT_TYPE_SRQ_EVENT			UINT32_C(0x32)
	#define NQ_SRQ_EVENT_RESERVED1_MASK			UINT32_C(0xc0)
	#define NQ_SRQ_EVENT_RESERVED1_SFT			6
	uint8_t event;
	/* This value define what type of async event has occurred on the SRQ. */
	/* The threshold event has occurred on the specified SRQ. */
	#define NQ_SRQ_EVENT_EVENT_SRQ_THRESHOLD_EVENT		UINT32_C(0x1)
	uint16_t reserved16;
	uint32_t srq_handle_low;
	/*
	 * This is the SRQ handle value for the queue that has reached its
	 * event threshold. This field carries the lower 32b of the value.
	 */
	uint32_t v;
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define NQ_SRQ_EVENT_V					UINT32_C(0x1)
	#define NQ_SRQ_EVENT_RESERVED31_MASK			UINT32_C(0xfffffffe)
	#define NQ_SRQ_EVENT_RESERVED31_SFT			1
	uint32_t srq_handle_high;
	/*
	 * This is the SRQ handle value for the queue that has reached its
	 * event threshold. This field carries the upper 32b of the value.
	 */
} __attribute__((packed));

/* DBQ Async Event Notification (16 bytes) */

struct nq_dbq_event {
	uint8_t type;
	/*
	 * This field indicates the exact type of the completion. By convention,
	 * the LSB identifies the length of the record in 16B units. Even values
	 * indicate 16B records. Odd values indicate 32B records.
	 */
	#define NQ_DBQ_EVENT_TYPE_MASK				UINT32_C(0x3f)
	#define NQ_DBQ_EVENT_TYPE_SFT				0
	/* DBQ Threshold Event */
	#define NQ_DBQ_EVENT_TYPE_DBQ_EVENT			UINT32_C(0x34)
	#define NQ_DBQ_EVENT_RESERVED1_MASK			UINT32_C(0xc0)
	#define NQ_DBQ_EVENT_RESERVED1_SFT			6
	uint8_t event;
	/* This value define what type of action the driver should take. */
	/*
	 * The driver should start writing dummy values to the
	 * doorbell in an attempt to consume all the PCIE posted write
	 * resources and prevent doorbell overflow.
	 */
	#define NQ_DBQ_EVENT_EVENT_DBQ_THRESHOLD_EVENT		UINT32_C(0x1)
	uint16_t db_pfid;
	/*
	 * This is the PFID of function that wrote the doorbell that crossed the
	 * async event threshold.
	 */
	#define NQ_DBQ_EVENT_DB_PFID_MASK			UINT32_C(0xf)
	#define NQ_DBQ_EVENT_DB_PFID_SFT			0
	#define NQ_DBQ_EVENT_RESERVED12_MASK			UINT32_C(0xfff0)
	#define NQ_DBQ_EVENT_RESERVED12_SFT			4
	uint32_t db_dpi;
	/*
	 * This is the DPI of the doorbell write that crossed the async event
	 * threshold.
	 */
	#define NQ_DBQ_EVENT_DB_DPI_MASK			UINT32_C(0xfffff)
	#define NQ_DBQ_EVENT_DB_DPI_SFT				0
	#define NQ_DBQ_EVENT_RESERVED12_2_MASK			UINT32_C(0xfff00000)
	#define NQ_DBQ_EVENT_RESERVED12_2_SFT			20
	uint32_t v;
	/*
	 * This value is written by the NIC such that it will be different for
	 * each pass through the completion queue. The even passes will write 1.
	 * The odd passes will write 0.
	 */
	#define NQ_DBQ_EVENT_V					UINT32_C(0x1)
	#define NQ_DBQ_EVENT_RESERVED32_MASK			UINT32_C(0xfffffffe)
	#define NQ_DBQ_EVENT_RESERVED32_SFT			1
	uint32_t db_type_db_xid;
	/* DB 'type' field from doorbell that crossed the async event threshold. */
	/*
	 * DB 'XID' field from doorbell that crossed the async event threshold.
	 * This is a QPID, SID, or CID, depending on the db_type field.
	 */
	#define NQ_DBQ_EVENT_DB_XID_MASK			UINT32_C(0xfffff)
	#define NQ_DBQ_EVENT_DB_XID_SFT				0
	#define NQ_DBQ_EVENT_RESERVED8_MASK			UINT32_C(0xff00000)
	#define NQ_DBQ_EVENT_RESERVED8_SFT			20
	/* DB 'type' field from doorbell that crossed the async event threshold. */
	#define NQ_DBQ_EVENT_DB_TYPE_MASK			UINT32_C(0xf0000000)
	#define NQ_DBQ_EVENT_DB_TYPE_SFT			28
} __attribute__((packed));

/* Read Request/Response Queue Structures */
/*
 * Description: This queue messages is used on the ORRQ to indicate output read
 * requests to the RX side of the chip.
 */
/* Input Read Request Queue (IRRQ) Message (32 bytes) */

struct xrrq_irrq {
	uint16_t credits_type;
	/*
	 * The credit code calculated by Rx path when receiving the request. It
	 * will be placed in the syndrome credit code with the acks on first and
	 * last response.
	 */
	/* Type indication */
	#define XRRQ_IRRQ_TYPE					UINT32_C(0x1)
	/* RDMA Read */
	#define XRRQ_IRRQ_TYPE_READ_REQ			UINT32_C(0x0)
	/* Atomic */
	#define XRRQ_IRRQ_TYPE_ATOMIC_REQ			UINT32_C(0x1)
	#define XRRQ_IRRQ_RESERVED10_MASK			UINT32_C(0x7fe)
	#define XRRQ_IRRQ_RESERVED10_SFT			1
	/*
	 * The credit code calculated by Rx path when receiving the request. It
	 * will be placed in the syndrome credit code with the acks on first and
	 * last response.
	 */
	#define XRRQ_IRRQ_CREDITS_MASK				UINT32_C(0xf800)
	#define XRRQ_IRRQ_CREDITS_SFT				11
	uint16_t reserved16;
	uint32_t reserved32;
	uint32_t psn;
	/* The PSN of the outstanding incoming request */
	#define XRRQ_IRRQ_PSN_MASK				UINT32_C(0xffffff)
	#define XRRQ_IRRQ_PSN_SFT				0
	#define XRRQ_IRRQ_RESERVED8_1_MASK			UINT32_C(0xff000000)
	#define XRRQ_IRRQ_RESERVED8_1_SFT			24
	uint32_t msn;
	/*
	 * The value of QPC.pending_ack_msn after it is incremented as a result
	 * of receiving the read/atomic request. IRRQ.msn-1 will be placed in
	 * the MSN field of the first response and IRRQ.msn will placed in the
	 * MSN field of the last or only response.
	 */
	#define XRRQ_IRRQ_MSN_MASK				UINT32_C(0xffffff)
	#define XRRQ_IRRQ_MSN_SFT				0
	#define XRRQ_IRRQ_RESERVED8_2_MASK			UINT32_C(0xff000000)
	#define XRRQ_IRRQ_RESERVED8_2_SFT			24
	uint64_t va_or_atomic_result;
	/*
	 * Virtual address on local host for RDMA READ In case of duplicate
	 * Atomic, the VA is not required to be validated, only the PSN is, thus
	 * this field is used to store the value returned in the Ack to the
	 * atomic request, and if duplicate arrives, this value is used again
	 * for resending the ack.
	 */
	uint32_t rdma_r_key;
	/* The key to the MR/W in the request */
	uint32_t length;
	/*
	 * Length in bytes of the data requested. Length must be 8 if type is
	 * atomic.
	 */
} __attribute__((packed));

/* Output Read Request Queue (ORRQ) Message (32 bytes) */

struct xrrq_orrq {
	uint16_t num_sges_type;
	/*
	 * Up to 6 SGEs. This value is 1 if type is atomic as one SGE is
	 * required to store Atomic response result field. 2 more bits allocated
	 * for future growth. Note that, if num_sges is 1 for an RDMA Read
	 * request, then the first_sge_phy_or_sing_sge_va, single_sge_l_key, and
	 * single_sge_size fields will be populated from the single SGE. If
	 * num_sges is 2 or more for an RDMA Read request, then the
	 * first_sge_phy_or_sing_sge_va field carries the physical address in
	 * host memory where the first sge is stored. The single_sge_l_key and
	 * single_sge_size fields are unused in this case. A special case is a
	 * zero-length, zero-sge RDMA read request WQE. In this situation,
	 * num_sges will be 1. However, first_sge_phy_or_sing_sge_va,
	 * single_sge_l_key, and single_sge_size will all be populated with
	 * zeros.
	 */
	/* Type indication */
	#define XRRQ_ORRQ_TYPE					UINT32_C(0x1)
	/* RDMA Read */
	#define XRRQ_ORRQ_TYPE_READ_REQ			UINT32_C(0x0)
	/* Atomic */
	#define XRRQ_ORRQ_TYPE_ATOMIC_REQ			UINT32_C(0x1)
	#define XRRQ_ORRQ_RESERVED10_MASK			UINT32_C(0x7fe)
	#define XRRQ_ORRQ_RESERVED10_SFT			1
	/*
	 * Up to 6 SGEs. This value is 1 if type is atomic as one SGE is
	 * required to store Atomic response result field. 2 more bits allocated
	 * for future growth. Note that, if num_sges is 1 for an RDMA Read
	 * request, then the first_sge_phy_or_sing_sge_va, single_sge_l_key, and
	 * single_sge_size fields will be populated from the single SGE. If
	 * num_sges is 2 or more for an RDMA Read request, then the
	 * first_sge_phy_or_sing_sge_va field carries the physical address in
	 * host memory where the first sge is stored. The single_sge_l_key and
	 * single_sge_size fields are unused in this case. A special case is a
	 * zero-length, zero-sge RDMA read request WQE. In this situation,
	 * num_sges will be 1. However, first_sge_phy_or_sing_sge_va,
	 * single_sge_l_key, and single_sge_size will all be populated with
	 * zeros.
	 */
	#define XRRQ_ORRQ_NUM_SGES_MASK				UINT32_C(0xf800)
	#define XRRQ_ORRQ_NUM_SGES_SFT				11
	uint16_t reserved16;
	uint32_t length;
	/*
	 * Length in bytes of the data requested. Length must be 8 if type is
	 * atomic.
	 */
	uint32_t psn;
	/* The PSN of the outstanding outgoing request */
	#define XRRQ_ORRQ_PSN_MASK				UINT32_C(0xffffff)
	#define XRRQ_ORRQ_PSN_SFT				0
	#define XRRQ_ORRQ_RESERVED8_1_MASK			UINT32_C(0xff000000)
	#define XRRQ_ORRQ_RESERVED8_1_SFT			24
	uint32_t end_psn;
	/*
	 * The expected last PSN on a response to this request where an ack with
	 * response, rather than just response, should arrive. If ack arrive
	 * with smaller PSN than end_psn then it is considered a NAK.
	 */
	#define XRRQ_ORRQ_END_PSN_MASK				UINT32_C(0xffffff)
	#define XRRQ_ORRQ_END_PSN_SFT				0
	#define XRRQ_ORRQ_RESERVED8_2_MASK			UINT32_C(0xff000000)
	#define XRRQ_ORRQ_RESERVED8_2_SFT			24
	uint64_t first_sge_phy_or_sing_sge_va;
	/*
	 * If num_sges == 1 this is the va of that SGE. Otherwise, physical
	 * address to the first SGE specified by the WQE. Points to the first
	 * SGE in the Request's WQE in the SQ. It is assumed that WQE does not
	 * cross page boundaries! Driver is responsible to enforce that. SGEs
	 * are 16B aligned 0b0000 lsb added to get 64 bit address.
	 */
	uint32_t single_sge_l_key;
	/* The L_Key of a single SGE if used */
	uint32_t single_sge_size;
	/* The size in bytes of the single SGE if used */
} __attribute__((packed));

/* Page Buffer List Memory Structures (PBL) */
/*
 * Description: Page directory entries point to a page directories made up of
 * PTE values.
 */
/* Page Table Entry (PTE) (8 bytes) */

struct ptu_pte {
	uint64_t page_next_to_last_last_valid;
	/*
	 * This is the upper bits of the physical page controlled by this PTE.
	 * If the page is larger than 4KB, then the unused lower bits of the
	 * page address should be zero.
	 */
	/*
	 * This field indicates if the PTE is valid. A value of '0' indicates
	 * that the page is not valid. A value of '1' indicates that the page is
	 * valid. A reference to an invalid page will return a PTU error.
	 */
	#define PTU_PTE_VALID					UINT32_C(0x1)
	/*
	 * This field is used only for "ring" PBLs that are used for SQ, RQ,
	 * SRQ, or CQ structures. For all other PBL structures, this bit should
	 * be zero. When this bit is '1', it indicates that the page pointed to
	 * by this PTE is the last page in the ring. A prefetch for the ring
	 * should use the first PTE in the PBL.
	 */
	#define PTU_PTE_LAST					UINT32_C(0x2)
	/*
	 * This field is used only for "ring" PBLs that are used for SQ, RQ,
	 * SRQ, or CQ structures. For all other PBL structures, this bit should
	 * be zero. When this bit is '1', it indicates that this is the next-to-
	 * last page of the PBL.
	 */
	#define PTU_PTE_NEXT_TO_LAST				UINT32_C(0x4)
	/* These bits should be programmed to zero. */
	/*
	 * This is the upper bits of the physical page controlled by this PTE.
	 * If the page is larger than 4KB, then the unused lower bits of the
	 * page address should be zero.
	 */
	#define PTU_PTE_PAGE_MASK				UINT32_C(0xfffff000)
	#define PTU_PTE_PAGE_SFT				12
} __attribute__((packed));

/* Page Directory Entry (PDE) (8 bytes) */

struct ptu_pde {
	uint64_t page_valid;
	/*
	 * This is the upper bits of the physical page controlled by this PTE.
	 * If the page is larger than 4KB, then the unused lower bits of the
	 * page address should be zero.
	 */
	/*
	 * This field indicates if the PTE is valid. A value of '0' indicates
	 * that the page is not valid. A value of '1' indicates that the page is
	 * valid. A reference to an invalid page will return a PTU error.
	 */
	#define PTU_PDE_VALID					UINT32_C(0x1)
	/* These bits should be programmed to zero. */
	/*
	 * This is the upper bits of the physical page controlled by this PTE.
	 * If the page is larger than 4KB, then the unused lower bits of the
	 * page address should be zero.
	 */
	#define PTU_PDE_PAGE_MASK				UINT32_C(0xfffff000)
	#define PTU_PDE_PAGE_SFT				12
} __attribute__((packed));

/* RoCE Fastpath Host Structures */
/*
 * Note: This section documents the host structures used between RoCE state
 * machines and RoCE drivers/libraries.
 */
/* hwrm_ver_get */
/*
 * Description: This function is called by a driver to determine the HWRM
 * interface version supported by the HWRM firmware, the version of HWRM
 * firmware implementation, the name of HWRM firmware, the versions of other
 * embedded firmwares, and the names of other embedded firmwares, etc. Any
 * interface or firmware version with major = 0, minor = 0, and update = 0 shall
 * be considered an invalid version.
 */
/* Input (24 bytes) */

struct hwrm_ver_get_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t hwrm_intf_maj;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the driver HWRM implementation. The
	 * interface major version is intended to change only when non backward
	 * compatible changes are made to the HWRM interface specification.
	 */
	uint8_t hwrm_intf_min;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the driver HWRM implementation. A change
	 * in interface minor version is used to reflect significant backward
	 * compatible modification to HWRM interface specification. This can be
	 * due to addition or removal of functionality. HWRM interface
	 * specifications with the same major version but different minor
	 * versions are compatible.
	 */
	uint8_t hwrm_intf_upd;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the driver HWRM implementation. The
	 * interface update version is used to reflect minor changes or bug
	 * fixes to a released HWRM interface specification.
	 */
	uint8_t unused_0[5];
} __attribute__((packed));

/* Output (128 bytes) */

struct hwrm_ver_get_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t hwrm_intf_maj;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the HWRM implementation. The interface
	 * major version is intended to change only when non backward compatible
	 * changes are made to the HWRM interface specification. A HWRM
	 * implementation that is compliant with this specification shall
	 * provide value of 1 in this field.
	 */
	uint8_t hwrm_intf_min;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the HWRM implementation. A change in
	 * interface minor version is used to reflect significant backward
	 * compatible modification to HWRM interface specification. This can be
	 * due to addition or removal of functionality. HWRM interface
	 * specifications with the same major version but different minor
	 * versions are compatible. A HWRM implementation that is compliant with
	 * this specification shall provide value of 2 in this field.
	 */
	uint8_t hwrm_intf_upd;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the HWRM implementation. The interface
	 * update version is used to reflect minor changes or bug fixes to a
	 * released HWRM interface specification. A HWRM implementation that is
	 * compliant with this specification shall provide value of 2 in this
	 * field.
	 */
	uint8_t hwrm_intf_rsvd;
	uint8_t hwrm_fw_maj;
	/*
	 * This field represents the major version of HWRM firmware. A change in
	 * firmware major version represents a major firmware release.
	 */
	uint8_t hwrm_fw_min;
	/*
	 * This field represents the minor version of HWRM firmware. A change in
	 * firmware minor version represents significant firmware functionality
	 * changes.
	 */
	uint8_t hwrm_fw_bld;
	/*
	 * This field represents the build version of HWRM firmware. A change in
	 * firmware build version represents bug fixes to a released firmware.
	 */
	uint8_t hwrm_fw_rsvd;
	/*
	 * This field is a reserved field. This field can be used to represent
	 * firmware branches or customer specific releases tied to a specific
	 * (major,minor,update) version of the HWRM firmware.
	 */
	uint8_t mgmt_fw_maj;
	/*
	 * This field represents the major version of mgmt firmware. A change in
	 * major version represents a major release.
	 */
	uint8_t mgmt_fw_min;
	/*
	 * This field represents the minor version of mgmt firmware. A change in
	 * minor version represents significant functionality changes.
	 */
	uint8_t mgmt_fw_bld;
	/*
	 * This field represents the build version of mgmt firmware. A change in
	 * update version represents bug fixes.
	 */
	uint8_t mgmt_fw_rsvd;
	/*
	 * This field is a reserved field. This field can be used to represent
	 * firmware branches or customer specific releases tied to a specific
	 * (major,minor,update) version
	 */
	uint8_t netctrl_fw_maj;
	/*
	 * This field represents the major version of network control firmware.
	 * A change in major version represents a major release.
	 */
	uint8_t netctrl_fw_min;
	/*
	 * This field represents the minor version of network control firmware.
	 * A change in minor version represents significant functionality
	 * changes.
	 */
	uint8_t netctrl_fw_bld;
	/*
	 * This field represents the build version of network control firmware.
	 * A change in update version represents bug fixes.
	 */
	uint8_t netctrl_fw_rsvd;
	/*
	 * This field is a reserved field. This field can be used to represent
	 * firmware branches or customer specific releases tied to a specific
	 * (major,minor,update) version
	 */
	uint32_t dev_caps_cfg;
	/*
	 * This field is used to indicate device's capabilities and
	 * configurations.
	 */
	/*
	 * If set to 1, then secure firmware update behavior is supported. If
	 * set to 0, then secure firmware update behavior is not supported.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SECURE_FW_UPD_SUPPORTED UINT32_C(0x1)
	/*
	 * If set to 1, then firmware based DCBX agent is supported. If set to
	 * 0, then firmware based DCBX agent capability is not supported on this
	 * device.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_FW_DCBX_AGENT_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, then HWRM short command format is supported. If set to
	 * 0, then HWRM short command format is not supported.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SHORT_CMD_SUPPORTED UINT32_C(0x4)
	/*
	 * If set to 1, then HWRM short command format is required. If set to 0,
	 * then HWRM short command format is not required.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SHORT_CMD_REQUIRED UINT32_C(0x8)
	uint8_t roce_fw_maj;
	/*
	 * This field represents the major version of RoCE firmware. A change in
	 * major version represents a major release.
	 */
	uint8_t roce_fw_min;
	/*
	 * This field represents the minor version of RoCE firmware. A change in
	 * minor version represents significant functionality changes.
	 */
	uint8_t roce_fw_bld;
	/*
	 * This field represents the build version of RoCE firmware. A change in
	 * update version represents bug fixes.
	 */
	uint8_t roce_fw_rsvd;
	/*
	 * This field is a reserved field. This field can be used to represent
	 * firmware branches or customer specific releases tied to a specific
	 * (major,minor,update) version
	 */
	char hwrm_fw_name[16];
	/*
	 * This field represents the name of HWRM FW (ASCII chars with NULL at
	 * the end).
	 */
	char mgmt_fw_name[16];
	/*
	 * This field represents the name of mgmt FW (ASCII chars with NULL at
	 * the end).
	 */
	char netctrl_fw_name[16];
	/*
	 * This field represents the name of network control firmware (ASCII
	 * chars with NULL at the end).
	 */
	uint32_t reserved2[4];
	/*
	 * This field is reserved for future use. The responder should set it to
	 * 0. The requester should ignore this field.
	 */
	char roce_fw_name[16];
	/*
	 * This field represents the name of RoCE FW (ASCII chars with NULL at
	 * the end).
	 */
	uint16_t chip_num;
	/* This field returns the chip number. */
	uint8_t chip_rev;
	/* This field returns the revision of chip. */
	uint8_t chip_metal;
	/* This field returns the chip metal number. */
	uint8_t chip_bond_id;
	/* This field returns the bond id of the chip. */
	uint8_t chip_platform_type;
	/*
	 * This value indicates the type of platform used for chip
	 * implementation.
	 */
	/* ASIC */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_ASIC	UINT32_C(0x0)
	/* FPGA platform of the chip. */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_FPGA	UINT32_C(0x1)
	/* Palladium platform of the chip. */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_PALLADIUM  UINT32_C(0x2)
	uint16_t max_req_win_len;
	/*
	 * This field returns the maximum value of request window that is
	 * supported by the HWRM. The request window is mapped into device
	 * address space using MMIO.
	 */
	uint16_t max_resp_len;
	/* This field returns the maximum value of response buffer in bytes. */
	uint16_t def_req_timeout;
	/* This field returns the default request timeout value in milliseconds. */
	uint8_t init_pending;
	/* This field will indicate if any subsystems is not fully initialized. */
	/*
	 * If set to 1, device is not ready. If set to 0, device is ready to
	 * accept all HWRM commands.
	 */
	#define HWRM_VER_GET_OUTPUT_INIT_PENDING_DEV_NOT_RDY	UINT32_C(0x1)
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_reset */
/*
 * Description: This command resets a hardware function (PCIe function) and
 * frees any resources used by the function. This command shall be initiated by
 * the driver after an FLR has occurred to prepare the function for re-use. This
 * command may also be initiated by a driver prior to doing its own
 * configuration. This command puts the function into the reset state. In the
 * reset state, global and port related features of the chip are not available.
 */
/*
 * Note: This command will reset a function that has already been disabled or
 * idled. The command returns all the resources owned by the function so a new
 * driver may allocate and configure resources normally.
 */
/* Input (24 bytes) */

struct hwrm_func_reset_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the vf_id_valid field to be configured. */
	#define HWRM_FUNC_RESET_INPUT_ENABLES_VF_ID_VALID	UINT32_C(0x1)
	uint16_t vf_id;
	/*
	 * The ID of the VF that this PF is trying to reset. Only the parent PF
	 * shall be allowed to reset a child VF. A parent PF driver shall use
	 * this field only when a specific child VF is requested to be reset.
	 */
	uint8_t func_reset_level;
	/* This value indicates the level of a function reset. */
	/*
	 * Reset the caller function and its children VFs (if any). If
	 * no children functions exist, then reset the caller function
	 * only.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETALL   UINT32_C(0x0)
	/* Reset the caller function only */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETME	UINT32_C(0x1)
	/*
	 * Reset all children VFs of the caller function driver if the
	 * caller is a PF driver. It is an error to specify this level
	 * by a VF driver. It is an error to specify this level by a PF
	 * driver with no children VFs.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETCHILDREN UINT32_C(0x2)
	/*
	 * Reset a specific VF of the caller function driver if the
	 * caller is the parent PF driver. It is an error to specify
	 * this level by a VF driver. It is an error to specify this
	 * level by a PF driver that is not the parent of the VF that is
	 * being requested to reset.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETVF	UINT32_C(0x3)
	uint8_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_reset_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_getfid */
/*
 * Description: This command returns the FID value for the function. If a valid
 * pci_id is provided, then this function returns fid for that PCI function.
 * Otherwise, it returns FID of the requesting function. This value is needed to
 * configure Rings and MSI-X vectors so their DMA operations appear correctly on
 * the PCI bus. For PF-HWRM commands, there is no need for FID. Similarly there
 * is no need for FID for VF-HWRM commands. In the PF-VF communication, only PF
 * needs to know FIDs.
 */
/* Input (24 bytes) */

struct hwrm_func_getfid_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the pci_id field to be configured. */
	#define HWRM_FUNC_GETFID_INPUT_ENABLES_PCI_ID		UINT32_C(0x1)
	uint16_t pci_id;
	/*
	 * This value is the PCI ID of the queried function. If ARI is enabled,
	 * then it is Bus Number (8b):Function Number(8b). Otherwise, it is Bus
	 * Number (8b):Device Number (5b):Function Number(3b).
	 */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_getfid_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t fid;
	/*
	 * FID value. This value is used to identify operations on the PCI bus
	 * as belonging to a particular PCI function.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_vf_alloc */
/*
 * Description: This command is used to allocate requested number of virtual
 * functions on a physical function. It will return the FID value of the first
 * virtual function. The FIDs of the remaining virtual functions can be derived
 * by sequentially incrementing the FID value of the first VF. This command
 * supports the following models for VF allocation: # Allocation of one or more
 * VFs from a PF without specifying the first VF ID # Allocation of multiple VFs
 * from a PF starting with a specific VF # Allocation of a specific VF from a PF
 * If this command is called on a virtual function or a physical function that
 * is not enabled for SR-IOV, the HWRM shall return an error. The VF IDs
 * returned by this function remain valid after the VF is disabled or reset.
 */
/* Input (24 bytes) */

struct hwrm_func_vf_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the first_vf_id field to be configured. */
	#define HWRM_FUNC_VF_ALLOC_INPUT_ENABLES_FIRST_VF_ID	UINT32_C(0x1)
	uint16_t first_vf_id;
	/*
	 * This value is used to identify a Virtual Function (VF). The scope of
	 * VF ID is local within a PF.
	 */
	uint16_t num_vfs;
	/* The number of virtual functions requested. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_vf_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t first_vf_id;
	/* The ID of the first VF allocated. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_vf_free */
/*
 * Description: This command will free allocated virtual functions on a physical
 * function. If this command is called on a virtual function or a physical
 * function that is not enabled for SR-IOV, the HWRM shall return an error.
 * After the successful completion of this command, the VF IDs of the VFs that
 * are freed on the PF are invalid.
 */
/* Input (24 bytes) */

struct hwrm_func_vf_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the first_vf_id field to be configured. */
	#define HWRM_FUNC_VF_FREE_INPUT_ENABLES_FIRST_VF_ID	UINT32_C(0x1)
	uint16_t first_vf_id;
	/*
	 * This value is used to identify a Virtual Function (VF). The scope of
	 * VF ID is local within a PF.
	 */
	uint16_t num_vfs;
	/*
	 * The number of virtual functions requested. 0xFFFF - Cleanup all
	 * children of this PF.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_vf_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_vf_cfg */
/*
 * Description: This command allows configuration of a VF by its driver. If this
 * function is called by a PF driver, then the HWRM shall fail this command. If
 * guest VLAN and/or MAC address are provided in this command, then the HWRM
 * shall set up appropriate MAC/VLAN filters for the VF that is being
 * configured. A VF driver should set VF MTU/MRU using this command prior to
 * allocating RX VNICs or TX rings for the corresponding VF.
 */
/* Input (32 bytes) */

struct hwrm_func_vf_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the mtu field to be configured. */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_MTU		UINT32_C(0x1)
	/* This bit must be '1' for the guest_vlan field to be configured. */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_GUEST_VLAN	UINT32_C(0x2)
	/* This bit must be '1' for the async_event_cr field to be configured. */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_ASYNC_EVENT_CR	UINT32_C(0x4)
	/* This bit must be '1' for the dflt_mac_addr field to be configured. */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_DFLT_MAC_ADDR	UINT32_C(0x8)
	uint16_t mtu;
	/*
	 * The maximum transmission unit requested on the function. The HWRM
	 * should make sure that the mtu of the function does not exceed the mtu
	 * of the physical port that this function is associated with. In
	 * addition to requesting mtu per function, it is possible to configure
	 * mtu per transmit ring. By default, the mtu of each transmit ring
	 * associated with a function is equal to the mtu of the function. The
	 * HWRM should make sure that the mtu of each transmit ring that is
	 * assigned to a function has a valid mtu.
	 */
	uint16_t guest_vlan;
	/*
	 * The guest VLAN for the function being configured. This field's format
	 * is same as 802.1Q Tag's Tag Control Information (TCI) format that
	 * includes both Priority Code Point (PCP) and VLAN Identifier (VID).
	 */
	uint16_t async_event_cr;
	/*
	 * ID of the target completion ring for receiving asynchronous event
	 * completions. If this field is not valid, then the HWRM shall use the
	 * default completion ring of the function that is being configured as
	 * the target completion ring for providing any asynchronous event
	 * completions for that function. If this field is valid, then the HWRM
	 * shall use the completion ring identified by this ID as the target
	 * completion ring for providing any asynchronous event completions for
	 * the function that is being configured.
	 */
	uint8_t dflt_mac_addr[6];
	/*
	 * This value is the current MAC address requested by the VF driver to
	 * be configured on this VF. A value of 00-00-00-00-00-00 indicates no
	 * MAC address configuration is requested by the VF driver. The parent
	 * PF driver may reject or overwrite this MAC address.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_vf_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_qcaps */
/*
 * Description: This command returns capabilities of a function. The input FID
 * value is used to indicate what function is being queried. This allows a
 * physical function driver to query virtual functions that are children of the
 * physical function. The output FID value is needed to configure Rings and
 * MSI-X vectors so their DMA operations appear correctly on the PCI bus.
 */
/* Input (24 bytes) */

struct hwrm_func_qcaps_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being queried. 0xFF... (All Fs)
	 * if the query is for the requesting function.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (80 bytes) */

struct hwrm_func_qcaps_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t fid;
	/*
	 * FID value. This value is used to identify operations on the PCI bus
	 * as belonging to a particular PCI function.
	 */
	uint16_t port_id;
	/*
	 * Port ID of port that this function is associated with. Valid only for
	 * the PF. 0xFF... (All Fs) if this function is not associated with any
	 * port. 0xFF... (All Fs) if this function is called from a VF.
	 */
	uint32_t flags;
	/* If 1, then Push mode is supported on this function. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PUSH_MODE_SUPPORTED   UINT32_C(0x1)
	/* If 1, then the global MSI-X auto-masking is enabled for the device. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_GLOBAL_MSIX_AUTOMASKING UINT32_C(0x2)
	/*
	 * If 1, then the Precision Time Protocol (PTP) processing is supported
	 * on this function. The HWRM should enable PTP on only a single
	 * Physical Function (PF) per port.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PTP_SUPPORTED	UINT32_C(0x4)
	/*
	 * If 1, then RDMA over Converged Ethernet (RoCE) v1 is supported on
	 * this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ROCE_V1_SUPPORTED	UINT32_C(0x8)
	/*
	 * If 1, then RDMA over Converged Ethernet (RoCE) v2 is supported on
	 * this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ROCE_V2_SUPPORTED	UINT32_C(0x10)
	/*
	 * If 1, then control and configuration of WoL magic packet are
	 * supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_WOL_MAGICPKT_SUPPORTED UINT32_C(0x20)
	/*
	 * If 1, then control and configuration of bitmap pattern packet are
	 * supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_WOL_BMP_SUPPORTED	UINT32_C(0x40)
	/*
	 * If set to 1, then the control and configuration of rate limit of an
	 * allocated TX ring on the queried function is supported.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_TX_RING_RL_SUPPORTED  UINT32_C(0x80)
	/*
	 * If 1, then control and configuration of minimum and maximum
	 * bandwidths are supported on the queried function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_TX_BW_CFG_SUPPORTED   UINT32_C(0x100)
	/*
	 * If the query is for a VF, then this flag shall be ignored. If this
	 * query is for a PF and this flag is set to 1, then the PF has the
	 * capability to set the rate limits on the TX rings of its children
	 * VFs. If this query is for a PF and this flag is set to 0, then the PF
	 * does not have the capability to set the rate limits on the TX rings
	 * of its children VFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_VF_TX_RING_RL_SUPPORTED UINT32_C(0x200)
	/*
	 * If the query is for a VF, then this flag shall be ignored. If this
	 * query is for a PF and this flag is set to 1, then the PF has the
	 * capability to set the minimum and/or maximum bandwidths for its
	 * children VFs. If this query is for a PF and this flag is set to 0,
	 * then the PF does not have the capability to set the minimum or
	 * maximum bandwidths for its children VFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_VF_BW_CFG_SUPPORTED   UINT32_C(0x400)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring and
	 * underlying scheduling resources that allow bandwidth reservation and
	 * limit settings on the queried function. If set to 1, then standard TX
	 * ring mode is supported on the queried function. If set to 0, then
	 * standard TX ring mode is not available on the queried function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_STD_TX_RING_MODE_SUPPORTED UINT32_C(0x800)
	uint8_t mac_address[6];
	/*
	 * This value is current MAC address configured for this function. A
	 * value of 00-00-00-00-00-00 indicates no MAC address is currently
	 * configured.
	 */
	uint16_t max_rsscos_ctx;
	/*
	 * The maximum number of RSS/COS contexts that can be allocated to the
	 * function.
	 */
	uint16_t max_cmpl_rings;
	/*
	 * The maximum number of completion rings that can be allocated to the
	 * function.
	 */
	uint16_t max_tx_rings;
	/*
	 * The maximum number of transmit rings that can be allocated to the
	 * function.
	 */
	uint16_t max_rx_rings;
	/*
	 * The maximum number of receive rings that can be allocated to the
	 * function.
	 */
	uint16_t max_l2_ctxs;
	/*
	 * The maximum number of L2 contexts that can be allocated to the
	 * function.
	 */
	uint16_t max_vnics;
	/* The maximum number of VNICs that can be allocated to the function. */
	uint16_t first_vf_id;
	/*
	 * The identifier for the first VF enabled on a PF. This is valid only
	 * on the PF with SR-IOV enabled. 0xFF... (All Fs) if this command is
	 * called on a PF with SR-IOV disabled or on a VF.
	 */
	uint16_t max_vfs;
	/*
	 * The maximum number of VFs that can be allocated to the function. This
	 * is valid only on the PF with SR-IOV enabled. 0xFF... (All Fs) if this
	 * command is called on a PF with SR-IOV disabled or on a VF.
	 */
	uint16_t max_stat_ctx;
	/*
	 * The maximum number of statistic contexts that can be allocated to the
	 * function.
	 */
	uint32_t max_encap_records;
	/*
	 * The maximum number of Encapsulation records that can be offloaded by
	 * this function.
	 */
	uint32_t max_decap_records;
	/*
	 * The maximum number of decapsulation records that can be offloaded by
	 * this function.
	 */
	uint32_t max_tx_em_flows;
	/*
	 * The maximum number of Exact Match (EM) flows that can be offloaded by
	 * this function on the TX side.
	 */
	uint32_t max_tx_wm_flows;
	/*
	 * The maximum number of Wildcard Match (WM) flows that can be offloaded
	 * by this function on the TX side.
	 */
	uint32_t max_rx_em_flows;
	/*
	 * The maximum number of Exact Match (EM) flows that can be offloaded by
	 * this function on the RX side.
	 */
	uint32_t max_rx_wm_flows;
	/*
	 * The maximum number of Wildcard Match (WM) flows that can be offloaded
	 * by this function on the RX side.
	 */
	uint32_t max_mcast_filters;
	/*
	 * The maximum number of multicast filters that can be supported by this
	 * function on the RX side.
	 */
	uint32_t max_flow_id;
	/*
	 * The maximum value of flow_id that can be supported in completion
	 * records.
	 */
	uint32_t max_hw_ring_grps;
	/*
	 * The maximum number of HW ring groups that can be supported on this
	 * function.
	 */
	uint16_t max_sp_tx_rings;
	/*
	 * The maximum number of strict priority transmit rings that can be
	 * allocated to the function. This number indicates the maximum number
	 * of TX rings that can be assigned strict priorities out of the maximum
	 * number of TX rings that can be allocated (max_tx_rings) to the
	 * function.
	 */
	uint8_t unused_0;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_qcfg */
/*
 * Description: This command returns the current configuration of a function.
 * The input FID value is used to indicate what function is being queried. This
 * allows a physical function driver to query virtual functions that are
 * children of the physical function. The output FID value is needed to
 * configure Rings and MSI-X vectors so their DMA operations appear correctly on
 * the PCI bus. This command should be called by every driver after
 * 'hwrm_func_cfg' to get the actual number of resources allocated by the HWRM.
 * The values returned by hwrm_func_qcfg are the values the driver shall use.
 * These values may be different than what was originally requested in the
 * 'hwrm_func_cfg' command.
 */
/* Input (24 bytes) */

struct hwrm_func_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being queried. 0xFF... (All Fs)
	 * if the query is for the requesting function.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (72 bytes) */

struct hwrm_func_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t fid;
	/*
	 * FID value. This value is used to identify operations on the PCI bus
	 * as belonging to a particular PCI function.
	 */
	uint16_t port_id;
	/*
	 * Port ID of port that this function is associated with. 0xFF... (All
	 * Fs) if this function is not associated with any port.
	 */
	uint16_t vlan;
	/*
	 * This value is the current VLAN setting for this function. The value
	 * of 0 for this field indicates no priority tagging or VLAN is used.
	 * This field's format is same as 802.1Q Tag's Tag Control Information
	 * (TCI) format that includes both Priority Code Point (PCP) and VLAN
	 * Identifier (VID).
	 */
	uint16_t flags;
	/*
	 * If 1, then magic packet based Out-Of-Box WoL is enabled on the port
	 * associated with this function.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_OOB_WOL_MAGICPKT_ENABLED UINT32_C(0x1)
	/*
	 * If 1, then bitmap pattern based Out-Of-Box WoL packet is enabled on
	 * the port associated with this function.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_OOB_WOL_BMP_ENABLED	UINT32_C(0x2)
	/*
	 * If set to 1, then FW based DCBX agent is enabled and running on the
	 * port associated with this function. If set to 0, then DCBX agent is
	 * not running in the firmware.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_FW_DCBX_AGENT_ENABLED  UINT32_C(0x4)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring and
	 * underlying scheduling resources that allow bandwidth reservation and
	 * limit settings on the queried function. If set to 1, then standard TX
	 * ring mode is enabled on the queried function. If set to 0, then the
	 * standard TX ring mode is disabled on the queried function. In this
	 * extended TX ring resource mode, the minimum and maximum bandwidth
	 * settings are not supported to allow the allocation of TX rings to
	 * span multiple scheduler nodes.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_STD_TX_RING_MODE_ENABLED UINT32_C(0x8)
	/*
	 * If set to 1 then FW based LLDP agent is enabled and running on the
	 * port associated with this function. If set to 0 then the LLDP agent
	 * is not running in the firmware.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_FW_LLDP_AGENT_ENABLED  UINT32_C(0x10)
	/*
	 * If set to 1, then multi-host mode is active for this function. If set
	 * to 0, then multi-host mode is inactive for this function or not
	 * applicable for this device.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_MULTI_HOST		UINT32_C(0x20)
	uint8_t mac_address[6];
	/*
	 * This value is current MAC address configured for this function. A
	 * value of 00-00-00-00-00-00 indicates no MAC address is currently
	 * configured.
	 */
	uint16_t pci_id;
	/*
	 * This value is current PCI ID of this function. If ARI is enabled,
	 * then it is Bus Number (8b):Function Number(8b). Otherwise, it is Bus
	 * Number (8b):Device Number (4b):Function Number(4b). If multi-host
	 * mode is active, the 4 lsb will indicate the PF index for this
	 * function.
	 */
	uint16_t alloc_rsscos_ctx;
	/* The number of RSS/COS contexts currently allocated to the function. */
	uint16_t alloc_cmpl_rings;
	/*
	 * The number of completion rings currently allocated to the function.
	 * This does not include the rings allocated to any children functions
	 * if any.
	 */
	uint16_t alloc_tx_rings;
	/*
	 * The number of transmit rings currently allocated to the function.
	 * This does not include the rings allocated to any children functions
	 * if any.
	 */
	uint16_t alloc_rx_rings;
	/*
	 * The number of receive rings currently allocated to the function. This
	 * does not include the rings allocated to any children functions if
	 * any.
	 */
	uint16_t alloc_l2_ctx;
	/* The allocated number of L2 contexts to the function. */
	uint16_t alloc_vnics;
	/* The allocated number of vnics to the function. */
	uint16_t mtu;
	/*
	 * The maximum transmission unit of the function. For rings allocated on
	 * this function, this default value is used if ring MTU is not
	 * specified.
	 */
	uint16_t mru;
	/*
	 * The maximum receive unit of the function. For vnics allocated on this
	 * function, this default value is used if vnic MRU is not specified.
	 */
	uint16_t stat_ctx_id;
	/* The statistics context assigned to a function. */
	uint8_t port_partition_type;
	/*
	 * The HWRM shall return Unknown value for this field when this command
	 * is used to query VF's configuration.
	 */
	/* Single physical function */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_SPF	UINT32_C(0x0)
	/* Multiple physical functions */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_MPFS	UINT32_C(0x1)
	/* Network Partitioning 1.0 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR1_0 UINT32_C(0x2)
	/* Network Partitioning 1.5 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR1_5 UINT32_C(0x3)
	/* Network Partitioning 2.0 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR2_0 UINT32_C(0x4)
	/* Unknown */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_UNKNOWN UINT32_C(0xff)
	uint8_t port_pf_cnt;
	/*
	 * This field will indicate number of physical functions on this
	 * port_partition. HWRM shall return unavail (i.e. value of 0) for this
	 * field when this command is used to query VF's configuration or from
	 * older firmware that doesn't support this field.
	 */
	/* number of PFs is not available */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PF_CNT_UNAVAIL	UINT32_C(0x0)
	uint16_t dflt_vnic_id;
	/* The default VNIC ID assigned to a function that is being queried. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t min_bw;
	/*
	 * Minimum BW allocated for this function. The HWRM will translate this
	 * value into byte counter and time interval used for the scheduler
	 * inside the device. A value of 0 indicates the minimum bandwidth is
	 * not configured.
	 */
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_MASK	UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_SFT	0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BITS	(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BYTES	(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_LAST	HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_MEGA   (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_KILO   (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_BASE   (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_GIGA   (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t max_bw;
	/*
	 * Maximum BW allocated for this function. The HWRM will translate this
	 * value into byte counter and time interval used for the scheduler
	 * inside the device. A value of 0 indicates that the maximum bandwidth
	 * is not configured.
	 */
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_MASK	UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_SFT	0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BITS	(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BYTES	(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_LAST	HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_MEGA   (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_KILO   (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_BASE   (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_GIGA   (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t evb_mode;
	/*
	 * This value indicates the Edge virtual bridge mode for the domain that
	 * this function belongs to.
	 */
	/* No Edge Virtual Bridging (EVB) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_NO_EVB		UINT32_C(0x0)
	/* Virtual Ethernet Bridge (VEB) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEB		UINT32_C(0x1)
	/* Virtual Ethernet Port Aggregator (VEPA) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEPA		UINT32_C(0x2)
	uint8_t unused_2;
	uint16_t alloc_vfs;
	/*
	 * The number of VFs that are allocated to the function. This is valid
	 * only on the PF with SR-IOV enabled. 0xFF... (All Fs) if this command
	 * is called on a PF with SR-IOV disabled or on a VF.
	 */
	uint32_t alloc_mcast_filters;
	/*
	 * The number of allocated multicast filters for this function on the RX
	 * side.
	 */
	uint32_t alloc_hw_ring_grps;
	/* The number of allocated HW ring groups for this function. */
	uint16_t alloc_sp_tx_rings;
	/*
	 * The number of strict priority transmit rings out of currently
	 * allocated TX rings to the function (alloc_tx_rings).
	 */
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_vlan_qcfg */
/*
 * Description: This command should be called by PF driver to get the current
 * C-TAG, S-TAG and corresponding PCP and TPID values configured for the
 * function.
 */
/* Input (24 bytes) */

struct hwrm_func_vlan_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being configured. If set to
	 * 0xFF... (All Fs), then the configuration is for the requesting
	 * function.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (40 bytes) */

struct hwrm_func_vlan_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
	uint16_t stag_vid;
	/* S-TAG VLAN identifier configured for the function. */
	uint8_t stag_pcp;
	/* S-TAG PCP value configured for the function. */
	uint8_t unused_4;
	uint16_t stag_tpid; /* big endian */
	/*
	 * S-TAG TPID value configured for the function. This field is specified
	 * in network byte order.
	 */
	uint16_t ctag_vid;
	/* C-TAG VLAN identifier configured for the function. */
	uint8_t ctag_pcp;
	/* C-TAG PCP value configured for the function. */
	uint8_t unused_5;
	uint16_t ctag_tpid; /* big endian */
	/*
	 * C-TAG TPID value configured for the function. This field is specified
	 * in network byte order.
	 */
	uint32_t rsvd2;
	/* Future use. */
	uint32_t rsvd3;
	/* Future use. */
	uint32_t unused_6;
} __attribute__((packed));

/* hwrm_func_vlan_cfg */
/*
 * Description: This command allows PF driver to configure C-TAG, S-TAG and
 * corresponding PCP and TPID values for a function.
 */
/* Input (48 bytes) */

struct hwrm_func_vlan_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being configured. If set to
	 * 0xFF... (All Fs), then the configuration is for the requesting
	 * function.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t enables;
	/* This bit must be '1' for the stag_vid field to be configured. */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_STAG_VID	UINT32_C(0x1)
	/* This bit must be '1' for the ctag_vid field to be configured. */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_CTAG_VID	UINT32_C(0x2)
	/* This bit must be '1' for the stag_pcp field to be configured. */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_STAG_PCP	UINT32_C(0x4)
	/* This bit must be '1' for the ctag_pcp field to be configured. */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_CTAG_PCP	UINT32_C(0x8)
	/* This bit must be '1' for the stag_tpid field to be configured. */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_STAG_TPID	UINT32_C(0x10)
	/* This bit must be '1' for the ctag_tpid field to be configured. */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_CTAG_TPID	UINT32_C(0x20)
	uint16_t stag_vid;
	/* S-TAG VLAN identifier configured for the function. */
	uint8_t stag_pcp;
	/* S-TAG PCP value configured for the function. */
	uint8_t unused_2;
	uint16_t stag_tpid; /* big endian */
	/*
	 * S-TAG TPID value configured for the function. This field is specified
	 * in network byte order.
	 */
	uint16_t ctag_vid;
	/* C-TAG VLAN identifier configured for the function. */
	uint8_t ctag_pcp;
	/* C-TAG PCP value configured for the function. */
	uint8_t unused_3;
	uint16_t ctag_tpid; /* big endian */
	/*
	 * C-TAG TPID value configured for the function. This field is specified
	 * in network byte order.
	 */
	uint32_t rsvd1;
	/* Future use. */
	uint32_t rsvd2;
	/* Future use. */
	uint32_t unused_4;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_vlan_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_cfg */
/*
 * Description: This command allows configuration of a PF by the corresponding
 * PF driver. This command also allows configuration of a child VF by its parent
 * PF driver. The input FID value is used to indicate what function is being
 * configured. This allows a PF driver to configure the PF owned by itself or a
 * virtual function that is a child of the PF. This command allows to reserve
 * resources for a VF by its parent PF. To reverse the process, the command
 * should be called with all enables flags cleared for resources. This will free
 * allocated resources for the VF and return them to the resource pool. If this
 * command is requested by a VF driver to configure or reserve resources, then
 * the HWRM shall fail this command. If default MAC address and/or VLAN are
 * provided in this command, then the HWRM shall set up appropriate MAC/VLAN
 * filters for the function that is being configured. If source properties
 * checks are enabled and default MAC address and/or IP address are provided in
 * this command, then the HWRM shall set appropriate source property checks
 * based on provided MAC and/or IP addresses. The parent PF driver should not
 * set MTU/MRU for a VF using this command. This is to allow MTU/MRU setting by
 * the VF driver. If the MTU or MRU for a VF is set by the PF driver, then the
 * HWRM should ignore it. A function's MTU/MRU should be set prior to allocating
 * RX VNICs or TX rings. A PF driver calls hwrm_func_cfg to allocate resources
 * for itself or its children VFs. All function drivers shall call hwrm_func_cfg
 * to reserve resources. A request to hwrm_func_cfg may not be fully granted;
 * that is, a request for resources may be larger than what can be supported by
 * the device and the HWRM will allocate the best set of resources available,
 * but that may be less than requested. If all the amounts requested could not
 * be fulfilled, the HWRM shall allocate what it could and return a status code
 * of success. A function driver should call hwrm_func_qcfg immediately after
 * hwrm_func_cfg to determine what resources were assigned to the configured
 * function. A call by a PF driver to hwrm_func_cfg to allocate resources for
 * itself shall only allocate resources for the PF driver to use, not for its
 * children VFs. Likewise, a call to hwrm_func_qcfg shall return the resources
 * available for the PF driver to use, not what is available to its children
 * VFs.
 */
/* Input (88 bytes) */

struct hwrm_func_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being configured. If set to
	 * 0xFF... (All Fs), then the configuration is for the requesting
	 * function.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t flags;
	/*
	 * When this bit is '1', the function is disabled with source MAC
	 * address check. This is an anti-spoofing check. If this flag is set,
	 * then the function shall be configured to disallow transmission of
	 * frames with the source MAC address that is configured for this
	 * function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_SRC_MAC_ADDR_CHECK_DISABLE UINT32_C(0x1)
	/*
	 * When this bit is '1', the function is enabled with source MAC address
	 * check. This is an anti-spoofing check. If this flag is set, then the
	 * function shall be configured to allow transmission of frames with the
	 * source MAC address that is configured for this function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_SRC_MAC_ADDR_CHECK_ENABLE UINT32_C(0x2)
	/* reserved */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSVD_MASK		UINT32_C(0x1fc)
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSVD_SFT		2
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring and
	 * underlying scheduling resources that allow bandwidth reservation and
	 * limit settings on the queried function. If set to 1, then standard TX
	 * ring mode is requested to be enabled on the function being
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STD_TX_RING_MODE_ENABLE  UINT32_C(0x200)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring and
	 * underlying scheduling resources that allow bandwidth reservation and
	 * limit settings on the queried function. If set to 1, then the
	 * standard TX ring mode is requested to be disabled on the function
	 * being configured. In this extended TX ring resource mode, the minimum
	 * and maximum bandwidth settings are not supported to allow the
	 * allocation of TX rings to span multiple scheduler nodes.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STD_TX_RING_MODE_DISABLE UINT32_C(0x400)
	/*
	 * If this bit is set, virtual mac address configured in this command
	 * will be persistent over warm boot.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_VIRT_MAC_PERSIST	UINT32_C(0x800)
	/*
	 * This bit only applies to the VF. If this bit is set, the statistic
	 * context counters will not be cleared when the statistic context is
	 * freed or a function reset is called on VF. This bit will be cleared
	 * when the PF is unloaded or a function reset is called on the PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_NO_AUTOCLEAR_STATISTIC   UINT32_C(0x1000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of TX rings) are available.
	 * The firmware will return an error if the requested assets are not
	 * available. The firmware will NOT reserve the assets if they are
	 * available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_TX_ASSETS_TEST	UINT32_C(0x2000)
	uint32_t enables;
	/* This bit must be '1' for the mtu field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MTU			UINT32_C(0x1)
	/* This bit must be '1' for the mru field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MRU			UINT32_C(0x2)
	/* This bit must be '1' for the num_rsscos_ctxs field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_RSSCOS_CTXS	UINT32_C(0x4)
	/* This bit must be '1' for the num_cmpl_rings field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_CMPL_RINGS	UINT32_C(0x8)
	/* This bit must be '1' for the num_tx_rings field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_TX_RINGS	UINT32_C(0x10)
	/* This bit must be '1' for the num_rx_rings field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_RX_RINGS	UINT32_C(0x20)
	/* This bit must be '1' for the num_l2_ctxs field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_L2_CTXS		UINT32_C(0x40)
	/* This bit must be '1' for the num_vnics field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_VNICS		UINT32_C(0x80)
	/* This bit must be '1' for the num_stat_ctxs field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_STAT_CTXS	UINT32_C(0x100)
	/* This bit must be '1' for the dflt_mac_addr field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_MAC_ADDR	UINT32_C(0x200)
	/* This bit must be '1' for the dflt_vlan field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_VLAN		UINT32_C(0x400)
	/* This bit must be '1' for the dflt_ip_addr field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_IP_ADDR	UINT32_C(0x800)
	/* This bit must be '1' for the min_bw field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MIN_BW		UINT32_C(0x1000)
	/* This bit must be '1' for the max_bw field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MAX_BW		UINT32_C(0x2000)
	/* This bit must be '1' for the async_event_cr field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ASYNC_EVENT_CR	UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the vlan_antispoof_mode field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_VLAN_ANTISPOOF_MODE	UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the allowed_vlan_pris field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ALLOWED_VLAN_PRIS	UINT32_C(0x10000)
	/* This bit must be '1' for the evb_mode field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_EVB_MODE		UINT32_C(0x20000)
	/*
	 * This bit must be '1' for the num_mcast_filters field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_MCAST_FILTERS	UINT32_C(0x40000)
	/* This bit must be '1' for the num_hw_ring_grps field to be configured. */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_HW_RING_GRPS	UINT32_C(0x80000)
	uint16_t mtu;
	/*
	 * The maximum transmission unit of the function. The HWRM should make
	 * sure that the mtu of the function does not exceed the mtu of the
	 * physical port that this function is associated with. In addition to
	 * configuring mtu per function, it is possible to configure mtu per
	 * transmit ring. By default, the mtu of each transmit ring associated
	 * with a function is equal to the mtu of the function. The HWRM should
	 * make sure that the mtu of each transmit ring that is assigned to a
	 * function has a valid mtu.
	 */
	uint16_t mru;
	/*
	 * The maximum receive unit of the function. The HWRM should make sure
	 * that the mru of the function does not exceed the mru of the physical
	 * port that this function is associated with. In addition to
	 * configuring mru per function, it is possible to configure mru per
	 * vnic. By default, the mru of each vnic associated with a function is
	 * equal to the mru of the function. The HWRM should make sure that the
	 * mru of each vnic that is assigned to a function has a valid mru.
	 */
	uint16_t num_rsscos_ctxs;
	/* The number of RSS/COS contexts requested for the function. */
	uint16_t num_cmpl_rings;
	/*
	 * The number of completion rings requested for the function. This does
	 * not include the rings allocated to any children functions if any.
	 */
	uint16_t num_tx_rings;
	/*
	 * The number of transmit rings requested for the function. This does
	 * not include the rings allocated to any children functions if any.
	 */
	uint16_t num_rx_rings;
	/*
	 * The number of receive rings requested for the function. This does not
	 * include the rings allocated to any children functions if any.
	 */
	uint16_t num_l2_ctxs;
	/* The requested number of L2 contexts for the function. */
	uint16_t num_vnics;
	/* The requested number of vnics for the function. */
	uint16_t num_stat_ctxs;
	/* The requested number of statistic contexts for the function. */
	uint16_t num_hw_ring_grps;
	/*
	 * The number of HW ring groups that should be reserved for this
	 * function.
	 */
	uint8_t dflt_mac_addr[6];
	/* The default MAC address for the function being configured. */
	uint16_t dflt_vlan;
	/*
	 * The default VLAN for the function being configured. This field's
	 * format is same as 802.1Q Tag's Tag Control Information (TCI) format
	 * that includes both Priority Code Point (PCP) and VLAN Identifier
	 * (VID).
	 */
	uint32_t dflt_ip_addr[4]; /* big endian */
	/*
	 * The default IP address for the function being configured. This
	 * address is only used in enabling source property check.
	 */
	uint32_t min_bw;
	/*
	 * Minimum BW allocated for this function. The HWRM will translate this
	 * value into byte counter and time interval used for the scheduler
	 * inside the device.
	 */
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_MASK	UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_SFT		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_LAST	HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_MEGA	(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_KILO	(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_BASE	(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_GIGA	(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_INVALID  (UINT32_C(0x7) << 29)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t max_bw;
	/*
	 * Maximum BW allocated for this function. The HWRM will translate this
	 * value into byte counter and time interval used for the scheduler
	 * inside the device.
	 */
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_MASK	UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_SFT		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BITS		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BYTES		(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_LAST	HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_MEGA	(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_KILO	(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_BASE	(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_GIGA	(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID  (UINT32_C(0x7) << 29)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	uint16_t async_event_cr;
	/*
	 * ID of the target completion ring for receiving asynchronous event
	 * completions. If this field is not valid, then the HWRM shall use the
	 * default completion ring of the function that is being configured as
	 * the target completion ring for providing any asynchronous event
	 * completions for that function. If this field is valid, then the HWRM
	 * shall use the completion ring identified by this ID as the target
	 * completion ring for providing any asynchronous event completions for
	 * the function that is being configured.
	 */
	uint8_t vlan_antispoof_mode;
	/* VLAN Anti-spoofing mode. */
	/* No VLAN anti-spoofing checks are enabled */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_NOCHECK   UINT32_C(0x0)
	/* Validate VLAN against the configured VLAN(s) */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_VALIDATE_VLAN UINT32_C(0x1)
	/* Insert VLAN if it does not exist, otherwise discard */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_IF_VLANDNE UINT32_C(0x2)
	/* Insert VLAN if it does not exist, override VLAN if it exists */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_OR_OVERRIDE_VLAN UINT32_C(0x3)
	uint8_t allowed_vlan_pris;
	/*
	 * This bit field defines VLAN PRIs that are allowed on this function.
	 * If nth bit is set, then VLAN PRI n is allowed on this function.
	 */
	uint8_t evb_mode;
	/*
	 * The HWRM shall allow a PF driver to change EVB mode for the partition
	 * it belongs to. The HWRM shall not allow a VF driver to change the EVB
	 * mode. The HWRM shall take into account the switching of EVB mode from
	 * one to another and reconfigure hardware resources as appropriately.
	 * The switching from VEB to VEPA mode requires the disabling of the
	 * loopback traffic. Additionally, source knock outs are handled
	 * differently in VEB and VEPA modes.
	 */
	/* No Edge Virtual Bridging (EVB) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_NO_EVB		UINT32_C(0x0)
	/* Virtual Ethernet Bridge (VEB) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_VEB		UINT32_C(0x1)
	/* Virtual Ethernet Port Aggregator (VEPA) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_VEPA		UINT32_C(0x2)
	uint8_t unused_2;
	uint16_t num_mcast_filters;
	/*
	 * The number of multicast filters that should be reserved for this
	 * function on the RX side.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_qstats */
/*
 * Description: This command returns statistics of a function. The input FID
 * value is used to indicate what function is being queried. This allows a
 * physical function driver to query virtual functions that are children of the
 * physical function. The HWRM shall return any unsupported counter with a value
 * of 0xFFFFFFFF for 32-bit counters and 0xFFFFFFFFFFFFFFFF for 64-bit counters.
 */
/* Input (24 bytes) */

struct hwrm_func_qstats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being queried. 0xFF... (All Fs)
	 * if the query is for the requesting function.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (176 bytes) */

struct hwrm_func_qstats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t tx_ucast_pkts;
	/* Number of transmitted unicast packets on the function. */
	uint64_t tx_mcast_pkts;
	/* Number of transmitted multicast packets on the function. */
	uint64_t tx_bcast_pkts;
	/* Number of transmitted broadcast packets on the function. */
	uint64_t tx_discard_pkts;
	/*
	 * Number of transmitted packets that were discarded due to internal NIC
	 * resource problems. For transmit, this can only happen if TMP is
	 * configured to allow dropping in HOL blocking conditions, which is not
	 * a normal configuration.
	 */
	uint64_t tx_drop_pkts;
	/*
	 * Number of dropped packets on transmit path on the function. These are
	 * packets that have been marked for drop by the TE CFA block or are
	 * packets that exceeded the transmit MTU limit for the function.
	 */
	uint64_t tx_ucast_bytes;
	/* Number of transmitted bytes for unicast traffic on the function. */
	uint64_t tx_mcast_bytes;
	/* Number of transmitted bytes for multicast traffic on the function. */
	uint64_t tx_bcast_bytes;
	/* Number of transmitted bytes for broadcast traffic on the function. */
	uint64_t rx_ucast_pkts;
	/* Number of received unicast packets on the function. */
	uint64_t rx_mcast_pkts;
	/* Number of received multicast packets on the function. */
	uint64_t rx_bcast_pkts;
	/* Number of received broadcast packets on the function. */
	uint64_t rx_discard_pkts;
	/*
	 * Number of received packets that were discarded on the function due to
	 * resource limitations. This can happen for 3 reasons. # The BD used
	 * for the packet has a bad format. # There were no BDs available in the
	 * ring for the packet. # There were no BDs available on-chip for the
	 * packet.
	 */
	uint64_t rx_drop_pkts;
	/*
	 * Number of dropped packets on received path on the function. These are
	 * packets that have been marked for drop by the RE CFA.
	 */
	uint64_t rx_ucast_bytes;
	/* Number of received bytes for unicast traffic on the function. */
	uint64_t rx_mcast_bytes;
	/* Number of received bytes for multicast traffic on the function. */
	uint64_t rx_bcast_bytes;
	/* Number of received bytes for broadcast traffic on the function. */
	uint64_t rx_agg_pkts;
	/* Number of aggregated unicast packets on the function. */
	uint64_t rx_agg_bytes;
	/* Number of aggregated unicast bytes on the function. */
	uint64_t rx_agg_events;
	/* Number of aggregation events on the function. */
	uint64_t rx_agg_aborts;
	/* Number of aborted aggregations on the function. */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_clr_stats */
/*
 * Description: This command clears statistics of a function. The input FID
 * value is used to indicate what function's statistics is being cleared. This
 * allows a physical function driver to clear statistics of virtual functions
 * that are children of the physical function.
 */
/* Input (24 bytes) */

struct hwrm_func_clr_stats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function. 0xFF... (All Fs) if the query is for the
	 * requesting function.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_clr_stats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_vf_resc_free */
/* Description: This command frees resources of a vf. */
/* Input (24 bytes) */

struct hwrm_func_vf_resc_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t vf_id;
	/*
	 * This value is used to identify a Virtual Function (VF). The scope of
	 * VF ID is local within a PF.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_vf_resc_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_vf_vnic_ids_query */
/* Description: This command is used to query vf vnic ids. */
/* Input (32 bytes) */

struct hwrm_func_vf_vnic_ids_query_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t vf_id;
	/*
	 * This value is used to identify a Virtual Function (VF). The scope of
	 * VF ID is local within a PF.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t max_vnic_id_cnt;
	/* Max number of vnic ids in vnic id table */
	uint64_t vnic_id_tbl_addr;
	/* This is the address for VF VNIC ID table */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_vf_vnic_ids_query_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t vnic_id_cnt;
	/* Actual number of vnic ids Each VNIC ID is written as a 32-bit number. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_drv_rgtr */
/*
 * Description: This command is used by the function driver to register its
 * information with the HWRM. A function driver shall implement this command. A
 * function driver shall use this command during the driver initialization right
 * after the HWRM version discovery and default ring resources allocation.
 */
/* Input (80 bytes) */

struct hwrm_func_drv_rgtr_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', the function driver is requesting all requests
	 * from its children VF drivers to be forwarded to itself. This flag can
	 * only be set by the PF driver. If a VF driver sets this flag, it
	 * should be ignored by the HWRM.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FWD_ALL_MODE	UINT32_C(0x1)
	/*
	 * When this bit is '1', the function is requesting none of the requests
	 * from its children VF drivers to be forwarded to itself. This flag can
	 * only be set by the PF driver. If a VF driver sets this flag, it
	 * should be ignored by the HWRM.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FWD_NONE_MODE	UINT32_C(0x2)
	uint32_t enables;
	/* This bit must be '1' for the os_type field to be configured. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_OS_TYPE	UINT32_C(0x1)
	/* This bit must be '1' for the ver field to be configured. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_VER		UINT32_C(0x2)
	/* This bit must be '1' for the timestamp field to be configured. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_TIMESTAMP	UINT32_C(0x4)
	/* This bit must be '1' for the vf_req_fwd field to be configured. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_VF_REQ_FWD	UINT32_C(0x8)
	/* This bit must be '1' for the async_event_fwd field to be configured. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_ASYNC_EVENT_FWD   UINT32_C(0x10)
	uint16_t os_type;
	/*
	 * This value indicates the type of OS. The values are based on
	 * CIM_OperatingSystem.mof file as published by the DMTF.
	 */
	/* Unknown */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_UNKNOWN	UINT32_C(0x0)
	/* Other OS not listed below. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_OTHER		UINT32_C(0x1)
	/* MSDOS OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_MSDOS		UINT32_C(0xe)
	/* Windows OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WINDOWS	UINT32_C(0x12)
	/* Solaris OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_SOLARIS	UINT32_C(0x1d)
	/* Linux OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_LINUX		UINT32_C(0x24)
	/* FreeBSD OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_FREEBSD	UINT32_C(0x2a)
	/* VMware ESXi OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_ESXI		UINT32_C(0x68)
	/* Microsoft Windows 8 64-bit OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WIN864	UINT32_C(0x73)
	/* Microsoft Windows Server 2012 R2 OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WIN2012R2	UINT32_C(0x74)
	uint8_t ver_maj;
	/* This is the major version of the driver. */
	uint8_t ver_min;
	/* This is the minor version of the driver. */
	uint8_t ver_upd;
	/* This is the update version of the driver. */
	uint8_t unused_0;
	uint16_t unused_1;
	uint32_t timestamp;
	/*
	 * This is a 32-bit timestamp provided by the driver for keep alive. The
	 * timestamp is in multiples of 1ms.
	 */
	uint32_t unused_2;
	uint32_t vf_req_fwd[8];
	/*
	 * This is a 256-bit bit mask provided by the PF driver for letting the
	 * HWRM know what commands issued by the VF driver to the HWRM should be
	 * forwarded to the PF driver. Nth bit refers to the Nth req_type.
	 * Setting Nth bit to 1 indicates that requests from the VF driver with
	 * req_type equal to N shall be forwarded to the parent PF driver. This
	 * field is not valid for the VF driver.
	 */
	uint32_t async_event_fwd[8];
	/*
	 * This is a 256-bit bit mask provided by the function driver (PF or VF
	 * driver) to indicate the list of asynchronous event completions to be
	 * forwarded. Nth bit refers to the Nth event_id. Setting Nth bit to 1
	 * by the function driver shall result in the HWRM forwarding
	 * asynchronous event completion with event_id equal to N. If all bits
	 * are set to 0 (value of 0), then the HWRM shall not forward any
	 * asynchronous event completion to this function driver.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_drv_rgtr_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_drv_unrgtr */
/*
 * Description: This command is used by the function driver to un register with
 * the HWRM. A function driver shall implement this command. A function driver
 * shall use this command during the driver unloading.
 */
/* Input (24 bytes) */

struct hwrm_func_drv_unrgtr_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', the function driver is notifying the HWRM to
	 * prepare for the shutdown.
	 */
	#define HWRM_FUNC_DRV_UNRGTR_INPUT_FLAGS_PREPARE_FOR_SHUTDOWN UINT32_C(0x1)
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_drv_unrgtr_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_buf_rgtr */
/*
 * Description: This command is used by the PF driver to register buffers used
 * in the PF-VF communication with the HWRM. The PF driver uses this command to
 * register buffers for each PF-VF channel. A parent PF may issue this command
 * per child VF. If VF ID is not valid, then this command is used to register
 * buffers for all children VFs of the PF.
 */
/* Input (128 bytes) */

struct hwrm_func_buf_rgtr_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the vf_id field to be configured. */
	#define HWRM_FUNC_BUF_RGTR_INPUT_ENABLES_VF_ID		UINT32_C(0x1)
	/* This bit must be '1' for the err_buf_addr field to be configured. */
	#define HWRM_FUNC_BUF_RGTR_INPUT_ENABLES_ERR_BUF_ADDR	UINT32_C(0x2)
	uint16_t vf_id;
	/*
	 * This value is used to identify a Virtual Function (VF). The scope of
	 * VF ID is local within a PF.
	 */
	uint16_t req_buf_num_pages;
	/* This field represents the number of pages used for request buffer(s). */
	uint16_t req_buf_page_size;
	/* This field represents the page size used for request buffer(s). */
	/* 16 bytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_16B	UINT32_C(0x4)
	/* 4 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_4K	UINT32_C(0xc)
	/* 8 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_8K	UINT32_C(0xd)
	/* 64 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_64K	UINT32_C(0x10)
	/* 2 Mbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_2M	UINT32_C(0x15)
	/* 4 Mbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_4M	UINT32_C(0x16)
	/* 1 Gbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_1G	UINT32_C(0x1e)
	uint16_t req_buf_len;
	/* The length of the request buffer per VF in bytes. */
	uint16_t resp_buf_len;
	/* The length of the response buffer in bytes. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint64_t req_buf_page_addr0;
	/* This field represents the page address of page #0. */
	uint64_t req_buf_page_addr1;
	/* This field represents the page address of page #1. */
	uint64_t req_buf_page_addr2;
	/* This field represents the page address of page #2. */
	uint64_t req_buf_page_addr3;
	/* This field represents the page address of page #3. */
	uint64_t req_buf_page_addr4;
	/* This field represents the page address of page #4. */
	uint64_t req_buf_page_addr5;
	/* This field represents the page address of page #5. */
	uint64_t req_buf_page_addr6;
	/* This field represents the page address of page #6. */
	uint64_t req_buf_page_addr7;
	/* This field represents the page address of page #7. */
	uint64_t req_buf_page_addr8;
	/* This field represents the page address of page #8. */
	uint64_t req_buf_page_addr9;
	/* This field represents the page address of page #9. */
	uint64_t error_buf_addr;
	/*
	 * This field is used to receive the error reporting from the chipset.
	 * Only applicable for PFs.
	 */
	uint64_t resp_buf_addr;
	/* This field is used to receive the response forwarded by the HWRM. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_buf_rgtr_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_buf_unrgtr */
/*
 * Description: This command is used by the PF driver to unregister buffers used
 * in the PF-VF communication with the HWRM. The PF driver uses this command to
 * unregister buffers for PF-VF communication. A parent PF may issue this
 * command to unregister buffers for communication between the PF and a specific
 * VF. If the VF ID is not valid, then this command is used to unregister
 * buffers used for communications with all children VFs of the PF.
 */
/* Input (24 bytes) */

struct hwrm_func_buf_unrgtr_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the vf_id field to be configured. */
	#define HWRM_FUNC_BUF_UNRGTR_INPUT_ENABLES_VF_ID	UINT32_C(0x1)
	uint16_t vf_id;
	/*
	 * This value is used to identify a Virtual Function (VF). The scope of
	 * VF ID is local within a PF.
	 */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_buf_unrgtr_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_func_drv_qver */
/*
 * Description: This command is used to query the version of the driver. Any
 * driver version with major = 0, minor = 0, and update = 0 shall be considered
 * an invalid or unknown version.
 */
/* Input (24 bytes) */

struct hwrm_func_drv_qver_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t reserved;
	/* Reserved for future use */
	uint16_t fid;
	/*
	 * Function ID of the function that is being queried. 0xFF... (All Fs)
	 * if the query is for the requesting function.
	 */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_func_drv_qver_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t os_type;
	/*
	 * This value indicates the type of OS. The values are based on
	 * CIM_OperatingSystem.mof file as published by the DMTF.
	 */
	/* Unknown */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_UNKNOWN	UINT32_C(0x0)
	/* Other OS not listed below. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_OTHER	UINT32_C(0x1)
	/* MSDOS OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_MSDOS	UINT32_C(0xe)
	/* Windows OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WINDOWS	UINT32_C(0x12)
	/* Solaris OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_SOLARIS	UINT32_C(0x1d)
	/* Linux OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_LINUX	UINT32_C(0x24)
	/* FreeBSD OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_FREEBSD	UINT32_C(0x2a)
	/* VMware ESXi OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_ESXI		UINT32_C(0x68)
	/* Microsoft Windows 8 64-bit OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WIN864	UINT32_C(0x73)
	/* Microsoft Windows Server 2012 R2 OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WIN2012R2	UINT32_C(0x74)
	uint8_t ver_maj;
	/* This is the major version of the driver. */
	uint8_t ver_min;
	/* This is the minor version of the driver. */
	uint8_t ver_upd;
	/* This is the update version of the driver. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_phy_cfg */
/*
 * Description: This command configures the PHY device for the port. It allows
 * setting of the most generic settings for the PHY. The HWRM shall complete
 * this command as soon as PHY settings are configured. They may not be applied
 * when the command response is provided. A VF driver shall not be allowed to
 * configure PHY using this command. In a network partition mode, a PF driver
 * shall not be allowed to configure PHY using this command.
 */
/* Input (56 bytes) */

struct hwrm_port_phy_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * When this bit is set to '1', the PHY for the port shall be reset. #
	 * If this bit is set to 1, then the HWRM shall reset the PHY after
	 * applying PHY configuration changes specified in this command. # In
	 * order to guarantee that PHY configuration changes specified in this
	 * command take effect, the HWRM client should set this flag to 1. # If
	 * this bit is not set to 1, then the HWRM may reset the PHY depending
	 * on the current PHY configuration and settings specified in this
	 * command.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_RESET_PHY		UINT32_C(0x1)
	/* deprecated bit. Do not use!!! */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_DEPRECATED	UINT32_C(0x2)
	/*
	 * When this bit is set to '1', the link shall be forced to the
	 * force_link_speed value. When this bit is set to '1', the HWRM client
	 * should not enable any of the auto negotiation related fields
	 * represented by auto_XXX fields in this command. When this bit is set
	 * to '1' and the HWRM client has enabled a auto_XXX field in this
	 * command, then the HWRM shall ignore the enabled auto_XXX field. When
	 * this bit is set to zero, the link shall be allowed to autoneg.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FORCE		UINT32_C(0x4)
	/*
	 * When this bit is set to '1', the auto-negotiation process shall be
	 * restarted on the link.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_RESTART_AUTONEG	UINT32_C(0x8)
	/*
	 * When this bit is set to '1', Energy Efficient Ethernet (EEE) is
	 * requested to be enabled on this link. If EEE is not supported on this
	 * port, then this flag shall be ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_ENABLE	UINT32_C(0x10)
	/*
	 * When this bit is set to '1', Energy Efficient Ethernet (EEE) is
	 * requested to be disabled on this link. If EEE is not supported on
	 * this port, then this flag shall be ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_DISABLE	UINT32_C(0x20)
	/*
	 * When this bit is set to '1' and EEE is enabled on this link, then TX
	 * LPI is requested to be enabled on the link. If EEE is not supported
	 * on this port, then this flag shall be ignored by the HWRM. If EEE is
	 * disabled on this port, then this flag shall be ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_TX_LPI_ENABLE	UINT32_C(0x40)
	/*
	 * When this bit is set to '1' and EEE is enabled on this link, then TX
	 * LPI is requested to be disabled on the link. If EEE is not supported
	 * on this port, then this flag shall be ignored by the HWRM. If EEE is
	 * disabled on this port, then this flag shall be ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_TX_LPI_DISABLE   UINT32_C(0x80)
	/*
	 * When set to 1, then the HWRM shall enable FEC autonegotiation on
	 * this port if supported. When set to 0, then this flag shall be
	 * ignored. If FEC autonegotiation is not supported, then the HWRM shall
	 * ignore this flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_AUTONEG_ENABLE   UINT32_C(0x100)
	/*
	 * When set to 1, then the HWRM shall disable FEC autonegotiation on
	 * this port if supported. When set to 0, then this flag shall be
	 * ignored. If FEC autonegotiation is not supported, then the HWRM shall
	 * ignore this flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_AUTONEG_DISABLE  UINT32_C(0x200)
	/*
	 * When set to 1, then the HWRM shall enable FEC CLAUSE 74 (Fire Code)
	 * on this port if supported. When set to 0, then this flag shall be
	 * ignored. If FEC CLAUSE 74 is not supported, then the HWRM shall
	 * ignore this flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE74_ENABLE  UINT32_C(0x400)
	/*
	 * When set to 1, then the HWRM shall disable FEC CLAUSE 74 (Fire Code)
	 * on this port if supported. When set to 0, then this flag shall be
	 * ignored. If FEC CLAUSE 74 is not supported, then the HWRM shall
	 * ignore this flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE74_DISABLE UINT32_C(0x800)
	/*
	 * When set to 1, then the HWRM shall enable FEC CLAUSE 91 (Reed
	 * Solomon) on this port if supported. When set to 0, then this flag
	 * shall be ignored. If FEC CLAUSE 91 is not supported, then the HWRM
	 * shall ignore this flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE91_ENABLE  UINT32_C(0x1000)
	/*
	 * When set to 1, then the HWRM shall disable FEC CLAUSE 91 (Reed
	 * Solomon) on this port if supported. When set to 0, then this flag
	 * shall be ignored. If FEC CLAUSE 91 is not supported, then the HWRM
	 * shall ignore this flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE91_DISABLE UINT32_C(0x2000)
	/*
	 * When this bit is set to '1', the link shall be forced to be taken
	 * down. # When this bit is set to '1", all other command input settings
	 * related to the link speed shall be ignored. Once the link state is
	 * forced down, it can be explicitly cleared from that state by setting
	 * this flag to '0'. # If this flag is set to '0', then the link shall
	 * be cleared from forced down state if the link is in forced down
	 * state. There may be conditions (e.g. out-of-band or sideband
	 * configuration changes for the link) outside the scope of the HWRM
	 * implementation that may clear forced down link state.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FORCE_LINK_DWN	UINT32_C(0x4000)
	uint32_t enables;
	/* This bit must be '1' for the auto_mode field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_MODE	UINT32_C(0x1)
	/* This bit must be '1' for the auto_duplex field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_DUPLEX	UINT32_C(0x2)
	/* This bit must be '1' for the auto_pause field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_PAUSE	UINT32_C(0x4)
	/* This bit must be '1' for the auto_link_speed field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_LINK_SPEED	UINT32_C(0x8)
	/*
	 * This bit must be '1' for the auto_link_speed_mask field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_LINK_SPEED_MASK UINT32_C(0x10)
	/* This bit must be '1' for the wirespeed field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_WIRESPEED	UINT32_C(0x20)
	/* This bit must be '1' for the lpbk field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_LPBK		UINT32_C(0x40)
	/* This bit must be '1' for the preemphasis field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_PREEMPHASIS	UINT32_C(0x80)
	/* This bit must be '1' for the force_pause field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_FORCE_PAUSE	UINT32_C(0x100)
	/*
	 * This bit must be '1' for the eee_link_speed_mask field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_EEE_LINK_SPEED_MASK UINT32_C(0x200)
	/* This bit must be '1' for the tx_lpi_timer field to be configured. */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_TX_LPI_TIMER	UINT32_C(0x400)
	uint16_t port_id;
	/* Port ID of port that is to be configured. */
	uint16_t force_link_speed;
	/*
	 * This is the speed that will be used if the force bit is '1'. If
	 * unsupported speed is selected, an error will be generated.
	 */
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_100MB	UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_1GB	UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_2GB	UINT32_C(0x14)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_2_5GB	UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_10GB	UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_20GB	UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_25GB	UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_40GB	UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_50GB	UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_100GB	UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_10MB	UINT32_C(0xffff)
	uint8_t auto_mode;
	/*
	 * This value is used to identify what autoneg mode is used when the
	 * link speed is not being forced.
	 */
	/* Disable autoneg or autoneg disabled. No speeds are selected. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_NONE		UINT32_C(0x0)
	/* Select all possible speeds for autoneg mode. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_ALL_SPEEDS	UINT32_C(0x1)
	/*
	 * Select only the auto_link_speed speed for autoneg mode. This
	 * mode has been DEPRECATED. An HWRM client should not use this
	 * mode.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_ONE_SPEED	UINT32_C(0x2)
	/*
	 * Select the auto_link_speed or any speed below that speed for
	 * autoneg. This mode has been DEPRECATED. An HWRM client should
	 * not use this mode.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_ONE_OR_BELOW	UINT32_C(0x3)
	/*
	 * Select the speeds based on the corresponding link speed mask
	 * value that is provided.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_SPEED_MASK	UINT32_C(0x4)
	uint8_t auto_duplex;
	/*
	 * This is the duplex setting that will be used if the autoneg_mode is
	 * "one_speed" or "one_or_below".
	 */
	/* Half Duplex will be requested. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_HALF	UINT32_C(0x0)
	/* Full duplex will be requested. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_FULL	UINT32_C(0x1)
	/* Both Half and Full dupex will be requested. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_BOTH	UINT32_C(0x2)
	uint8_t auto_pause;
	/*
	 * This value is used to configure the pause that will be used for
	 * autonegotiation. Add text on the usage of auto_pause and force_pause.
	 */
	/*
	 * When this bit is '1', Generation of tx pause messages has been
	 * requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_PAUSE_TX		UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages has been
	 * requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_PAUSE_RX		UINT32_C(0x2)
	/*
	 * When set to 1, the advertisement of pause is enabled. # When the
	 * auto_mode is not set to none and this flag is set to 1, then the
	 * auto_pause bits on this port are being advertised and autoneg pause
	 * results are being interpreted. # When the auto_mode is not set to
	 * none and this flag is set to 0, the pause is forced as indicated in
	 * force_pause, and also advertised as auto_pause bits, but the autoneg
	 * results are not interpreted since the pause configuration is being
	 * forced. # When the auto_mode is set to none and this flag is set to
	 * 1, auto_pause bits should be ignored and should be set to 0.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_PAUSE_AUTONEG_PAUSE   UINT32_C(0x4)
	uint8_t unused_0;
	uint16_t auto_link_speed;
	/*
	 * This is the speed that will be used if the autoneg_mode is
	 * "one_speed" or "one_or_below". If an unsupported speed is selected,
	 * an error will be generated.
	 */
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_100MB	UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_1GB	UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_2GB	UINT32_C(0x14)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_2_5GB	UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_10GB	UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_20GB	UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_25GB	UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_40GB	UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_50GB	UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_100GB	UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_10MB	UINT32_C(0xffff)
	uint16_t auto_link_speed_mask;
	/*
	 * This is a mask of link speeds that will be used if autoneg_mode is
	 * "mask". If unsupported speed is enabled an error will be generated.
	 */
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_100MBHD UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_100MB UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_1GBHD UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_1GB   UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_2GB   UINT32_C(0x10)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_2_5GB UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_10GB  UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_20GB  UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_25GB  UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_40GB  UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_50GB  UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_100GB UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_10MBHD UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_10MB  UINT32_C(0x2000)
	uint8_t wirespeed;
	/* This value controls the wirespeed feature. */
	/* Wirespeed feature is disabled. */
	#define HWRM_PORT_PHY_CFG_INPUT_WIRESPEED_OFF		UINT32_C(0x0)
	/* Wirespeed feature is enabled. */
	#define HWRM_PORT_PHY_CFG_INPUT_WIRESPEED_ON		UINT32_C(0x1)
	uint8_t lpbk;
	/* This value controls the loopback setting for the PHY. */
	/* No loopback is selected. Normal operation. */
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_NONE		UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that host
	 * data is sent back to the host without modification.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_LOCAL		UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that port
	 * logic will send packets back out the transmitter that are
	 * received.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_REMOTE		UINT32_C(0x2)
	uint8_t force_pause;
	/*
	 * This value is used to configure the pause that will be used for force
	 * mode.
	 */
	/*
	 * When this bit is '1', Generation of tx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_PAUSE_TX		UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_PAUSE_RX		UINT32_C(0x2)
	uint8_t unused_1;
	uint32_t preemphasis;
	/*
	 * This value controls the pre-emphasis to be used for the link. Driver
	 * should not set this value (use enable.preemphasis = 0) unless driver
	 * is sure of setting. Normally HWRM FW will determine proper pre-
	 * emphasis.
	 */
	uint16_t eee_link_speed_mask;
	/*
	 * Setting for link speed mask that is used to advertise speeds during
	 * autonegotiation when EEE is enabled. This field is valid only when
	 * EEE is enabled. The speeds specified in this field shall be a subset
	 * of speeds specified in auto_link_speed_mask. If EEE is enabled,then
	 * at least one speed shall be provided in this mask.
	 */
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD1  UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_100MB  UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD2  UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_1GB	UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD3  UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD4  UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_10GB   UINT32_C(0x40)
	uint8_t unused_2;
	uint8_t unused_3;
	uint32_t tx_lpi_timer;
	uint32_t unused_4;
	/*
	 * Requested setting of TX LPI timer in microseconds. This field is valid
	 * only when EEE is enabled and TX LPI is enabled.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_TX_LPI_TIMER_MASK	UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_CFG_INPUT_TX_LPI_TIMER_SFT	0
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_port_phy_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_phy_qcfg */
/* Description: This command queries the PHY configuration for the port. */
/* Input (24 bytes) */

struct hwrm_port_phy_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port that is to be queried. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (96 bytes) */

struct hwrm_port_phy_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t link;
	/* This value indicates the current link status. */
	/* There is no link or cable detected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_NO_LINK		UINT32_C(0x0)
	/* There is no link, but a cable has been detected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SIGNAL		UINT32_C(0x1)
	/* There is a link. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_LINK		UINT32_C(0x2)
	uint8_t unused_0;
	uint16_t link_speed;
	/* This value indicates the current link speed of the connection. */
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_100MB	UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_1GB	UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_2GB	UINT32_C(0x14)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_2_5GB	UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_10GB	UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_20GB	UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_25GB	UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_40GB	UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_50GB	UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_100GB	UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_10MB	UINT32_C(0xffff)
	uint8_t duplex_cfg;
	/* This value is indicates the duplex of the current configuration. */
	/* Half Duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_CFG_HALF	UINT32_C(0x0)
	/* Full duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_CFG_FULL	UINT32_C(0x1)
	uint8_t pause;
	/*
	 * This value is used to indicate the current pause configuration. When
	 * autoneg is enabled, this value represents the autoneg results of
	 * pause configuration.
	 */
	/*
	 * When this bit is '1', Generation of tx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PAUSE_TX		UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PAUSE_RX		UINT32_C(0x2)
	uint16_t support_speeds;
	/*
	 * The supported speeds for the port. This is a bit mask. For each speed
	 * that is supported, the corresponding bit will be set to '1'.
	 */
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_100MBHD   UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_100MB	UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_1GBHD	UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_1GB	UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_2GB	UINT32_C(0x10)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_2_5GB	UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_10GB	UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_20GB	UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_25GB	UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_40GB	UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_50GB	UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_100GB	UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_10MBHD	UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_10MB	UINT32_C(0x2000)
	uint16_t force_link_speed;
	/*
	 * Current setting of forced link speed. When the link speed is not
	 * being forced, this value shall be set to 0.
	 */
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_100MB  UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_1GB	UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_2GB	UINT32_C(0x14)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_2_5GB  UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_10GB   UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_20GB   UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_25GB   UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_40GB   UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_50GB   UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_100GB  UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_10MB   UINT32_C(0xffff)
	uint8_t auto_mode;
	/* Current setting of auto negotiation mode. */
	/* Disable autoneg or autoneg disabled. No speeds are selected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_NONE	UINT32_C(0x0)
	/* Select all possible speeds for autoneg mode. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_ALL_SPEEDS	UINT32_C(0x1)
	/*
	 * Select only the auto_link_speed speed for autoneg mode. This
	 * mode has been DEPRECATED. An HWRM client should not use this
	 * mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_ONE_SPEED	UINT32_C(0x2)
	/*
	 * Select the auto_link_speed or any speed below that speed for
	 * autoneg. This mode has been DEPRECATED. An HWRM client should
	 * not use this mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_ONE_OR_BELOW  UINT32_C(0x3)
	/*
	 * Select the speeds based on the corresponding link speed mask
	 * value that is provided.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_SPEED_MASK	UINT32_C(0x4)
	uint8_t auto_pause;
	/*
	 * Current setting of pause autonegotiation. Move autoneg_pause flag
	 * here.
	 */
	/*
	 * When this bit is '1', Generation of tx pause messages has been
	 * requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_PAUSE_TX		UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages has been
	 * requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_PAUSE_RX		UINT32_C(0x2)
	/*
	 * When set to 1, the advertisement of pause is enabled. # When the
	 * auto_mode is not set to none and this flag is set to 1, then the
	 * auto_pause bits on this port are being advertised and autoneg pause
	 * results are being interpreted. # When the auto_mode is not set to
	 * none and this flag is set to 0, the pause is forced as indicated in
	 * force_pause, and also advertised as auto_pause bits, but the autoneg
	 * results are not interpreted since the pause configuration is being
	 * forced. # When the auto_mode is set to none and this flag is set to
	 * 1, auto_pause bits should be ignored and should be set to 0.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_PAUSE_AUTONEG_PAUSE UINT32_C(0x4)
	uint16_t auto_link_speed;
	/*
	 * Current setting for auto_link_speed. This field is only valid when
	 * auto_mode is set to "one_speed" or "one_or_below".
	 */
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_100MB   UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_1GB	UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_2GB	UINT32_C(0x14)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_2_5GB   UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_10GB	UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_20GB	UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_25GB	UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_40GB	UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_50GB	UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_100GB   UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_10MB	UINT32_C(0xffff)
	uint16_t auto_link_speed_mask;
	/*
	 * Current setting for auto_link_speed_mask that is used to advertise
	 * speeds during autonegotiation. This field is only valid when
	 * auto_mode is set to "mask". The speeds specified in this field shall
	 * be a subset of supported speeds on this port.
	 */
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_100MBHD UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_100MB UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_1GBHD UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_1GB UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_2GB UINT32_C(0x10)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_2_5GB UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_10GB UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_20GB UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_25GB UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_40GB UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_50GB UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_100GB UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_10MBHD UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_10MB UINT32_C(0x2000)
	uint8_t wirespeed;
	/* Current setting for wirespeed. */
	/* Wirespeed feature is disabled. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_WIRESPEED_OFF	UINT32_C(0x0)
	/* Wirespeed feature is enabled. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_WIRESPEED_ON		UINT32_C(0x1)
	uint8_t lpbk;
	/* Current setting for loopback. */
	/* No loopback is selected. Normal operation. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_NONE		UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that host
	 * data is sent back to the host without modification.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_LOCAL		UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that port
	 * logic will send packets back out the transmitter that are
	 * received.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_REMOTE		UINT32_C(0x2)
	uint8_t force_pause;
	/*
	 * Current setting of forced pause. When the pause configuration is not
	 * being forced, then this value shall be set to 0.
	 */
	/*
	 * When this bit is '1', Generation of tx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_PAUSE_TX	UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_PAUSE_RX	UINT32_C(0x2)
	uint8_t module_status;
	/*
	 * This value indicates the current status of the optics module on this
	 * port.
	 */
	/* Module is inserted and accepted */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_NONE	UINT32_C(0x0)
	/* Module is rejected and transmit side Laser is disabled. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_DISABLETX UINT32_C(0x1)
	/* Module mismatch warning. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_WARNINGMSG UINT32_C(0x2)
	/* Module is rejected and powered down. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_PWRDOWN   UINT32_C(0x3)
	/* Module is not inserted. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_NOTINSERTED UINT32_C(0x4)
	/* Module status is not applicable. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_NOTAPPLICABLE UINT32_C(0xff)
	uint32_t preemphasis;
	/* Current setting for preemphasis. */
	uint8_t phy_maj;
	/* This field represents the major version of the PHY. */
	uint8_t phy_min;
	/* This field represents the minor version of the PHY. */
	uint8_t phy_bld;
	/* This field represents the build version of the PHY. */
	uint8_t phy_type;
	/* This value represents a PHY type. */
	/* Unknown */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_UNKNOWN	UINT32_C(0x0)
	/* BASE-CR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASECR	UINT32_C(0x1)
	/* BASE-KR4 (Deprecated) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKR4	UINT32_C(0x2)
	/* BASE-LR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASELR	UINT32_C(0x3)
	/* BASE-SR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASESR	UINT32_C(0x4)
	/* BASE-KR2 (Deprecated) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKR2	UINT32_C(0x5)
	/* BASE-KX */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKX	UINT32_C(0x6)
	/* BASE-KR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKR	UINT32_C(0x7)
	/* BASE-T */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASET	UINT32_C(0x8)
	/* EEE capable BASE-T */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASETE	UINT32_C(0x9)
	/* SGMII connected external PHY */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_SGMIIEXTPHY	UINT32_C(0xa)
	/* 25G_BASECR_CA_L */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASECR_CA_L UINT32_C(0xb)
	/* 25G_BASECR_CA_S */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASECR_CA_S UINT32_C(0xc)
	/* 25G_BASECR_CA_N */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASECR_CA_N UINT32_C(0xd)
	/* 25G_BASESR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASESR	UINT32_C(0xe)
	/* 100G_BASECR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASECR4   UINT32_C(0xf)
	/* 100G_BASESR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASESR4   UINT32_C(0x10)
	/* 100G_BASELR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASELR4   UINT32_C(0x11)
	/* 100G_BASEER4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASEER4   UINT32_C(0x12)
	/* 100G_BASESR10 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASESR10  UINT32_C(0x13)
	/* 40G_BASECR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASECR4	UINT32_C(0x14)
	/* 40G_BASESR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASESR4	UINT32_C(0x15)
	/* 40G_BASELR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASELR4	UINT32_C(0x16)
	/* 40G_BASEER4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASEER4	UINT32_C(0x17)
	/* 40G_ACTIVE_CABLE */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_ACTIVE_CABLE UINT32_C(0x18)
	/* 1G_baseT */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_1G_BASET	UINT32_C(0x19)
	/* 1G_baseSX */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_1G_BASESX	UINT32_C(0x1a)
	/* 1G_baseCX */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_1G_BASECX	UINT32_C(0x1b)
	uint8_t media_type;
	/* This value represents a media type. */
	/* Unknown */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_UNKNOWN	UINT32_C(0x0)
	/* Twisted Pair */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_TP	UINT32_C(0x1)
	/* Direct Attached Copper */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_DAC	UINT32_C(0x2)
	/* Fiber */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_FIBRE	UINT32_C(0x3)
	uint8_t xcvr_pkg_type;
	/* This value represents a transceiver type. */
	/* PHY and MAC are in the same package */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_PKG_TYPE_XCVR_INTERNAL UINT32_C(0x1)
	/* PHY and MAC are in different packages */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_PKG_TYPE_XCVR_EXTERNAL UINT32_C(0x2)
	uint8_t eee_config_phy_addr;
	/*
	 * This field represents flags related to EEE configuration. These EEE
	 * configuration flags are valid only when the auto_mode is not set to
	 * none (in other words autonegotiation is enabled).
	 */
	/* This field represents PHY address. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_ADDR_MASK		UINT32_C(0x1f)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_ADDR_SFT		0
	/*
	 * When set to 1, Energy Efficient Ethernet (EEE) mode is enabled.
	 * Speeds for autoneg with EEE mode enabled are based on
	 * eee_link_speed_mask.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_EEE_ENABLED   UINT32_C(0x20)
	/*
	 * This flag is valid only when eee_enabled is set to 1. # If
	 * eee_enabled is set to 0, then EEE mode is disabled and this flag
	 * shall be ignored. # If eee_enabled is set to 1 and this flag is set
	 * to 1, then Energy Efficient Ethernet (EEE) mode is enabled and in
	 * use. # If eee_enabled is set to 1 and this flag is set to 0, then
	 * Energy Efficient Ethernet (EEE) mode is enabled but is currently not
	 * in use.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_EEE_ACTIVE	UINT32_C(0x40)
	/*
	 * This flag is valid only when eee_enabled is set to 1. # If
	 * eee_enabled is set to 0, then EEE mode is disabled and this flag
	 * shall be ignored. # If eee_enabled is set to 1 and this flag is set
	 * to 1, then Energy Efficient Ethernet (EEE) mode is enabled and TX LPI
	 * is enabled. # If eee_enabled is set to 1 and this flag is set to 0,
	 * then Energy Efficient Ethernet (EEE) mode is enabled but TX LPI is
	 * disabled.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_EEE_TX_LPI	UINT32_C(0x80)
	/*
	 * This field represents flags related to EEE configuration. These EEE
	 * configuration flags are valid only when the auto_mode is not set to
	 * none (in other words autonegotiation is enabled).
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_MASK	UINT32_C(0xe0)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_SFT	5
	uint8_t parallel_detect;
	/* Reserved field, set to 0 */
	/*
	 * When set to 1, the parallel detection is used to determine the speed
	 * of the link partner. Parallel detection is used when a
	 * autonegotiation capable device is connected to a link parter that is
	 * not capable of autonegotiation.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PARALLEL_DETECT	UINT32_C(0x1)
	/* Reserved field, set to 0 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_RESERVED_MASK		UINT32_C(0xfe)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_RESERVED_SFT		1
	uint16_t link_partner_adv_speeds;
	/*
	 * The advertised speeds for the port by the link partner. Each
	 * advertised speed will be set to '1'.
	 */
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_100MBHD UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_100MB UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_1GBHD UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_1GB UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_2GB UINT32_C(0x10)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_2_5GB UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_10GB UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_20GB UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_25GB UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_40GB UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_50GB UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_100GB UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_10MBHD UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_10MB UINT32_C(0x2000)
	uint8_t link_partner_adv_auto_mode;
	/*
	 * The advertised autoneg for the port by the link partner. This field
	 * is deprecated and should be set to 0.
	 */
	/* Disable autoneg or autoneg disabled. No speeds are selected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_NONE UINT32_C(0x0)
	/* Select all possible speeds for autoneg mode. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_ALL_SPEEDS UINT32_C(0x1)
	/*
	 * Select only the auto_link_speed speed for autoneg mode. This
	 * mode has been DEPRECATED. An HWRM client should not use this
	 * mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_ONE_SPEED UINT32_C(0x2)
	/*
	 * Select the auto_link_speed or any speed below that speed for
	 * autoneg. This mode has been DEPRECATED. An HWRM client should
	 * not use this mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_ONE_OR_BELOW UINT32_C(0x3)
	/*
	 * Select the speeds based on the corresponding link speed mask
	 * value that is provided.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_SPEED_MASK UINT32_C(0x4)
	uint8_t link_partner_adv_pause;
	/* The advertised pause settings on the port by the link partner. */
	/*
	 * When this bit is '1', Generation of tx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_PAUSE_TX UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages is supported.
	 * Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_PAUSE_RX UINT32_C(0x2)
	uint16_t adv_eee_link_speed_mask;
	/*
	 * Current setting for link speed mask that is used to advertise speeds
	 * during autonegotiation when EEE is enabled. This field is valid only
	 * when eee_enabled flags is set to 1. The speeds specified in this
	 * field shall be a subset of speeds specified in auto_link_speed_mask.
	 */
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD1 UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_100MB UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD2 UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_1GB UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD3 UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD4 UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_10GB UINT32_C(0x40)
	uint16_t link_partner_adv_eee_link_speed_mask;
	/*
	 * Current setting for link speed mask that is advertised by the link
	 * partner when EEE is enabled. This field is valid only when
	 * eee_enabled flags is set to 1.
	 */
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD1 UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_100MB UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD2 UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_1GB UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD3 UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD4 UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_10GB UINT32_C(0x40)
	uint32_t xcvr_identifier_type_tx_lpi_timer;
	/* This value represents transceiver identifier type. */
	/*
	 * Current setting of TX LPI timer in microseconds. This field is valid
	 * only when_eee_enabled flag is set to 1 and tx_lpi_enabled is set to
	 * 1.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_TX_LPI_TIMER_MASK	UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_TX_LPI_TIMER_SFT	0
	/* This value represents transceiver identifier type. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_MASK UINT32_C(0xff000000)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_SFT 24
	/* Unknown */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_UNKNOWN (UINT32_C(0x0) << 24)
	/* SFP/SFP+/SFP28 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_SFP (UINT32_C(0x3) << 24)
	/* QSFP */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_QSFP (UINT32_C(0xc) << 24)
	/* QSFP+ */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_QSFPPLUS (UINT32_C(0xd) << 24)
	/* QSFP28 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_QSFP28 (UINT32_C(0x11) << 24)
	uint16_t fec_cfg;
	/*
	 * This value represents the current configuration of Forward Error
	 * Correction (FEC) on the port.
	 */
	/*
	 * When set to 1, then FEC is not supported on this port. If this flag
	 * is set to 1, then all other FEC configuration flags shall be ignored.
	 * When set to 0, then FEC is supported as indicated by other
	 * configuration flags. If no cable is attached and the HWRM does not
	 * yet know the FEC capability, then the HWRM shall set this flag to 1
	 * when reporting FEC capability.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_NONE_SUPPORTED UINT32_C(0x1)
	/*
	 * When set to 1, then FEC autonegotiation is supported on this port.
	 * When set to 0, then FEC autonegotiation is not supported on this
	 * port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_AUTONEG_SUPPORTED UINT32_C(0x2)
	/*
	 * When set to 1, then FEC autonegotiation is enabled on this port. When
	 * set to 0, then FEC autonegotiation is disabled if supported. This
	 * flag should be ignored if FEC autonegotiation is not supported on
	 * this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_AUTONEG_ENABLED UINT32_C(0x4)
	/*
	 * When set to 1, then FEC CLAUSE 74 (Fire Code) is supported on this
	 * port. When set to 0, then FEC CLAUSE 74 (Fire Code) is not supported
	 * on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE74_SUPPORTED UINT32_C(0x8)
	/*
	 * When set to 1, then FEC CLAUSE 74 (Fire Code) is enabled on this
	 * port. When set to 0, then FEC CLAUSE 74 (Fire Code) is disabled if
	 * supported. This flag should be ignored if FEC CLAUSE 74 is not
	 * supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE74_ENABLED UINT32_C(0x10)
	/*
	 * When set to 1, then FEC CLAUSE 91 (Reed Solomon) is supported on this
	 * port. When set to 0, then FEC CLAUSE 91 (Reed Solomon) is not
	 * supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE91_SUPPORTED UINT32_C(0x20)
	/*
	 * When set to 1, then FEC CLAUSE 91 (Reed Solomon) is enabled on this
	 * port. When set to 0, then FEC CLAUSE 91 (Reed Solomon) is disabled if
	 * supported. This flag should be ignored if FEC CLAUSE 91 is not
	 * supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE91_ENABLED UINT32_C(0x40)
	uint8_t duplex_state;
	/* This value is indicates the duplex of the current connection state. */
	/* Half Duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_STATE_HALF	UINT32_C(0x0)
	/* Full duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_STATE_FULL	UINT32_C(0x1)
	uint8_t unused_1;
	char phy_vendor_name[16];
	/*
	 * Up to 16 bytes of null padded ASCII string representing PHY vendor.
	 * If the string is set to null, then the vendor name is not available.
	 */
	char phy_vendor_partnumber[16];
	/*
	 * Up to 16 bytes of null padded ASCII string that identifies vendor
	 * specific part number of the PHY. If the string is set to null, then
	 * the vendor specific part number is not available.
	 */
	uint32_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_mac_cfg */
/*
 * Description: This command configures the MAC block for the port. # Only PF
 * drivers shall be allowed to configure MAC. # A VF driver should not be
 * allowed to configure MAC using this command. # In a network partition mode, a
 * PF driver should not be allowed to configure MAC using this command. The QoS
 * settings in port_mac_cfg() are global for all ports/functions. If multiple PF
 * drivers on different ports are configuring QoS settings, then the HWRM is not
 * responsible for maintaining consistency between them. A PF driver changing
 * global QoS settings using this command may impact other PF drivers on
 * different ports.
 */
/* Input (40 bytes) */

struct hwrm_port_mac_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * In this field, there are a number of CoS mappings related flags that
	 * are used to configure CoS mappings and their corresponding priorities
	 * in the hardware. For the priorities of CoS mappings, the HWRM uses
	 * the following priority order (high to low) by default: # vlan pri #
	 * ip_dscp # tunnel_vlan_pri # default cos A subset of CoS mappings can
	 * be enabled. If a priority is not specified for an enabled CoS
	 * mapping, the priority will be assigned in the above order for the
	 * enabled CoS mappings. For example, if vlan_pri and ip_dscp CoS
	 * mappings are enabled and their priorities are not specified, the
	 * following priority order (high to low) will be used by the HWRM: #
	 * vlan_pri # ip_dscp # default cos vlan_pri CoS mapping together with
	 * default CoS with lower priority are enabled by default by the HWRM.
	 */
	/*
	 * When this bit is '1', this command will configure the MAC to match
	 * the current link state of the PHY. If the link is not established on
	 * the PHY, then this bit has no effect.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_MATCH_LINK	UINT32_C(0x1)
	/*
	 * When this bit is set to '1', the inner VLAN PRI to CoS mapping is
	 * requested to be enabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_VLAN_PRI2COS_ENABLE  UINT32_C(0x2)
	/*
	 * When this bit is set to '1', tunnel VLAN PRI field to CoS mapping is
	 * requested to be enabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_TUNNEL_PRI2COS_ENABLE UINT32_C(0x4)
	/*
	 * When this bit is set to '1', the IP DSCP to CoS mapping is requested
	 * to be enabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_IP_DSCP2COS_ENABLE   UINT32_C(0x8)
	/*
	 * When this bit is '1', the HWRM is requested to enable timestamp
	 * capture capability on the receive side of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_RX_TS_CAPTURE_ENABLE UINT32_C(0x10)
	/*
	 * When this bit is '1', the HWRM is requested to disable timestamp
	 * capture capability on the receive side of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_RX_TS_CAPTURE_DISABLE UINT32_C(0x20)
	/*
	 * When this bit is '1', the HWRM is requested to enable timestamp
	 * capture capability on the transmit side of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_TX_TS_CAPTURE_ENABLE UINT32_C(0x40)
	/*
	 * When this bit is '1', the HWRM is requested to disable timestamp
	 * capture capability on the transmit side of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_TX_TS_CAPTURE_DISABLE UINT32_C(0x80)
	/*
	 * When this bit is '1', the Out-Of-Box WoL is requested to be enabled
	 * on this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_OOB_WOL_ENABLE	UINT32_C(0x100)
	/*
	 * When this bit is '1', the Out-Of-Box WoL is requested to be
	 * disabled on this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_OOB_WOL_DISABLE	UINT32_C(0x200)
	/*
	 * When this bit is set to '1', the inner VLAN PRI to CoS mapping is
	 * requested to be disabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_VLAN_PRI2COS_DISABLE UINT32_C(0x400)
	/*
	 * When this bit is set to '1', tunnel VLAN PRI field to CoS mapping is
	 * requested to be disabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_TUNNEL_PRI2COS_DISABLE UINT32_C(0x800)
	/*
	 * When this bit is set to '1', the IP DSCP to CoS mapping is requested
	 * to be disabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_IP_DSCP2COS_DISABLE  UINT32_C(0x1000)
	uint32_t enables;
	/* This bit must be '1' for the ipg field to be configured. */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_IPG		UINT32_C(0x1)
	/* This bit must be '1' for the lpbk field to be configured. */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_LPBK		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the vlan_pri2cos_map_pri field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_VLAN_PRI2COS_MAP_PRI UINT32_C(0x4)
	/* This bit must be '1' for the Reserved1 field to be configured. */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_RESERVED1	UINT32_C(0x8)
	/*
	 * This bit must be '1' for the tunnel_pri2cos_map_pri field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_TUNNEL_PRI2COS_MAP_PRI UINT32_C(0x10)
	/* This bit must be '1' for the dscp2cos_map_pri field to be configured. */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_DSCP2COS_MAP_PRI   UINT32_C(0x20)
	/*
	 * This bit must be '1' for the rx_ts_capture_ptp_msg_type field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_RX_TS_CAPTURE_PTP_MSG_TYPE UINT32_C(0x40)
	/*
	 * This bit must be '1' for the tx_ts_capture_ptp_msg_type field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_TX_TS_CAPTURE_PTP_MSG_TYPE UINT32_C(0x80)
	/* This bit must be '1' for the cos_field_cfg field to be configured. */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_COS_FIELD_CFG	UINT32_C(0x100)
	uint16_t port_id;
	/* Port ID of port that is to be configured. */
	uint8_t ipg;
	/*
	 * This value is used to configure the minimum IPG that will be sent
	 * between packets by this port.
	 */
	uint8_t lpbk;
	/* This value controls the loopback setting for the MAC. */
	/* No loopback is selected. Normal operation. */
	#define HWRM_PORT_MAC_CFG_INPUT_LPBK_NONE		UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that host
	 * data is sent back to the host without modification.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_LPBK_LOCAL		UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that port
	 * logic will send packets back out the transmitter that are
	 * received.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_LPBK_REMOTE		UINT32_C(0x2)
	uint8_t vlan_pri2cos_map_pri;
	/*
	 * This value controls the priority setting of VLAN PRI to CoS mapping
	 * based on VLAN Tags of inner packet headers of tunneled packets or
	 * packet headers of non-tunneled packets. # Each XXX_pri variable shall
	 * have a unique priority value when it is being specified. # When
	 * comparing priorities of mappings, higher value indicates higher
	 * priority. For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority.
	 */
	uint8_t reserved1;
	/* Reserved field */
	uint8_t tunnel_pri2cos_map_pri;
	/*
	 * This value controls the priority setting of VLAN PRI to CoS mapping
	 * based on VLAN Tags of tunneled header. This mapping only applies when
	 * tunneled headers are present. # Each XXX_pri variable shall have a
	 * unique priority value when it is being specified. # When comparing
	 * priorities of mappings, higher value indicates higher priority. For
	 * example, a value of 0-3 is returned where 0 is being the lowest
	 * priority and 3 is being the highest priority.
	 */
	uint8_t dscp2pri_map_pri;
	/*
	 * This value controls the priority setting of IP DSCP to CoS mapping
	 * based on inner IP header of tunneled packets or IP header of non-
	 * tunneled packets. # Each XXX_pri variable shall have a unique
	 * priority value when it is being specified. # When comparing
	 * priorities of mappings, higher value indicates higher priority. For
	 * example, a value of 0-3 is returned where 0 is being the lowest
	 * priority and 3 is being the highest priority.
	 */
	uint16_t rx_ts_capture_ptp_msg_type;
	/*
	 * This is a 16-bit bit mask that is used to request a specific
	 * configuration of time stamp capture of PTP messages on the receive
	 * side of this port. This field shall be ignored if the
	 * ptp_rx_ts_capture_enable flag is not set in this command. Otherwise,
	 * if bit 'i' is set, then the HWRM is being requested to configure the
	 * receive side of the port to capture the time stamp of every received
	 * PTP message with messageType field value set to i.
	 */
	uint16_t tx_ts_capture_ptp_msg_type;
	/*
	 * This is a 16-bit bit mask that is used to request a specific
	 * configuration of time stamp capture of PTP messages on the transmit
	 * side of this port. This field shall be ignored if the
	 * ptp_tx_ts_capture_enable flag is not set in this command. Otherwise,
	 * if bit 'i' is set, then the HWRM is being requested to configure the
	 * transmit side of the port to capture the time stamp of every
	 * transmitted PTP message with messageType field value set to i.
	 */
	uint8_t cos_field_cfg;
	/* Configuration of CoS fields. */
	/* Reserved. */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_RSVD1	UINT32_C(0x1)
	/*
	 * This field is used to specify selection of VLAN PRI value based on
	 * whether one or two VLAN Tags are present in the inner packet headers
	 * of tunneled packets or non-tunneled packets. This field is valid only
	 * if inner VLAN PRI to CoS mapping is enabled. If VLAN PRI to CoS
	 * mapping is not enabled, then this field shall be ignored.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_MASK UINT32_C(0x6)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_SFT 1
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are present in
	 * the inner packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_INNERMOST (UINT32_C(0x0) << 1)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are present in the
	 * inner packet headers. No VLAN PRI shall be selected for this
	 * configuration if only one VLAN Tag is present in the inner
	 * packet headers.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTER (UINT32_C(0x1) << 1)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags are present
	 * in the inner packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTERMOST (UINT32_C(0x2) << 1)
	/* Unspecified */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED (UINT32_C(0x3) << 1)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_LAST	HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field is used to specify selection of tunnel VLAN PRI value
	 * based on whether one or two VLAN Tags are present in tunnel headers.
	 * This field is valid only if tunnel VLAN PRI to CoS mapping is
	 * enabled. If tunnel VLAN PRI to CoS mapping is not enabled, then this
	 * field shall be ignored.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_MASK UINT32_C(0x18)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_SFT 3
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are present in
	 * the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_INNERMOST (UINT32_C(0x0) << 3)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are present in the
	 * tunnel packet headers. No tunnel VLAN PRI shall be selected
	 * for this configuration if only one VLAN Tag is present in the
	 * tunnel packet headers.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTER (UINT32_C(0x1) << 3)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags are present
	 * in the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTERMOST (UINT32_C(0x2) << 3)
	/* Unspecified */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED (UINT32_C(0x3) << 3)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_LAST	HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field shall be used to provide default CoS value that has been
	 * configured on this port. This field is valid only if default CoS
	 * mapping is enabled. If default CoS mapping is not enabled, then this
	 * field shall be ignored.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_DEFAULT_COS_MASK UINT32_C(0xe0)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_DEFAULT_COS_SFT 5
	uint8_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_port_mac_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t mru;
	/*
	 * This is the configured maximum length of Ethernet packet payload that
	 * is allowed to be received on the port. This value does not include
	 * the number of bytes used by Ethernet header and trailer (CRC).
	 */
	uint16_t mtu;
	/*
	 * This is the configured maximum length of Ethernet packet payload that
	 * is allowed to be transmitted on the port. This value does not include
	 * the number of bytes used by Ethernet header and trailer (CRC).
	 */
	uint8_t ipg;
	/* Current configuration of the IPG value. */
	uint8_t lpbk;
	/* Current value of the loopback value. */
	/* No loopback is selected. Normal operation. */
	#define HWRM_PORT_MAC_CFG_OUTPUT_LPBK_NONE		UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that host
	 * data is sent back to the host without modification.
	 */
	#define HWRM_PORT_MAC_CFG_OUTPUT_LPBK_LOCAL		UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that port
	 * logic will send packets back out the transmitter that are
	 * received.
	 */
	#define HWRM_PORT_MAC_CFG_OUTPUT_LPBK_REMOTE		UINT32_C(0x2)
	uint8_t unused_0;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_mac_qcfg */
/* Description: This command queries the MAC block for the port. */
/* Input (24 bytes) */

struct hwrm_port_mac_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port that is to be configured. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_port_mac_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t mru;
	/*
	 * This is the configured maximum length of Ethernet packet payload that
	 * is allowed to be received on the port. This value does not include
	 * the number of bytes used by the Ethernet header and trailer (CRC).
	 */
	uint16_t mtu;
	/*
	 * This is the configured maximum length of Ethernet packet payload that
	 * is allowed to be transmitted on the port. This value does not include
	 * the number of bytes used by the Ethernet header and trailer (CRC).
	 */
	uint8_t ipg;
	/* The minimum IPG that will be sent between packets by this port. */
	uint8_t lpbk;
	/* The loopback setting for the MAC. */
	/* No loopback is selected. Normal operation. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_NONE		UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that host
	 * data is sent back to the host without modification.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_LOCAL		UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that port
	 * logic will send packets back out the transmitter that are
	 * received.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_REMOTE		UINT32_C(0x2)
	uint8_t vlan_pri2cos_map_pri;
	/*
	 * Priority setting for VLAN PRI to CoS mapping. # Each XXX_pri variable
	 * shall have a unique priority value when it is being used. # When
	 * comparing priorities of mappings, higher value indicates higher
	 * priority. For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority. # If the
	 * corresponding CoS mapping is not enabled, then this field should be
	 * ignored. # This value indicates the normalized priority value
	 * retained in the HWRM.
	 */
	uint8_t flags;
	/*
	 * In this field, a number of CoS mappings related flags are used to
	 * indicate configured CoS mappings.
	 */
	/*
	 * When this bit is set to '1', the inner VLAN PRI to CoS mapping is
	 * enabled.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_VLAN_PRI2COS_ENABLE UINT32_C(0x1)
	/*
	 * When this bit is set to '1', tunnel VLAN PRI field to CoS mapping is
	 * enabled.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_TUNNEL_PRI2COS_ENABLE UINT32_C(0x2)
	/* When this bit is set to '1', the IP DSCP to CoS mapping is enabled. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_IP_DSCP2COS_ENABLE UINT32_C(0x4)
	/* When this bit is '1', the Out-Of-Box WoL is enabled on this port. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_OOB_WOL_ENABLE	UINT32_C(0x8)
	/* When this bit is '1', PTP is enabled for RX on this port. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_PTP_RX_TS_CAPTURE_ENABLE UINT32_C(0x10)
	/* When this bit is '1', PTP is enabled for TX on this port. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_PTP_TX_TS_CAPTURE_ENABLE UINT32_C(0x20)
	uint8_t tunnel_pri2cos_map_pri;
	/*
	 * Priority setting for tunnel VLAN PRI to CoS mapping. # Each XXX_pri
	 * variable shall have a unique priority value when it is being used. #
	 * When comparing priorities of mappings, higher value indicates higher
	 * priority. For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority. # If the
	 * corresponding CoS mapping is not enabled, then this field should be
	 * ignored. # This value indicates the normalized priority value
	 * retained in the HWRM.
	 */
	uint8_t dscp2pri_map_pri;
	/*
	 * Priority setting for DSCP to PRI mapping. # Each XXX_pri variable
	 * shall have a unique priority value when it is being used. # When
	 * comparing priorities of mappings, higher value indicates higher
	 * priority. For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority. # If the
	 * corresponding CoS mapping is not enabled, then this field should be
	 * ignored. # This value indicates the normalized priority value
	 * retained in the HWRM.
	 */
	uint16_t rx_ts_capture_ptp_msg_type;
	/*
	 * This is a 16-bit bit mask that represents the current configuration
	 * of time stamp capture of PTP messages on the receive side of this
	 * port. If bit 'i' is set, then the receive side of the port is
	 * configured to capture the time stamp of every received PTP message
	 * with messageType field value set to i. If all bits are set to 0 (i.e.
	 * field value set 0), then the receive side of the port is not
	 * configured to capture timestamp for PTP messages. If all bits are set
	 * to 1, then the receive side of the port is configured to capture
	 * timestamp for all PTP messages.
	 */
	uint16_t tx_ts_capture_ptp_msg_type;
	/*
	 * This is a 16-bit bit mask that represents the current configuration
	 * of time stamp capture of PTP messages on the transmit side of this
	 * port. If bit 'i' is set, then the transmit side of the port is
	 * configured to capture the time stamp of every received PTP message
	 * with messageType field value set to i. If all bits are set to 0 (i.e.
	 * field value set 0), then the transmit side of the port is not
	 * configured to capture timestamp for PTP messages. If all bits are set
	 * to 1, then the transmit side of the port is configured to capture
	 * timestamp for all PTP messages.
	 */
	uint8_t cos_field_cfg;
	/* Configuration of CoS fields. */
	/* Reserved */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_RSVD	UINT32_C(0x1)
	/*
	 * This field is used for selecting VLAN PRI value based on whether one
	 * or two VLAN Tags are present in the inner packet headers of tunneled
	 * packets or non-tunneled packets.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_MASK UINT32_C(0x6)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_SFT 1
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are present in
	 * the inner packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_INNERMOST (UINT32_C(0x0) << 1)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are present in the
	 * inner packet headers. No VLAN PRI is selected for this
	 * configuration if only one VLAN Tag is present in the inner
	 * packet headers.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTER (UINT32_C(0x1) << 1)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags are present
	 * in the inner packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTERMOST (UINT32_C(0x2) << 1)
	/* Unspecified */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED (UINT32_C(0x3) << 1)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_LAST	HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field is used for selecting tunnel VLAN PRI value based on
	 * whether one or two VLAN Tags are present in the tunnel headers of
	 * tunneled packets. This selection does not apply to non-tunneled
	 * packets.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_MASK UINT32_C(0x18)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_SFT 3
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are present in
	 * the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_INNERMOST (UINT32_C(0x0) << 3)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are present in the
	 * tunnel packet headers. No VLAN PRI is selected for this
	 * configuration if only one VLAN Tag is present in the tunnel
	 * packet headers.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTER (UINT32_C(0x1) << 3)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags are present
	 * in the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTERMOST (UINT32_C(0x2) << 3)
	/* Unspecified */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED (UINT32_C(0x3) << 3)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_LAST	HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field is used to provide default CoS value that has been
	 * configured on this port.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_DEFAULT_COS_MASK UINT32_C(0xe0)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_DEFAULT_COS_SFT 5
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_mac_ptp_qcfg */
/* Description: This command queries the PTP information for the port. */
/* Input (24 bytes) */

struct hwrm_port_mac_ptp_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port that is being queried. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (80 bytes) */

struct hwrm_port_mac_ptp_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t flags;
	/*
	 * In this field, a number of PTP related flags are used to indicate
	 * configured PTP capabilities.
	 */
	/*
	 * When this bit is set to '1', the PTP related registers are directly
	 * accessible by the host.
	 */
	#define HWRM_PORT_MAC_PTP_QCFG_OUTPUT_FLAGS_DIRECT_ACCESS  UINT32_C(0x1)
	/*
	 * When this bit is set to '1', the PTP information is accessible via
	 * HWRM commands.
	 */
	#define HWRM_PORT_MAC_PTP_QCFG_OUTPUT_FLAGS_HWRM_ACCESS	UINT32_C(0x2)
	uint8_t unused_0;
	uint16_t unused_1;
	uint32_t rx_ts_reg_off_lower;
	/* Offset of the PTP register for the lower 32 bits of timestamp for RX. */
	uint32_t rx_ts_reg_off_upper;
	/* Offset of the PTP register for the upper 32 bits of timestamp for RX. */
	uint32_t rx_ts_reg_off_seq_id;
	/* Offset of the PTP register for the sequence ID for RX. */
	uint32_t rx_ts_reg_off_src_id_0;
	/* Offset of the first PTP source ID for RX. */
	uint32_t rx_ts_reg_off_src_id_1;
	/* Offset of the second PTP source ID for RX. */
	uint32_t rx_ts_reg_off_src_id_2;
	/* Offset of the third PTP source ID for RX. */
	uint32_t rx_ts_reg_off_domain_id;
	/* Offset of the domain ID for RX. */
	uint32_t rx_ts_reg_off_fifo;
	/* Offset of the PTP FIFO register for RX. */
	uint32_t rx_ts_reg_off_fifo_adv;
	/* Offset of the PTP advance FIFO register for RX. */
	uint32_t rx_ts_reg_off_granularity;
	/* PTP timestamp granularity for RX. */
	uint32_t tx_ts_reg_off_lower;
	/* Offset of the PTP register for the lower 32 bits of timestamp for TX. */
	uint32_t tx_ts_reg_off_upper;
	/* Offset of the PTP register for the upper 32 bits of timestamp for TX. */
	uint32_t tx_ts_reg_off_seq_id;
	/* Offset of the PTP register for the sequence ID for TX. */
	uint32_t tx_ts_reg_off_fifo;
	/* Offset of the PTP FIFO register for TX. */
	uint32_t tx_ts_reg_off_granularity;
	/* PTP timestamp granularity for TX. */
	uint32_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_qstats */
/* Description: This function returns per port Ethernet statistics. */
/* Input (40 bytes) */

struct hwrm_port_qstats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port that is being queried. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2[3];
	uint8_t unused_3;
	uint64_t tx_stat_host_addr;
	/* This is the host address where Tx port statistics will be stored */
	uint64_t rx_stat_host_addr;
	/* This is the host address where Rx port statistics will be stored */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_port_qstats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t tx_stat_size;
	/* The size of TX port statistics block in bytes. */
	uint16_t rx_stat_size;
	/* The size of RX port statistics block in bytes. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_lpbk_qstats */
/* Description: This function returns loopback statistics. */
/* Input (16 bytes) */

struct hwrm_port_lpbk_qstats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (96 bytes) */

struct hwrm_port_lpbk_qstats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t lpbk_ucast_frames;
	/* Number of transmitted unicast frames */
	uint64_t lpbk_mcast_frames;
	/* Number of transmitted multicast frames */
	uint64_t lpbk_bcast_frames;
	/* Number of transmitted broadcast frames */
	uint64_t lpbk_ucast_bytes;
	/* Number of transmitted bytes for unicast traffic */
	uint64_t lpbk_mcast_bytes;
	/* Number of transmitted bytes for multicast traffic */
	uint64_t lpbk_bcast_bytes;
	/* Number of transmitted bytes for broadcast traffic */
	uint64_t tx_stat_discard;
	/* Total Tx Drops for loopback traffic reported by STATS block */
	uint64_t tx_stat_error;
	/* Total Tx Error Drops for loopback traffic reported by STATS block */
	uint64_t rx_stat_discard;
	/* Total Rx Drops for loopback traffic reported by STATS block */
	uint64_t rx_stat_error;
	/* Total Rx Error Drops for loopback traffic reported by STATS block */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_clr_stats */
/*
 * Description: This function clears per port statistics. The HWRM shall not
 * allow a VF driver to clear port statistics. The HWRM shall not allow a PF
 * driver to clear port statistics in a partitioning mode. The HWRM may allow a
 * PF driver to clear port statistics in the non-partitioning mode.
 */
/* Input (24 bytes) */

struct hwrm_port_clr_stats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port that is being queried. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_port_clr_stats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_lpbk_clr_stats */
/*
 * Description: This function clears loopback statistics. The HWRM shall not
 * allow a VF driver to clear loopback statistics. The HWRM shall not allow a PF
 * driver to clear loopback statistics in a partitioning mode. The HWRM may
 * allow a PF driver to clear loopback statistics in the non-partitioning mode.
 */
/* Input (16 bytes) */

struct hwrm_port_lpbk_clr_stats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_port_lpbk_clr_stats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_ts_query */
/*
 * Description: This function is used to read timestamp information captured for
 * PTP messages on this port.
 */
/* Input (24 bytes) */

struct hwrm_port_ts_query_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH		UINT32_C(0x1)
	/* tx path */
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_TX		UINT32_C(0x0)
	/* rx path */
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_RX		UINT32_C(0x1)
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_LAST	HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_RX
	uint16_t port_id;
	/* Port ID of port that is being queried. */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_port_ts_query_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t ptp_msg_ts;
	/* Timestamp value of PTP message captured. */
	uint16_t ptp_msg_seqid;
	/* Sequence ID of the PTP message captured. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_phy_qcaps */
/*
 * Description: This function is used to query the current capabilities of PHY
 * on this link.
 */
/* Input (24 bytes) */

struct hwrm_port_phy_qcaps_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port that is being queried. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_port_phy_qcaps_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t flags;
	/* PHY capability flags */
	/*
	 * If set to 1, then this field indicates that the link is capable of
	 * supporting EEE.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_FLAGS_EEE_SUPPORTED	UINT32_C(0x1)
	/*
	 * Reserved field. The HWRM shall set this field to 0. An HWRM client
	 * shall ignore this field.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_FLAGS_RSVD1_MASK	UINT32_C(0xfe)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_FLAGS_RSVD1_SFT	1
	uint8_t port_cnt;
	/* Number of front panel ports for this device. */
	/* Not supported or unknown */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_UNKNOWN	UINT32_C(0x0)
	/* single port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_1		UINT32_C(0x1)
	/* 2-port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_2		UINT32_C(0x2)
	/* 3-port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_3		UINT32_C(0x3)
	/* 4-port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_4		UINT32_C(0x4)
	uint16_t supported_speeds_force_mode;
	/*
	 * This is a bit mask to indicate what speeds are supported as forced
	 * speeds on this link. For each speed that can be forced on this link,
	 * the corresponding mask bit shall be set to '1'.
	 */
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_100MBHD UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_100MB UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_1GBHD UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_1GB UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_2GB UINT32_C(0x10)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_2_5GB UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_10GB UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_20GB UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_25GB UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_40GB UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_50GB UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_100GB UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_10MBHD UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_10MB UINT32_C(0x2000)
	uint16_t supported_speeds_auto_mode;
	/*
	 * This is a bit mask to indicate what speeds are supported for
	 * autonegotiation on this link. For each speed that can be
	 * autonegotiated on this link, the corresponding mask bit shall be set
	 * to '1'.
	 */
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_100MBHD UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_100MB UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_1GBHD UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_1GB UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_2GB UINT32_C(0x10)
	/* 2.5Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_2_5GB UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_10GB UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_20GB UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_25GB UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_40GB UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_50GB UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_100GB UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_10MBHD UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_10MB UINT32_C(0x2000)
	uint16_t supported_speeds_eee_mode;
	/*
	 * This is a bit mask to indicate what speeds are supported for EEE on
	 * this link. For each speed that can be autonegotiated when EEE is
	 * enabled on this link, the corresponding mask bit shall be set to '1'.
	 * This field is only valid when the eee_suppotred is set to '1'.
	 */
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD1 UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_100MB UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD2 UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_1GB UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD3 UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD4 UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_10GB UINT32_C(0x40)
	uint32_t tx_lpi_timer_low;
	/*
	 * Reserved field. The HWRM shall set this field to 0. An HWRM client
	 * shall ignore this field.
	 */
	/*
	 * The lowest value of TX LPI timer that can be set on this link when
	 * EEE is enabled. This value is in microseconds. This field is valid
	 * only when_eee_supported is set to '1'.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_LOW_MASK   UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_LOW_SFT	0
	/*
	 * Reserved field. The HWRM shall set this field to 0. An HWRM client
	 * shall ignore this field.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_RSVD2_MASK		UINT32_C(0xff000000)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_RSVD2_SFT		24
	uint32_t valid_tx_lpi_timer_high;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
	/*
	 * The highest value of TX LPI timer that can be set on this link when
	 * EEE is enabled. This value is in microseconds. This field is valid
	 * only when_eee_supported is set to '1'.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_HIGH_MASK  UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_HIGH_SFT   0
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_VALID_MASK		UINT32_C(0xff000000)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_VALID_SFT		24
} __attribute__((packed));

/* hwrm_port_phy_i2c_read (40 bytes) */
struct hwrm_port_phy_i2c_read_input {
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t req_type;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t cmpl_ring;
	/* This value indicates the command sequence number. */
	uint16_t seq_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint16_t target_id;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t resp_addr;
	uint32_t flags;
	uint32_t enables;
#define HWRM_PORT_PHY_I2C_READ_REQ_ENABLES_PAGE_OFFSET     0x1UL

	uint16_t port_id;
	uint8_t i2c_slave_addr;
	uint8_t unused_0;
	uint16_t page_number;
	uint16_t page_offset;
	uint8_t data_length;
	uint8_t unused_1[7];
} __attribute__((packed));

/* hwrm_port_phy_i2c_read_output (80 bytes)*/
struct hwrm_port_phy_i2c_read_output {
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t error_code;
	/* This field returns the type of original request. */
	uint16_t req_type;
	/* This field provides original sequence number of the command. */
	uint16_t seq_id;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t resp_len;
	uint32_t data[16];
	uint8_t unused_0[7];
	uint8_t valid;
} __attribute__((packed));

/* hwrm_port_led_cfg */
/*
 * Description: This function is used to configure LEDs on a given port. Each
 * port has individual set of LEDs associated with it. These LEDs are used for
 * speed/link configuration as well as activity indicator configuration. Up to
 * three LEDs can be configured, one for activity and two for speeds.
 */
/* Input (64 bytes) */

struct hwrm_port_led_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the led0_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_ID		UINT32_C(0x1)
	/* This bit must be '1' for the led0_state field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_STATE	UINT32_C(0x2)
	/* This bit must be '1' for the led0_color field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_COLOR	UINT32_C(0x4)
	/* This bit must be '1' for the led0_blink_on field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_BLINK_ON	UINT32_C(0x8)
	/* This bit must be '1' for the led0_blink_off field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_BLINK_OFF	UINT32_C(0x10)
	/* This bit must be '1' for the led0_group_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_GROUP_ID	UINT32_C(0x20)
	/* This bit must be '1' for the led1_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_ID		UINT32_C(0x40)
	/* This bit must be '1' for the led1_state field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_STATE	UINT32_C(0x80)
	/* This bit must be '1' for the led1_color field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_COLOR	UINT32_C(0x100)
	/* This bit must be '1' for the led1_blink_on field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_BLINK_ON	UINT32_C(0x200)
	/* This bit must be '1' for the led1_blink_off field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_BLINK_OFF	UINT32_C(0x400)
	/* This bit must be '1' for the led1_group_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_GROUP_ID	UINT32_C(0x800)
	/* This bit must be '1' for the led2_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_ID		UINT32_C(0x1000)
	/* This bit must be '1' for the led2_state field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_STATE	UINT32_C(0x2000)
	/* This bit must be '1' for the led2_color field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_COLOR	UINT32_C(0x4000)
	/* This bit must be '1' for the led2_blink_on field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_BLINK_ON	UINT32_C(0x8000)
	/* This bit must be '1' for the led2_blink_off field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_BLINK_OFF	UINT32_C(0x10000)
	/* This bit must be '1' for the led2_group_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_GROUP_ID	UINT32_C(0x20000)
	/* This bit must be '1' for the led3_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_ID		UINT32_C(0x40000)
	/* This bit must be '1' for the led3_state field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_STATE	UINT32_C(0x80000)
	/* This bit must be '1' for the led3_color field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_COLOR	UINT32_C(0x100000)
	/* This bit must be '1' for the led3_blink_on field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_BLINK_ON	UINT32_C(0x200000)
	/* This bit must be '1' for the led3_blink_off field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_BLINK_OFF	UINT32_C(0x400000)
	/* This bit must be '1' for the led3_group_id field to be configured. */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_GROUP_ID	UINT32_C(0x800000)
	uint16_t port_id;
	/* Port ID of port whose LEDs are configured. */
	uint8_t num_leds;
	/*
	 * The number of LEDs that are being configured. Up to 4 LEDs can be
	 * configured with this command.
	 */
	uint8_t rsvd;
	/* Reserved field. */
	uint8_t led0_id;
	/* An identifier for the LED #0. */
	uint8_t led0_state;
	/* The requested state of the LED #0. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_OFF		UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_ON		UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led0_color;
	/* The requested color of LED #0. */
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_GREENAMBER	UINT32_C(0x3)
	uint8_t unused_0;
	uint16_t led0_blink_on;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led0_blink_off;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led0_group_id;
	/*
	 * An identifier for the group of LEDs that LED #0 belongs to. If set to
	 * 0, then the LED #0 shall not be grouped and shall be treated as an
	 * individual resource. For all other non-zero values of this field, LED
	 * #0 shall be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t rsvd0;
	/* Reserved field. */
	uint8_t led1_id;
	/* An identifier for the LED #1. */
	uint8_t led1_state;
	/* The requested state of the LED #1. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_OFF		UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_ON		UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led1_color;
	/* The requested color of LED #1. */
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_GREENAMBER	UINT32_C(0x3)
	uint8_t unused_1;
	uint16_t led1_blink_on;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led1_blink_off;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led1_group_id;
	/*
	 * An identifier for the group of LEDs that LED #1 belongs to. If set to
	 * 0, then the LED #1 shall not be grouped and shall be treated as an
	 * individual resource. For all other non-zero values of this field, LED
	 * #1 shall be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t rsvd1;
	/* Reserved field. */
	uint8_t led2_id;
	/* An identifier for the LED #2. */
	uint8_t led2_state;
	/* The requested state of the LED #2. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_OFF		UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_ON		UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led2_color;
	/* The requested color of LED #2. */
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_GREENAMBER	UINT32_C(0x3)
	uint8_t unused_2;
	uint16_t led2_blink_on;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led2_blink_off;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led2_group_id;
	/*
	 * An identifier for the group of LEDs that LED #2 belongs to. If set to
	 * 0, then the LED #2 shall not be grouped and shall be treated as an
	 * individual resource. For all other non-zero values of this field, LED
	 * #2 shall be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t rsvd2;
	/* Reserved field. */
	uint8_t led3_id;
	/* An identifier for the LED #3. */
	uint8_t led3_state;
	/* The requested state of the LED #3. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_OFF		UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_ON		UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led3_color;
	/* The requested color of LED #3. */
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_GREENAMBER	UINT32_C(0x3)
	uint8_t unused_3;
	uint16_t led3_blink_on;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led3_blink_off;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led3_group_id;
	/*
	 * An identifier for the group of LEDs that LED #3 belongs to. If set to
	 * 0, then the LED #3 shall not be grouped and shall be treated as an
	 * individual resource. For all other non-zero values of this field, LED
	 * #3 shall be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t rsvd3;
	/* Reserved field. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_port_led_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_led_qcfg */
/*
 * Description: This function is used to query configuration of LEDs on a given
 * port. Each port has individual set of LEDs associated with it. These LEDs are
 * used for speed/link configuration as well as activity indicator
 * configuration. Up to three LEDs can be configured, one for activity and two
 * for speeds.
 */
/* Input (24 bytes) */

struct hwrm_port_led_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port whose LED configuration is being queried. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (56 bytes) */

struct hwrm_port_led_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t num_leds;
	/*
	 * The number of LEDs that are configured on this port. Up to 4 LEDs can
	 * be returned in the response.
	 */
	uint8_t led0_id;
	/* An identifier for the LED #0. */
	uint8_t led0_type;
	/* The type of LED #0. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led0_state;
	/* The current state of the LED #0. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_OFF	UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_ON	UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led0_color;
	/* The color of LED #0. */
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_GREENAMBER   UINT32_C(0x3)
	uint8_t unused_0;
	uint16_t led0_blink_on;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led0_blink_off;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led0_group_id;
	/*
	 * An identifier for the group of LEDs that LED #0 belongs to. If set to
	 * 0, then the LED #0 is not grouped. For all other non-zero values of
	 * this field, LED #0 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t led1_id;
	/* An identifier for the LED #1. */
	uint8_t led1_type;
	/* The type of LED #1. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led1_state;
	/* The current state of the LED #1. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_OFF	UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_ON	UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led1_color;
	/* The color of LED #1. */
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_GREENAMBER   UINT32_C(0x3)
	uint8_t unused_1;
	uint16_t led1_blink_on;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led1_blink_off;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led1_group_id;
	/*
	 * An identifier for the group of LEDs that LED #1 belongs to. If set to
	 * 0, then the LED #1 is not grouped. For all other non-zero values of
	 * this field, LED #1 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t led2_id;
	/* An identifier for the LED #2. */
	uint8_t led2_type;
	/* The type of LED #2. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led2_state;
	/* The current state of the LED #2. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_OFF	UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_ON	UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led2_color;
	/* The color of LED #2. */
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_GREENAMBER   UINT32_C(0x3)
	uint8_t unused_2;
	uint16_t led2_blink_on;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led2_blink_off;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led2_group_id;
	/*
	 * An identifier for the group of LEDs that LED #2 belongs to. If set to
	 * 0, then the LED #2 is not grouped. For all other non-zero values of
	 * this field, LED #2 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t led3_id;
	/* An identifier for the LED #3. */
	uint8_t led3_type;
	/* The type of LED #3. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led3_state;
	/* The current state of the LED #3. */
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_DEFAULT	UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_OFF	UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_ON	UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_BLINK	UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_BLINKALT	UINT32_C(0x4)
	uint8_t led3_color;
	/* The color of LED #3. */
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_DEFAULT	UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_AMBER	UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_GREEN	UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_GREENAMBER   UINT32_C(0x3)
	uint8_t unused_3;
	uint16_t led3_blink_on;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED on between
	 * cycles.
	 */
	uint16_t led3_blink_off;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then this field
	 * represents the requested time in milliseconds to keep LED off between
	 * cycles.
	 */
	uint8_t led3_group_id;
	/*
	 * An identifier for the group of LEDs that LED #3 belongs to. If set to
	 * 0, then the LED #3 is not grouped. For all other non-zero values of
	 * this field, LED #3 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t unused_4;
	uint16_t unused_5;
	uint8_t unused_6;
	uint8_t unused_7;
	uint8_t unused_8;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_port_led_qcaps */
/*
 * Description: This function is used to query capabilities of LEDs on a given
 * port. Each port has individual set of LEDs associated with it. These LEDs are
 * used for speed/link configuration as well as activity indicator
 * configuration.
 */
/* Input (24 bytes) */

struct hwrm_port_led_qcaps_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port whose LED configuration is being queried. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (48 bytes) */

struct hwrm_port_led_qcaps_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t num_leds;
	/*
	 * The number of LEDs that are configured on this port. Up to 4 LEDs can
	 * be returned in the response.
	 */
	uint8_t unused_0[3];
	/* Reserved for future use. */
	uint8_t led0_id;
	/* An identifier for the LED #0. */
	uint8_t led0_type;
	/* The type of LED #0. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led0_group_id;
	/*
	 * An identifier for the group of LEDs that LED #0 belongs to. If set to
	 * 0, then the LED #0 cannot be grouped. For all other non-zero values
	 * of this field, LED #0 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t unused_1;
	uint16_t led0_state_caps;
	/* The states supported by LED #0. */
	/* If set to 1, this LED is enabled. If set to 0, this LED is disabled. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_ENABLED UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED. If set to 0, off
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_OFF_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED. If set to 0, on state
	 * is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_ON_SUPPORTED UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED. If set to 0, blink
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_BLINK_SUPPORTED UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED. If set to 0,
	 * blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_BLINK_ALT_SUPPORTED UINT32_C(0x10)
	uint16_t led0_color_caps;
	/* The colors supported by LED #0. */
	/* reserved */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_COLOR_CAPS_RSVD	UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED. If set to 0, Amber
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_COLOR_CAPS_AMBER_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED. If set to 0, Green
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_COLOR_CAPS_GREEN_SUPPORTED UINT32_C(0x4)
	uint8_t led1_id;
	/* An identifier for the LED #1. */
	uint8_t led1_type;
	/* The type of LED #1. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led1_group_id;
	/*
	 * An identifier for the group of LEDs that LED #1 belongs to. If set to
	 * 0, then the LED #0 cannot be grouped. For all other non-zero values
	 * of this field, LED #0 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t unused_2;
	uint16_t led1_state_caps;
	/* The states supported by LED #1. */
	/* If set to 1, this LED is enabled. If set to 0, this LED is disabled. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_ENABLED UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED. If set to 0, off
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_OFF_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED. If set to 0, on state
	 * is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_ON_SUPPORTED UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED. If set to 0, blink
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_BLINK_SUPPORTED UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED. If set to 0,
	 * blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_BLINK_ALT_SUPPORTED UINT32_C(0x10)
	uint16_t led1_color_caps;
	/* The colors supported by LED #1. */
	/* reserved */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_COLOR_CAPS_RSVD	UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED. If set to 0, Amber
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_COLOR_CAPS_AMBER_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED. If set to 0, Green
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_COLOR_CAPS_GREEN_SUPPORTED UINT32_C(0x4)
	uint8_t led2_id;
	/* An identifier for the LED #2. */
	uint8_t led2_type;
	/* The type of LED #2. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led2_group_id;
	/*
	 * An identifier for the group of LEDs that LED #0 belongs to. If set to
	 * 0, then the LED #0 cannot be grouped. For all other non-zero values
	 * of this field, LED #0 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t unused_3;
	uint16_t led2_state_caps;
	/* The states supported by LED #2. */
	/* If set to 1, this LED is enabled. If set to 0, this LED is disabled. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_ENABLED UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED. If set to 0, off
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_OFF_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED. If set to 0, on state
	 * is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_ON_SUPPORTED UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED. If set to 0, blink
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_BLINK_SUPPORTED UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED. If set to 0,
	 * blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_BLINK_ALT_SUPPORTED UINT32_C(0x10)
	uint16_t led2_color_caps;
	/* The colors supported by LED #2. */
	/* reserved */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_COLOR_CAPS_RSVD	UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED. If set to 0, Amber
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_COLOR_CAPS_AMBER_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED. If set to 0, Green
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_COLOR_CAPS_GREEN_SUPPORTED UINT32_C(0x4)
	uint8_t led3_id;
	/* An identifier for the LED #3. */
	uint8_t led3_type;
	/* The type of LED #3. */
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_SPEED	UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_ACTIVITY	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_INVALID	UINT32_C(0xff)
	uint8_t led3_group_id;
	/*
	 * An identifier for the group of LEDs that LED #3 belongs to. If set to
	 * 0, then the LED #0 cannot be grouped. For all other non-zero values
	 * of this field, LED #0 is grouped together with the LEDs with the same
	 * group ID value.
	 */
	uint8_t unused_4;
	uint16_t led3_state_caps;
	/* The states supported by LED #3. */
	/* If set to 1, this LED is enabled. If set to 0, this LED is disabled. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_ENABLED UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED. If set to 0, off
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_OFF_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED. If set to 0, on state
	 * is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_ON_SUPPORTED UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED. If set to 0, blink
	 * state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_BLINK_SUPPORTED UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED. If set to 0,
	 * blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_BLINK_ALT_SUPPORTED UINT32_C(0x10)
	uint16_t led3_color_caps;
	/* The colors supported by LED #3. */
	/* reserved */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_COLOR_CAPS_RSVD	UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED. If set to 0, Amber
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_COLOR_CAPS_AMBER_SUPPORTED UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED. If set to 0, Green
	 * color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_COLOR_CAPS_GREEN_SUPPORTED UINT32_C(0x4)
	uint8_t unused_5;
	uint8_t unused_6;
	uint8_t unused_7;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_qportcfg */
/*
 * Description: This function is called by a driver to query queue configuration
 * of a port. # The HWRM shall at least advertise one queue with lossy service
 * profile. # The driver shall use this command to query queue ids before
 * configuring or using any queues. # If a service profile is not set for a
 * queue, then the driver shall not use that queue without configuring a service
 * profile for it. # If the driver is not allowed to configure service profiles,
 * then the driver shall only use queues for which service profiles are pre-
 * configured.
 */
/* Input (24 bytes) */

struct hwrm_queue_qportcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH		UINT32_C(0x1)
	/* tx path */
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_TX	UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_RX	UINT32_C(0x1)
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_LAST	HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_RX
	uint16_t port_id;
	/*
	 * Port ID of port for which the queue configuration is being queried.
	 * This field is only required when sent by IPC.
	 */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_queue_qportcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t max_configurable_queues;
	/*
	 * The maximum number of queues that can be configured on this port.
	 * Valid values range from 1 through 8.
	 */
	uint8_t max_configurable_lossless_queues;
	/*
	 * The maximum number of lossless queues that can be configured on this
	 * port. Valid values range from 0 through 8.
	 */
	uint8_t queue_cfg_allowed;
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_cfg command. Each bit represents a specific queue where
	 * bit 0 represents queue 0 and bit 7 represents queue 7. # A value of 0
	 * indicates that the queue is not configurable by the hwrm_queue_cfg
	 * command. # A value of 1 indicates that the queue is configurable. # A
	 * hwrm_queue_cfg command shall return error when trying to configure a
	 * queue not configurable.
	 */
	uint8_t queue_cfg_info;
	/* Information about queue configuration. */
	/*
	 * If this flag is set to '1', then the queues are configured
	 * asymmetrically on TX and RX sides. If this flag is set to '0', then
	 * the queues are configured symmetrically on TX and RX sides. For
	 * symmetric configuration, the queue configuration including queue ids
	 * and service profiles on the TX side is the same as the corresponding
	 * queue configuration on the RX side.
	 */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_CFG_INFO_ASYM_CFG UINT32_C(0x1)
	uint8_t queue_pfcenable_cfg_allowed;
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_pfcenable_cfg command. Each bit represents a specific
	 * priority where bit 0 represents priority 0 and bit 7 represents
	 * priority 7. # A value of 0 indicates that the priority is not
	 * configurable by the hwrm_queue_pfcenable_cfg command. # A value of 1
	 * indicates that the priority is configurable. # A
	 * hwrm_queue_pfcenable_cfg command shall return error when trying to
	 * configure a priority that is not configurable.
	 */
	uint8_t queue_pri2cos_cfg_allowed;
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_pri2cos_cfg command. Each bit represents a specific queue
	 * where bit 0 represents queue 0 and bit 7 represents queue 7. # A
	 * value of 0 indicates that the queue is not configurable by the
	 * hwrm_queue_pri2cos_cfg command. # A value of 1 indicates that the
	 * queue is configurable. # A hwrm_queue_pri2cos_cfg command shall
	 * return error when trying to configure a queue that is not
	 * configurable.
	 */
	uint8_t queue_cos2bw_cfg_allowed;
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_pri2cos_cfg command. Each bit represents a specific queue
	 * where bit 0 represents queue 0 and bit 7 represents queue 7. # A
	 * value of 0 indicates that the queue is not configurable by the
	 * hwrm_queue_pri2cos_cfg command. # A value of 1 indicates that the
	 * queue is configurable. # A hwrm_queue_pri2cos_cfg command shall
	 * return error when trying to configure a queue not configurable.
	 */
	uint8_t queue_id0;
	/*
	 * ID of CoS Queue 0. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id0_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t queue_id1;
	/*
	 * ID of CoS Queue 1. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id1_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t queue_id2;
	/*
	 * ID of CoS Queue 2. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id2_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t queue_id3;
	/*
	 * ID of CoS Queue 3. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id3_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t queue_id4;
	/*
	 * ID of CoS Queue 4. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id4_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t queue_id5;
	/*
	 * ID of CoS Queue 5. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id5_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t queue_id6;
	/*
	 * ID of CoS Queue 6. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id6_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t queue_id7;
	/*
	 * ID of CoS Queue 7. FF - Invalid id # This ID can be used on any
	 * subsequent call to an hwrm command that takes a queue id. # IDs must
	 * always be queried by this command before any use by the driver or
	 * software. # Any driver or software should not make any assumptions
	 * about queue IDs. # A value of 0xff indicates that the queue is not
	 * available. # Available queues may not be in sequential order.
	 */
	uint8_t queue_id7_service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LOSSY UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_UNKNOWN UINT32_C(0xff)
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_qcfg */
/*
 * Description: This function is called by a driver to query a queue
 * configuration.
 */
/* Input (24 bytes) */

struct hwrm_queue_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH		UINT32_C(0x1)
	/* tx path */
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_TX		UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_RX		UINT32_C(0x1)
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_LAST	HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_RX
	uint32_t queue_id;
	/* Queue ID of the queue. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t queue_len;
	/* This value is a the estimate packet length used in the TX arbiter. */
	uint8_t service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_LOSSY	UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_LOSSLESS   UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_UNKNOWN	UINT32_C(0xff)
	uint8_t queue_cfg_info;
	/* Information about queue configuration. */
	/*
	 * If this flag is set to '1', then the queue is configured
	 * asymmetrically on TX and RX sides. If this flag is set to '0', then
	 * this queue is configured symmetrically on TX and RX sides.
	 */
	#define HWRM_QUEUE_QCFG_OUTPUT_QUEUE_CFG_INFO_ASYM_CFG	UINT32_C(0x1)
	uint8_t unused_0;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_cfg */
/* Description: This function is called by a driver to configure a queue. */
/* Input (40 bytes) */

struct hwrm_queue_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX, or both directions applicable to the
	 * resource. This enumeration is used for resources that are similar for
	 * both TX and RX paths of the chip.
	 */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_MASK		UINT32_C(0x3)
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_SFT		0
	/* tx path */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_TX		UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_RX		UINT32_C(0x1)
	/* Bi-directional (Symmetrically applicable to TX and RX paths) */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_BIDIR		UINT32_C(0x2)
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_LAST	HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_BIDIR
	uint32_t enables;
	/* This bit must be '1' for the dflt_len field to be configured. */
	#define HWRM_QUEUE_CFG_INPUT_ENABLES_DFLT_LEN		UINT32_C(0x1)
	/* This bit must be '1' for the service_profile field to be configured. */
	#define HWRM_QUEUE_CFG_INPUT_ENABLES_SERVICE_PROFILE	UINT32_C(0x2)
	uint32_t queue_id;
	/* Queue ID of queue that is to be configured by this function. */
	uint32_t dflt_len;
	/*
	 * This value is a the estimate packet length used in the TX arbiter.
	 * Set to 0xFF... (All Fs) to not adjust this value.
	 */
	uint8_t service_profile;
	/* This value is applicable to CoS queues only. */
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_LOSSY	UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_LOSSLESS	UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_UNKNOWN	UINT32_C(0xff)
	uint8_t unused_0[7];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_pfcenable_qcfg */
/*
 * Description: This function is called by a driver to query PFC configuration
 * for different priorities on that port. This mapping can be different on
 * different ports.
 */
/* Input (24 bytes) */

struct hwrm_queue_pfcenable_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure pri2cos
	 * mapping on this port.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_pfcenable_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t flags;
	/* If set to 1, then PFC is enabled on PRI 0. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI0_PFC_ENABLED UINT32_C(0x1)
	/* If set to 1, then PFC is enabled on PRI 1. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI1_PFC_ENABLED UINT32_C(0x2)
	/* If set to 1, then PFC is enabled on PRI 2. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI2_PFC_ENABLED UINT32_C(0x4)
	/* If set to 1, then PFC is enabled on PRI 3. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI3_PFC_ENABLED UINT32_C(0x8)
	/* If set to 1, then PFC is enabled on PRI 4. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI4_PFC_ENABLED UINT32_C(0x10)
	/* If set to 1, then PFC is enabled on PRI 5. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI5_PFC_ENABLED UINT32_C(0x20)
	/* If set to 1, then PFC is enabled on PRI 6. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI6_PFC_ENABLED UINT32_C(0x40)
	/* If set to 1, then PFC is enabled on PRI 7. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI7_PFC_ENABLED UINT32_C(0x80)
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_pfcenable_cfg */
/*
 * Description: This function is called by a driver to configure the PFC enabled
 * for different priorities on that port. This mapping can be different on
 * different ports.
 */
/* Input (24 bytes) */

struct hwrm_queue_pfcenable_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/* If set to 1, then PFC is requested to be enabled on PRI 0. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI0_PFC_ENABLED UINT32_C(0x1)
	/* If set to 1, then PFC is requested to be enabled on PRI 1. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI1_PFC_ENABLED UINT32_C(0x2)
	/* If set to 1, then PFC is requested to be enabled on PRI 2. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI2_PFC_ENABLED UINT32_C(0x4)
	/* If set to 1, then PFC is requested to be enabled on PRI 3. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI3_PFC_ENABLED UINT32_C(0x8)
	/* If set to 1, then PFC is requested to be enabled on PRI 4. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI4_PFC_ENABLED UINT32_C(0x10)
	/* If set to 1, then PFC is requested to be enabled on PRI 5. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI5_PFC_ENABLED UINT32_C(0x20)
	/* If set to 1, then PFC is requested to be enabled on PRI 6. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI6_PFC_ENABLED UINT32_C(0x40)
	/* If set to 1, then PFC is requested to be enabled on PRI 7. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI7_PFC_ENABLED UINT32_C(0x80)
	uint16_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure pri2cos
	 * mapping on this port.
	 */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_pfcenable_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_pri2cos_qcfg */
/*
 * Description: This function is called by a driver to query configuration of
 * the priority to CoS queue mapping on the transmit side and receive side. This
 * mapping can be different in each direction (TX or RX). This mapping can be
 * different on different ports. Each CoS queue represents a Traffic Class (TC)
 * on that port.
 */
/* Input (24 bytes) */

struct hwrm_queue_pri2cos_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH	UINT32_C(0x1)
	/* tx path */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_TX	(UINT32_C(0x0) << 0)
	/* rx path */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_RX	(UINT32_C(0x1) << 0)
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_LAST	HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_RX
	/*
	 * When this bit is set to '0', the query is for VLAN PRI field in
	 * tunnel headers. When this bit is set to '1', the query is for VLAN
	 * PRI field in inner packet headers.
	 */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_IVLAN	UINT32_C(0x2)
	uint8_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure pri2cos
	 * mapping on this port.
	 */
	uint8_t unused_0[3];
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_queue_pri2cos_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t pri0_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 0. This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t pri1_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 1. This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t pri2_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 2 This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t pri3_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 3. This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t pri4_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 4. This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t pri5_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 5. This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t pri6_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 6. This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t pri7_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 7. This value can only be changed
	 * before traffic has started. A value of 0xff indicates that no CoS
	 * queue is assigned to the specified priority.
	 */
	uint8_t queue_cfg_info;
	/* Information about queue configuration. */
	/*
	 * If this flag is set to '1', then the PRI to CoS configuration is
	 * asymmetric on TX and RX sides. If this flag is set to '0', then PRI
	 * to CoS configuration is symmetric on TX and RX sides.
	 */
	#define HWRM_QUEUE_PRI2COS_QCFG_OUTPUT_QUEUE_CFG_INFO_ASYM_CFG UINT32_C(0x1)
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_pri2cos_cfg */
/*
 * Description: This function is called by a driver to configure the priority to
 * CoS queue mapping on the transmit side and receive side. This mapping can be
 * different in each direction (TX or RX). This mapping can be different on
 * different ports. Each CoS queue represents a Traffic Class (TC) on that port.
 * This command configures the VLAN PRI-to-TC mapping for a specific port in
 * specific direction.
 */
/* Input (40 bytes) */

struct hwrm_queue_pri2cos_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX, or both directions applicable to the
	 * resource. This enumeration is used for resources that are similar for
	 * both TX and RX paths of the chip.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_MASK	UINT32_C(0x3)
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_SFT	0
	/* tx path */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_TX	(UINT32_C(0x0) << 0)
	/* rx path */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_RX	(UINT32_C(0x1) << 0)
	/* Bi-directional (Symmetrically applicable to TX and RX paths) */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_BIDIR	(UINT32_C(0x2) << 0)
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_LAST	HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_BIDIR
	/*
	 * When this bit is set to '0', the mapping is requested for VLAN PRI
	 * field in tunnel headers. When this bit is set to '1', the mapping is
	 * requested for VLAN PRI field in inner packet headers.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_IVLAN	UINT32_C(0x4)
	uint32_t enables;
	/*
	 * This bit must be '1' for the pri0_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI0_COS_QUEUE_ID UINT32_C(0x1)
	/*
	 * This bit must be '1' for the pri1_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI1_COS_QUEUE_ID UINT32_C(0x2)
	/*
	 * This bit must be '1' for the pri2_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI2_COS_QUEUE_ID UINT32_C(0x4)
	/*
	 * This bit must be '1' for the pri3_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI3_COS_QUEUE_ID UINT32_C(0x8)
	/*
	 * This bit must be '1' for the pri4_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI4_COS_QUEUE_ID UINT32_C(0x10)
	/*
	 * This bit must be '1' for the pri5_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI5_COS_QUEUE_ID UINT32_C(0x20)
	/*
	 * This bit must be '1' for the pri6_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI6_COS_QUEUE_ID UINT32_C(0x40)
	/*
	 * This bit must be '1' for the pri7_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI7_COS_QUEUE_ID UINT32_C(0x80)
	uint8_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure pri2cos
	 * mapping on this port.
	 */
	uint8_t pri0_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 0. This value can only be changed
	 * before traffic has started.
	 */
	uint8_t pri1_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 1. This value can only be changed
	 * before traffic has started.
	 */
	uint8_t pri2_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 2 This value can only be changed
	 * before traffic has started.
	 */
	uint8_t pri3_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 3. This value can only be changed
	 * before traffic has started.
	 */
	uint8_t pri4_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 4. This value can only be changed
	 * before traffic has started.
	 */
	uint8_t pri5_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 5. This value can only be changed
	 * before traffic has started.
	 */
	uint8_t pri6_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 6. This value can only be changed
	 * before traffic has started.
	 */
	uint8_t pri7_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 7. This value can only be changed
	 * before traffic has started.
	 */
	uint8_t unused_0[7];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_pri2cos_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_cos2bw_qcfg */
/*
 * Description: This function is called by a driver to query the BW to CoS queue
 * mapping on the transmit side of a specific port. This mapping can be
 * different on different ports. Each CoS queue represents a Traffic Class (TC)
 * on that port. Each traffic class can be assigned a valid combination of the
 * following: - Minimum bandwidth - Maximum bandwidth - Transmission selection
 * algorithm (TSA) - Priority Level (only applies to strict priority COS) -
 * Bandwidth weight # A CoS can be SP or non-SP: A SP CoS always gets the strict
 * priority. Is an COS min BW is set to 0x0 then it is considered to be non-SP;
 * this is a valid configuration. Note: SP provides lower latency in addition to
 * reserved bandwidth # For both SP CoS and non-SP CoS, min BW can be specified
 * to reserve specific amount of the port BW. # The min BW specified for a CoS
 * shall not exceed max port bandwidth. # The total of min BWs specified for all
 * CoS shall not exceed max port bandwidth. # For any non-SP CoS, the minimum
 * bandwidth guarantees are subject to round-robin scheduling. This allows BW
 * reservation with anti-starvation; one CoS will not block another CoS using
 * RR. Note: The bandwidth guarantees for any non-SP CoS are met after servicing
 * all SP CoS. # An SP CoS can potentially starve other lower priority SP CoS
 * and non-SP CoS queues. This can occur to the extent the SP min exceeds the
 * available port BW. # For any CoS, max BW can be specified to limit the BW
 * consumed by the CoS. # The max BW specified for a CoS shall not exceed the
 * max port bandwidth. # The WFQ provides a mechanism for sharing available
 * bandwidth beyond the reserved minimums configured for each CoS. The WFQ
 * scheduler is used to provide the percentages of remaining bandwidth after: *
 * first servicing the reserved bandwidth for all SP CoS, * followed by the
 * reserved bandwidth for all non-SP CoS * All CoS may participate in the WFQ #
 * If a CoS does not have a configured max BW it may use all available bandwidth
 * up to the max port bandwidth Minimum Bandwidth (min BW): # This is the
 * guaranteed bandwidth for the COS. # A value of 0x0 is valid and it means that
 * this COS is not guaranteed any bandwidth. A value of 0xFF.. (all Fs) means
 * min BW is not specified. When the min BW is not specified, the HWRM can set
 * it to any value it considers appropriate. Note: For a non-SP COS, the HWRM
 * should set min BW to 0 when the min BW is not specified. For an SP COS, the
 * HWRM should set min BW to some small value when the min BW is not specified.
 * Maximum Bandwidth: # This is the bandwidth limit of the COS. # Values 0x0 and
 * 0xFF.. (all Fs) are considered unspecified and the HWRM will set the maximum
 * bandwidth to maximum port bandwidth. Priority Level: # It applies only to SP.
 * # This parameter is ignored for non-SP. # 0-7 are valid values (higher value
 * means higher priority) # A priority level can be assigned to at most one SP.
 * # Invalid priority levels assignment for SPs shall result in failure.
 * Additional notes: # The HWRM may have to use min and (max - min) to set
 * appropriate counters of hardware rate limiters. # The bandwidth percentage as
 * specified in the DCB TC BW assignment should be used by the driver to specify
 * maximum bandwidth and bandwidth weight for a COS. For example, the driver
 * should set max BW to 20 Gbps and weight to 50 for two COSs when these two
 * COSs are assigned 50% share of 40 Gbps max port bandwidth.
 */
/* Input (24 bytes) */

struct hwrm_queue_cos2bw_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure TC BW
	 * assignment on this port.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (112 bytes) */

struct hwrm_queue_cos2bw_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t queue_id0;
	/* ID of CoS Queue 0. */
	uint8_t unused_0;
	uint16_t unused_1;
	uint32_t queue_id0_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id0_max_bw;
	/*
	 * Maximum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id0_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id0_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id0_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id1;
	/* ID of CoS Queue 1. */
	uint32_t queue_id1_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id1_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id1_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id1_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id1_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id2;
	/* ID of CoS Queue 2. */
	uint32_t queue_id2_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id2_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id2_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id2_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id2_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id3;
	/* ID of CoS Queue 3. */
	uint32_t queue_id3_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id3_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id3_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id3_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id3_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id4;
	/* ID of CoS Queue 4. */
	uint32_t queue_id4_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id4_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id4_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id4_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id4_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id5;
	/* ID of CoS Queue 5. */
	uint32_t queue_id5_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id5_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id5_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id5_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id5_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id6;
	/* ID of CoS Queue 6. */
	uint32_t queue_id6_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id6_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id6_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id6_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id6_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id7;
	/* ID of CoS Queue 7. */
	uint32_t queue_id7_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id7_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id7_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id7_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id7_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_cos2bw_cfg */
/*
 * Description: This function is called by a driver to configure the BW to CoS
 * queue mapping on the transmit side of a specific port. This mapping can be
 * different on different ports. Each CoS queue represents a Traffic Class (TC)
 * on that port. Each traffic class can be assigned a valid combination of the
 * following: - Minimum bandwidth - Maximum bandwidth - Transmission selection
 * algorithm (TSA) - Priority Level (only applies to strict priority COS) -
 * Bandwidth weight # A CoS can be SP or non-SP: A SP CoS always gets the strict
 * priority. Note: SP provides lower latency in addition to reserved bandwidth #
 * For non-SP CoS, min BW can be specified to reserve specific amount of the
 * port BW. # The min BW specified for a CoS shall not exceed max port
 * bandwidth. # The total of min BWs specified for all CoS shall not exceed max
 * port bandwidth. # For any non-SP CoS, the minimum bandwidth guarantees are
 * subject to round-robin scheduling. This allows BW reservation with anti-
 * starvation; one CoS will not block another CoS using RR. Note: The bandwidth
 * guarantees for any non-SP CoS are met after servicing all SP CoS. # An SP CoS
 * can potentially starve other lower priority SP CoS and non-SP CoS queues.
 * This can occur to the extent the SP min exceeds the available port BW. # For
 * any CoS, max BW can be specified to limit the BW consumed by the CoS. # A max
 * BW can be used for a SP CoS to limit the starvation of other CoS, but using
 * this will cause some characteristics of any ETS CoS to be violated. # The max
 * BW specified for a CoS shall not exceed the max port bandwidth. # For SP CoS,
 * it is recommended to set min and max BW to 0. This instructs the adapter to
 * use default values. # The WFQ provides a mechanism for sharing available
 * bandwidth beyond the reserved minimums configured for each CoS. The WFQ
 * scheduler is used to provide the percentages of remaining bandwidth after: -
 * first servicing the reserved bandwidth for all SP CoS, - followed by the
 * reserved bandwidth for all non-SP CoS - All CoS may participate in the WFQ #
 * If a CoS does not have a configured max BW it may use all available bandwidth
 * up to the max port bandwidth Minimum Bandwidth (min BW): # This is the
 * guaranteed bandwidth for the COS. # A value of 0x0 is valid and it means that
 * this COS is not guaranteed any bandwidth. A value of 0xFF.. (all Fs) means
 * min BW is not specified. When the min BW is not specified, the HWRM can set
 * it to any value it considers appropriate. Note: For a non-SP COS, the HWRM
 * should set min BW to 0 when the min BW is not specified. For an SP COS, min
 * BW value is ignored. Maximum Bandwidth: # This is the bandwidth limit of the
 * COS. # Values 0x0 and 0xFF.. (all Fs) are considered unspecified and the HWRM
 * will set the maximum bandwidth to maximum port bandwidth. Priority Level: #
 * It applies only to SP. # This parameter is ignored for non-SP. # 0-7 are
 * valid values (higher value means higher priority) # A priority level can be
 * assigned to at most one SP. # Invalid priority levels assignment for SPs
 * shall result in failure. Additional notes: # The HWRM may have to use min and
 * (max - min) to set appropriate counters of hardware rate limiters. # The
 * bandwidth percentage as specified in the DCB TC BW assignment should be used
 * by the driver to specify minimum bandwidth and bandwidth weight for a COS.
 * For example, the driver should set max BW to 20 Gbps and weight to 50 for two
 * COSs when these two COSs are assigned 50% share of 40 Gbps max port
 * bandwidth. DCBX use cases should always use max BW of 100% for all ETS CoS
 * queues.
 */
/* Input (128 bytes) */

struct hwrm_queue_cos2bw_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	uint32_t enables;
	/*
	 * If this bit is set to 1, then all queue_id0 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID0_VALID UINT32_C(0x1)
	/*
	 * If this bit is set to 1, then all queue_id1 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID1_VALID UINT32_C(0x2)
	/*
	 * If this bit is set to 1, then all queue_id2 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID2_VALID UINT32_C(0x4)
	/*
	 * If this bit is set to 1, then all queue_id3 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID3_VALID UINT32_C(0x8)
	/*
	 * If this bit is set to 1, then all queue_id4 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID4_VALID UINT32_C(0x10)
	/*
	 * If this bit is set to 1, then all queue_id5 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID5_VALID UINT32_C(0x20)
	/*
	 * If this bit is set to 1, then all queue_id6 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID6_VALID UINT32_C(0x40)
	/*
	 * If this bit is set to 1, then all queue_id7 related parameters in
	 * this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID7_VALID UINT32_C(0x80)
	uint16_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure TC BW
	 * assignment on this port.
	 */
	uint8_t queue_id0;
	/* ID of CoS Queue 0. */
	uint8_t unused_0;
	uint32_t queue_id0_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id0_max_bw;
	/*
	 * Maximum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id0_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id0_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id0_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id1;
	/* ID of CoS Queue 1. */
	uint32_t queue_id1_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id1_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id1_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id1_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id1_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id2;
	/* ID of CoS Queue 2. */
	uint32_t queue_id2_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id2_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id2_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id2_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id2_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id3;
	/* ID of CoS Queue 3. */
	uint32_t queue_id3_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id3_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id3_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id3_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id3_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id4;
	/* ID of CoS Queue 4. */
	uint32_t queue_id4_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id4_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id4_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id4_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id4_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id5;
	/* ID of CoS Queue 5. */
	uint32_t queue_id5_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id5_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id5_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id5_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id5_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id6;
	/* ID of CoS Queue 6. */
	uint32_t queue_id6_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id6_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id6_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id6_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id6_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t queue_id7;
	/* ID of CoS Queue 7. */
	uint32_t queue_id7_min_bw;
	/*
	 * Minimum BW allocated to CoS Queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID
	uint32_t queue_id7_max_bw;
	/*
	 * Maximum BW allocated to CoS queue. The HWRM will translate this value
	 * into byte counter and time interval used for this COS inside the
	 * device.
	 */
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t queue_id7_tsa_assign;
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_SP UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_ETS UINT32_C(0x1)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_FIRST UINT32_C(0x2)
	/* reserved */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_LAST UINT32_C(0xff)
	uint8_t queue_id7_pri_lvl;
	/*
	 * Priority level for strict priority. Valid only when the tsa_assign is
	 * 0 - Strict Priority (SP) 0..7 - Valid values. 8..255 - Reserved.
	 */
	uint8_t queue_id7_bw_weight;
	/*
	 * Weight used to allocate remaining BW for this COS after servicing
	 * guaranteed bandwidths for all COS.
	 */
	uint8_t unused_1[5];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_cos2bw_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_dscp_qcaps */
/*
 * Description: This command is called by a driver to query the DSCP
 * capabilities for a port.
 */
/* Input (24 bytes) */

struct hwrm_queue_dscp_qcaps_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure pri2cos
	 * mapping on this port.
	 */
	uint8_t unused_0[7];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_dscp_qcaps_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t num_dscp_bits;
	/* The number of bits provided by the hardware for the DSCP value. */
	uint8_t unused_0;
	uint16_t max_entries;
	/* Max number of DSCP-MASK-PRI entries supported. */
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_dscp2pri_qcfg */
/*
 * Description: This command is called by a driver to query configuration of the
 * DSCP to PRI mapping on the receive side. This mapping can be different on
 * different ports.
 */
/* Input (32 bytes) */

struct hwrm_queue_dscp2pri_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t dest_data_addr;
	/*
	 * This is the host address where the 24-bits DSCP-MASK-PRI tuple(s)
	 * will be copied to.
	 */
	uint8_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure pri2cos
	 * mapping on this port.
	 */
	uint8_t unused_0;
	uint16_t dest_data_buffer_size;
	/* Size of the buffer pointed to by dest_data_addr. */
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_dscp2pri_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t entry_cnt;
	/*
	 * A count of the number of DSCP-MASK-PRI tuple(s) pointed to by the
	 * dest_data_addr.
	 */
	uint8_t default_pri;
	/*
	 * This is the default PRI which un-initialized DSCP values are mapped
	 * to.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_queue_dscp2pri_cfg */
/*
 * Description: This command is called by a driver to configure the DSCP to PRI
 * mapping on the receive side. This mapping can be different on different
 * ports.
 */
/* Input (40 bytes) */

struct hwrm_queue_dscp2pri_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t src_data_addr;
	/*
	 * This is the host address where the 24-bits DSCP-MASK-PRI tuple will
	 * be copied from.
	 */
	uint32_t flags;
	/* use_hw_default_pri is 1 b */
	#define HWRM_QUEUE_DSCP2PRI_CFG_INPUT_FLAGS_USE_HW_DEFAULT_PRI UINT32_C(0x1)
	uint32_t enables;
	/* This bit must be '1' for the default_pri field to be configured. */
	#define HWRM_QUEUE_DSCP2PRI_CFG_INPUT_ENABLES_DEFAULT_PRI  UINT32_C(0x1)
	uint8_t port_id;
	/*
	 * Port ID of port for which the table is being configured. The HWRM
	 * needs to check whether this function is allowed to configure pri2cos
	 * mapping on this port.
	 */
	uint8_t default_pri;
	/*
	 * This is the default PRI which un-initialized DSCP values will be
	 * mapped to.
	 */
	uint16_t entry_cnt;
	/*
	 * A count of the number of DSCP-MASK-PRI tuple(s) in the data pointed
	 * to by src_data_addr.
	 */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_queue_dscp2pri_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_alloc */
/*
 * Description: This VNIC is a resource in the RX side of the chip that is used
 * to represent a virtual host "interface". # At the time of VNIC allocation or
 * configuration, the function can specify whether it wants the requested VNIC
 * to be the default VNIC for the function or not. # If a function requests
 * allocation of a VNIC for the first time and a VNIC is successfully allocated
 * by the HWRM, then the HWRM shall make the allocated VNIC as the default VNIC
 * for that function. # The default VNIC shall be used for the default action
 * for a partition or function. # For each VNIC allocated on a function, a
 * mapping on the RX side to map the allocated VNIC to source virtual interface
 * shall be performed by the HWRM. This should be hidden to the function driver
 * requesting the VNIC allocation. This enables broadcast/multicast replication
 * with source knockout. # If multicast replication with source knockout is
 * enabled, then the internal VNIC to SVIF mapping data structures shall be
 * programmed at the time of VNIC allocation.
 */
/* Input (24 bytes) */

struct hwrm_vnic_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', this VNIC is requested to be the default VNIC
	 * for this function.
	 */
	#define HWRM_VNIC_ALLOC_INPUT_FLAGS_DEFAULT		UINT32_C(0x1)
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t vnic_id;
	/* Logical vnic ID */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_free */
/*
 * Description: Free a VNIC resource. Idle any resources associated with the
 * VNIC as well as the VNIC. Reset and release all resources associated with the
 * VNIC.
 */
/* Input (24 bytes) */

struct hwrm_vnic_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t vnic_id;
	/* Logical vnic ID */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_cfg */
/* Description: Configure the RX VNIC structure. */
/* Input (40 bytes) */

struct hwrm_vnic_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', the VNIC is requested to be the default VNIC
	 * for the function.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_DEFAULT		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is being configured to strip VLAN in
	 * the RX path. If set to '0', then VLAN stripping is disabled on this
	 * VNIC.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_VLAN_STRIP_MODE	UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is being configured to buffer receive
	 * packets in the hardware until the host posts new receive buffers. If
	 * set to '0', then bd_stall is being configured to be disabled on this
	 * VNIC.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_BD_STALL_MODE		UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is being configured to receive both
	 * RoCE and non-RoCE traffic. If set to '0', then this VNIC is not
	 * configured to be operating in dual VNIC mode.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_ROCE_DUAL_VNIC_MODE	UINT32_C(0x8)
	/*
	 * When this flag is set to '1', the VNIC is requested to be configured
	 * to receive only RoCE traffic. If this flag is set to '0', then this
	 * flag shall be ignored by the HWRM. If roce_dual_vnic_mode flag is set
	 * to '1', then the HWRM client shall not set this flag to '1'.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_ROCE_ONLY_VNIC_MODE	UINT32_C(0x10)
	/*
	 * When a VNIC uses one destination ring group for certain application
	 * (e.g. Receive Flow Steering) where exact match is used to direct
	 * packets to a VNIC with one destination ring group only, there is no
	 * need to configure RSS indirection table for that VNIC as only one
	 * destination ring group is used. This flag is used to enable a mode
	 * where RSS is enabled in the VNIC using a RSS context for computing
	 * RSS hash but the RSS indirection table is not configured using
	 * hwrm_vnic_rss_cfg. If this mode is enabled, then the driver should
	 * not program RSS indirection table for the RSS context that is used
	 * for computing RSS hash only.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_RSS_DFLT_CR_MODE	UINT32_C(0x20)
	uint32_t enables;
	/* This bit must be '1' for the dflt_ring_grp field to be configured. */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_DFLT_RING_GRP	UINT32_C(0x1)
	/* This bit must be '1' for the rss_rule field to be configured. */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_RSS_RULE		UINT32_C(0x2)
	/* This bit must be '1' for the cos_rule field to be configured. */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_COS_RULE		UINT32_C(0x4)
	/* This bit must be '1' for the lb_rule field to be configured. */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_LB_RULE		UINT32_C(0x8)
	/* This bit must be '1' for the mru field to be configured. */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_MRU			UINT32_C(0x10)
	uint16_t vnic_id;
	/* Logical vnic ID */
	uint16_t dflt_ring_grp;
	/*
	 * Default Completion ring for the VNIC. This ring will be chosen if
	 * packet does not match any RSS rules and if there is no COS rule.
	 */
	uint16_t rss_rule;
	/*
	 * RSS ID for RSS rule/table structure. 0xFF... (All Fs) if there is no
	 * RSS rule.
	 */
	uint16_t cos_rule;
	/*
	 * RSS ID for COS rule/table structure. 0xFF... (All Fs) if there is no
	 * COS rule.
	 */
	uint16_t lb_rule;
	/*
	 * RSS ID for load balancing rule/table structure. 0xFF... (All Fs) if
	 * there is no LB rule.
	 */
	uint16_t mru;
	/*
	 * The maximum receive unit of the vnic. Each vnic is associated with a
	 * function. The vnic mru value overwrites the mru setting of the
	 * associated function. The HWRM shall make sure that vnic mru does not
	 * exceed the mru of the port the function is associated with.
	 */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_qcfg */
/*
 * Description: Query the RX VNIC structure. This function can be used by a PF
 * driver to query its own VNIC resource or VNIC resource of its child VF. This
 * function can also be used by a VF driver to query its own VNIC resource.
 */
/* Input (32 bytes) */

struct hwrm_vnic_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the vf_id_valid field to be configured. */
	#define HWRM_VNIC_QCFG_INPUT_ENABLES_VF_ID_VALID	UINT32_C(0x1)
	uint32_t vnic_id;
	/* Logical vnic ID */
	uint16_t vf_id;
	/* ID of Virtual Function whose VNIC resource is being queried. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_vnic_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t dflt_ring_grp;
	/* Default Completion ring for the VNIC. */
	uint16_t rss_rule;
	/*
	 * RSS ID for RSS rule/table structure. 0xFF... (All Fs) if there is no
	 * RSS rule.
	 */
	uint16_t cos_rule;
	/*
	 * RSS ID for COS rule/table structure. 0xFF... (All Fs) if there is no
	 * COS rule.
	 */
	uint16_t lb_rule;
	/*
	 * RSS ID for load balancing rule/table structure. 0xFF... (All Fs) if
	 * there is no LB rule.
	 */
	uint16_t mru;
	/* The maximum receive unit of the vnic. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t flags;
	/* When this bit is '1', the VNIC is the default VNIC for the function. */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_DEFAULT		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is configured to strip VLAN in the RX
	 * path. If set to '0', then VLAN stripping is disabled on this VNIC.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_VLAN_STRIP_MODE	UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is configured to buffer receive
	 * packets in the hardware until the host posts new receive buffers. If
	 * set to '0', then bd_stall is disabled on this VNIC.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_BD_STALL_MODE	UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is configured to receive both RoCE and
	 * non-RoCE traffic. If set to '0', then this VNIC is not configured to
	 * operate in dual VNIC mode.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_ROCE_DUAL_VNIC_MODE	UINT32_C(0x8)
	/*
	 * When this flag is set to '1', the VNIC is configured to receive only
	 * RoCE traffic. When this flag is set to '0', the VNIC is not
	 * configured to receive only RoCE traffic. If roce_dual_vnic_mode flag
	 * and this flag both are set to '1', then it is an invalid
	 * configuration of the VNIC. The HWRM should not allow that type of
	 * mis-configuration by HWRM clients.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_ROCE_ONLY_VNIC_MODE	UINT32_C(0x10)
	/*
	 * When a VNIC uses one destination ring group for certain application
	 * (e.g. Receive Flow Steering) where exact match is used to direct
	 * packets to a VNIC with one destination ring group only, there is no
	 * need to configure RSS indirection table for that VNIC as only one
	 * destination ring group is used. When this bit is set to '1', then the
	 * VNIC is enabled in a mode where RSS is enabled in the VNIC using a
	 * RSS context for computing RSS hash but the RSS indirection table is
	 * not configured.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_RSS_DFLT_CR_MODE	UINT32_C(0x20)
	uint32_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_qcaps */
/*
 * Description: This function is used to query the capabilities of VNIC
 * resources.
 */
/* Input (24 bytes) */

struct hwrm_vnic_qcaps_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	uint32_t unused_0;
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_vnic_qcaps_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t mru;
	/* The maximum receive unit that is settable on a vnic. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t flags;
	/* Unused. */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_UNUSED		UINT32_C(0x1)
	/*
	 * When this bit is '1', the capability of stripping VLAN in the RX path
	 * is supported on VNIC(s). If set to '0', then VLAN stripping
	 * capability is not supported on VNIC(s).
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_VLAN_STRIP_CAP	UINT32_C(0x2)
	/*
	 * When this bit is '1', the capability to buffer receive packets in the
	 * hardware until the host posts new receive buffers is supported on
	 * VNIC(s). If set to '0', then bd_stall capability is not supported on
	 * VNIC(s).
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_BD_STALL_CAP	UINT32_C(0x4)
	/*
	 * When this bit is '1', the capability to receive both RoCE and non-
	 * RoCE traffic on VNIC(s) is supported. If set to '0', then the
	 * capability to receive both RoCE and non-RoCE traffic on VNIC(s) is
	 * not supported.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_ROCE_DUAL_VNIC_CAP	UINT32_C(0x8)
	/*
	 * When this bit is set to '1', the capability to configure a VNIC to
	 * receive only RoCE traffic is supported. When this flag is set to '0',
	 * the VNIC capability to configure to receive only RoCE traffic is not
	 * supported.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_ROCE_ONLY_VNIC_CAP	UINT32_C(0x10)
	/*
	 * When this bit is set to '1', then the capability to enable a VNIC in
	 * a mode where RSS context without configuring RSS indirection table is
	 * supported (for RSS hash computation). When this bit is set to '0',
	 * then a VNIC can not be configured with a mode to enable RSS context
	 * without configuring RSS indirection table.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_RSS_DFLT_CR_CAP	UINT32_C(0x20)
	uint32_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_tpa_cfg */
/* Description: This function is used to enable/configure TPA on the VNIC. */
/* Input (40 bytes) */

struct hwrm_vnic_tpa_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', the VNIC shall be configured to perform
	 * transparent packet aggregation (TPA) of non-tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_TPA		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC shall be configured to perform
	 * transparent packet aggregation (TPA) of tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_ENCAP_TPA		UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC shall be configured to perform
	 * transparent packet aggregation (TPA) according to Windows Receive
	 * Segment Coalescing (RSC) rules.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_RSC_WND_UPDATE	UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC shall be configured to perform
	 * transparent packet aggregation (TPA) according to Linux Generic
	 * Receive Offload (GRO) rules.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_GRO		UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC shall be configured to perform
	 * transparent packet aggregation (TPA) for TCP packets with IP ECN set
	 * to non-zero.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_AGG_WITH_ECN	UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC shall be configured to perform
	 * transparent packet aggregation (TPA) for GRE tunneled TCP packets
	 * only if all packets have the same GRE sequence.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_AGG_WITH_SAME_GRE_SEQ UINT32_C(0x20)
	/*
	 * When this bit is '1' and the GRO mode is enabled, the VNIC shall be
	 * configured to perform transparent packet aggregation (TPA) for
	 * TCP/IPv4 packets with consecutively increasing IPIDs. In other words,
	 * the last packet that is being aggregated to an already existing
	 * aggregation context shall have IPID 1 more than the IPID of the last
	 * packet that was aggregated in that aggregation context.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_GRO_IPID_CHECK	UINT32_C(0x40)
	/*
	 * When this bit is '1' and the GRO mode is enabled, the VNIC shall be
	 * configured to perform transparent packet aggregation (TPA) for TCP
	 * packets with the same TTL (IPv4) or Hop limit (IPv6) value.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_GRO_TTL_CHECK	UINT32_C(0x80)
	uint32_t enables;
	/* This bit must be '1' for the max_agg_segs field to be configured. */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MAX_AGG_SEGS	UINT32_C(0x1)
	/* This bit must be '1' for the max_aggs field to be configured. */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MAX_AGGS	UINT32_C(0x2)
	/* This bit must be '1' for the max_agg_timer field to be configured. */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MAX_AGG_TIMER	UINT32_C(0x4)
	/* This bit must be '1' for the min_agg_len field to be configured. */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MIN_AGG_LEN	UINT32_C(0x8)
	uint16_t vnic_id;
	/* Logical vnic ID */
	uint16_t max_agg_segs;
	/*
	 * This is the maximum number of TCP segments that can be aggregated
	 * (unit is Log2). Max value is 31.
	 */
	/* 1 segment */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_1		UINT32_C(0x0)
	/* 2 segments */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_2		UINT32_C(0x1)
	/* 4 segments */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_4		UINT32_C(0x2)
	/* 8 segments */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_8		UINT32_C(0x3)
	/* Any segment size larger than this is not valid */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_MAX	UINT32_C(0x1f)
	uint16_t max_aggs;
	/*
	 * This is the maximum number of aggregations this VNIC is allowed (unit
	 * is Log2). Max value is 7
	 */
	/* 1 aggregation */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_1		UINT32_C(0x0)
	/* 2 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_2		UINT32_C(0x1)
	/* 4 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_4		UINT32_C(0x2)
	/* 8 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_8		UINT32_C(0x3)
	/* 16 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_16		UINT32_C(0x4)
	/* Any aggregation size larger than this is not valid */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_MAX		UINT32_C(0x7)
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t max_agg_timer;
	/*
	 * This is the maximum amount of time allowed for an aggregation context
	 * to complete after it was initiated.
	 */
	uint32_t min_agg_len;
	/*
	 * This is the minimum amount of payload length required to start an
	 * aggregation context.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_tpa_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_tpa_qcfg */
/*
 * Description: This function can be used to query TPA configuration on the
 * VNIC.
 */
/* Input (24 bytes) */

struct hwrm_vnic_tpa_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t vnic_id;
	/* Logical vnic ID */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_vnic_tpa_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', the VNIC is configured to perform transparent
	 * packet aggregation (TPA) of non-tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_TPA		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is configured to perform transparent
	 * packet aggregation (TPA) of tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_ENCAP_TPA	UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is configured to perform transparent
	 * packet aggregation (TPA) according to Windows Receive Segment
	 * Coalescing (RSC) rules.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_RSC_WND_UPDATE	UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is configured to perform transparent
	 * packet aggregation (TPA) according to Linux Generic Receive Offload
	 * (GRO) rules.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_GRO		UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC is configured to perform transparent
	 * packet aggregation (TPA) for TCP packets with IP ECN set to non-zero.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_AGG_WITH_ECN	UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC is configured to perform transparent
	 * packet aggregation (TPA) for GRE tunneled TCP packets only if all
	 * packets have the same GRE sequence.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_AGG_WITH_SAME_GRE_SEQ UINT32_C(0x20)
	/*
	 * When this bit is '1' and the GRO mode is enabled, the VNIC is
	 * configured to perform transparent packet aggregation (TPA) for
	 * TCP/IPv4 packets with consecutively increasing IPIDs. In other words,
	 * the last packet that is being aggregated to an already existing
	 * aggregation context shall have IPID 1 more than the IPID of the last
	 * packet that was aggregated in that aggregation context.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_GRO_IPID_CHECK	UINT32_C(0x40)
	/*
	 * When this bit is '1' and the GRO mode is enabled, the VNIC is
	 * configured to perform transparent packet aggregation (TPA) for TCP
	 * packets with the same TTL (IPv4) or Hop limit (IPv6) value.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_GRO_TTL_CHECK	UINT32_C(0x80)
	uint16_t max_agg_segs;
	/*
	 * This is the maximum number of TCP segments that can be aggregated
	 * (unit is Log2). Max value is 31.
	 */
	/* 1 segment */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_1	UINT32_C(0x0)
	/* 2 segments */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_2	UINT32_C(0x1)
	/* 4 segments */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_4	UINT32_C(0x2)
	/* 8 segments */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_8	UINT32_C(0x3)
	/* Any segment size larger than this is not valid */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_MAX	UINT32_C(0x1f)
	uint16_t max_aggs;
	/*
	 * This is the maximum number of aggregations this VNIC is allowed (unit
	 * is Log2). Max value is 7
	 */
	/* 1 aggregation */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_1		UINT32_C(0x0)
	/* 2 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_2		UINT32_C(0x1)
	/* 4 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_4		UINT32_C(0x2)
	/* 8 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_8		UINT32_C(0x3)
	/* 16 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_16		UINT32_C(0x4)
	/* Any aggregation size larger than this is not valid */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_MAX		UINT32_C(0x7)
	uint32_t max_agg_timer;
	/*
	 * This is the maximum amount of time allowed for an aggregation context
	 * to complete after it was initiated.
	 */
	uint32_t min_agg_len;
	/*
	 * This is the minimum amount of payload length required to start an
	 * aggregation context.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_rss_cfg */
/* Description: This function is used to enable RSS configuration. */
/* Input (48 bytes) */

struct hwrm_vnic_rss_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t hash_type;
	/*
	 * When this bit is '1', the RSS hash shall be computed over source and
	 * destination IPv4 addresses of IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_IPV4		UINT32_C(0x1)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv4 addresses and source/destination ports of
	 * TCP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_TCP_IPV4	UINT32_C(0x2)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv4 addresses and source/destination ports of
	 * UDP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_UDP_IPV4	UINT32_C(0x4)
	/*
	 * When this bit is '1', the RSS hash shall be computed over source and
	 * destination IPv4 addresses of IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_IPV6		UINT32_C(0x8)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv6 addresses and source/destination ports of
	 * TCP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_TCP_IPV6	UINT32_C(0x10)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv6 addresses and source/destination ports of
	 * UDP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_UDP_IPV6	UINT32_C(0x20)
	uint32_t unused_0;
	uint64_t ring_grp_tbl_addr;
	/* This is the address for rss ring group table */
	uint64_t hash_key_tbl_addr;
	/* This is the address for rss hash key table */
	uint16_t rss_ctx_idx;
	/* Index to the rss indirection table. */
	uint16_t unused_1[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_rss_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_rss_qcfg */
/* Description: This function is used to query RSS context configuration. */
/* Input (24 bytes) */

struct hwrm_vnic_rss_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t rss_ctx_idx;
	/* Index to the rss indirection table. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (64 bytes) */

struct hwrm_vnic_rss_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t hash_type;
	/*
	 * When this bit is '1', the RSS hash shall be computed over source and
	 * destination IPv4 addresses of IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_IPV4	UINT32_C(0x1)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv4 addresses and source/destination ports of
	 * TCP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_TCP_IPV4	UINT32_C(0x2)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv4 addresses and source/destination ports of
	 * UDP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_UDP_IPV4	UINT32_C(0x4)
	/*
	 * When this bit is '1', the RSS hash shall be computed over source and
	 * destination IPv4 addresses of IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_IPV6	UINT32_C(0x8)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv6 addresses and source/destination ports of
	 * TCP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_TCP_IPV6	UINT32_C(0x10)
	/*
	 * When this bit is '1', the RSS hash shall be computed over
	 * source/destination IPv6 addresses and source/destination ports of
	 * UDP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_UDP_IPV6	UINT32_C(0x20)
	uint32_t unused_0;
	uint32_t hash_key[10];
	/* This is the value of rss hash key */
	uint32_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_plcmodes_cfg */
/*
 * Description: This function can be used to set placement mode configuration of
 * the VNIC.
 */
/* Input (40 bytes) */

struct hwrm_vnic_plcmodes_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', the VNIC shall be configured to use regular
	 * placement algorithm. By default, the regular placement algorithm
	 * shall be enabled on the VNIC.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_REGULAR_PLACEMENT UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC shall be configured use the jumbo
	 * placement algorithm.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_JUMBO_PLACEMENT UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC shall be configured to enable Header-
	 * Data split for IPv4 packets according to the following rules: # If
	 * the packet is identified as TCP/IPv4, then the packet is split at the
	 * beginning of the TCP payload. # If the packet is identified as
	 * UDP/IPv4, then the packet is split at the beginning of UDP payload. #
	 * If the packet is identified as non-TCP and non-UDP IPv4 packet, then
	 * the packet is split at the beginning of the upper layer protocol
	 * header carried in the IPv4 packet.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_IPV4	UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC shall be configured to enable Header-
	 * Data split for IPv6 packets according to the following rules: # If
	 * the packet is identified as TCP/IPv6, then the packet is split at the
	 * beginning of the TCP payload. # If the packet is identified as
	 * UDP/IPv6, then the packet is split at the beginning of UDP payload. #
	 * If the packet is identified as non-TCP and non-UDP IPv6 packet, then
	 * the packet is split at the beginning of the upper layer protocol
	 * header carried in the IPv6 packet.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_IPV6	UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC shall be configured to enable Header-
	 * Data split for FCoE packets at the beginning of FC payload.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_FCOE	UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC shall be configured to enable Header-
	 * Data split for RoCE packets at the beginning of RoCE payload (after
	 * BTH/GRH headers).
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_ROCE	UINT32_C(0x20)
	uint32_t enables;
	/*
	 * This bit must be '1' for the jumbo_thresh_valid field to be
	 * configured.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_ENABLES_JUMBO_THRESH_VALID UINT32_C(0x1)
	/* This bit must be '1' for the hds_offset_valid field to be configured. */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_ENABLES_HDS_OFFSET_VALID UINT32_C(0x2)
	/*
	 * This bit must be '1' for the hds_threshold_valid field to be
	 * configured.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_ENABLES_HDS_THRESHOLD_VALID UINT32_C(0x4)
	uint32_t vnic_id;
	/* Logical vnic ID */
	uint16_t jumbo_thresh;
	/*
	 * When jumbo placement algorithm is enabled, this value is used to
	 * determine the threshold for jumbo placement. Packets with length
	 * larger than this value will be placed according to the jumbo
	 * placement algorithm.
	 */
	uint16_t hds_offset;
	/*
	 * This value is used to determine the offset into packet buffer where
	 * the split data (payload) will be placed according to one of of HDS
	 * placement algorithm. The lengths of packet buffers provided for split
	 * data shall be larger than this value.
	 */
	uint16_t hds_threshold;
	/*
	 * When one of the HDS placement algorithm is enabled, this value is
	 * used to determine the threshold for HDS placement. Packets with
	 * length larger than this value will be placed according to the HDS
	 * placement algorithm. This value shall be in multiple of 4 bytes.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_plcmodes_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_plcmodes_qcfg */
/*
 * Description: This function can be used to query placement mode configuration
 * of the VNIC.
 */
/* Input (24 bytes) */

struct hwrm_vnic_plcmodes_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t vnic_id;
	/* Logical vnic ID */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_vnic_plcmodes_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t flags;
	/*
	 * When this bit is '1', the VNIC is configured to use regular placement
	 * algorithm.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_REGULAR_PLACEMENT UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is configured to use the jumbo
	 * placement algorithm.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_JUMBO_PLACEMENT UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is configured to enable Header-Data
	 * split for IPv4 packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_IPV4	UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is configured to enable Header-Data
	 * split for IPv6 packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_IPV6	UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC is configured to enable Header-Data
	 * split for FCoE packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_FCOE	UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC is configured to enable Header-Data
	 * split for RoCE packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_ROCE	UINT32_C(0x20)
	/*
	 * When this bit is '1', the VNIC is configured to be the default VNIC
	 * of the requesting function.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_DFLT_VNIC	UINT32_C(0x40)
	uint16_t jumbo_thresh;
	/*
	 * When jumbo placement algorithm is enabled, this value is used to
	 * determine the threshold for jumbo placement. Packets with length
	 * larger than this value will be placed according to the jumbo
	 * placement algorithm.
	 */
	uint16_t hds_offset;
	/*
	 * This value is used to determine the offset into packet buffer where
	 * the split data (payload) will be placed according to one of of HDS
	 * placement algorithm. The lengths of packet buffers provided for split
	 * data shall be larger than this value.
	 */
	uint16_t hds_threshold;
	/*
	 * When one of the HDS placement algorithm is enabled, this value is
	 * used to determine the threshold for HDS placement. Packets with
	 * length larger than this value will be placed according to the HDS
	 * placement algorithm. This value shall be in multiple of 4 bytes.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_rss_cos_lb_ctx_alloc */
/* Description: This function is used to allocate COS/Load Balance context. */
/* Input (16 bytes) */

struct hwrm_vnic_rss_cos_lb_ctx_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_rss_cos_lb_ctx_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t rss_cos_lb_ctx_id;
	/* rss_cos_lb_ctx_id is 16 b */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_vnic_rss_cos_lb_ctx_free */
/* Description: This function can be used to free COS/Load Balance context. */
/* Input (24 bytes) */

struct hwrm_vnic_rss_cos_lb_ctx_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t rss_cos_lb_ctx_id;
	/* rss_cos_lb_ctx_id is 16 b */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_vnic_rss_cos_lb_ctx_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_ring_alloc */
/*
 * Description: This command allocates and does basic preparation for a ring.
 */
/* Input (80 bytes) */

struct hwrm_ring_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the Reserved1 field to be configured. */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_RESERVED1		UINT32_C(0x1)
	/* This bit must be '1' for the ring_arb_cfg field to be configured. */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_RING_ARB_CFG	UINT32_C(0x2)
	/* This bit must be '1' for the Reserved3 field to be configured. */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_RESERVED3		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the stat_ctx_id_valid field to be
	 * configured.
	 */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_STAT_CTX_ID_VALID	UINT32_C(0x8)
	/* This bit must be '1' for the Reserved4 field to be configured. */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_RESERVED4		UINT32_C(0x10)
	/* This bit must be '1' for the max_bw_valid field to be configured. */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_MAX_BW_VALID	UINT32_C(0x20)
	uint8_t ring_type;
	/* Ring Type. */
	/* L2 Completion Ring (CR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_L2_CMPL	UINT32_C(0x0)
	/* TX Ring (TR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_TX		UINT32_C(0x1)
	/* RX Ring (RR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_RX		UINT32_C(0x2)
	/* RoCE Notification Completion Ring (ROCE_CR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_ROCE_CMPL	UINT32_C(0x3)
	uint8_t unused_0;
	uint16_t unused_1;
	uint64_t page_tbl_addr;
	/* This value is a pointer to the page table for the Ring. */
	uint32_t fbo;
	/* First Byte Offset of the first entry in the first page. */
	uint8_t page_size;
	/*
	 * Actual page size in 2^page_size. The supported range is increments in
	 * powers of 2 from 16 bytes to 1GB. - 4 = 16 B Page size is 16 B. - 12
	 * = 4 KB Page size is 4 KB. - 13 = 8 KB Page size is 8 KB. - 16 = 64 KB
	 * Page size is 64 KB. - 21 = 2 MB Page size is 2 MB. - 22 = 4 MB Page
	 * size is 4 MB. - 30 = 1 GB Page size is 1 GB.
	 */
	uint8_t page_tbl_depth;
	/*
	 * This value indicates the depth of page table. For this version of the
	 * specification, value other than 0 or 1 shall be considered as an
	 * invalid value. When the page_tbl_depth = 0, then it is treated as a
	 * special case with the following. 1. FBO and page size fields are not
	 * valid. 2. page_tbl_addr is the physical address of the first element
	 * of the ring.
	 */
	uint8_t unused_2;
	uint8_t unused_3;
	uint32_t length;
	/*
	 * Number of 16B units in the ring. Minimum size for a ring is 16 16B
	 * entries.
	 */
	uint16_t logical_id;
	/*
	 * Logical ring number for the ring to be allocated. This value
	 * determines the position in the doorbell area where the update to the
	 * ring will be made. For completion rings, this value is also the MSI-X
	 * vector number for the function the completion ring is associated
	 * with.
	 */
	uint16_t cmpl_ring_id;
	/*
	 * This field is used only when ring_type is a TX ring. This value
	 * indicates what completion ring the TX ring is associated with.
	 */
	uint16_t queue_id;
	/*
	 * This field is used only when ring_type is a TX ring. This value
	 * indicates what CoS queue the TX ring is associated with.
	 */
	uint8_t unused_4;
	uint8_t unused_5;
	uint32_t reserved1;
	/* This field is reserved for the future use. It shall be set to 0. */
	uint16_t ring_arb_cfg;
	/*
	 * This field is used only when ring_type is a TX ring. This field is
	 * used to configure arbitration related parameters for a TX ring.
	 */
	/* Arbitration policy used for the ring. */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_MASK UINT32_C(0xf)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_SFT  0
	/*
	 * Use strict priority for the TX ring. Priority value is
	 * specified in arb_policy_param
	 */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_SP  (UINT32_C(0x1) << 0)
	/*
	 * Use weighted fair queue arbitration for the TX ring. Weight
	 * is specified in arb_policy_param
	 */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_WFQ (UINT32_C(0x2) << 0)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_LAST	HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_WFQ
	/* Reserved field. */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_RSVD_MASK	UINT32_C(0xf0)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_RSVD_SFT	4
	/*
	 * Arbitration policy specific parameter. # For strict priority
	 * arbitration policy, this field represents a priority value. If set to
	 * 0, then the priority is not specified and the HWRM is allowed to
	 * select any priority for this TX ring. # For weighted fair queue
	 * arbitration policy, this field represents a weight value. If set to
	 * 0, then the weight is not specified and the HWRM is allowed to select
	 * any weight for this TX ring.
	 */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_PARAM_MASK UINT32_C(0xff00)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_PARAM_SFT 8
	uint8_t unused_6;
	uint8_t unused_7;
	uint32_t reserved3;
	/* This field is reserved for the future use. It shall be set to 0. */
	uint32_t stat_ctx_id;
	/*
	 * This field is used only when ring_type is a TX ring. This input
	 * indicates what statistics context this ring should be associated
	 * with.
	 */
	uint32_t reserved4;
	/* This field is reserved for the future use. It shall be set to 0. */
	uint32_t max_bw;
	/*
	 * This field is used only when ring_type is a TX ring to specify
	 * maximum BW allocated to the TX ring. The HWRM will translate this
	 * value into byte counter and time interval used for this ring inside
	 * the device.
	 */
	/* The bandwidth value. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_MASK	UINT32_C(0xfffffff)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_SFT	0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_BITS	(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_BYTES	(UINT32_C(0x1) << 28)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_LAST	HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_MASK	UINT32_C(0xe0000000)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_SFT	29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_MEGA   (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_KILO   (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_BASE   (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_GIGA   (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_LAST	HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	uint8_t int_mode;
	/*
	 * This field is used only when ring_type is a Completion ring. This
	 * value indicates what interrupt mode should be used on this completion
	 * ring. Note: In the legacy interrupt mode, no more than 16 completion
	 * rings are allowed.
	 */
	/* Legacy INTA */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_LEGACY		UINT32_C(0x0)
	/* Reserved */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_RSVD		UINT32_C(0x1)
	/* MSI-X */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_MSIX		UINT32_C(0x2)
	/* No Interrupt - Polled mode */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_POLL		UINT32_C(0x3)
	uint8_t unused_8[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_ring_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t ring_id;
	/*
	 * Physical number of ring allocated. This value shall be unique for a
	 * ring type.
	 */
	uint16_t logical_ring_id;
	/* Logical number of ring allocated. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_ring_free */
/*
 * Description: This command is used to free a ring and associated resources.
 * With QoS and DCBx agents, it is possible the traffic classes will be moved
 * from one CoS queue to another. When this occurs, the driver shall call
 * 'hwrm_ring_free' to free the allocated rings and then call 'hwrm_ring_alloc'
 * to re-allocate each ring and assign it to a new CoS queue. hwrm_ring_free
 * shall be called on a ring only after it has been idle for 500ms or more and
 * no frames have been posted to the ring during this time. All frames queued
 * for transmission shall be completed and at least 500ms time elapsed from the
 * last completion before calling this command.
 */
/* Input (24 bytes) */

struct hwrm_ring_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t ring_type;
	/* Ring Type. */
	/* L2 Completion Ring (CR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_L2_CMPL		UINT32_C(0x0)
	/* TX Ring (TR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_TX		UINT32_C(0x1)
	/* RX Ring (RR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_RX		UINT32_C(0x2)
	/* RoCE Notification Completion Ring (ROCE_CR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_ROCE_CMPL	UINT32_C(0x3)
	uint8_t unused_0;
	uint16_t ring_id;
	/* Physical number of ring allocated. */
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_ring_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_ring_cmpl_ring_qaggint_params */
/*
 * Description: This command is used to query aggregation and interrupt related
 * parameters specified on a given completion ring.
 */
/* Input (24 bytes) */

struct hwrm_ring_cmpl_ring_qaggint_params_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t ring_id;
	/* Physical number of completion ring. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_ring_cmpl_ring_qaggint_params_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t flags;
	/*
	 * When this bit is set to '1', interrupt max timer is reset whenever a
	 * completion is received.
	 */
	#define HWRM_RING_CMPL_RING_QAGGINT_PARAMS_OUTPUT_FLAGS_TIMER_RESET UINT32_C(0x1)
	/*
	 * When this bit is set to '1', ring idle mode aggregation will be
	 * enabled.
	 */
	#define HWRM_RING_CMPL_RING_QAGGINT_PARAMS_OUTPUT_FLAGS_RING_IDLE UINT32_C(0x2)
	uint16_t num_cmpl_dma_aggr;
	/* Number of completions to aggregate before DMA during the normal mode. */
	uint16_t num_cmpl_dma_aggr_during_int;
	/*
	 * Number of completions to aggregate before DMA during the interrupt
	 * mode.
	 */
	uint16_t cmpl_aggr_dma_tmr;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before DMA
	 * during the normal mode (not in interrupt mode).
	 */
	uint16_t cmpl_aggr_dma_tmr_during_int;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before DMA
	 * during the interrupt mode.
	 */
	uint16_t int_lat_tmr_min;
	/* Minimum time (in unit of 80-nsec) between two interrupts. */
	uint16_t int_lat_tmr_max;
	/*
	 * Maximum wait time (in unit of 80-nsec) spent aggregating completions
	 * before signaling the interrupt after the interrupt is enabled.
	 */
	uint16_t num_cmpl_aggr_int;
	/*
	 * Minimum number of completions aggregated before signaling an
	 * interrupt.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_ring_cmpl_ring_cfg_aggint_params */
/*
 * Description: This command is used to configure aggregation and interrupt
 * related parameters specified on a given completion ring.
 */
/* Input (40 bytes) */

struct hwrm_ring_cmpl_ring_cfg_aggint_params_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t ring_id;
	/* Physical number of completion ring. */
	uint16_t flags;
	/*
	 * When this bit is set to '1', interrupt latency max timer is reset
	 * whenever a completion is received.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_FLAGS_TIMER_RESET UINT32_C(0x1)
	/*
	 * When this bit is set to '1', ring idle mode aggregation will be
	 * enabled.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_FLAGS_RING_IDLE UINT32_C(0x2)
	uint16_t num_cmpl_dma_aggr;
	/* Number of completions to aggregate before DMA during the normal mode. */
	uint16_t num_cmpl_dma_aggr_during_int;
	/*
	 * Number of completions to aggregate before DMA during the interrupt
	 * mode.
	 */
	uint16_t cmpl_aggr_dma_tmr;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before DMA
	 * during the normal mode (not in interrupt mode).
	 */
	uint16_t cmpl_aggr_dma_tmr_during_int;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before DMA
	 * during the interrupt mode.
	 */
	uint16_t int_lat_tmr_min;
	/* Minimum time (in unit of 80-nsec) between two interrupts. */
	uint16_t int_lat_tmr_max;
	/*
	 * Maximum wait time (in unit of 80-nsec) spent aggregating cmpls before
	 * signaling the interrupt after the interrupt is enabled.
	 */
	uint16_t num_cmpl_aggr_int;
	/*
	 * Minimum number of completions aggregated before signaling an
	 * interrupt.
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_ring_cmpl_ring_cfg_aggint_params_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_ring_reset */
/*
 * Description: This command is used to reset a given ring. When an RX ring is
 * being reset, the HWRM shall perform TPA flush on all VNICs associated with
 * the RX ring that is being reset.
 */
/* Input (24 bytes) */

struct hwrm_ring_reset_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t ring_type;
	/* Ring Type. */
	/* L2 Completion Ring (CR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_L2_CMPL	UINT32_C(0x0)
	/* TX Ring (TR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_TX		UINT32_C(0x1)
	/* RX Ring (RR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_RX		UINT32_C(0x2)
	/* RoCE Notification Completion Ring (ROCE_CR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_ROCE_CMPL	UINT32_C(0x3)
	uint8_t unused_0;
	uint16_t ring_id;
	/* Physical number of the ring. */
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_ring_reset_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_ring_grp_alloc */
/*
 * Description: This API allocates and does basic preparation for a ring group.
 */
/* Input (24 bytes) */

struct hwrm_ring_grp_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t cr;
	/* This value identifies the CR associated with the ring group. */
	uint16_t rr;
	/* This value identifies the main RR associated with the ring group. */
	uint16_t ar;
	/*
	 * This value identifies the aggregation RR associated with the ring
	 * group. If this value is 0xFF... (All Fs), then no Aggregation ring
	 * will be set.
	 */
	uint16_t sc;
	/*
	 * This value identifies the statistics context associated with the ring
	 * group.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_ring_grp_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t ring_group_id;
	/*
	 * This is the ring group ID value. Use this value to program the
	 * default ring group for the VNIC or as table entries in an RSS/COS
	 * context.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_ring_grp_free */
/*
 * Description: This API frees a ring group and associated resources. # If a
 * ring in the ring group is reset or free, then the associated rings in the
 * ring group shall also be reset/free using hwrm_ring_free. # A function driver
 * shall always use hwrm_ring_grp_free after freeing all rings in a group. # As
 * a part of executing this command, the HWRM shall reset all associated ring
 * group resources.
 */
/* Input (24 bytes) */

struct hwrm_ring_grp_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t ring_group_id;
	/* This is the ring group ID value. */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_ring_grp_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_l2_filter_alloc */
/*
 * Description: An L2 filter is a filter resource that is used to identify a
 * vnic or ring for a packet based on layer 2 fields. Layer 2 fields for
 * encapsulated packets include both outer L2 header and/or inner l2 header of
 * encapsulated packet. The L2 filter resource covers the following OS specific
 * L2 filters. Linux/FreeBSD (per function): # Broadcast enable/disable # List
 * of individual multicast filters # All multicast enable/disable filter #
 * Unicast filters # Promiscuous mode VMware: # Broadcast enable/disable (per
 * physical function) # All multicast enable/disable (per function) # Unicast
 * filters per ring or vnic # Promiscuous mode per PF Windows: # Broadcast
 * enable/disable (per physical function) # List of individual multicast filters
 * (Driver needs to advertise the maximum number of filters supported) # All
 * multicast enable/disable per physical function # Unicast filters per vnic #
 * Promiscuous mode per PF Implementation notes on the use of VNIC in this
 * command: # By default, these filters belong to default vnic for the function.
 * # Once these filters are set up, only destination VNIC can be modified. # If
 * the destination VNIC is not specified in this command, then the HWRM shall
 * only create an l2 context id. HWRM Implementation notes for multicast
 * filters: # The hwrm_filter_alloc command can be used to set up multicast
 * filters (perfect match or partial match). Each individual function driver can
 * set up multicast filters independently. # The HWRM needs to keep track of
 * multicast filters set up by function drivers and maintain multicast group
 * replication records to enable a subset of functions to receive traffic for a
 * specific multicast address. # When a specific multicast filter cannot be set,
 * the HWRM shall return an error. In this error case, the driver should fall
 * back to using one general filter (rather than specific) for all multicast
 * traffic. # When the SR-IOV is enabled, the HWRM needs to additionally track
 * source knockout per multicast group record. Examples of setting unicast
 * filters: For a unicast MAC based filter, one can use a combination of the
 * fields and masks provided in this command to set up the filter. Below are
 * some examples: # MAC + no VLAN filter: This filter is used to identify
 * traffic that does not contain any VLAN tags and matches destination (or
 * source) MAC address. This filter can be set up by setting only l2_addr field
 * to be a valid field. All other fields are not valid. The following value is
 * set for l2_addr. l2_addr = MAC # MAC + Any VLAN filter: This filter is used
 * to identify traffic that carries single VLAN tag and matches (destination or
 * source) MAC address. This filter can be set up by setting only l2_addr and
 * l2_ovlan_mask fields to be valid fields. All other fields are not valid. The
 * following values are set for those two valid fields. l2_addr = MAC,
 * l2_ovlan_mask = 0xFFFF # MAC + no VLAN or VLAN ID=0: This filter is used to
 * identify untagged traffic that does not contain any VLAN tags or a VLAN tag
 * with VLAN ID = 0 and matches destination (or source) MAC address. This filter
 * can be set up by setting only l2_addr and l2_ovlan fields to be valid fields.
 * All other fields are not valid. The following value are set for l2_addr and
 * l2_ovlan. l2_addr = MAC, l2_ovlan = 0x0 # MAC + no VLAN or any VLAN: This
 * filter is used to identify traffic that contains zero or 1 VLAN tag and
 * matches destination (or source) MAC address. This filter can be set up by
 * setting only l2_addr, l2_ovlan, and l2_mask fields to be valid fields. All
 * other fields are not valid. The following value are set for l2_addr,
 * l2_ovlan, and l2_mask fields. l2_addr = MAC, l2_ovlan = 0x0, l2_ovlan_mask =
 * 0xFFFF # MAC + VLAN ID filter: This filter can be set up by setting only
 * l2_addr, l2_ovlan, and l2_ovlan_mask fields to be valid fields. All other
 * fields are not valid. The following values are set for those three valid
 * fields. l2_addr = MAC, l2_ovlan = VLAN ID, l2_ovlan_mask = 0xF000
 */
/* Input (96 bytes) */

struct hwrm_cfa_l2_filter_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH	UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_TX	(UINT32_C(0x0) << 0)
	/* rx path */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_RX	(UINT32_C(0x1) << 0)
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_LAST	HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_RX
	/*
	 * Setting of this flag indicates the applicability to the loopback
	 * path.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_LOOPBACK	UINT32_C(0x2)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_DROP	UINT32_C(0x4)
	/*
	 * If this flag is set, all t_l2_* fields are invalid and they should
	 * not be specified. If this flag is set, then l2_* fields refer to
	 * fields of outermost L2 header.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_OUTERMOST	UINT32_C(0x8)
	uint32_t enables;
	/* This bit must be '1' for the l2_addr field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_ADDR	UINT32_C(0x1)
	/* This bit must be '1' for the l2_addr_mask field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_ADDR_MASK UINT32_C(0x2)
	/* This bit must be '1' for the l2_ovlan field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_OVLAN	UINT32_C(0x4)
	/* This bit must be '1' for the l2_ovlan_mask field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_OVLAN_MASK UINT32_C(0x8)
	/* This bit must be '1' for the l2_ivlan field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_IVLAN	UINT32_C(0x10)
	/* This bit must be '1' for the l2_ivlan_mask field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_IVLAN_MASK UINT32_C(0x20)
	/* This bit must be '1' for the t_l2_addr field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_ADDR   UINT32_C(0x40)
	/* This bit must be '1' for the t_l2_addr_mask field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_ADDR_MASK UINT32_C(0x80)
	/* This bit must be '1' for the t_l2_ovlan field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_OVLAN  UINT32_C(0x100)
	/* This bit must be '1' for the t_l2_ovlan_mask field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_OVLAN_MASK UINT32_C(0x200)
	/* This bit must be '1' for the t_l2_ivlan field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_IVLAN  UINT32_C(0x400)
	/* This bit must be '1' for the t_l2_ivlan_mask field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_IVLAN_MASK UINT32_C(0x800)
	/* This bit must be '1' for the src_type field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_SRC_TYPE	UINT32_C(0x1000)
	/* This bit must be '1' for the src_id field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_SRC_ID	UINT32_C(0x2000)
	/* This bit must be '1' for the tunnel_type field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE UINT32_C(0x4000)
	/* This bit must be '1' for the dst_id field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_DST_ID	UINT32_C(0x8000)
	/* This bit must be '1' for the mirror_vnic_id field to be configured. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID UINT32_C(0x10000)
	uint8_t l2_addr[6];
	/*
	 * This value sets the match value for the L2 MAC address. Destination
	 * MAC address for RX path. Source MAC address for TX path.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t l2_addr_mask[6];
	/*
	 * This value sets the mask value for the L2 address. A value of 0 will
	 * mask the corresponding bit from compare.
	 */
	uint16_t l2_ovlan;
	/* This value sets VLAN ID value for outer VLAN. */
	uint16_t l2_ovlan_mask;
	/*
	 * This value sets the mask value for the ovlan id. A value of 0 will
	 * mask the corresponding bit from compare.
	 */
	uint16_t l2_ivlan;
	/* This value sets VLAN ID value for inner VLAN. */
	uint16_t l2_ivlan_mask;
	/*
	 * This value sets the mask value for the ivlan id. A value of 0 will
	 * mask the corresponding bit from compare.
	 */
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t t_l2_addr[6];
	/*
	 * This value sets the match value for the tunnel L2 MAC address.
	 * Destination MAC address for RX path. Source MAC address for TX path.
	 */
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t t_l2_addr_mask[6];
	/*
	 * This value sets the mask value for the tunnel L2 address. A value of
	 * 0 will mask the corresponding bit from compare.
	 */
	uint16_t t_l2_ovlan;
	/* This value sets VLAN ID value for tunnel outer VLAN. */
	uint16_t t_l2_ovlan_mask;
	/*
	 * This value sets the mask value for the tunnel ovlan id. A value of 0
	 * will mask the corresponding bit from compare.
	 */
	uint16_t t_l2_ivlan;
	/* This value sets VLAN ID value for tunnel inner VLAN. */
	uint16_t t_l2_ivlan_mask;
	/*
	 * This value sets the mask value for the tunnel ivlan id. A value of 0
	 * will mask the corresponding bit from compare.
	 */
	uint8_t src_type;
	/* This value identifies the type of source of the packet. */
	/* Network port */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_NPORT	UINT32_C(0x0)
	/* Physical function */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_PF	UINT32_C(0x1)
	/* Virtual function */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_VF	UINT32_C(0x2)
	/* Virtual NIC of a function */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_VNIC	UINT32_C(0x3)
	/* Embedded processor for CFA management */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_KONG	UINT32_C(0x4)
	/* Embedded processor for OOB management */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_APE	UINT32_C(0x5)
	/* Embedded processor for RoCE */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_BONO	UINT32_C(0x6)
	/* Embedded processor for network proxy functions */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_TANG	UINT32_C(0x7)
	uint8_t unused_6;
	uint32_t src_id;
	/*
	 * This value is the id of the source. For a network port, it represents
	 * port_id. For a physical function, it represents fid. For a virtual
	 * function, it represents vf_id. For a vnic, it represents vnic_id. For
	 * embedded processors, this id is not valid. Notes: 1. The function ID
	 * is implied if it src_id is not provided for a src_type that is either
	 */
	uint8_t tunnel_type;
	/* Tunnel Type. */
	/* Non-tunnel */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN  UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE  UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE  UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP   UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE UINT32_C(0x5)
	/* Multi-Protocol Label Switching (MPLS) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS   UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT	UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE  UINT32_C(0x8)
	/* Any tunneled traffic */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL UINT32_C(0xff)
	uint8_t unused_7;
	uint16_t dst_id;
	/*
	 * If set, this value shall represent the Logical VNIC ID of the
	 * destination VNIC for the RX path and network port id of the
	 * destination port for the TX path.
	 */
	uint16_t mirror_vnic_id;
	/* Logical VNIC ID of the VNIC where traffic is mirrored. */
	uint8_t pri_hint;
	/*
	 * This hint is provided to help in placing the filter in the filter
	 * table.
	 */
	/* No preference */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_NO_PREFER UINT32_C(0x0)
	/* Above the given filter */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_ABOVE_FILTER UINT32_C(0x1)
	/* Below the given filter */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_BELOW_FILTER UINT32_C(0x2)
	/* As high as possible */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_MAX	UINT32_C(0x3)
	/* As low as possible */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_MIN	UINT32_C(0x4)
	uint8_t unused_8;
	uint32_t unused_9;
	uint64_t l2_filter_id_hint;
	/*
	 * This is the ID of the filter that goes along with the pri_hint. This
	 * field is valid only for the following values. 1 - Above the given
	 * filter 2 - Below the given filter
	 */
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_cfa_l2_filter_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t l2_filter_id;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint32_t flow_id;
	/*
	 * This is the ID of the flow associated with this filter. This value
	 * shall be used to match and associate the flow identifier returned in
	 * completion records. A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_l2_filter_free */
/*
 * Description: Free a L2 filter. The HWRM shall free all associated filter
 * resources with the L2 filter.
 */
/* Input (24 bytes) */

struct hwrm_cfa_l2_filter_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t l2_filter_id;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_l2_filter_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_l2_filter_cfg */
/* Description: Change the configuration of an existing L2 filter */
/* Input (40 bytes) */

struct hwrm_cfa_l2_filter_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH		UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_TX	(UINT32_C(0x0) << 0)
	/* rx path */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_RX	(UINT32_C(0x1) << 0)
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_LAST	HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_RX
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_DROP		UINT32_C(0x2)
	uint32_t enables;
	/* This bit must be '1' for the dst_id field to be configured. */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_ENABLES_DST_ID	UINT32_C(0x1)
	/*
	 * This bit must be '1' for the new_mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_ENABLES_NEW_MIRROR_VNIC_ID UINT32_C(0x2)
	uint64_t l2_filter_id;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint32_t dst_id;
	/*
	 * If set, this value shall represent the Logical VNIC ID of the
	 * destination VNIC for the RX path and network port id of the
	 * destination port for the TX path.
	 */
	uint32_t new_mirror_vnic_id;
	/* New Logical VNIC ID of the VNIC where traffic is mirrored. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_l2_filter_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_l2_set_rx_mask */
/* Description: This command will set rx mask of the function. */
/* Input (56 bytes) */

struct hwrm_cfa_l2_set_rx_mask_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t vnic_id;
	/* VNIC ID */
	uint32_t mask;
	/* Reserved for future use. */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_RESERVED	UINT32_C(0x1)
	/*
	 * When this bit is '1', the function is requested to accept multi-cast
	 * packets specified by the multicast addr table.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_MCAST	UINT32_C(0x2)
	/*
	 * When this bit is '1', the function is requested to accept all multi-
	 * cast packets.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_ALL_MCAST	UINT32_C(0x4)
	/*
	 * When this bit is '1', the function is requested to accept broadcast
	 * packets.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_BCAST	UINT32_C(0x8)
	/*
	 * When this bit is '1', the function is requested to be put in the
	 * promiscuous mode. The HWRM should accept any function to set up
	 * promiscuous mode. The HWRM shall follow the semantics below for the
	 * promiscuous mode support. # When partitioning is not enabled on a
	 * port (i.e. single PF on the port), then the PF shall be allowed to be
	 * in the promiscuous mode. When the PF is in the promiscuous mode, then
	 * it shall receive all host bound traffic on that port. # When
	 * partitioning is enabled on a port (i.e. multiple PFs per port) and a
	 * PF on that port is in the promiscuous mode, then the PF receives all
	 * traffic within that partition as identified by a unique identifier
	 * for the PF (e.g. S-Tag). If a unique outer VLAN for the PF is
	 * specified, then the setting of promiscuous mode on that PF shall
	 * result in the PF receiving all host bound traffic with matching outer
	 * VLAN. # A VF shall can be set in the promiscuous mode. In the
	 * promiscuous mode, the VF does not receive any traffic unless a unique
	 * outer VLAN for the VF is specified. If a unique outer VLAN for the VF
	 * is specified, then the setting of promiscuous mode on that VF shall
	 * result in the VF receiving all host bound traffic with the matching
	 * outer VLAN. # The HWRM shall allow the setting of promiscuous mode on
	 * a function independently from the promiscuous mode settings on other
	 * functions.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_PROMISCUOUS	UINT32_C(0x10)
	/*
	 * If this flag is set, the corresponding RX filters shall be set up to
	 * cover multicast/broadcast filters for the outermost Layer 2
	 * destination MAC address field.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_OUTERMOST	UINT32_C(0x20)
	/*
	 * If this flag is set, the corresponding RX filters shall be set up to
	 * cover multicast/broadcast filters for the VLAN-tagged packets that
	 * match the TPID and VID fields of VLAN tags in the VLAN tag table
	 * specified in this command.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_VLANONLY	UINT32_C(0x40)
	/*
	 * If this flag is set, the corresponding RX filters shall be set up to
	 * cover multicast/broadcast filters for non-VLAN tagged packets and
	 * VLAN-tagged packets that match the TPID and VID fields of VLAN tags
	 * in the VLAN tag table specified in this command.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_VLAN_NONVLAN	UINT32_C(0x80)
	/*
	 * If this flag is set, the corresponding RX filters shall be set up to
	 * cover multicast/broadcast filters for non-VLAN tagged packets and
	 * VLAN-tagged packets matching any VLAN tag. If this flag is set, then
	 * the HWRM shall ignore VLAN tags specified in vlan_tag_tbl. If none of
	 * vlanonly, vlan_nonvlan, and anyvlan_nonvlan flags is set, then the
	 * HWRM shall ignore VLAN tags specified in vlan_tag_tbl. The HWRM
	 * client shall set at most one flag out of vlanonly, vlan_nonvlan, and
	 * anyvlan_nonvlan.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_ANYVLAN_NONVLAN UINT32_C(0x100)
	uint64_t mc_tbl_addr;
	/* This is the address for mcast address tbl. */
	uint32_t num_mc_entries;
	/*
	 * This value indicates how many entries in mc_tbl are valid. Each entry
	 * is 6 bytes.
	 */
	uint32_t unused_0;
	uint64_t vlan_tag_tbl_addr;
	/*
	 * This is the address for VLAN tag table. Each VLAN entry in the table
	 * is 4 bytes of a VLAN tag including TPID, PCP, DEI, and VID fields in
	 * network byte order.
	 */
	uint32_t num_vlan_tags;
	/*
	 * This value indicates how many entries in vlan_tag_tbl are valid. Each
	 * entry is 4 bytes.
	 */
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_l2_set_rx_mask_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_cfa_l2_set_rx_mask_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_CFA_L2_SET_RX_MASK_CMD_ERR_CODE_UNKNOWN	UINT32_C(0x0)
	/* Unable to complete operation due to conflict with Ntuple Filter */
	#define HWRM_CFA_L2_SET_RX_MASK_CMD_ERR_CODE_NTUPLE_FILTER_CONFLICT_ERR UINT32_C(0x1)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_cfa_vlan_antispoof_cfg */
/* Description: Configures vlan anti-spoof filters for VF. */
/* Input (32 bytes) */

struct hwrm_cfa_vlan_antispoof_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being configured. Only valid for
	 * a VF FID configured by the PF.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t num_vlan_entries;
	/* Number of VLAN entries in the vlan_tag_mask_tbl. */
	uint64_t vlan_tag_mask_tbl_addr;
	/*
	 * The vlan_tag_mask_tbl_addr is the DMA address of the VLAN antispoof
	 * table. Each table entry contains the 16-bit TPID (0x8100 or 0x88a8
	 * only), 16-bit VLAN ID, and a 16-bit mask, all in network order to
	 * match hwrm_cfa_l2_set_rx_mask. For an individual VLAN entry, the mask
	 * value should be 0xfff for the 12-bit VLAN ID.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_vlan_antispoof_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_vlan_antispoof_qcfg */
/*
 * Description: Returns the current configuration of the vlan anti-spoof filters
 * for VF.
 */
/* Input (32 bytes) */

struct hwrm_cfa_vlan_antispoof_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t fid;
	/*
	 * Function ID of the function that is being queried. Only valid for a
	 * VF FID queried by the PF.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t max_vlan_entries;
	/*
	 * Maximum number of VLAN entries the firmware is allowed to DMA to
	 * vlan_tag_mask_tbl.
	 */
	uint64_t vlan_tag_mask_tbl_addr;
	/*
	 * The vlan_tag_mask_tbl_addr is the DMA address of the VLAN antispoof
	 * table to which firmware will DMA to. Each table entry will contain
	 * the 16-bit TPID (0x8100 or 0x88a8 only), 16-bit VLAN ID, and a 16-bit
	 * mask, all in network order to match hwrm_cfa_l2_set_rx_mask. For an
	 * individual VLAN entry, the mask value should be 0xfff for the 12-bit
	 * VLAN ID.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_vlan_antispoof_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t num_vlan_entries;
	/* Number of valid entries DMAd by firmware to vlan_tag_mask_tbl. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_tunnel_filter_alloc */
/*
 * Description: This is a tunnel filter that uses fields from tunnel header in
 * addition to l2 context. The tunnel filter applies to receive side only. The
 * l2_* fields in this command represent fields of inner L2 header. They are
 * optional to be specified. It allows l2_filter_id to be created with outer L2
 * header fields that can be shared with multiple tunnel filters specified as
 * combinations of inner L2 header fields, tunnel type, and VNI.
 */
/* Input (88 bytes) */

struct hwrm_cfa_tunnel_filter_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Setting of this flag indicates the applicability to the loopback
	 * path.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_FLAGS_LOOPBACK  UINT32_C(0x1)
	uint32_t enables;
	/* This bit must be '1' for the l2_filter_id field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L2_FILTER_ID UINT32_C(0x1)
	/* This bit must be '1' for the l2_addr field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L2_ADDR UINT32_C(0x2)
	/* This bit must be '1' for the l2_ivlan field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L2_IVLAN UINT32_C(0x4)
	/* This bit must be '1' for the l3_addr field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L3_ADDR UINT32_C(0x8)
	/* This bit must be '1' for the l3_addr_type field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L3_ADDR_TYPE UINT32_C(0x10)
	/* This bit must be '1' for the t_l3_addr_type field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_T_L3_ADDR_TYPE UINT32_C(0x20)
	/* This bit must be '1' for the t_l3_addr field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_T_L3_ADDR UINT32_C(0x40)
	/* This bit must be '1' for the tunnel_type field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE UINT32_C(0x80)
	/* This bit must be '1' for the vni field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_VNI	UINT32_C(0x100)
	/* This bit must be '1' for the dst_vnic_id field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_DST_VNIC_ID UINT32_C(0x200)
	/* This bit must be '1' for the mirror_vnic_id field to be configured. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID UINT32_C(0x400)
	uint64_t l2_filter_id;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint8_t l2_addr[6];
	/*
	 * This value sets the match value for the inner L2 MAC address.
	 * Destination MAC address for RX path. Source MAC address for TX path.
	 */
	uint16_t l2_ivlan;
	/*
	 * This value sets VLAN ID value for inner VLAN. Only 12-bits of VLAN ID
	 * are used in setting the filter.
	 */
	uint32_t l3_addr[4];
	/*
	 * The value of inner destination IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t t_l3_addr[4];
	/*
	 * The value of tunnel destination IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint8_t l3_addr_type;
	/*
	 * This value indicates the type of inner IP address. 4 - IPv4 6 - IPv6
	 * All others are invalid.
	 */
	uint8_t t_l3_addr_type;
	/*
	 * This value indicates the type of tunnel IP address. 4 - IPv4 6 - IPv6
	 * All others are invalid.
	 */
	uint8_t tunnel_type;
	/* Tunnel Type. */
	/* Non-tunnel */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE UINT32_C(0x5)
	/* Multi-Protocol Label Switching (MPLS) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE UINT32_C(0x8)
	/* Any tunneled traffic */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL UINT32_C(0xff)
	uint8_t unused_0;
	uint32_t vni;
	/*
	 * Virtual Network Identifier (VNI). Only valid with tunnel_types VXLAN,
	 * NVGRE, and Geneve. Only lower 24-bits of VNI field are used in
	 * setting up the filter.
	 */
	uint32_t dst_vnic_id;
	/* Logical VNIC ID of the destination VNIC. */
	uint32_t mirror_vnic_id;
	/* Logical VNIC ID of the VNIC where traffic is mirrored. */
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_cfa_tunnel_filter_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t tunnel_filter_id;
	/* This value is an opaque id into CFA data structures. */
	uint32_t flow_id;
	/*
	 * This is the ID of the flow associated with this filter. This value
	 * shall be used to match and associate the flow identifier returned in
	 * completion records. A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_tunnel_filter_free */
/* Description: Free a tunnel filter */
/* Input (24 bytes) */

struct hwrm_cfa_tunnel_filter_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t tunnel_filter_id;
	/* This value is an opaque id into CFA data structures. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_tunnel_filter_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_encap_record_alloc */
/*
 * Description: This command is used to create an encapsulation record. The
 * source MAC address and source IP address specified for the source property
 * checks shall be used in the encapsulation where applicable.
 */
/* Input (32 bytes) */

struct hwrm_cfa_encap_record_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Setting of this flag indicates the applicability to the loopback
	 * path.
	 */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_FLAGS_LOOPBACK   UINT32_C(0x1)
	uint8_t encap_type;
	/* Encapsulation Type. */
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_VXLAN UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_NVGRE UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) after inside Ethernet payload */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_L2GRE UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_IPIP UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_GENEVE UINT32_C(0x5)
	/* Multi-Protocol Label Switching (MPLS) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_MPLS UINT32_C(0x6)
	/* VLAN */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_VLAN UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_IPGRE UINT32_C(0x8)
	uint8_t unused_0;
	uint16_t unused_1;
	uint32_t encap_data[20];
	/* This value is encap data used for the given encap type. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_encap_record_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t encap_record_id;
	/* This value is an opaque id into CFA data structures. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_encap_record_free */
/* Description: Free an encap record */
/* Input (24 bytes) */

struct hwrm_cfa_encap_record_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t encap_record_id;
	/* This value is an opaque id into CFA data structures. */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_encap_record_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_ntuple_filter_alloc */
/*
 * Description: This is a ntuple filter that uses fields from L4/L3 header and
 * optionally fields from L2. The ntuple filters apply to receive traffic only.
 * All L2/L3/L4 header fields are specified in network byte order. These filters
 * can be used for Receive Flow Steering (RFS). # For ethertype value, only
 * 0x0800 (IPv4) and 0x86dd (IPv6) shall be supported for ntuple filters. # If a
 * field specified in this command is not enabled as a valid field, then that
 * field shall not be used in matching packet header fields against this filter.
 */
/* Input (128 bytes) */

struct hwrm_cfa_ntuple_filter_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Setting of this flag indicates the applicability to the loopback
	 * path.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_FLAGS_LOOPBACK  UINT32_C(0x1)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_FLAGS_DROP	UINT32_C(0x2)
	/*
	 * Setting of this flag indicates that a meter is expected to be
	 * attached to this flow. This hint can be used when choosing the action
	 * record format required for the flow.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_FLAGS_METER	UINT32_C(0x4)
	uint32_t enables;
	/* This bit must be '1' for the l2_filter_id field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_L2_FILTER_ID UINT32_C(0x1)
	/* This bit must be '1' for the ethertype field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_ETHERTYPE UINT32_C(0x2)
	/* This bit must be '1' for the tunnel_type field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE UINT32_C(0x4)
	/* This bit must be '1' for the src_macaddr field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_MACADDR UINT32_C(0x8)
	/* This bit must be '1' for the ipaddr_type field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_IPADDR_TYPE UINT32_C(0x10)
	/* This bit must be '1' for the src_ipaddr field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_IPADDR UINT32_C(0x20)
	/* This bit must be '1' for the src_ipaddr_mask field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_IPADDR_MASK UINT32_C(0x40)
	/* This bit must be '1' for the dst_ipaddr field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_IPADDR UINT32_C(0x80)
	/* This bit must be '1' for the dst_ipaddr_mask field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_IPADDR_MASK UINT32_C(0x100)
	/* This bit must be '1' for the ip_protocol field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_IP_PROTOCOL UINT32_C(0x200)
	/* This bit must be '1' for the src_port field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_PORT UINT32_C(0x400)
	/* This bit must be '1' for the src_port_mask field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_PORT_MASK UINT32_C(0x800)
	/* This bit must be '1' for the dst_port field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_PORT UINT32_C(0x1000)
	/* This bit must be '1' for the dst_port_mask field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_PORT_MASK UINT32_C(0x2000)
	/* This bit must be '1' for the pri_hint field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_PRI_HINT UINT32_C(0x4000)
	/* This bit must be '1' for the ntuple_filter_id field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_NTUPLE_FILTER_ID UINT32_C(0x8000)
	/* This bit must be '1' for the dst_id field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_ID  UINT32_C(0x10000)
	/* This bit must be '1' for the mirror_vnic_id field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID UINT32_C(0x20000)
	/* This bit must be '1' for the dst_macaddr field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_MACADDR UINT32_C(0x40000)
	uint64_t l2_filter_id;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint8_t src_macaddr[6];
	/* This value indicates the source MAC address in the Ethernet header. */
	uint16_t ethertype; /* big endian */
	/* This value indicates the ethertype in the Ethernet header. */
	uint8_t ip_addr_type;
	/*
	 * This value indicates the type of IP address. 4 - IPv4 6 - IPv6 All
	 * others are invalid.
	 */
	/* invalid */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_UNKNOWN UINT32_C(0x0)
	/* IPv4 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV4 UINT32_C(0x4)
	/* IPv6 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV6 UINT32_C(0x6)
	uint8_t ip_protocol;
	/*
	 * The value of protocol filed in IP header. Applies to UDP and TCP
	 * traffic. 6 - TCP 17 - UDP
	 */
	/* invalid */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_UNKNOWN UINT32_C(0x0)
	/* TCP */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_TCP UINT32_C(0x6)
	/* UDP */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_UDP UINT32_C(0x11)
	uint16_t dst_id;
	/*
	 * If set, this value shall represent the Logical VNIC ID of the
	 * destination VNIC for the RX path and network port id of the
	 * destination port for the TX path.
	 */
	uint16_t mirror_vnic_id;
	/* Logical VNIC ID of the VNIC where traffic is mirrored. */
	uint8_t tunnel_type;
	/*
	 * This value indicates the tunnel type for this filter. If this field
	 * is not specified, then the filter shall apply to both non-tunneled
	 * and tunneled packets. If this field conflicts with the tunnel_type
	 * specified in the l2_filter_id, then the HWRM shall return an error
	 * for this command.
	 */
	/* Non-tunnel */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE UINT32_C(0x5)
	/* Multi-Protocol Label Switching (MPLS) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE UINT32_C(0x8)
	/* Any tunneled traffic */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL UINT32_C(0xff)
	uint8_t pri_hint;
	/*
	 * This hint is provided to help in placing the filter in the filter
	 * table.
	 */
	/* No preference */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_NO_PREFER UINT32_C(0x0)
	/* Above the given filter */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_ABOVE UINT32_C(0x1)
	/* Below the given filter */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_BELOW UINT32_C(0x2)
	/* As high as possible */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_HIGHEST UINT32_C(0x3)
	/* As low as possible */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_LOWEST UINT32_C(0x4)
	uint32_t src_ipaddr[4]; /* big endian */
	/*
	 * The value of source IP address to be used in filtering. For IPv4,
	 * first four bytes represent the IP address.
	 */
	uint32_t src_ipaddr_mask[4]; /* big endian */
	/*
	 * The value of source IP address mask to be used in filtering. For
	 * IPv4, first four bytes represent the IP address mask.
	 */
	uint32_t dst_ipaddr[4]; /* big endian */
	/*
	 * The value of destination IP address to be used in filtering. For
	 * IPv4, first four bytes represent the IP address.
	 */
	uint32_t dst_ipaddr_mask[4]; /* big endian */
	/*
	 * The value of destination IP address mask to be used in filtering. For
	 * IPv4, first four bytes represent the IP address mask.
	 */
	uint16_t src_port; /* big endian */
	/*
	 * The value of source port to be used in filtering. Applies to UDP and
	 * TCP traffic.
	 */
	uint16_t src_port_mask; /* big endian */
	/*
	 * The value of source port mask to be used in filtering. Applies to UDP
	 * and TCP traffic.
	 */
	uint16_t dst_port; /* big endian */
	/*
	 * The value of destination port to be used in filtering. Applies to UDP
	 * and TCP traffic.
	 */
	uint16_t dst_port_mask; /* big endian */
	/*
	 * The value of destination port mask to be used in filtering. Applies
	 * to UDP and TCP traffic.
	 */
	uint64_t ntuple_filter_id_hint;
	/* This is the ID of the filter that goes along with the pri_hint. */
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_cfa_ntuple_filter_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t ntuple_filter_id;
	/* This value is an opaque id into CFA data structures. */
	uint32_t flow_id;
	/*
	 * This is the ID of the flow associated with this filter. This value
	 * shall be used to match and associate the flow identifier returned in
	 * completion records. A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_cfa_ntuple_filter_alloc_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_CMD_ERR_CODE_UNKNOWN UINT32_C(0x0)
	/* Unable to complete operation due to conflict with Rx Mask VLAN */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_CMD_ERR_CODE_RX_MASK_VLAN_CONFLICT_ERR UINT32_C(0x1)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_cfa_ntuple_filter_free */
/* Description: Free an ntuple filter */
/* Input (24 bytes) */

struct hwrm_cfa_ntuple_filter_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t ntuple_filter_id;
	/* This value is an opaque id into CFA data structures. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_ntuple_filter_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_ntuple_filter_cfg */
/*
 * Description: Configure an ntuple filter with a new destination VNIC and/or
 * meter.
 */
/* Input (48 bytes) */

struct hwrm_cfa_ntuple_filter_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the new_dst_id field to be configured. */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_ENABLES_NEW_DST_ID UINT32_C(0x1)
	/*
	 * This bit must be '1' for the new_mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_ENABLES_NEW_MIRROR_VNIC_ID UINT32_C(0x2)
	/*
	 * This bit must be '1' for the new_meter_instance_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_ENABLES_NEW_METER_INSTANCE_ID UINT32_C(0x4)
	uint32_t unused_0;
	uint64_t ntuple_filter_id;
	/* This value is an opaque id into CFA data structures. */
	uint32_t new_dst_id;
	/*
	 * If set, this value shall represent the new Logical VNIC ID of the
	 * destination VNIC for the RX path and new network port id of the
	 * destination port for the TX path.
	 */
	uint32_t new_mirror_vnic_id;
	/* New Logical VNIC ID of the VNIC where traffic is mirrored. */
	uint16_t new_meter_instance_id;
	/*
	 * New meter to attach to the flow. Specifying the invalid instance ID
	 * is used to remove any existing meter from the flow.
	 */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_NEW_METER_INSTANCE_ID_INVALID UINT32_C(0xffff)
	uint16_t unused_1[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_ntuple_filter_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_em_flow_alloc */
/*
 * Description: This is a generic Exact Match (EM) flow that uses fields from
 * L4/L3/L2 headers. The EM flows apply to transmit and receive traffic. All
 * L2/L3/L4 header fields are specified in network byte order. For each EM flow,
 * there is an associated set of actions specified. For tunneled packets, all
 * L2/L3/L4 fields specified are fields of inner headers unless otherwise
 * specified. # If a field specified in this command is not enabled as a valid
 * field, then that field shall not be used in matching packet header fields
 * against this EM flow entry.
 */
/* Input (112 bytes) */

struct hwrm_cfa_em_flow_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH		UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_TX	(UINT32_C(0x0) << 0)
	/* rx path */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_RX	(UINT32_C(0x1) << 0)
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_LAST	HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_RX
	/*
	 * Setting of this flag indicates enabling of a byte counter for a given
	 * flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_BYTE_CTR	UINT32_C(0x2)
	/*
	 * Setting of this flag indicates enabling of a packet counter for a
	 * given flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PKT_CTR	UINT32_C(0x4)
	/*
	 * Setting of this flag indicates de-capsulation action for the given
	 * flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_DECAP	UINT32_C(0x8)
	/*
	 * Setting of this flag indicates encapsulation action for the given
	 * flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_ENCAP	UINT32_C(0x10)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_DROP		UINT32_C(0x20)
	/*
	 * Setting of this flag indicates that a meter is expected to be
	 * attached to this flow. This hint can be used when choosing the action
	 * record format required for the flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_METER	UINT32_C(0x40)
	uint32_t enables;
	/* This bit must be '1' for the l2_filter_id field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_L2_FILTER_ID  UINT32_C(0x1)
	/* This bit must be '1' for the tunnel_type field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_TUNNEL_TYPE   UINT32_C(0x2)
	/* This bit must be '1' for the tunnel_id field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_TUNNEL_ID	UINT32_C(0x4)
	/* This bit must be '1' for the src_macaddr field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_SRC_MACADDR   UINT32_C(0x8)
	/* This bit must be '1' for the dst_macaddr field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_MACADDR   UINT32_C(0x10)
	/* This bit must be '1' for the ovlan_vid field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_OVLAN_VID	UINT32_C(0x20)
	/* This bit must be '1' for the ivlan_vid field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_IVLAN_VID	UINT32_C(0x40)
	/* This bit must be '1' for the ethertype field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_ETHERTYPE	UINT32_C(0x80)
	/* This bit must be '1' for the src_ipaddr field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_SRC_IPADDR	UINT32_C(0x100)
	/* This bit must be '1' for the dst_ipaddr field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_IPADDR	UINT32_C(0x200)
	/* This bit must be '1' for the ipaddr_type field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_IPADDR_TYPE   UINT32_C(0x400)
	/* This bit must be '1' for the ip_protocol field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_IP_PROTOCOL   UINT32_C(0x800)
	/* This bit must be '1' for the src_port field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_SRC_PORT	UINT32_C(0x1000)
	/* This bit must be '1' for the dst_port field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_PORT	UINT32_C(0x2000)
	/* This bit must be '1' for the dst_id field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_ID	UINT32_C(0x4000)
	/* This bit must be '1' for the mirror_vnic_id field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID UINT32_C(0x8000)
	/* This bit must be '1' for the encap_record_id field to be configured. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_ENCAP_RECORD_ID UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the meter_instance_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_METER_INSTANCE_ID UINT32_C(0x20000)
	uint64_t l2_filter_id;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint8_t tunnel_type;
	/* Tunnel Type. */
	/* Non-tunnel */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_VXLAN	UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_NVGRE	UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_L2GRE	UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_IPIP	UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_GENEVE   UINT32_C(0x5)
	/* Multi-Protocol Label Switching (MPLS) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_MPLS	UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_STT	UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_IPGRE	UINT32_C(0x8)
	/* Any tunneled traffic */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL UINT32_C(0xff)
	uint8_t unused_0;
	uint16_t unused_1;
	uint32_t tunnel_id;
	/*
	 * Tunnel identifier. Virtual Network Identifier (VNI). Only valid with
	 * tunnel_types VXLAN, NVGRE, and Geneve. Only lower 24-bits of VNI
	 * field are used in setting up the filter.
	 */
	uint8_t src_macaddr[6];
	/* This value indicates the source MAC address in the Ethernet header. */
	uint16_t meter_instance_id;
	/* The meter instance to attach to the flow. */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_METER_INSTANCE_ID_INVALID UINT32_C(0xffff)
	uint8_t dst_macaddr[6];
	/*
	 * This value indicates the destination MAC address in the Ethernet
	 * header.
	 */
	uint16_t ovlan_vid;
	/*
	 * This value indicates the VLAN ID of the outer VLAN tag in the
	 * Ethernet header.
	 */
	uint16_t ivlan_vid;
	/*
	 * This value indicates the VLAN ID of the inner VLAN tag in the
	 * Ethernet header.
	 */
	uint16_t ethertype; /* big endian */
	/* This value indicates the ethertype in the Ethernet header. */
	uint8_t ip_addr_type;
	/*
	 * This value indicates the type of IP address. 4 - IPv4 6 - IPv6 All
	 * others are invalid.
	 */
	/* invalid */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_UNKNOWN UINT32_C(0x0)
	/* IPv4 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_IPV4	UINT32_C(0x4)
	/* IPv6 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_IPV6	UINT32_C(0x6)
	uint8_t ip_protocol;
	/*
	 * The value of protocol filed in IP header. Applies to UDP and TCP
	 * traffic. 6 - TCP 17 - UDP
	 */
	/* invalid */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_UNKNOWN  UINT32_C(0x0)
	/* TCP */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_TCP	UINT32_C(0x6)
	/* UDP */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_UDP	UINT32_C(0x11)
	uint8_t unused_2;
	uint8_t unused_3;
	uint32_t src_ipaddr[4]; /* big endian */
	/*
	 * The value of source IP address to be used in filtering. For IPv4,
	 * first four bytes represent the IP address.
	 */
	uint32_t dst_ipaddr[4]; /* big endian */
	/*
	 * big_endian = True The value of destination IP address to be used in
	 * filtering. For IPv4, first four bytes represent the IP address.
	 */
	uint16_t src_port; /* big endian */
	/*
	 * The value of source port to be used in filtering. Applies to UDP and
	 * TCP traffic.
	 */
	uint16_t dst_port; /* big endian */
	/*
	 * The value of destination port to be used in filtering. Applies to UDP
	 * and TCP traffic.
	 */
	uint16_t dst_id;
	/*
	 * If set, this value shall represent the Logical VNIC ID of the
	 * destination VNIC for the RX path and network port id of the
	 * destination port for the TX path.
	 */
	uint16_t mirror_vnic_id;
	/* Logical VNIC ID of the VNIC where traffic is mirrored. */
	uint32_t encap_record_id;
	/* Logical ID of the encapsulation record. */
	uint32_t unused_4;
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_cfa_em_flow_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t em_filter_id;
	/* This value is an opaque id into CFA data structures. */
	uint32_t flow_id;
	/*
	 * This is the ID of the flow associated with this filter. This value
	 * shall be used to match and associate the flow identifier returned in
	 * completion records. A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_em_flow_free */
/* Description: Free an EM flow table entry */
/* Input (24 bytes) */

struct hwrm_cfa_em_flow_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t em_filter_id;
	/* This value is an opaque id into CFA data structures. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_em_flow_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_em_flow_cfg */
/*
 * Description: Configure an EM flow with a new destination VNIC and/or meter.
 */
/* Input (48 bytes) */

struct hwrm_cfa_em_flow_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the new_dst_id field to be configured. */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_ENABLES_NEW_DST_ID	UINT32_C(0x1)
	/*
	 * This bit must be '1' for the new_mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_ENABLES_NEW_MIRROR_VNIC_ID UINT32_C(0x2)
	/*
	 * This bit must be '1' for the new_meter_instance_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_ENABLES_NEW_METER_INSTANCE_ID UINT32_C(0x4)
	uint32_t unused_0;
	uint64_t em_filter_id;
	/* This value is an opaque id into CFA data structures. */
	uint32_t new_dst_id;
	/*
	 * If set, this value shall represent the new Logical VNIC ID of the
	 * destination VNIC for the RX path and network port id of the
	 * destination port for the TX path.
	 */
	uint32_t new_mirror_vnic_id;
	/* New Logical VNIC ID of the VNIC where traffic is mirrored. */
	uint16_t new_meter_instance_id;
	/*
	 * New meter to attach to the flow. Specifying the invalid instance ID
	 * is used to remove any existing meter from the flow.
	 */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_NEW_METER_INSTANCE_ID_INVALID UINT32_C(0xffff)
	uint16_t unused_1[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_em_flow_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_meter_profile_alloc */
/*
 * Description: This is a meter profile that defines the characteristics of the
 * meter. This includes the algorithm, information rates, and burst sizes. No
 * running state is kept in a profile and instead meter instances are allocated
 * that reference a profile.
 */
/* Input (40 bytes) */

struct hwrm_cfa_meter_profile_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH	UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_TX  UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_RX  UINT32_C(0x1)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_RX
	uint8_t meter_type;
	/* The meter algorithm type. */
	/* RFC 2697 (srTCM) */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_RFC2697 UINT32_C(0x0)
	/* RFC 2698 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_RFC2698 UINT32_C(0x1)
	/* RFC 4115 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_RFC4115 UINT32_C(0x2)
	uint16_t reserved1;
	/* This field is reserved for the future use. It shall be set to 0. */
	uint32_t reserved2;
	/* This field is reserved for the future use. It shall be set to 0. */
	uint32_t commit_rate;
	/* A meter rate specified in bytes-per-second. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID
	uint32_t commit_burst;
	/* A meter burst size specified in bytes. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID
	uint32_t excess_peak_rate;
	/* A meter rate specified in bytes-per-second. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID
	uint32_t excess_peak_burst;
	/* A meter burst size specified in bytes. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_meter_profile_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t meter_profile_id;
	/* This value identifies a meter profile in CFA. */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_PROFILE_ALLOC_OUTPUT_METER_PROFILE_ID_INVALID UINT32_C(0xffff)
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_meter_profile_free */
/* Description: Free a meter profile. */
/* Input (24 bytes) */

struct hwrm_cfa_meter_profile_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH	UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_TX   UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_RX   UINT32_C(0x1)
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_LAST	HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_RX
	uint8_t unused_0;
	uint16_t meter_profile_id;
	/* This value identifies a meter profile in CFA. */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_METER_PROFILE_ID_INVALID UINT32_C(0xffff)
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_meter_profile_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_meter_profile_cfg */
/* Description: Reconfigure a meter profile. */
/* Input (40 bytes) */

struct hwrm_cfa_meter_profile_cfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH	UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_TX	UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_RX	UINT32_C(0x1)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_RX
	uint8_t meter_type;
	/* The meter algorithm type. */
	/* RFC 2697 (srTCM) */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_RFC2697 UINT32_C(0x0)
	/* RFC 2698 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_RFC2698 UINT32_C(0x1)
	/* RFC 4115 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_RFC4115 UINT32_C(0x2)
	uint16_t meter_profile_id;
	/* This value identifies a meter profile in CFA. */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_PROFILE_ID_INVALID UINT32_C(0xffff)
	uint32_t reserved;
	/* This field is reserved for the future use. It shall be set to 0. */
	uint32_t commit_rate;
	/* A meter rate specified in bytes-per-second. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID
	uint32_t commit_burst;
	/* A meter burst size specified in bytes. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID
	uint32_t excess_peak_rate;
	/* A meter rate specified in bytes-per-second. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID
	uint32_t excess_peak_burst;
	/* A meter burst size specified in bytes. */
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_MASK UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_SFT 0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_BITS (UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES (UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MASK UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_SFT 29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MEGA (UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_KILO (UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_BASE (UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_GIGA (UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_PERCENT1_100 (UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID (UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_LAST	HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_meter_profile_cfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_meter_instance_alloc */
/*
 * Description: This is a meter instance which is used to track a meter's bucket
 * fill values for a flow. Each meter instance references a meter profile that
 * defines the meter algorithm in use.
 */
/* Input (24 bytes) */

struct hwrm_cfa_meter_instance_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH	UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_TX UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_RX UINT32_C(0x1)
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_LAST	HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_RX
	uint8_t unused_0;
	uint16_t meter_profile_id;
	/* This value identifies a meter profile in CFA. */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_METER_PROFILE_ID_INVALID UINT32_C(0xffff)
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_meter_instance_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t meter_instance_id;
	/* This value identifies a meter instance in CFA. */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_OUTPUT_METER_INSTANCE_ID_INVALID UINT32_C(0xffff)
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_meter_instance_free */
/* Description: Free a meter instance. */
/* Input (24 bytes) */

struct hwrm_cfa_meter_instance_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource. This
	 * enumeration is used for resources that are similar for both TX and RX
	 * paths of the chip.
	 */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH	UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_TX  UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_RX  UINT32_C(0x1)
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_LAST	HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_RX
	uint8_t unused_0;
	uint16_t meter_instance_id;
	/* This value identifies a meter instance in CFA. */
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_METER_INSTANCE_ID_INVALID UINT32_C(0xffff)
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_meter_instance_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_decap_filter_alloc */
/*
 * Description: This command uses fields from L4/L3/L2 headers. All L2/L3/L4
 * header fields are specified in network byte order.
 */
/* Input (104 bytes) */

struct hwrm_cfa_decap_filter_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/* ovs_tunnel is 1 b */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_FLAGS_OVS_TUNNEL UINT32_C(0x1)
	uint32_t enables;
	/* This bit must be '1' for the tunnel_type field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE UINT32_C(0x1)
	/* This bit must be '1' for the tunnel_id field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_ID UINT32_C(0x2)
	/* This bit must be '1' for the src_macaddr field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_SRC_MACADDR UINT32_C(0x4)
	/* This bit must be '1' for the dst_macaddr field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_MACADDR UINT32_C(0x8)
	/* This bit must be '1' for the ovlan_vid field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_OVLAN_VID UINT32_C(0x10)
	/* This bit must be '1' for the ivlan_vid field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_IVLAN_VID UINT32_C(0x20)
	/* This bit must be '1' for the t_ovlan_vid field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_T_OVLAN_VID UINT32_C(0x40)
	/* This bit must be '1' for the t_ivlan_vid field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_T_IVLAN_VID UINT32_C(0x80)
	/* This bit must be '1' for the ethertype field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_ETHERTYPE UINT32_C(0x100)
	/* This bit must be '1' for the src_ipaddr field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_SRC_IPADDR UINT32_C(0x200)
	/* This bit must be '1' for the dst_ipaddr field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_IPADDR UINT32_C(0x400)
	/* This bit must be '1' for the ipaddr_type field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_IPADDR_TYPE UINT32_C(0x800)
	/* This bit must be '1' for the ip_protocol field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_IP_PROTOCOL UINT32_C(0x1000)
	/* This bit must be '1' for the src_port field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_SRC_PORT UINT32_C(0x2000)
	/* This bit must be '1' for the dst_port field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_PORT UINT32_C(0x4000)
	/* This bit must be '1' for the dst_id field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_ID   UINT32_C(0x8000)
	/* This bit must be '1' for the mirror_vnic_id field to be configured. */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID UINT32_C(0x10000)
	uint32_t tunnel_id;
	/*
	 * Tunnel identifier. Virtual Network Identifier (VNI). Only valid with
	 * tunnel_types VXLAN, NVGRE, and Geneve. Only lower 24-bits of VNI
	 * field are used in setting up the filter.
	 */
	uint8_t tunnel_type;
	/* Tunnel Type. */
	/* Non-tunnel */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE UINT32_C(0x5)
	/* Multi-Protocol Label Switching (MPLS) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE UINT32_C(0x8)
	/* Any tunneled traffic */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL UINT32_C(0xff)
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t src_macaddr[6];
	/* This value indicates the source MAC address in the Ethernet header. */
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t dst_macaddr[6];
	/*
	 * This value indicates the destination MAC address in the Ethernet
	 * header.
	 */
	uint16_t ovlan_vid;
	/*
	 * This value indicates the VLAN ID of the outer VLAN tag in the
	 * Ethernet header.
	 */
	uint16_t ivlan_vid;
	/*
	 * This value indicates the VLAN ID of the inner VLAN tag in the
	 * Ethernet header.
	 */
	uint16_t t_ovlan_vid;
	/*
	 * This value indicates the VLAN ID of the outer VLAN tag in the tunnel
	 * Ethernet header.
	 */
	uint16_t t_ivlan_vid;
	/*
	 * This value indicates the VLAN ID of the inner VLAN tag in the tunnel
	 * Ethernet header.
	 */
	uint16_t ethertype; /* big endian */
	/* This value indicates the ethertype in the Ethernet header. */
	uint8_t ip_addr_type;
	/*
	 * This value indicates the type of IP address. 4 - IPv4 6 - IPv6 All
	 * others are invalid.
	 */
	/* invalid */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_UNKNOWN UINT32_C(0x0)
	/* IPv4 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV4 UINT32_C(0x4)
	/* IPv6 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV6 UINT32_C(0x6)
	uint8_t ip_protocol;
	/*
	 * The value of protocol filed in IP header. Applies to UDP and TCP
	 * traffic. 6 - TCP 17 - UDP
	 */
	/* invalid */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_UNKNOWN UINT32_C(0x0)
	/* TCP */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_TCP UINT32_C(0x6)
	/* UDP */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_UDP UINT32_C(0x11)
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t unused_6[3];
	uint8_t unused_7;
	uint32_t src_ipaddr[4]; /* big endian */
	/*
	 * The value of source IP address to be used in filtering. For IPv4,
	 * first four bytes represent the IP address.
	 */
	uint32_t dst_ipaddr[4]; /* big endian */
	/*
	 * The value of destination IP address to be used in filtering. For
	 * IPv4, first four bytes represent the IP address.
	 */
	uint16_t src_port; /* big endian */
	/*
	 * The value of source port to be used in filtering. Applies to UDP and
	 * TCP traffic.
	 */
	uint16_t dst_port; /* big endian */
	/*
	 * The value of destination port to be used in filtering. Applies to UDP
	 * and TCP traffic.
	 */
	uint16_t dst_id;
	/*
	 * If set, this value shall represent the Logical VNIC ID of the
	 * destination VNIC for the RX path.
	 */
	uint16_t l2_ctxt_ref_id;
	/*
	 * If set, this value shall represent the L2 context that matches the L2
	 * information of the decap filter.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_decap_filter_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t decap_filter_id;
	/* This value is an opaque id into CFA data structures. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_decap_filter_free */
/* Description: Free an decap filter table entry */
/* Input (24 bytes) */

struct hwrm_cfa_decap_filter_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t decap_filter_id;
	/* This value is an opaque id into CFA data structures. */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_decap_filter_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_flow_alloc */
/* Description: Flow is added to table and resources are allocated. */
/* Input (128 bytes) */

struct hwrm_cfa_flow_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t flags;
	/* tunnel is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_TUNNEL		UINT32_C(0x1)
	/* num_vlan is 2 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_MASK	UINT32_C(0x6)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_SFT	1
	/* no tags */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_NONE	(UINT32_C(0x0) << 1)
	/* 1 tag */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_ONE	(UINT32_C(0x1) << 1)
	/* 2 tags */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_TWO	(UINT32_C(0x2) << 1)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_LAST	HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_TWO
	/* Enumeration denoting the Flow Type. */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_MASK	UINT32_C(0x38)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_SFT	3
	/* L2 flow */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_L2	(UINT32_C(0x0) << 3)
	/* IPV4 flow */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_IPV4	(UINT32_C(0x1) << 3)
	/* IPV6 flow */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_IPV6	(UINT32_C(0x2) << 3)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_LAST	HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_IPV6
	uint16_t src_fid;
	/* Tx Flow: vf fid. Rx Flow: pf fid. */
	uint32_t tunnel_handle;
	/* Tunnel handle valid when tunnel flag is set. */
	uint16_t action_flags;
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_FWD	UINT32_C(0x1)
	/* recycle is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_RECYCLE	UINT32_C(0x2)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_DROP	UINT32_C(0x4)
	/* meter is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_METER	UINT32_C(0x8)
	/* tunnel is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_TUNNEL	UINT32_C(0x10)
	/* nat_src is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_NAT_SRC	UINT32_C(0x20)
	/* nat_dest is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_NAT_DEST	UINT32_C(0x40)
	/* nat_ipv4_address is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_NAT_IPV4_ADDRESS UINT32_C(0x80)
	/* l2_header_rewrite is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_L2_HEADER_REWRITE UINT32_C(0x100)
	/* ttl_decrement is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_TTL_DECREMENT UINT32_C(0x200)
	uint16_t dst_fid;
	/* Tx Flow: pf or vf fid. Rx Flow: vf fid. */
	uint16_t l2_rewrite_vlan_tpid; /* big endian */
	/* VLAN tpid, valid when push_vlan flag is set. */
	uint16_t l2_rewrite_vlan_tci; /* big endian */
	/* VLAN tci, valid when push_vlan flag is set. */
	uint16_t act_meter_id;
	/* Meter id, valid when meter flag is set. */
	uint16_t ref_flow_handle;
	/* Flow with the same l2 context tcam key. */
	uint16_t ethertype; /* big endian */
	/* This value sets the match value for the ethertype. */
	uint16_t outer_vlan_tci; /* big endian */
	/* valid when num tags is 1 or 2. */
	uint16_t dmac[3]; /* big endian */
	/* This value sets the match value for the Destination MAC address. */
	uint16_t inner_vlan_tci; /* big endian */
	/* valid when num tags is 2. */
	uint16_t smac[3]; /* big endian */
	/* This value sets the match value for the Source MAC address. */
	uint8_t ip_dst_mask_len;
	/* The bit length of destination IP address mask. */
	uint8_t ip_src_mask_len;
	/* The bit length of source IP address mask. */
	uint32_t ip_dst[4]; /* big endian */
	/* The value of destination IPv4/IPv6 address. */
	uint32_t ip_src[4]; /* big endian */
	/* The source IPv4/IPv6 address. */
	uint16_t l4_src_port; /* big endian */
	/* The value of source port. Applies to UDP and TCP traffic. */
	uint16_t l4_src_port_mask; /* big endian */
	/* The value of source port mask. Applies to UDP and TCP traffic. */
	uint16_t l4_dst_port; /* big endian */
	/* The value of destination port. Applies to UDP and TCP traffic. */
	uint16_t l4_dst_port_mask; /* big endian */
	/* The value of destination port mask. Applies to UDP and TCP traffic. */
	uint32_t nat_ip_address[4]; /* big endian */
	/* NAT IPv4/6 address based on address type flag. 0 values are ignored. */
	uint16_t l2_rewrite_dmac[3]; /* big endian */
	/* L2 header re-write Destination MAC address. */
	uint16_t nat_port; /* big endian */
	/*
	 * The NAT source/destination port based on direction flag. Applies to
	 * UDP and TCP traffic. 0 values are ignored.
	 */
	uint16_t l2_rewrite_smac[3]; /* big endian */
	/* L2 header re-write Source MAC address. */
	uint8_t ip_proto;
	/* The value of ip protocol. */
	uint8_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_flow_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t flow_handle;
	/* Flow record index. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_flow_free */
/* Description: Flow is removed from table and resources are released. */
/* Input (24 bytes) */

struct hwrm_cfa_flow_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t flow_handle;
	/* Flow record index. */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_cfa_flow_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t packet;
	/* packet is 64 b */
	uint64_t byte;
	/* byte is 64 b */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_flow_info */
/* Description: Flow record content for specified flow is returned. */
/* Input (24 bytes) */

struct hwrm_cfa_flow_info_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t flow_handle;
	/* Flow record index. */
	/* Max flow handle */
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_MAX_MASK	UINT32_C(0xfff)
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_MAX_SFT	0
	/* CNP flow handle */
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_CNP_CNT	UINT32_C(0x1000)
	/* Reserved */
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_RESERVED_MASK UINT32_C(0x6000)
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_RESERVED_SFT  13
	/* Direction rx = 1 */
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_DIR_RX	UINT32_C(0x8000)
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (56 bytes) */

struct hwrm_cfa_flow_info_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t flags;
	/* flags is 8 b */
	uint8_t profile;
	/* profile is 8 b */
	uint16_t src_fid;
	/* src_fid is 16 b */
	uint16_t dst_fid;
	/* dst_fid is 16 b */
	uint16_t l2_ctxt_id;
	/* l2_ctxt_id is 16 b */
	uint64_t em_info;
	/* em_info is 64 b */
	uint64_t tcam_info;
	/* tcam_info is 64 b */
	uint64_t vfp_tcam_info;
	/* vfp_tcam_info is 64 b */
	uint16_t ar_id;
	/* ar_id is 16 b */
	uint16_t flow_handle;
	/* flow_handle is 16 b */
	uint32_t tunnel_handle;
	/* tunnel_handle is 32 b */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_flow_flush */
/* Description: All flows are removed from table and resources are released. */
/* Input (24 bytes) */

struct hwrm_cfa_flow_flush_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_flow_flush_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_flow_stats */
/* Description: Flow is removed from table and resources are released. */
/* Input (40 bytes) */

struct hwrm_cfa_flow_stats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t num_flows;
	/* Flow handle. */
	uint16_t flow_handle_0;
	/* Flow handle. */
	uint16_t flow_handle_1;
	/* Flow handle. */
	uint16_t flow_handle_2;
	/* Flow handle. */
	uint16_t flow_handle_3;
	/* Flow handle. */
	uint16_t flow_handle_4;
	/* Flow handle. */
	uint16_t flow_handle_5;
	/* Flow handle. */
	uint16_t flow_handle_6;
	/* Flow handle. */
	uint16_t flow_handle_7;
	/* Flow handle. */
	uint16_t flow_handle_8;
	/* Flow handle. */
	uint16_t flow_handle_9;
	/* Flow handle. */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (176 bytes) */

struct hwrm_cfa_flow_stats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t packet_0;
	/* packet_0 is 64 b */
	uint64_t packet_1;
	/* packet_1 is 64 b */
	uint64_t packet_2;
	/* packet_2 is 64 b */
	uint64_t packet_3;
	/* packet_3 is 64 b */
	uint64_t packet_4;
	/* packet_4 is 64 b */
	uint64_t packet_5;
	/* packet_5 is 64 b */
	uint64_t packet_6;
	/* packet_6 is 64 b */
	uint64_t packet_7;
	/* packet_7 is 64 b */
	uint64_t packet_8;
	/* packet_8 is 64 b */
	uint64_t packet_9;
	/* packet_9 is 64 b */
	uint64_t byte_0;
	/* byte_0 is 64 b */
	uint64_t byte_1;
	/* byte_1 is 64 b */
	uint64_t byte_2;
	/* byte_2 is 64 b */
	uint64_t byte_3;
	/* byte_3 is 64 b */
	uint64_t byte_4;
	/* byte_4 is 64 b */
	uint64_t byte_5;
	/* byte_5 is 64 b */
	uint64_t byte_6;
	/* byte_6 is 64 b */
	uint64_t byte_7;
	/* byte_7 is 64 b */
	uint64_t byte_8;
	/* byte_8 is 64 b */
	uint64_t byte_9;
	/* byte_9 is 64 b */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_vf_pair_alloc */
/* Description: VF pair is added to table and resources are allocated. */
/* Input (32 bytes) */

struct hwrm_cfa_vf_pair_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t vf_a_id;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint16_t vf_b_id;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint32_t unused_0;
	char pair_name[32];
	/* VF Pair name (32 byte string). */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_vf_pair_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_vf_pair_free */
/* Description: VF Pair is removed from table and resources are released. */
/* Input (24 bytes) */

struct hwrm_cfa_vf_pair_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	char pair_name[32];
	/* VF Pair name (32 byte string). */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_vf_pair_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_vf_pair_info */
/* Description: VF pair information is returned. */
/* Input (32 bytes) */

struct hwrm_cfa_vf_pair_info_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/* If this flag is set, lookup by name else lookup by index. */
	#define HWRM_CFA_VF_PAIR_INFO_INPUT_FLAGS_LOOKUP_TYPE	UINT32_C(0x1)
	uint16_t vf_pair_index;
	/* vf pair table index. */
	uint8_t unused_0;
	uint8_t unused_1;
	char vf_pair_name[32];
	/* VF Pair name (32 byte string). */
} __attribute__((packed));

/* Output (64 bytes) */

struct hwrm_cfa_vf_pair_info_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t next_vf_pair_index;
	/* vf pair table index. */
	uint16_t vf_a_fid;
	/* vf pair member a's vf_fid. */
	uint16_t vf_a_index;
	/* vf pair member a's Linux logical VF number. */
	uint16_t vf_b_fid;
	/* vf pair member b's vf_fid. */
	uint16_t vf_b_index;
	/* vf pair member a's Linux logical VF number. */
	uint8_t pair_state;
	/* vf pair state. */
	/* Pair has been allocated */
	#define HWRM_CFA_VF_PAIR_INFO_OUTPUT_PAIR_STATE_ALLOCATED UINT32_C(0x1)
	/* Both pair members are active */
	#define HWRM_CFA_VF_PAIR_INFO_OUTPUT_PAIR_STATE_ACTIVE	UINT32_C(0x2)
	uint8_t unused_0;
	uint32_t unused_1;
	char pair_name[32];
	/* VF Pair name (32 byte string). */
	uint32_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t unused_5;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_vfr_alloc */
/* Description: VF-R is added to table and resources are allocated. */
/* Input (32 bytes) */

struct hwrm_cfa_vfr_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t vf_id;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint16_t reserved;
	/* This field is reserved for the future use. It shall be set to 0. */
	uint32_t unused_0;
	char vfr_name[32];
	/* VF Representor name (32 byte string). */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_vfr_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t rx_cfa_code;
	/* Rx CFA code. */
	uint16_t tx_cfa_action;
	/* Tx CFA action. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_cfa_vfr_free */
/* Description: VF-R is removed from table and resources are released. */
/* Input (24 bytes) */

struct hwrm_cfa_vfr_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	char vfr_name[32];
	/* VF Representor name (32 byte string). */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_cfa_vfr_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_tunnel_dst_port_query */
/*
 * Description: This function is called by a driver to query tunnel type
 * specific destination port configuration.
 */
/* Input (24 bytes) */

struct hwrm_tunnel_dst_port_query_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t tunnel_type;
	/* Tunnel Type. */
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_VXLAN UINT32_C(0x1)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_GENEVE UINT32_C(0x5)
	uint8_t unused_0[7];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_tunnel_dst_port_query_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t tunnel_dst_port_id;
	/*
	 * This field represents the identifier of L4 destination port used for
	 * the given tunnel type. This field is valid for specific tunnel types
	 * that use layer 4 (e.g. UDP) transports for tunneling.
	 */
	uint16_t tunnel_dst_port_val; /* big endian */
	/*
	 * This field represents the value of L4 destination port identified by
	 * tunnel_dst_port_id. This field is valid for specific tunnel types
	 * that use layer 4 (e.g. UDP) transports for tunneling. This field is
	 * in network byte order. A value of 0 means that the destination port
	 * is not configured.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_tunnel_dst_port_alloc */
/*
 * Description: This function is called by a driver to allocate l4 destination
 * port for a specific tunnel type. The destination port value is provided in
 * the input. If the HWRM supports only one global destination port for a tunnel
 * type, then the HWRM shall keep track of its usage as described below. # The
 * first caller that allocates a destination port shall always succeed and the
 * HWRM shall save the destination port configuration for that tunnel type and
 * increment the usage count to 1. # Subsequent callers allocating the same
 * destination port for that tunnel type shall succeed and the HWRM shall
 * increment the usage count for that port for each subsequent caller that
 * succeeds. # Any subsequent caller trying to allocate a different destination
 * port for that tunnel type shall fail until the usage count for the original
 * destination port goes to zero. # A caller that frees a port will cause the
 * usage count for that port to decrement.
 */
/* Input (24 bytes) */

struct hwrm_tunnel_dst_port_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t tunnel_type;
	/* Tunnel Type. */
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_VXLAN UINT32_C(0x1)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_GENEVE UINT32_C(0x5)
	uint8_t unused_0;
	uint16_t tunnel_dst_port_val; /* big endian */
	/*
	 * This field represents the value of L4 destination port used for the
	 * given tunnel type. This field is valid for specific tunnel types that
	 * use layer 4 (e.g. UDP) transports for tunneling. This field is in
	 * network byte order. A value of 0 shall fail the command.
	 */
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_tunnel_dst_port_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t tunnel_dst_port_id;
	/*
	 * Identifier of a tunnel L4 destination port value. Only applies to
	 * tunnel types that has l4 destination port parameters.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_tunnel_dst_port_free */
/*
 * Description: This function is called by a driver to free l4 destination port
 * for a specific tunnel type.
 */
/* Input (24 bytes) */

struct hwrm_tunnel_dst_port_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t tunnel_type;
	/* Tunnel Type. */
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_VXLAN UINT32_C(0x1)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_GENEVE UINT32_C(0x5)
	uint8_t unused_0;
	uint16_t tunnel_dst_port_id;
	/*
	 * Identifier of a tunnel L4 destination port value. Only applies to
	 * tunnel types that has l4 destination port parameters.
	 */
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_tunnel_dst_port_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_stat_ctx_alloc */
/*
 * Description: This command allocates and does basic preparation for a stat
 * context.
 */
/* Input (32 bytes) */

struct hwrm_stat_ctx_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t stats_dma_addr;
	/* This is the address for statistic block. */
	uint32_t update_period_ms;
	/*
	 * The statistic block update period in ms. e.g. 250ms, 500ms, 750ms,
	 * 1000ms. If update_period_ms is 0, then the stats update shall be
	 * never done and the DMA address shall not be used. In this case, the
	 * stat block can only be read by hwrm_stat_ctx_query command.
	 */
	uint8_t stat_ctx_flags;
	/*
	 * This field is used to specify statistics context specific
	 * configuration flags.
	 */
	/*
	 * When this bit is set to '1', the statistics context shall be
	 * allocated for RoCE traffic only. In this case, traffic other than
	 * offloaded RoCE traffic shall not be included in this statistic
	 * context. When this bit is set to '0', the statistics context shall be
	 * used for the network traffic other than offloaded RoCE traffic.
	 */
	#define HWRM_STAT_CTX_ALLOC_INPUT_STAT_CTX_FLAGS_ROCE	UINT32_C(0x1)
	uint8_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_stat_ctx_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t stat_ctx_id;
	/* This is the statistics context ID value. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_stat_ctx_free */
/* Description: This command is used to free a stat context. */
/* Input (24 bytes) */

struct hwrm_stat_ctx_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t stat_ctx_id;
	/* ID of the statistics context that is being queried. */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_stat_ctx_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t stat_ctx_id;
	/* This is the statistics context ID value. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_stat_ctx_query */
/* Description: This command returns statistics of a context. */
/* Input (24 bytes) */

struct hwrm_stat_ctx_query_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t stat_ctx_id;
	/* ID of the statistics context that is being queried. */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (176 bytes) */

struct hwrm_stat_ctx_query_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t tx_ucast_pkts;
	/* Number of transmitted unicast packets */
	uint64_t tx_mcast_pkts;
	/* Number of transmitted multicast packets */
	uint64_t tx_bcast_pkts;
	/* Number of transmitted broadcast packets */
	uint64_t tx_err_pkts;
	/* Number of transmitted packets with error */
	uint64_t tx_drop_pkts;
	/* Number of dropped packets on transmit path */
	uint64_t tx_ucast_bytes;
	/* Number of transmitted bytes for unicast traffic */
	uint64_t tx_mcast_bytes;
	/* Number of transmitted bytes for multicast traffic */
	uint64_t tx_bcast_bytes;
	/* Number of transmitted bytes for broadcast traffic */
	uint64_t rx_ucast_pkts;
	/* Number of received unicast packets */
	uint64_t rx_mcast_pkts;
	/* Number of received multicast packets */
	uint64_t rx_bcast_pkts;
	/* Number of received broadcast packets */
	uint64_t rx_err_pkts;
	/* Number of received packets with error */
	uint64_t rx_drop_pkts;
	/* Number of dropped packets on received path */
	uint64_t rx_ucast_bytes;
	/* Number of received bytes for unicast traffic */
	uint64_t rx_mcast_bytes;
	/* Number of received bytes for multicast traffic */
	uint64_t rx_bcast_bytes;
	/* Number of received bytes for broadcast traffic */
	uint64_t rx_agg_pkts;
	/* Number of aggregated unicast packets */
	uint64_t rx_agg_bytes;
	/* Number of aggregated unicast bytes */
	uint64_t rx_agg_events;
	/* Number of aggregation events */
	uint64_t rx_agg_aborts;
	/* Number of aborted aggregations */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_stat_ctx_clr_stats */
/* Description: This command clears statistics of a context. */
/* Input (24 bytes) */

struct hwrm_stat_ctx_clr_stats_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t stat_ctx_id;
	/* ID of the statistics context that is being queried. */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_stat_ctx_clr_stats_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_fw_reset */
/*
 * Description: This function is called by a driver to self reset the firmware
 * running on the processor indicated by the embedded_proc_type.
 */
/* Input (24 bytes) */

struct hwrm_fw_reset_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t embedded_proc_type;
	/* Type of embedded processor. */
	/* Boot Processor */
	#define HWRM_FW_RESET_INPUT_EMBEDDED_PROC_TYPE_BOOT	UINT32_C(0x0)
	/* Management Processor */
	#define HWRM_FW_RESET_INPUT_EMBEDDED_PROC_TYPE_MGMT	UINT32_C(0x1)
	/* Network control processor */
	#define HWRM_FW_RESET_INPUT_EMBEDDED_PROC_TYPE_NETCTRL	UINT32_C(0x2)
	/* RoCE control processor */
	#define HWRM_FW_RESET_INPUT_EMBEDDED_PROC_TYPE_ROCE	UINT32_C(0x3)
	/*
	 * Host (in multi-host environment): This is only valid if
	 * requester is IPC
	 */
	#define HWRM_FW_RESET_INPUT_EMBEDDED_PROC_TYPE_HOST	UINT32_C(0x4)
	uint8_t selfrst_status;
	/* Type of self reset. */
	/* No Self Reset */
	#define HWRM_FW_RESET_INPUT_SELFRST_STATUS_SELFRSTNONE	UINT32_C(0x0)
	/* Self Reset as soon as possible to do so safely */
	#define HWRM_FW_RESET_INPUT_SELFRST_STATUS_SELFRSTASAP	UINT32_C(0x1)
	/* Self Reset on PCIe Reset */
	#define HWRM_FW_RESET_INPUT_SELFRST_STATUS_SELFRSTPCIERST UINT32_C(0x2)
	uint8_t host_idx;
	/*
	 * Indicate which host is being reset. 0 means first host. Only valid
	 * when embedded_proc_type is host in multihost environment
	 */
	uint8_t unused_0[5];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fw_reset_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t selfrst_status;
	/* Type of self reset. */
	/* No Self Reset */
	#define HWRM_FW_RESET_OUTPUT_SELFRST_STATUS_SELFRSTNONE   UINT32_C(0x0)
	/* Self Reset as soon as possible to do so safely */
	#define HWRM_FW_RESET_OUTPUT_SELFRST_STATUS_SELFRSTASAP   UINT32_C(0x1)
	/* Self Reset on PCIe Reset */
	#define HWRM_FW_RESET_OUTPUT_SELFRST_STATUS_SELFRSTPCIERST UINT32_C(0x2)
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_fw_qstatus */
/*
 * Description: This function is called by a driver to query the status of the
 * firmware running on the processor indicated by the embedded_proc_type.
 */
/* Input (24 bytes) */

struct hwrm_fw_qstatus_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t embedded_proc_type;
	/* Type of embedded processor. */
	/* Boot Processor */
	#define HWRM_FW_QSTATUS_INPUT_EMBEDDED_PROC_TYPE_BOOT	UINT32_C(0x0)
	/* Management Processor */
	#define HWRM_FW_QSTATUS_INPUT_EMBEDDED_PROC_TYPE_MGMT	UINT32_C(0x1)
	/* Network control processor */
	#define HWRM_FW_QSTATUS_INPUT_EMBEDDED_PROC_TYPE_NETCTRL  UINT32_C(0x2)
	/* RoCE control processor */
	#define HWRM_FW_QSTATUS_INPUT_EMBEDDED_PROC_TYPE_ROCE	UINT32_C(0x3)
	/*
	 * Host (in multi-host environment): This is only valid if
	 * requester is IPC
	 */
	#define HWRM_FW_QSTATUS_INPUT_EMBEDDED_PROC_TYPE_HOST	UINT32_C(0x4)
	uint8_t unused_0[7];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fw_qstatus_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t selfrst_status;
	/* Type of self reset. */
	/* No Self Reset */
	#define HWRM_FW_QSTATUS_OUTPUT_SELFRST_STATUS_SELFRSTNONE UINT32_C(0x0)
	/* Self Reset as soon as possible to do so safely */
	#define HWRM_FW_QSTATUS_OUTPUT_SELFRST_STATUS_SELFRSTASAP UINT32_C(0x1)
	/* Self Reset on PCIe Reset */
	#define HWRM_FW_QSTATUS_OUTPUT_SELFRST_STATUS_SELFRSTPCIERST UINT32_C(0x2)
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_fw_set_time */
/*
 * Description: Inform the HWRM firmware of the current date/time. Ideally, the
 * date/time will be current time in GMT/UTC and the zone value will be 0
 * (indicating UTC). If the time zone is not known, the zone value shall be
 * 0xffff. Other values for zone are discouraged, but if specified, they
 * indicate the number of minutes east of UTC, while zones west of UTC are
 * represented with a 2's complement negative value (e.g. PST would be -480
 * while PDT would be -420).
 */
/* Input (32 bytes) */

struct hwrm_fw_set_time_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t year;
	/* Current year */
	/* Date/time is not known */
	#define HWRM_FW_SET_TIME_INPUT_YEAR_UNKNOWN		UINT32_C(0x0)
	uint8_t month;
	/* Current month of year (1-12) */
	uint8_t day;
	/* Current day of month (1-31) */
	uint8_t hour;
	/* Current hour (0-23) */
	uint8_t minute;
	/* Current minute (0-59) */
	uint8_t second;
	/* Current second (0-59) */
	uint8_t unused_0;
	uint16_t millisecond;
	/* Current millisecond (0-999) */
	uint16_t zone;
	/* Minutes east of UTC, 0xffff if TZ is not known */
	/* Time zone is Coordinated Universal Time (UTC) */
	#define HWRM_FW_SET_TIME_INPUT_ZONE_UTC		UINT32_C(0x0)
	/* Time zone is not known */
	#define HWRM_FW_SET_TIME_INPUT_ZONE_UNKNOWN		UINT32_C(0xffff)
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fw_set_time_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_fw_get_time */
/* Description: Query the HWRM firmware's notion of the current date/time. */
/* Input (16 bytes) */

struct hwrm_fw_get_time_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_fw_get_time_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t year;
	/* Current year */
	/* Date/time is not known */
	#define HWRM_FW_GET_TIME_OUTPUT_YEAR_UNKNOWN		UINT32_C(0x0)
	uint8_t month;
	/* Current month of year (1-12) */
	uint8_t day;
	/* Current day of month (1-31) */
	uint8_t hour;
	/* Current hour (0-23) */
	uint8_t minute;
	/* Current minute (0-59) */
	uint8_t second;
	/* Current second (0-59) */
	uint8_t unused_0;
	uint16_t millisecond;
	/* Current millisecond (0-999) */
	uint16_t zone;
	/* Minutes east of UTC, 0xffff if TZ is not known */
	/* Time zone is Coordinated Universal Time (UTC) */
	#define HWRM_FW_GET_TIME_OUTPUT_ZONE_UTC		UINT32_C(0x0)
	/* Time zone is not known */
	#define HWRM_FW_GET_TIME_OUTPUT_ZONE_UNKNOWN		UINT32_C(0xffff)
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_fw_set_structured_data */
/*
 * Description: There can be a variable number of Structure Data Headers (SDH)
 * between offset 0x0 and the 'valid' field to handle customizable return
 * values. Each Structure Data Header will include one defined structure. The
 * number of returned structures can be 0, in which case the 'valid' field
 * starts at offset 0x8. The 'valid' field offset is adjusted based on the
 * Structure Data Header length and the length of the structured data it
 * contains.
 */
/* Input (32 bytes) */

struct hwrm_fw_set_structured_data_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t src_data_addr;
	/* This is the host address where structured data will be copied from */
	uint16_t data_len;
	/* size of data in bytes */
	uint8_t hdr_cnt;
	/*
	 * a count of the number of Structured Data Headers in the data pointed
	 * by src_data_addr.
	 */
	uint8_t unused_0[5];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fw_set_structured_data_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_fw_set_structured_data_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_FW_SET_STRUCTURED_DATA_CMD_ERR_CODE_UNKNOWN  UINT32_C(0x0)
	/* count_of_headers is incorrect */
	#define HWRM_FW_SET_STRUCTURED_DATA_CMD_ERR_CODE_BAD_HDR_CNT UINT32_C(0x1)
	/* data improperly formatted */
	#define HWRM_FW_SET_STRUCTURED_DATA_CMD_ERR_CODE_BAD_FMT  UINT32_C(0x2)
	/* unknown structure ID(s) */
	#define HWRM_FW_SET_STRUCTURED_DATA_CMD_ERR_CODE_BAD_ID   UINT32_C(0x3)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_fw_get_structured_data */
/* Input (32 bytes) */

struct hwrm_fw_get_structured_data_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t dest_data_addr;
	/* This is the host address where structured data will be copied to */
	uint16_t data_len;
	/* size of data in bytes */
	uint16_t structure_id;
	/*
	 * Structure_id is the id of the structure data requesting and count is
	 * a requested number of instances of this data requested. The actual
	 * number will be returned in count_of_headers
	 */
	uint16_t subtype;
	/*
	 * Subtype is an optional field used to specify additional information
	 * of the data being retrieved. For example, if data can be categorized
	 * as "live" vs "saved" then this field can be used to provide an
	 * indication of "saved" vs "live" data. Not all structured data
	 * supports subtypes and if they are supported then the structured data
	 * will specify the valid values. If structured data is requested that
	 * supports subtypes but no subtype is given then it is implementation
	 * specific what will be returned. Some structure data can support a
	 * subtype of "All" which would cause a list of structures to be
	 * returned for all supported subtypes. "All" is only used on the
	 * hwrm_get_structured_data command.
	 */
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_ALL	UINT32_C(0xffff)
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_NEAR_BRIDGE_ADMIN UINT32_C(0x100)
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_NEAR_BRIDGE_PEER UINT32_C(0x101)
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_NEAR_BRIDGE_OPERATIONAL UINT32_C(0x102)
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_NON_TPMR_ADMIN UINT32_C(0x200)
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_NON_TPMR_PEER UINT32_C(0x201)
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_NON_TPMR_OPERATIONAL UINT32_C(0x202)
	#define HWRM_FW_GET_STRUCTURED_DATA_INPUT_SUBTYPE_HOST_OPERATIONAL UINT32_C(0x300)
	uint8_t count;
	/* Number of elements. This allows support of arrayed data */
	uint8_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fw_get_structured_data_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t hdr_cnt;
	/*
	 * a count of the number of Structured Data Headers in the data pointed
	 * by dest_data_addr.
	 */
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_fw_get_structured_data_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_FW_GET_STRUCTURED_DATA_CMD_ERR_CODE_UNKNOWN  UINT32_C(0x0)
	/* unknown structure ID(s) */
	#define HWRM_FW_GET_STRUCTURED_DATA_CMD_ERR_CODE_BAD_ID   UINT32_C(0x3)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_fw_ipc_mailbox */
/* Input (32 bytes) */

struct hwrm_fw_ipc_mailbox_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint8_t flags;
	uint8_t unused_0;
	/* unused is 8 b */
	uint8_t event_id;
	/* asynchronous event to hosts. */
	uint8_t port_id;
	/* PORT ID */
	uint32_t event_data1;
	/* event data1 of asynchronous event */
	uint32_t event_data2;
	/* event data2 of asynchronous event */
	uint32_t unused_1;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fw_ipc_mailbox_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_fw_ipc_mailbox_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_FW_IPC_MAILBOX_CMD_ERR_CODE_UNKNOWN	UINT32_C(0x0)
	/* invalid event */
	#define HWRM_FW_IPC_MAILBOX_CMD_ERR_CODE_BAD_ID	UINT32_C(0x3)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_exec_fwd_resp */
/*
 * Description: This command is used to send an encapsulated request to the
 * HWRM. This command instructs the HWRM to execute the request and forward the
 * response of the encapsulated request to the location specified in the
 * original request that is encapsulated. The target id of this command shall be
 * set to 0xFFFF (HWRM). The response location in this command shall be used to
 * acknowledge the receipt of the encapsulated request and forwarding of the
 * response.
 */
/* Input (128 bytes) */

struct hwrm_exec_fwd_resp_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t encap_request[26];
	/*
	 * This is an encapsulated request. This request should be executed by
	 * the HWRM and the response should be provided in the response buffer
	 * inside the encapsulated request.
	 */
	uint16_t encap_resp_target_id;
	/*
	 * This value indicates the target id of the response to the
	 * encapsulated request. 0x0 - 0xFFF8 - Used for function ids 0xFFF8 -
	 * 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_exec_fwd_resp_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_reject_fwd_resp */
/*
 * Description: This command is used to send an encapsulated request to the
 * HWRM. This command instructs the HWRM to reject the request and forward the
 * error response of the encapsulated request to the location specified in the
 * original request that is encapsulated. The target id of this command shall be
 * set to 0xFFFF (HWRM). The response location in this command shall be used to
 * acknowledge the receipt of the encapsulated request and forwarding of the
 * response.
 */
/* Input (128 bytes) */

struct hwrm_reject_fwd_resp_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t encap_request[26];
	/*
	 * This is an encapsulated request. This request should be rejected by
	 * the HWRM and the error response should be provided in the response
	 * buffer inside the encapsulated request.
	 */
	uint16_t encap_resp_target_id;
	/*
	 * This value indicates the target id of the response to the
	 * encapsulated request. 0x0 - 0xFFF8 - Used for function ids 0xFFF8 -
	 * 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_reject_fwd_resp_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_fwd_resp */
/*
 * Description: This command is used to send an encapsulated response to the
 * HWRM. The HWRM shall forward this response based on the target id. The
 * response address provided in this command shall be used to acknowledge the
 * receipt of the encapsulated response. The encapsulated response address
 * provided in this command shall be used to provide the encapsulated response.
 */
/* Input (40 bytes) */

struct hwrm_fwd_resp_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t encap_resp_target_id;
	/*
	 * This value indicates the target id of the encapsulated response. 0x0
	 * - 0xFFF8 - Used for function ids 0xFFF8 - 0xFFFE - Reserved for
	 * internal processors 0xFFFF - HWRM
	 */
	uint16_t encap_resp_cmpl_ring;
	/*
	 * This value indicates the completion ring the encapsulated response
	 * will be optionally completed on. If the value is -1, then no CR
	 * completion shall be generated for the encapsulated response. Any
	 * other value must be a valid CR ring_id value. If a valid
	 * encap_resp_cmpl_ring is provided, then a CR completion shall be
	 * generated for the encapsulated response.
	 */
	uint16_t encap_resp_len;
	/* This field indicates the length of encapsulated response. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint64_t encap_resp_addr;
	/*
	 * This is the host address where the encapsulated response will be
	 * written. This area must be 16B aligned and must be cleared to zero
	 * before the original request is made.
	 */
	uint32_t encap_resp[24];
	/* This is an encapsulated response. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fwd_resp_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_fwd_async_event_cmpl */
/*
 * Description: This command is used to send an encapsulated asynchronous event
 * completion to the HWRM. The HWRM shall forward this asynchronous event
 * completion to target(s) specified in the command. The HWRM shall complete
 * this command only after forwarding asynchronous event completion to specified
 * targets.
 */
/* Input (32 bytes) */

struct hwrm_fwd_async_event_cmpl_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t encap_async_event_target_id;
	/*
	 * This value indicates the target id of the encapsulated asynchronous
	 * event. 0x0 - 0xFFF8 - Used for function ids 0xFFF8 - 0xFFFE -
	 * Reserved for internal processors 0xFFFF - Broadcast to all children
	 * VFs (only applicable when a PF is the requester)
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2[3];
	uint8_t unused_3;
	uint32_t encap_async_event_cmpl[4];
	/* This is an encapsulated asynchronous event completion. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_fwd_async_event_cmpl_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_temp_monitor_query */
/*
 * Description: A temperature monitor is used to query the device temperature.
 */
/* Input (16 bytes) */

struct hwrm_temp_monitor_query_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_temp_monitor_query_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t temp;
	/* The HWRM shall provide the current temperature of device in Celsius. */
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_wol_filter_alloc */
/*
 * Description: A Wake-On-LAN (WoL) filter is a filter resource that is used to
 * identify a WoL packet. # Among all function drivers, the HWRM shall only
 * allow PF drivers to allocate WoL filters. # The HWRM shall not allow VF
 * drivers to allocate any WoL filters. # When partitioning is enabled and WoL
 * is supported, the HWRM shall support at least one WoL filter per partition. #
 * The HWRM shall retain a WoL filter setting until the filter is freed. # If
 * the HWRM client is a function driver, then the HWRM shall not allow the HWRM
 * client to set up WoL filters on the port that the function is not associated
 * with. # If the HWRM client is one of the trusted embedded services (e.g.
 * management service), the HWRM shall allow the HWRM client to set up WoL
 * filters on any port of the device.
 */
/* Input (64 bytes) */

struct hwrm_wol_filter_alloc_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	uint32_t enables;
	/* This bit must be '1' for the mac_address field to be configured. */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_ENABLES_MAC_ADDRESS	UINT32_C(0x1)
	/* This bit must be '1' for the pattern_offset field to be configured. */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_ENABLES_PATTERN_OFFSET UINT32_C(0x2)
	/* This bit must be '1' for the pattern_buf_size field to be configured. */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_ENABLES_PATTERN_BUF_SIZE UINT32_C(0x4)
	/* This bit must be '1' for the pattern_buf_addr field to be configured. */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_ENABLES_PATTERN_BUF_ADDR UINT32_C(0x8)
	/*
	 * This bit must be '1' for the pattern_mask_addr field to be
	 * configured.
	 */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_ENABLES_PATTERN_MASK_ADDR UINT32_C(0x10)
	/*
	 * This bit must be '1' for the pattern_mask_size field to be
	 * configured.
	 */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_ENABLES_PATTERN_MASK_SIZE UINT32_C(0x20)
	uint16_t port_id;
	/* Port ID of port on which WoL filter is configured. */
	uint8_t wol_type;
	/* This value represents a Wake-on-LAN type. */
	/* Magic Packet */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_WOL_TYPE_MAGICPKT	UINT32_C(0x0)
	/* Bitmap */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_WOL_TYPE_BMP	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_WOL_FILTER_ALLOC_INPUT_WOL_TYPE_INVALID	UINT32_C(0xff)
	uint8_t unused_0;
	uint32_t unused_1;
	uint8_t mac_address[6];
	/*
	 * # If this field is enabled and magic packet WoL filter type is
	 * specified in this command, the value set in this field shall be used
	 * in setting the magic packet based WoL filter. # If this field is not
	 * enabled and magic packet WoL filter type is specified and port id is
	 * specified to 0xFF in this command, then the HWRM shall use default
	 * MAC address configured on the function associated with the HWRM
	 * client. # If this field is not enabled and magic packet WoL filter
	 * type is specified and port id is not specified to 0xFF in this
	 * command, then the HWRM shall use default MAC address configured on
	 * the port.
	 */
	uint16_t pattern_offset;
	/*
	 * The offset from the beginning of MAC header where pattern should be
	 * matched. Applies to bitmap WoL.
	 */
	uint16_t pattern_buf_size;
	/* The size of the pattern that is being matched. Applies to bitmap WoL. */
	uint16_t pattern_mask_size;
	/* The size of the pattern mask. Applies to bitmap WoL. */
	uint32_t unused_2;
	uint64_t pattern_buf_addr;
	/* Physical address of the pattern buffer. Applies to bitmap WoL. */
	uint64_t pattern_mask_addr;
	/* Physical address of the pattern mask. Applies to bitmap WoL. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_wol_filter_alloc_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t wol_filter_id;
	/* This value identifies a Wake-on-LAN (WoL) filter. */
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_wol_filter_free */
/*
 * Description: Free a WoL filter. # Among all function drivers, the HWRM shall
 * only allow PF drivers to free WoL filters. # The HWRM shall not allow VF
 * drivers to free any WoL filters. # The HWRM shall not allow a function driver
 * to free an Out-Of-Box WoL filter. # The HWRM shall not allow a function
 * driver to free a WoL filter on a port that the corresponding function is not
 * associated with. # The HWRM shall not allow a function driver to free a WoL
 * filter on a function that the function driver is not associated with.
 */
/* Input (32 bytes) */

struct hwrm_wol_filter_free_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t flags;
	/*
	 * # When this bit is set to '1', then all active WoL filters on the
	 * port are requested to be freed. # If the a function driver sets this
	 * flag to '1', then the HWRM shall free all active WoL filters that are
	 * not set by other function drivers on that port.
	 */
	#define HWRM_WOL_FILTER_FREE_INPUT_FLAGS_FREE_ALL_WOL_FILTERS UINT32_C(0x1)
	uint32_t enables;
	/* This bit must be '1' for the wol_filter_id field to be configured. */
	#define HWRM_WOL_FILTER_FREE_INPUT_ENABLES_WOL_FILTER_ID   UINT32_C(0x1)
	uint16_t port_id;
	/* Port ID of the port on which WoL filter(s) is (are) being freed. */
	uint8_t wol_filter_id;
	/* The HWRM shall ignore this field if free_all_wol_filters flag is set. */
	uint8_t unused_0[5];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_wol_filter_free_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_wol_filter_qcfg */
/*
 * Description: Query WoL filter configuration. # Among all function drivers,
 * the HWRM shall only allow PF drivers to query WoL filters. # The HWRM shall
 * not allow VF drivers to query any WoL filters. # The HWRM shall return WoL
 * filters that are active on the associated port for which this query is being
 * performed. # If the HWRM client is a function driver, then the HWRM shall not
 * allow the HWRM client to query WoL filters that are set up by other function
 * drivers. # If the HWRM client is a function driver, then the HWRM shall not
 * allow the HWRM client to query WoL filters on the port that the function is
 * not associated with. # If the HWRM client is one of the trusted embedded
 * service (e.g. management service), the HWRM shall allow the HWRM client
 * to query WoL filters on any port of the device.
 */
/* Input (56 bytes) */

struct hwrm_wol_filter_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port on which WoL filter that is being queried. */
	uint16_t handle;
	/*
	 * This is an opaque handle used to access filters. # The HWRM client
	 * shall set this field to 0x0000 to begin the query. # After the first
	 * query, the HWRM client shall retrieve next filters (if they exist)
	 * using the HWRM provided handle in the response.
	 */
	uint32_t unused_0;
	uint64_t pattern_buf_addr;
	/*
	 * Physical address of the pattern buffer. Applies to bitmap WoL filter
	 * only. # Value of 0 indicates an invalid buffer address. If this field
	 * is set to 0, then HWRM shall ignore pattern_buf_size. # If the HWRM
	 * client provides an invalid buffer address for the pattern, then the
	 * HWRM is not required to provide pattern when the response contains a
	 * bitmap WoL filter.
	 */
	uint16_t pattern_buf_size;
	/* The size of the pattern buffer. Applies to bitmap WoL filter only. */
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3[3];
	uint8_t unused_4;
	uint64_t pattern_mask_addr;
	/*
	 * Physical address of the pattern mask. Applies to bitmap WoL filter
	 * only. # Value of 0 indicates an invalid pattern mask address. If this
	 * field is set to 0, then HWRM shall ignore pattern_mask_size. # If the
	 * HWRM client provides an invalid mask address for the pattern, then
	 * the HWRM is not required to provide mask when the response contains a
	 * bitmap WoL filter.
	 */
	uint16_t pattern_mask_size;
	/*
	 * The size of the buffer for pattern mask. Applies to bitmap WoL filter
	 * only.
	 */
	uint16_t unused_5[3];
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_wol_filter_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t next_handle;
	/*
	 * This is the next handle that is used to access filters. # If this
	 * field is set to 0x0000, then no WoL filters are currently configured
	 * on this port and all other fields in the output shall be ignored by
	 * the HWRM client. # If this field is set to neither 0x0000 nor 0xFFFF,
	 * then the wol_filter_id is valid and the parameters provided in the
	 * response are based on the wol_type. # If this field is set to 0xFFFF,
	 * then there are no remaining configured WoL filters to be queried for
	 * the queried function after this response, wol_filter_id is valid and
	 * the parameters provided in the response are based on the wol_type.
	 */
	uint8_t wol_filter_id;
	/* This value identifies the filter returned in this response. */
	uint8_t wol_type;
	/*
	 * This value identifies the type of WoL filter returned in this
	 * response.
	 */
	/* Magic Packet */
	#define HWRM_WOL_FILTER_QCFG_OUTPUT_WOL_TYPE_MAGICPKT	UINT32_C(0x0)
	/* Bitmap */
	#define HWRM_WOL_FILTER_QCFG_OUTPUT_WOL_TYPE_BMP	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_WOL_FILTER_QCFG_OUTPUT_WOL_TYPE_INVALID	UINT32_C(0xff)
	uint32_t unused_0;
	uint8_t mac_address[6];
	/*
	 * The MAC address value used by the WoL filter. Applies to magic packet
	 * based WoL.
	 */
	uint16_t pattern_offset;
	/*
	 * The offset from the beginning of MAC header where pattern should be
	 * matched. Applies to bitmap WoL.
	 */
	uint16_t pattern_size;
	/*
	 * The actual size of the pattern that is being returned. Applies to
	 * bitmap WoL.
	 */
	uint16_t pattern_mask_size;
	/*
	 * The actual size of the pattern mask that is being returned. Applies
	 * to bitmap WoL.
	 */
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_wol_reason_qcfg */
/* Description: Query WoL reason for the last system wake up. */
/* Input (40 bytes) */

struct hwrm_wol_reason_qcfg_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t port_id;
	/* Port ID of port for which this query is for. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2[3];
	uint8_t unused_3;
	uint64_t wol_pkt_buf_addr;
	/* Physical address of the packet buffer for querying WoL packet. */
	uint16_t wol_pkt_buf_size;
	/* The size of the buffer for the WoL packet. */
	uint16_t unused_4[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_wol_reason_qcfg_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t wol_filter_id;
	/*
	 * This value identifies the filter that matched the last WoL packet.
	 * This id is only valid with valid WoL reason.
	 */
	uint8_t wol_reason;
	/*
	 * This value identifies the type of WoL reason returned in this
	 * response. When the wol_type is set to invalid, then there is no WoL
	 * event that happened during last system wake-up.
	 */
	/* Magic Packet */
	#define HWRM_WOL_REASON_QCFG_OUTPUT_WOL_REASON_MAGICPKT   UINT32_C(0x0)
	/* Bitmap */
	#define HWRM_WOL_REASON_QCFG_OUTPUT_WOL_REASON_BMP	UINT32_C(0x1)
	/* Invalid */
	#define HWRM_WOL_REASON_QCFG_OUTPUT_WOL_REASON_INVALID	UINT32_C(0xff)
	uint8_t wol_pkt_len;
	/* The value identifies the length of the WoL packet in bytes. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_dbg_dump */
/*
 * Description: This command is used by to initiate the dump of debug
 * information to a driver specified address.
 */
/* Input (40 bytes) */

struct hwrm_dbg_dump_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t handle;
	/*
	 * Handle used to dump debug data. handle = 0 indicates the beginning of
	 * the dump. handle != 0 indicates the request to dump the next part.
	 */
	uint32_t unused_0;
	uint64_t host_dbg_dump_addr;
	/*
	 * Address of the host buffer where the debug data is requested to be
	 * dumped.
	 */
	uint64_t host_dbg_dump_addr_len;
	/* Length of host buffer used for transferring debug data. */
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_dbg_dump_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t nexthandle;
	/*
	 * Handle used to indicate availability of additional debug data.
	 * nexthandle = 0 indicates that there is no more debug data available.
	 * nexthandle != 0 indicates the handle value that should be used to
	 * request the next part of debug data.
	 */
	uint32_t dbg_data_len;
	/* The number of bytes of debug data written to debug dump buffer. */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_raw_write_blk */
/*
 * Note: Write an unmanaged block of data at any physical offset within the
 * NVRAM. Used for initial provisioning/manufacturing purposes only. Implemented
 * in the ChiMP boot-strap firmware (fwutil.bin) only.
 */
/* Input (32 bytes) */

struct hwrm_nvm_raw_write_blk_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t host_src_addr;
	/*
	 * 64-bit Host Source Address. This is the location of the source data to
	 * be written.
	 */
	uint32_t dest_addr;
	/*
	 * 32-bit Destination Address. This is the NVRAM byte-offset where the
	 * source data will be written to.
	 */
	uint32_t len;
	/* Length of data to be written, in bytes. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_raw_write_blk_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_read */
/*
 * Note: Read the contents of an NVRAM item as referenced (indexed) by an
 * existing directory entry.
 */
/* Input (40 bytes) */

struct hwrm_nvm_read_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t host_dest_addr;
	/*
	 * 64-bit Host Destination Address. This is the host address where the
	 * data will be written to.
	 */
	uint16_t dir_idx;
	/* The 0-based index of the directory entry. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t offset;
	/* The NVRAM byte-offset to read from. */
	uint32_t len;
	/* The length of the data to be read, in bytes. */
	uint32_t unused_2;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_read_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_raw_dump */
/* Note: Dump a raw block of data from NVRAM. */
/* Input (32 bytes) */

struct hwrm_nvm_raw_dump_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t host_dest_addr;
	/*
	 * 64-bit Host Destination Address. This is the host address where the
	 * data will be written to.
	 */
	uint32_t offset;
	/* 32-bit NVRAM byte-offset to read from. */
	uint32_t len;
	/* Total length of NVRAM contents to be read, in bytes. */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_raw_dump_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_get_dir_entries */
/*
 * Description: Read the NVRAM directory. Each directory entry is at least 24
 * bytes in length and contains the: - 16-bit directory entry type
 * (BNX_DIR_TYPE_* value) - 16-bit ordinal (instance of this directory entry
 * type) - 16-bit extension flags (identifies inactive entries and entries for
 * firmware update) - 16-bit attribute flags (identifies entries with a
 * purposely invalid chksum value) - 32-bit byte-offset into NVRAM where this
 * item data is located - 32-bit length of allocated NVRAM for item, in bytes
 * (multiple of block size) - 32-bit length of data (excluding padding), in
 * bytes (may be 0) - 32-bit data checksum (CRC-32) See the
 * bnxnvm_directory_entry_t definition in the file bnxnvm_defs.h.
 */
/* Input (24 bytes) */

struct hwrm_nvm_get_dir_entries_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t host_dest_addr;
	/*
	 * 64-bit Host Destination Address. This is the host address where the
	 * directory will be written.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_get_dir_entries_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_get_dir_info */
/* Note: Get Directory Header info. */
/* Input (16 bytes) */

struct hwrm_nvm_get_dir_info_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_nvm_get_dir_info_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t entries;
	/* Number of directory entries in the directory. */
	uint32_t entry_length;
	/* Size of each directory entry, in bytes. */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_write */
/*
 * Note: Write to the allocated NVRAM of an item referenced by an existing
 * directory entry.
 */
/* Input (48 bytes) */

struct hwrm_nvm_write_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t host_src_addr;
	/* 64-bit Host Source Address. This is where the source data is. */
	uint16_t dir_type;
	/*
	 * The Directory Entry Type (valid values are defined in the
	 * bnxnvm_directory_type enum defined in the file bnxnvm_defs.h).
	 */
	uint16_t dir_ordinal;
	/*
	 * Directory ordinal. The 0-based instance of the combined Directory
	 * Entry Type and Extension.
	 */
	uint16_t dir_ext;
	/*
	 * The Directory Entry Extension flags (see BNX_DIR_EXT_* in the file
	 * bnxnvm_defs.h).
	 */
	uint16_t dir_attr;
	/*
	 * Directory Entry Attribute flags (see BNX_DIR_ATTR_* in the file
	 * bnxnvm_defs.h).
	 */
	uint32_t dir_data_length;
	/*
	 * Length of data to write, in bytes. May be less than or equal to the
	 * allocated size for the directory entry. The data length stored in the
	 * directory entry will be updated to reflect this value once the write
	 * is complete.
	 */
	uint16_t option;
	/* Option. */
	uint16_t flags;
	/*
	 * When this bit is '1', the original active image will not be removed.
	 * TBD: what purpose is this?
	 */
	#define HWRM_NVM_WRITE_INPUT_FLAGS_KEEP_ORIG_ACTIVE_IMG	UINT32_C(0x1)
	uint32_t dir_item_length;
	/*
	 * The requested length of the allocated NVM for the item, in bytes.
	 * This value may be greater than or equal to the specified data length
	 * (dir_data_length). If this value is less than the specified data
	 * length, it will be ignored. The response will contain the actual
	 * allocated item length, which may be greater than the requested item
	 * length. The purpose for allocating more than the required number of
	 * bytes for an item's data is to pre-allocate extra storage (padding)
	 * to accommodate the potential future growth of an item (e.g. upgraded
	 * firmware with a size increase, log growth, expanded configuration
	 * data).
	 */
	uint32_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_write_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t dir_item_length;
	/*
	 * Length of the allocated NVM for the item, in bytes. The value may be
	 * greater than or equal to the specified data length or the requested
	 * item length. The actual item length used when creating a new
	 * directory entry will be a multiple of an NVM block size.
	 */
	uint16_t dir_idx;
	/* The directory index of the created or modified item. */
	uint8_t unused_0;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_nvm_write_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_NVM_WRITE_CMD_ERR_CODE_UNKNOWN		UINT32_C(0x0)
	/* Unable to complete operation due to fragmentation */
	#define HWRM_NVM_WRITE_CMD_ERR_CODE_FRAG_ERR		UINT32_C(0x1)
	/* nvm is completely full. */
	#define HWRM_NVM_WRITE_CMD_ERR_CODE_NO_SPACE		UINT32_C(0x2)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_nvm_modify */
/*
 * Note: Modify the contents of an NVRAM item as referenced (indexed) by an
 * existing directory entry.
 */
/* Input (40 bytes) */

struct hwrm_nvm_modify_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t host_src_addr;
	/* 64-bit Host Source Address. This is where the modified data is. */
	uint16_t dir_idx;
	/* 16-bit directory entry index. */
	uint8_t unused_0;
	uint8_t unused_1;
	uint32_t offset;
	/* 32-bit NVRAM byte-offset to modify content from. */
	uint32_t len;
	/*
	 * Length of data to be modified, in bytes. The length shall be non-
	 * zero.
	 */
	uint32_t unused_2;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_modify_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_find_dir_entry */
/*
 * Note: Search a directory entry in the directory by either directory entry
 * index or directory entry parameters.
 */
/* Input (32 bytes) */

struct hwrm_nvm_find_dir_entry_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the dir_idx_valid field to be configured. */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_ENABLES_DIR_IDX_VALID UINT32_C(0x1)
	uint16_t dir_idx;
	/* Directory Entry Index */
	uint16_t dir_type;
	/* Directory Entry (Image) Type */
	uint16_t dir_ordinal;
	/* Directory ordinal. The instance of this Directory Type */
	uint16_t dir_ext;
	/* The Directory Entry Extension flags. */
	uint8_t opt_ordinal;
	/* This value indicates the search option using dir_ordinal. */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_MASK	UINT32_C(0x3)
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_SFT	0
	/* Equal to specified ordinal value. */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_EQ	UINT32_C(0x0)
	/* Greater than or equal to specified ordinal value */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_GE	UINT32_C(0x1)
	/* Greater than specified ordinal value */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_GT	UINT32_C(0x2)
	uint8_t unused_1[3];
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_nvm_find_dir_entry_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t dir_item_length;
	/* Allocated NVRAM for this directory entry, in bytes. */
	uint32_t dir_data_length;
	/* Size of the stored data for this directory entry, in bytes. */
	uint32_t fw_ver;
	/*
	 * Firmware version. Only valid if the directory entry is for embedded
	 * firmware stored in APE_BIN Format.
	 */
	uint16_t dir_ordinal;
	/* Directory ordinal. */
	uint16_t dir_idx;
	/* Directory Entry Index */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_erase_dir_entry */
/*
 * Note: Remove a directory entry specified by the directory entry index from
 * the directory.
 */
/* Input (24 bytes) */

struct hwrm_nvm_erase_dir_entry_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t dir_idx;
	/* Directory Entry Index */
	uint16_t unused_0[3];
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_erase_dir_entry_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_get_dev_info */
/*
 * Note: Get device info. Return Manufacturer_ID, Device_ID, block_size,
 * nvram_size, reserved_size and available_size.
 */
/* Input (16 bytes) */

struct hwrm_nvm_get_dev_info_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (32 bytes) */

struct hwrm_nvm_get_dev_info_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t manufacturer_id;
	/* Manufacturer ID. */
	uint16_t device_id;
	/* Device ID. */
	uint32_t sector_size;
	/* Sector size of the NVRAM device. */
	uint32_t nvram_size;
	/* Total size, in bytes of the NVRAM device. */
	uint32_t reserved_size;
	uint32_t available_size;
	/*
	 * Available size that can be used, in bytes. Available size is the
	 * NVRAM size take away the used size and reserved size.
	 */
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_mod_dir_entry */
/* Note: Modify a directory entry parameters in the directory. */
/* Input (32 bytes) */

struct hwrm_nvm_mod_dir_entry_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t enables;
	/* This bit must be '1' for the checksum field to be configured. */
	#define HWRM_NVM_MOD_DIR_ENTRY_INPUT_ENABLES_CHECKSUM	UINT32_C(0x1)
	uint16_t dir_idx;
	/* Directory Entry Index */
	uint16_t dir_ordinal;
	/* Directory ordinal. The (0-based) instance of this Directory Type. */
	uint16_t dir_ext;
	/*
	 * The Directory Entry Extension flags (see BNX_DIR_EXT_* for extension
	 * flag definitions).
	 */
	uint16_t dir_attr;
	/*
	 * Directory Entry Attribute flags (see BNX_DIR_ATTR_* for attribute
	 * flag definitions).
	 */
	uint32_t checksum;
	/*
	 * If valid, then this field updates the checksum value of the content
	 * in the directory entry.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_mod_dir_entry_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_verify_update */
/*
 * Description: Verify updated content of a directory entry. Before this
 * verification, there should be two valid directory entries of the given
 * directory type (one with "UPDATE" directory extension flag and the current
 * one "ACTIVE"). Below are steps the HWRM performs for executing this command:
 * # The HWRM finds the directory entry with "UDPATE" extension flag based on
 * input parameters. The new directory entry should already have updated
 * contents. # The HWRM performs signature verification of the updated content.
 * # If the signature verification is successful, the two directory entries are
 * switched (the verified updated entry is made active and the current "ACTIVE"
 * entry is marked with "UPDATE" extension flag). Implementation notes: # The
 * HWRM shall allow this command to be requested against any dir_type value (and
 * not limit it to a subset). # In the case of an updated HWRM firmware, the new
 * firmware version shall not automatically take effect (i.e. be executed).
 */
/* Input (24 bytes) */

struct hwrm_nvm_verify_update_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint16_t dir_type;
	/* Directory Entry Type, to be verified. */
	uint16_t dir_ordinal;
	/* Directory ordinal. The instance of the Directory Type to be verified. */
	uint16_t dir_ext;
	/*
	 * The Directory Entry Extension flags. The "UPDATE" extension flag must
	 * be set in this value. A corresponding directory entry with the same
	 * type and ordinal values but *without* the "UPDATE" extension flag
	 * must also exist. The other flags of the extension must be identical
	 * between the active and update entries.
	 */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_verify_update_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* hwrm_nvm_install_update */
/*
 * Description: Install a staged NVM package. A package file must first be
 * staged into the "UPDATE" NVM item. This staging is accomplished using the
 * nvm_write and/or nvm_modify HWRM commands.
 */
/* Input (24 bytes) */

struct hwrm_nvm_install_update_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint32_t install_type;
	/*
	 * Installation type. If the value 3 through 0xffff is used, only
	 * packaged items with that type value will be installed and conditional
	 * installation directives for those packaged items will be over-ridden
	 * (i.e. 'create' or 'replace' will be treated as 'install').
	 */
	/*
	 * Perform a normal package installation. Conditional
	 * installation directives (e.g. 'create' and 'replace') of
	 * packaged items will be followed.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_INSTALL_TYPE_NORMAL UINT32_C(0x0)
	/*
	 * Install all packaged items regardless of installation
	 * directive (i.e. treat all packaged items as though they have
	 * an installation directive of 'install').
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_INSTALL_TYPE_ALL	UINT32_C(0xffffffff)
	uint16_t flags;
	/*
	 * If set to 1, then securely erase all unused locations in persistent
	 * storage.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_FLAGS_ERASE_UNUSED_SPACE UINT32_C(0x1)
	/*
	 * If set to 1, then unspecified images, images not in the package file,
	 * will be safely deleted. When combined with erase_unused_space then
	 * unspecified images will be securely erased.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_FLAGS_REMOVE_UNUSED_PKG UINT32_C(0x2)
	/*
	 * If set to 1, FW will defragment the NVM if defragmentation is
	 * required for the update. Allow additional time for this command to
	 * complete if this bit is set to 1.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_FLAGS_ALLOWED_TO_DEFRAG UINT32_C(0x4)
	uint16_t unused_0;
} __attribute__((packed));

/* Output (24 bytes) */

struct hwrm_nvm_install_update_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint64_t installed_items;
	/*
	 * Bit-mask of successfully installed items. Bit-0 corresponding to the
	 * first packaged item, Bit-1 for the second item, etc. A value of 0
	 * indicates that no items were successfully installed.
	 */
	uint8_t result;
	/* result is 8 b */
	/* There was no problem with the package installation. */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESULT_SUCCESS	UINT32_C(0x0)
	uint8_t problem_item;
	/* problem_item is 8 b */
	/* There was no problem with any packaged items. */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_PROBLEM_ITEM_NONE  UINT32_C(0x0)
	/* There was a problem with the NVM package itself. */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_PROBLEM_ITEM_PACKAGE UINT32_C(0xff)
	uint8_t reset_required;
	/* reset_required is 8 b */
	/*
	 * No reset is required for installed/updated firmware or
	 * microcode to take effect.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_NONE UINT32_C(0x0)
	/*
	 * A PCIe reset (e.g. system reboot) is required for newly
	 * installed/updated firmware or microcode to take effect.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_PCI UINT32_C(0x1)
	/*
	 * A controller power reset (e.g. system power-cycle) is
	 * required for newly installed/updated firmware or microcode to
	 * take effect. Some newly installed/updated firmware or
	 * microcode may still take effect upon the next PCIe reset.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_POWER UINT32_C(0x2)
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_nvm_install_update_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_UNKNOWN	UINT32_C(0x0)
	/* Unable to complete operation due to fragmentation */
	#define HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_FRAG_ERR	UINT32_C(0x1)
	/* nvm is completely full. */
	#define HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_NO_SPACE	UINT32_C(0x2)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_nvm_flush */
/* Input (16 bytes) */

struct hwrm_nvm_flush_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_flush_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_nvm_flush_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_NVM_FLUSH_CMD_ERR_CODE_UNKNOWN		UINT32_C(0x0)
	/* flush could not be performed */
	#define HWRM_NVM_FLUSH_CMD_ERR_CODE_FAIL		UINT32_C(0x1)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_nvm_get_variable */
/* Input (40 bytes) */

struct hwrm_nvm_get_variable_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t dest_data_addr;
	/* This is the host address where nvm variable will be stored */
	uint16_t data_len;
	/* size of data in bits */
	uint16_t option_num;
	/* nvm cfg option number */
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_INPUT_OPTION_NUM_RSVD_0	UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_INPUT_OPTION_NUM_RSVD_FFFF  UINT32_C(0xffff)
	uint16_t dimensions;
	/*
	 * Number of dimensions for this nvm configuration variable. This value
	 * indicates how many of the indexN values to use. A value of 0 means
	 * that none of the indexN values are valid. A value of 1 requires at
	 * index0 is valued, a value of 2 requires that index0 and index1 are
	 * valid, and so forth
	 */
	uint16_t index_0;
	/* index for the 1st dimensions */
	uint16_t index_1;
	/* index for the 2nd dimensions */
	uint16_t index_2;
	/* index for the 3rd dimensions */
	uint16_t index_3;
	/* index for the 4th dimensions */
	uint8_t flags;
	/*
	 * When this bit is set to 1, the factory default value will be
	 * returned, 0 returns the operational value.
	 */
	#define HWRM_NVM_GET_VARIABLE_INPUT_FLAGS_FACTORY_DFLT	UINT32_C(0x1)
	uint8_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_get_variable_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint16_t data_len;
	/* size of data of the actual variable retrieved in bits */
	uint16_t option_num;
	/*
	 * option_num is the option number for the data retrieved. It is
	 * possible in the future that the option number returned would be
	 * different than requested. This condition could occur if an option is
	 * deprecated and a new option id is defined with similar
	 * characteristics, but has a slightly different definition. This also
	 * makes it convenient for the caller to identify the variable result
	 * with the option id from the response.
	 */
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_OUTPUT_OPTION_NUM_RSVD_0	UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_OUTPUT_OPTION_NUM_RSVD_FFFF UINT32_C(0xffff)
	uint8_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_nvm_get_variable_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_UNKNOWN	UINT32_C(0x0)
	/* variable does not exist */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_VAR_NOT_EXIST  UINT32_C(0x1)
	/* configuration is corrupted and the variable cannot be saved */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_CORRUPT_VAR	UINT32_C(0x2)
	/* length specified is too small */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_LEN_TOO_SHORT  UINT32_C(0x3)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_nvm_set_variable */
/* Input (40 bytes) */

struct hwrm_nvm_set_variable_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t src_data_addr;
	/* This is the host address where nvm variable will be copied from */
	uint16_t data_len;
	/* size of data in bits */
	uint16_t option_num;
	/* nvm cfg option number */
	/* reserved. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_OPTION_NUM_RSVD_0	UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_OPTION_NUM_RSVD_FFFF  UINT32_C(0xffff)
	uint16_t dimensions;
	/*
	 * Number of dimensions for this nvm configuration variable. This value
	 * indicates how many of the indexN values to use. A value of 0 means
	 * that none of the indexN values are valid. A value of 1 requires at
	 * index0 is valued, a value of 2 requires that index0 and index1 are
	 * valid, and so forth
	 */
	uint16_t index_0;
	/* index for the 1st dimensions */
	uint16_t index_1;
	/* index for the 2nd dimensions */
	uint16_t index_2;
	/* index for the 3rd dimensions */
	uint16_t index_3;
	/* index for the 4th dimensions */
	uint8_t flags;
	/*
	 * When this bit is 1, flush internal cache after this write operation
	 * (see hwrm_nvm_flush command.)
	 */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_FORCE_FLUSH	UINT32_C(0x1)
	/* encryption method */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_MASK UINT32_C(0xe)
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_SFT 1
	/* No encryption. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_NONE (UINT32_C(0x0) << 1)
	/* one-way encryption. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_HMAC_SHA1 (UINT32_C(0x1) << 1)
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_LAST	HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_HMAC_SHA1
	uint8_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_set_variable_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint32_t unused_0;
	uint8_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_nvm_set_variable_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_UNKNOWN	UINT32_C(0x0)
	/* variable does not exist */
	#define HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_VAR_NOT_EXIST  UINT32_C(0x1)
	/* configuration is corrupted and the variable cannot be saved */
	#define HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_CORRUPT_VAR	UINT32_C(0x2)
	uint8_t unused_0[7];
} __attribute__((packed));

/* hwrm_nvm_validate_option */
/* Input (40 bytes) */

struct hwrm_nvm_validate_option_input {
	uint16_t req_type;
	/*
	 * This value indicates what type of request this is. The format for the
	 * rest of the command is determined by this field.
	 */
	uint16_t cmpl_ring;
	/*
	 * This value indicates the what completion ring the request will be
	 * optionally completed on. If the value is -1, then no CR completion
	 * will be generated. Any other value must be a valid CR ring_id value
	 * for this function.
	 */
	uint16_t seq_id;
	/* This value indicates the command sequence number. */
	uint16_t target_id;
	/*
	 * Target ID of this command. 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors 0xFFFF - HWRM
	 */
	uint64_t resp_addr;
	/*
	 * This is the host address where the response will be written when the
	 * request is complete. This area must be 16B aligned and must be
	 * cleared to zero before the request is made.
	 */
	uint64_t src_data_addr;
	/* This is the host address where nvm variable will be copied from */
	uint16_t data_len;
	/* size of data in bits */
	uint16_t option_num;
	/* nvm cfg option number */
	/* reserved. */
	#define HWRM_NVM_VALIDATE_OPTION_INPUT_OPTION_NUM_RSVD_0  UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_VALIDATE_OPTION_INPUT_OPTION_NUM_RSVD_FFFF UINT32_C(0xffff)
	uint16_t dimensions;
	/*
	 * Number of dimensions for this nvm configuration variable. This value
	 * indicates how many of the indexN values to use. A value of 0 means
	 * that none of the indexN values are valid. A value of 1 requires at
	 * index0 is valued, a value of 2 requires that index0 and index1 are
	 * valid, and so forth
	 */
	uint16_t index_0;
	/* index for the 1st dimensions */
	uint16_t index_1;
	/* index for the 2nd dimensions */
	uint16_t index_2;
	/* index for the 3rd dimensions */
	uint16_t index_3;
	/* index for the 4th dimensions */
	uint16_t unused_0;
} __attribute__((packed));

/* Output (16 bytes) */

struct hwrm_nvm_validate_option_output {
	uint16_t error_code;
	/*
	 * Pass/Fail or error type Note: receiver to verify the in parameters,
	 * and fail the call with an error when appropriate
	 */
	uint16_t req_type;
	/* This field returns the type of original request. */
	uint16_t seq_id;
	/* This field provides original sequence number of the command. */
	uint16_t resp_len;
	/*
	 * This field is the length of the response in bytes. The last byte of
	 * the response is a valid flag that will read as '1' when the command
	 * has been completely written to memory.
	 */
	uint8_t result;
	/*
	 * indicates that the value provided for the option is not
	 * matching with the saved data.
	 */
	#define HWRM_NVM_VALIDATE_OPTION_OUTPUT_RESULT_NOT_MATCH  UINT32_C(0x0)
	/*
	 * indicates that the value provided for the option is matching
	 * the saved data.
	 */
	#define HWRM_NVM_VALIDATE_OPTION_OUTPUT_RESULT_MATCH	UINT32_C(0x1)
	uint8_t unused_0;
	uint16_t unused_1;
	uint8_t unused_2;
	uint8_t unused_3;
	uint8_t unused_4;
	uint8_t valid;
	/*
	 * This field is used in Output records to indicate that the output is
	 * completely written to RAM. This field should be read as '1' to
	 * indicate that the output has been completely written. When writing a
	 * command completion or response to an internal processor, the order of
	 * writes has to be such that this field is written last.
	 */
} __attribute__((packed));

/* Command specific Error Codes (8 bytes) */

struct hwrm_nvm_validate_option_cmd_err {
	uint8_t code;
	/*
	 * command specific error codes that goes to the cmd_err field in Common
	 * HWRM Error Response.
	 */
	/* Unknown error */
	#define HWRM_NVM_VALIDATE_OPTION_CMD_ERR_CODE_UNKNOWN	UINT32_C(0x0)
	uint8_t unused_0[7];
} __attribute__((packed));

/* Command Queue (CMDQ) Interface */
/* Description: This command queries congestion control settings. */
/* Init CMDQ (16 bytes) */

struct cmdq_init {
	uint64_t cmdq_pbl;
	/* CMDQ PBL physical address. */
	uint16_t cmdq_size_cmdq_lvl;
	/* CMDQ size. */
	/* CMDQ PBL indirection levels. */
	#define CMDQ_INIT_CMDQ_LVL_MASK				UINT32_C(0x3)
	#define CMDQ_INIT_CMDQ_LVL_SFT				0
	/* CMDQ size. */
	#define CMDQ_INIT_CMDQ_SIZE_MASK			UINT32_C(0xfffc)
	#define CMDQ_INIT_CMDQ_SIZE_SFT				2
	uint16_t creq_ring_id;
	/* CREQ completion ring id. */
	uint32_t prod_idx;
	/* Mailbox producer index. MSB must also be set. */
} __attribute__((packed));

/* Update CMDQ producer index (16 bytes) */

struct cmdq_update {
	uint64_t reserved64;
	/* reserved64 is 64 b */
	uint32_t reserved32;
	/* reserved32 is 32 b */
	uint32_t prod_idx;
	/* Mailbox producer index. */
} __attribute__((packed));

/* CMDQ common header structure (16 bytes) */

struct cmdq_base {
	uint8_t opcode;
	/* Command opcode. */
	/*
	 * Create QP command allocates QP context with the specified SQ,
	 * RQ/SRQ, CQ and other parameters.
	 */
	#define CMDQ_BASE_OPCODE_CREATE_QP			UINT32_C(0x1)
	/*
	 * Destroy QP command deletes the QP context and ceases any
	 * further reference.
	 */
	#define CMDQ_BASE_OPCODE_DESTROY_QP			UINT32_C(0x2)
	/*
	 * Modify QP command changes QP states and other QP specific
	 * parameters.
	 */
	#define CMDQ_BASE_OPCODE_MODIFY_QP			UINT32_C(0x3)
	/* Query QP command retrieves info about the specified QP. */
	#define CMDQ_BASE_OPCODE_QUERY_QP			UINT32_C(0x4)
	/* Create SRQ command allocates a SRQ with the specified parameters. */
	#define CMDQ_BASE_OPCODE_CREATE_SRQ			UINT32_C(0x5)
	/* Destroy SRQ command deletes and flushes the specified SRQ. */
	#define CMDQ_BASE_OPCODE_DESTROY_SRQ			UINT32_C(0x6)
	/* Query SRP command retrieves info about the specified SRQ. */
	#define CMDQ_BASE_OPCODE_QUERY_SRQ			UINT32_C(0x8)
	/* Create CQ command allocates a CQ with the specified parameters. */
	#define CMDQ_BASE_OPCODE_CREATE_CQ			UINT32_C(0x9)
	/* Destroy CQ command deletes and flushes the specified CQ. */
	#define CMDQ_BASE_OPCODE_DESTROY_CQ			UINT32_C(0xa)
	/* Resize CQ command resizes the specified CQ. */
	#define CMDQ_BASE_OPCODE_RESIZE_CQ			UINT32_C(0xc)
	/*
	 * Allocate MRW command allocates a MR/MW with the specified
	 * parameters and returns the region's L_KEY/R_KEY
	 */
	#define CMDQ_BASE_OPCODE_ALLOCATE_MRW			UINT32_C(0xd)
	/*
	 * De-allocate key command frees a MR/MW entry associated with
	 * the specified key.
	 */
	#define CMDQ_BASE_OPCODE_DEALLOCATE_KEY		UINT32_C(0xe)
	/* Register MR command registers memory to the specified MR. */
	#define CMDQ_BASE_OPCODE_REGISTER_MR			UINT32_C(0xf)
	/* Deregister MR command de-registers memory from the specified MR. */
	#define CMDQ_BASE_OPCODE_DEREGISTER_MR			UINT32_C(0x10)
	/* Add GID command adds a GID to the local address table. */
	#define CMDQ_BASE_OPCODE_ADD_GID			UINT32_C(0x11)
	/* Delete GID command deletes a GID from the local address table. */
	#define CMDQ_BASE_OPCODE_DELETE_GID			UINT32_C(0x12)
	/* Modify GID command modifies a GID in the local address table. */
	#define CMDQ_BASE_OPCODE_MODIFY_GID			UINT32_C(0x17)
	/* Query GID command queries a GID in the local address table. */
	#define CMDQ_BASE_OPCODE_QUERY_GID			UINT32_C(0x18)
	/* Create QP1 command allocates a QP1 only. */
	#define CMDQ_BASE_OPCODE_CREATE_QP1			UINT32_C(0x13)
	/* Destroy QP1 command deletes and flushes the specified QP1. */
	#define CMDQ_BASE_OPCODE_DESTROY_QP1			UINT32_C(0x14)
	/* Create AH command allocates an AH with the specified parameters. */
	#define CMDQ_BASE_OPCODE_CREATE_AH			UINT32_C(0x15)
	/* Destroy AH command deletes the specified AH. */
	#define CMDQ_BASE_OPCODE_DESTROY_AH			UINT32_C(0x16)
	/*
	 * Initialize firmware command initializes the firmware with the
	 * specified parameters.
	 */
	#define CMDQ_BASE_OPCODE_INITIALIZE_FW			UINT32_C(0x80)
	/* De-initialize firmware command deinitializes the firmware. */
	#define CMDQ_BASE_OPCODE_DEINITIALIZE_FW		UINT32_C(0x81)
	/* Stop the function */
	#define CMDQ_BASE_OPCODE_STOP_FUNC			UINT32_C(0x82)
	/* Query the HW capabilities for the function. */
	#define CMDQ_BASE_OPCODE_QUERY_FUNC			UINT32_C(0x83)
	/*
	 * Set the following resources for the function: - Max QP, CQ,
	 * MR+MW, SRQ per PF - Max QP, CQ, MR+MW, SRQ per VF
	 */
	#define CMDQ_BASE_OPCODE_SET_FUNC_RESOURCES		UINT32_C(0x84)
	/*
	 * Read the current state of any internal resource context. Can
	 * only be issued from a PF.
	 */
	#define CMDQ_BASE_OPCODE_READ_CONTEXT			UINT32_C(0x85)
	/*
	 * Send a request from VF to pass a command to the PF. VF HSI is
	 * suspended until the PF returns the response
	 */
	#define CMDQ_BASE_OPCODE_VF_BACKCHANNEL_REQUEST	UINT32_C(0x86)
	/*
	 * Read VF memory (primarily to get the backchannel request
	 * blob). Can only be issued from a PF.
	 */
	#define CMDQ_BASE_OPCODE_READ_VF_MEMORY		UINT32_C(0x87)
	/*
	 * Write VF memory (primarily to put the backchannel response
	 * blob), and reenable VF HSI (post a CAG completion to it). Can
	 * only be issued from a PF.
	 */
	#define CMDQ_BASE_OPCODE_COMPLETE_VF_REQUEST		UINT32_C(0x88)
	/*
	 * Extend resource (QPC, MRW, CQ, SRQ) array, after the host
	 * allocates more. Can only be issued from a PF.
	 */
	#define CMDQ_BASE_OPCODE_EXTEND_CONTEXT_ARRRAY		UINT32_C(0x89)
	/* Map TC to COS. Can only be issued from a PF. */
	#define CMDQ_BASE_OPCODE_MAP_TC_TO_COS			UINT32_C(0x8a)
	/* Query version. */
	#define CMDQ_BASE_OPCODE_QUERY_VERSION			UINT32_C(0x8b)
	/* Modify congestion control. Can only be issued from a PF. */
	#define CMDQ_BASE_OPCODE_MODIFY_ROCE_CC		UINT32_C(0x8c)
	/* Query congestion control. */
	#define CMDQ_BASE_OPCODE_QUERY_ROCE_CC			UINT32_C(0x8d)
	uint8_t cmd_size;
	/* Size of the command in 16-byte units. */
	uint16_t flags;
	/* Flags and attribs of the command. */
	uint16_t cookie;
	/* Driver supplied handle to associate the command and the response. */
	uint8_t resp_size;
	/* Size of the response buffer in 16-byte units. */
	uint8_t reserved8;
	uint64_t resp_addr;
	/* Host address of the response. */
} __attribute__((packed));

/* Create QP command (96 bytes) */

struct cmdq_create_qp {
	uint8_t opcode;
	/* Command opcode. */
	/*
	 * Create QP command allocates QP context with the specified SQ,
	 * RQ/SRQ, CQ and other parameters.
	 */
	#define CMDQ_CREATE_QP_OPCODE_CREATE_QP		UINT32_C(0x1)
	uint8_t cmd_size;
	/* Size of the command in 16-byte units. */
	uint16_t flags;
	/* Flags and attribs of the command. */
	uint16_t cookie;
	/* Driver supplied handle to associate the command and the response. */
	uint8_t resp_size;
	/* Size of the response buffer in 16-byte units. */
	uint8_t reserved8;
	uint64_t resp_addr;
	/* Host address of the response. */
	uint64_t qp_handle;
	/* QP handle. */
	uint32_t qp_flags;
	/* Create QP flags. */
	/* SRQ is used. */
	#define CMDQ_CREATE_QP_QP_FLAGS_SRQ_USED		UINT32_C(0x1)
	/* post CQE for all SQ WQEs. */
	#define CMDQ_CREATE_QP_QP_FLAGS_FORCE_COMPLETION	UINT32_C(0x2)
	/* This QP can use reserved L_Key */
	#define CMDQ_CREATE_QP_QP_FLAGS_RESERVED_LKEY_ENABLE	UINT32_C(0x4)
	/* This QP can fast register physical memory */
	#define CMDQ_CREATE_QP_QP_FLAGS_FR_PMR_ENABLED		UINT32_C(0x8)
	uint8_t type;
	/* Supported QP types. */
	/* Reliable Connection. */
	#define CMDQ_CREATE_QP_TYPE_RC				UINT32_C(0x2)
	/* Unreliable Datagram. */
	#define CMDQ_CREATE_QP_TYPE_UD				UINT32_C(0x4)
	/* Raw Ethertype. */
	#define CMDQ_CREATE_QP_TYPE_RAW_ETHERTYPE		UINT32_C(0x6)
	uint8_t sq_pg_size_sq_lvl;
	/* SQ page size. */
	/* SQ PBL indirect levels. */
	#define CMDQ_CREATE_QP_SQ_LVL_MASK			UINT32_C(0xf)
	#define CMDQ_CREATE_QP_SQ_LVL_SFT			0
	/* PBL pointer is physical start address. */
	#define CMDQ_CREATE_QP_SQ_LVL_LVL_0			UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define CMDQ_CREATE_QP_SQ_LVL_LVL_1			UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
	#define CMDQ_CREATE_QP_SQ_LVL_LVL_2			UINT32_C(0x2)
	/* SQ page size. */
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_MASK			UINT32_C(0xf0)
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_SFT			4
	/* 4KB. */
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_4K		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_8K		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_64K		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_2M		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_8M		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define CMDQ_CREATE_QP_SQ_PG_SIZE_PG_1G		(UINT32_C(0x5) << 4)
	uint8_t rq_pg_size_rq_lvl;
	/* RQ page size. */
	/* RQ PBL indirect levels. */
	#define CMDQ_CREATE_QP_RQ_LVL_MASK			UINT32_C(0xf)
	#define CMDQ_CREATE_QP_RQ_LVL_SFT			0
	/* PBL pointer is physical start address. */
	#define CMDQ_CREATE_QP_RQ_LVL_LVL_0			UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define CMDQ_CREATE_QP_RQ_LVL_LVL_1			UINT32_C(0x1)
	/*
	 * PBL pointer points to PDE table with each entry pointing to
	 * PTE tables.
	 */
	#define CMDQ_CREATE_QP_RQ_LVL_LVL_2			UINT32_C(0x2)
	/* RQ page size. */
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_MASK			UINT32_C(0xf0)
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_SFT			4
	/* 4KB. */
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_4K		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_8K		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_64K		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_2M		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_8M		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define CMDQ_CREATE_QP_RQ_PG_SIZE_PG_1G		(UINT32_C(0x5) << 4)
	uint8_t unused_0;
	uint32_t dpi;
	/* Doorbell page index. */
	uint32_t sq_size;
	/* Max number of SQ wqes. */
	uint32_t rq_size;
	/* Max number of RQ wqes. */
	uint16_t sq_fwo_sq_sge;
	/* Offset of First WQE in the first SQ page, in 128 byte units */
	/* Max send SGEs per SWQE. */
	#define CMDQ_CREATE_QP_SQ_SGE_MASK			UINT32_C(0xf)
	#define CMDQ_CREATE_QP_SQ_SGE_SFT			0
	/* Offset of First WQE in the first SQ page, in 128 byte units */
	#define CMDQ_CREATE_QP_SQ_FWO_MASK			UINT32_C(0xfff0)
	#define CMDQ_CREATE_QP_SQ_FWO_SFT			4
	uint16_t rq_fwo_rq_sge;
	/* Offset of First WQE in the first RQ page, in 128 byte units */
	/* Max recv SGEs per RWQE (NOT SUPPORTED BY HARDWARE). */
	#define CMDQ_CREATE_QP_RQ_SGE_MASK			UINT32_C(0xf)
	#define CMDQ_CREATE_QP_RQ_SGE_SFT			0
	/* Offset of First WQE in the first RQ page, in 128 byte units */
	#define CMDQ_CREATE_QP_RQ_FWO_MASK			UINT32_C(0xfff0)
	#define CMDQ_CREATE_QP_RQ_FWO_SFT			4
	uint32_t scq_cid;
	/* Send CQ context id. */
	uint32_t rcq_cid;
	/* Receive CQ context id. */
	uint32_t srq_cid;
	/* SRQ CQ context id. */
	uint32_t pd_id;
	/* Protection domain id. */
	uint64_t sq_pbl;
	/* SQ PBL physical address. */
	uint64_t rq_pbl;
	/* RQ PBL physical address. */
	uint64_t irrq_addr;
	/* IRRQ address. */
	uint64_t orrq_addr;
	/* ORRQ address. */
} __attribute__((packed));

/* Destroy QP command (24 bytes) */

struct cmdq_destroy_qp {
	uint8_t opcode;
	/* Command opcode. */
	/*
	 * Destroy QP command deletes the QP context and ceases any
	 * further reference.
	 */
	#define CMDQ_DESTROY_QP_OPCODE_DESTROY_QP		UINT32_C(0x2)
	uint8_t cmd_size;
	/* Size of the command in 16-byte units. */
	uint16_t flags;
	/* Flags and attribs of the command. */
	uint16_t cookie;
	/* Driver supplied handle to associate the command and the response. */
	uint8_t resp_size;
	/* Size of the response buffer in 16-byte units. */
	uint8_t reserved8;
	uint64_t resp_addr;
	/* Host address of the response. */
	uint32_t qp_cid;
	/* QP context id */
	uint32_t unused_0;
} __attribute__((packed));

/* Modify QP command (112 bytes) */

struct cmdq_modify_qp {
	uint8_t opcode;
	/* Command opcode. */
	/*
	 * Modify QP command changes QP states and other QP specific
	 * parameters.
	 */
	#define CMDQ_MODIFY_QP_OPCODE_MODIFY_QP		UINT32_C(0x3)
	uint8_t cmd_size;
	/* Size of the command in 16-byte units. */
	uint16_t flags;
	/* Flags and attribs of the command. */
	uint16_t cookie;
	/* Driver supplied handle to associate the command and the response. */
	uint8_t resp_size;
	/* Size of the response buffer in 16-byte units. */
	uint8_t reserved8;
	uint64_t resp_addr;
	/* Host address of the response. */
	uint32_t modify_mask;
	/* Modify mask signifies the field that is requesting the change. */
	/* QP state change. */
	#define CMDQ_MODIFY_QP_MODIFY_MASK_STATE		UINT32_C(0x1)
	/* Enable SQ drain asynchronous notification change. */
	#define CMDQ_MODIFY_QP_MODIFY_MASK_EN_SQD_ASYNC_NOTIFY	UINT32_C(0x2)
	/* Access change. */
	#define CMDQ_MODIFY_QP_MODIFY_MASK_ACCE