/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.lang.reflect.ParameterizedType;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;

public abstract class FlexibleStanzaTypeFilter<S extends Stanza>
implements StanzaFilter {
    protected final Class<S> stanzaType;

    public FlexibleStanzaTypeFilter(Class<S> packetType) {
        this.stanzaType = Objects.requireNonNull(packetType, "Type must not be null");
    }

    public FlexibleStanzaTypeFilter() {
        this.stanzaType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public final boolean accept(Stanza packet) {
        if (this.stanzaType.isInstance(packet)) {
            return this.acceptSpecific(packet);
        }
        return false;
    }

    protected abstract boolean acceptSpecific(S var1);

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.stanzaType.toString();
    }
}

