/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBClassLoader;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJarResource;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBResourceLoader;
import com.ca.commons.cbutil.CBSystemProperties;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.JndiSocketFactory;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.LdifUtility;
import com.ca.commons.security.cert.CertViewer;
import com.ca.directory.BuildNumber;
import com.ca.directory.jxplorer.ButtonBar;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.DataSink;
import com.ca.directory.jxplorer.MainMenu;
import com.ca.directory.jxplorer.broker.Broker;
import com.ca.directory.jxplorer.broker.JNDIBroker;
import com.ca.directory.jxplorer.broker.OfflineBroker;
import com.ca.directory.jxplorer.broker.SchemaBroker;
import com.ca.directory.jxplorer.broker.StopMonitor;
import com.ca.directory.jxplorer.event.JXplorerEvent;
import com.ca.directory.jxplorer.event.JXplorerEventGenerator;
import com.ca.directory.jxplorer.event.JXplorerListener;
import com.ca.directory.jxplorer.search.SearchBar;
import com.ca.directory.jxplorer.tree.SmartModel;
import com.ca.directory.jxplorer.tree.SmartNode;
import com.ca.directory.jxplorer.tree.SmartTree;
import com.ca.directory.jxplorer.viewer.AttributeDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class JXplorer
extends JFrame
implements JXplorerEventGenerator {
    static String version = BuildNumber.value;
    private static JFrame rootFrame;
    Container mainPane;
    transient JXplorerListener jxplorerListener;
    EventListenerList eventListeners = new EventListenerList();
    JScrollPane explorePanel;
    JScrollPane resultsPanel;
    JScrollPane schemaPanel;
    JTabbedPane treeTabPane;
    JPanel userViewPanel;
    CBPanel topPanel;
    JToolBar searchBar;
    ButtonBar buttonBar;
    public static Properties myProperties;
    public static String propertyFile;
    public static String localDir;
    public static JFrame jx;
    JNDIBroker jndiBroker = null;
    JNDIBroker searchBroker = null;
    OfflineBroker offlineBroker = null;
    SchemaBroker schemaBroker = null;
    SmartTree mrTree = null;
    SmartTree searchTree = null;
    SmartTree schemaTree = null;
    AttributeDisplay mainViewer;
    CBPanel statusDisplay;
    JLabel displayLabel;
    boolean workOffline = false;
    public static boolean debug;
    public static int debugLevel;
    protected Stack statusStack = new Stack();
    protected MainMenu mainMenu;
    protected static ButtonRegister buttonRegister;
    protected CBHelpSystem helpSystem;
    protected StopMonitor stopMonitor;
    public Thread jndiThread;
    public Thread schemaThread;
    public Thread searchThread;
    public Thread offlineThread;
    public String url = "Disconnected";
    CBResourceLoader resourceLoader;
    CBClassLoader classLoader;
    public static final String CLIENT_TYPE_PROPERTY = "keystoreType.clientcerts";
    public static final String CA_TYPE_PROPERTY = "keystoreType.cacerts";
    public static final String CLIENT_PATH_PROPERTY = "option.ssl.clientcerts";
    public static final String CA_PATH_PROPERTY = "option.ssl.cacerts";
    public static final String ALLOW_CONNECTION_CERT_IMPORT = "option.ssl.import.cert.during.connection";
    private static Logger log;
    boolean connected = false;

    public JXplorer() {
        JWindow splash = new JWindow();
        this.showSplashScreen(splash);
        rootFrame = this;
        this.mainPane = rootFrame.getContentPane();
        this.mrTree = null;
        JXplorer.loadProperties(myProperties);
        JXplorer.setupLogger();
        this.initUtilityFtns(this);
        this.setupResourceFiles();
        CBIntText.init("language.JX", this.classLoader);
        if (!JXplorer.checkFileEnvironment()) {
            return;
        }
        this.initJNDIBroker();
        this.initSearchBroker();
        this.initSchemaBroker();
        this.initOfflineBroker();
        this.initStopMonitor();
        buttonRegister = new ButtonRegister();
        this.setupGUI();
        this.setStatus(CBIntText.get("Not Connected"));
        this.setBackground(Color.white);
        this.setVisible(true);
        splash.dispose();
    }

    public static void printTime(String msg) {
        long time = System.currentTimeMillis();
        log.info(msg + "\nTIME: " + new Date().toString() + "  (" + time % 1000L + ")\n");
    }

    public static void main(String[] args) {
        JXplorer.printTime("main start");
        log.fine("running JXplorer version " + version);
        if (!JXplorer.checkJavaEnvironment()) {
            System.exit(-1);
        }
        new JXplorer();
        JXplorer.printTime("main end");
    }

    protected static void setupBackupLogger() {
        Logger mainLogger = LogManager.getLogManager().getLogger("com.ca");
        mainLogger.setLevel(Level.parse(JXplorer.getProperty("java.util.logging.ConsoleHandler.level")));
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        mainLogger.addHandler(handler);
    }

    protected static void setupLogger() {
        log.info("setting up logger");
        try {
            Logger.getLogger("com");
            Logger.getLogger("com.ca");
            Logger.getLogger("com.ca.directory");
            Logger.getLogger("com.ca.directory.jxplorer");
            log = Logger.getLogger(JXplorer.class.getName());
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            logManager.readConfiguration(new FileInputStream(propertyFile));
            System.out.println("XXX logging initially level " + CBUtility.getTrueLogLevel(log) + " with " + log.getHandlers().length + " parents=" + log.getUseParentHandlers());
            log.info("Using configuration file: " + propertyFile);
            log.info("logging initialised to global level " + CBUtility.getTrueLogLevel(log));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Unable to load log configuration from config file: " + propertyFile, e);
            System.err.println("Unable to load log configuration from config file: " + propertyFile);
            e.printStackTrace();
            JXplorer.setupBackupLogger();
        }
        int currentLogLevel = CBUtility.getTrueLogLevel(log).intValue();
        if (currentLogLevel <= Level.FINE.intValue()) {
            Vector<String> sortedKeys = new Vector<String>();
            Enumeration<Object> baseKeys = myProperties.keys();
            while (baseKeys.hasMoreElements()) {
                String key = (String)baseKeys.nextElement();
                sortedKeys.addElement(key);
            }
            Collections.sort(sortedKeys);
            Enumeration propNames = sortedKeys.elements();
            StringBuffer propertyData = new StringBuffer();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                propertyData.append("property: ").append(propName).append(" = ").append(myProperties.getProperty(propName)).append("\n");
            }
            log.fine("property:\n" + propertyData.toString());
        }
    }

    public void initUtilityFtns(JFrame rootFrame) {
        CBUtility.initDefaultDisplay(rootFrame);
    }

    public static boolean checkJavaEnvironment() {
        log.info("running java from: " + System.getProperty("java.home"));
        String javaVersion = System.getProperty("java.version");
        log.info("running java version " + javaVersion);
        if (javaVersion.compareTo("1.4") < 0) {
            log.severe(CBIntText.get("TERMINATING: JXplorer requires Security Extensions and other features found only in java 1.4.0 or better."));
            JOptionPane.showMessageDialog(null, CBIntText.get("TERMINATING: JXplorer requires java 1.4.0 or better"), CBIntText.get("The Current Java Version is {0}", new String[]{javaVersion}), 0);
            return false;
        }
        return true;
    }

    public static boolean checkFileEnvironment() {
        return true;
    }

    public static String getProperty(String key) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        if (myProperties.containsKey(key)) {
            return myProperties.getProperty(key);
        }
        return null;
    }

    public static String getProperty(String key, String defaultValue) {
        if (myProperties == null) {
            return defaultValue;
        }
        return myProperties.getProperty(key, defaultValue);
    }

    public static Properties getMyProperties() {
        return myProperties;
    }

    public static void setProperty(String key, String value) {
        if (key != null) {
            myProperties.setProperty(key, value);
        }
    }

    public void checkSpecialLoggingActions() {
        if (CBUtility.getTrueLogLevel(log) == Level.ALL) {
            this.jndiBroker.setTracing(true);
        } else {
            this.jndiBroker.setTracing(false);
        }
    }

    public static String setDefaultProperty(String key, String value) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        if (myProperties.containsKey(key)) {
            return myProperties.getProperty(key);
        }
        myProperties.setProperty(key, value);
        return value;
    }

    public static String setDefaultProperty(String key, String value, String comment) {
        if (comment != null && comment.length() > 0) {
            myProperties.put(key + ".comment", comment);
        }
        return JXplorer.setDefaultProperty(key, value);
    }

    public static void loadProperties(Properties suppliedProperties) {
        localDir = System.getProperty("user.dir") + File.separator;
        if (suppliedProperties == null) {
            String configFileName = "jxconfig.txt";
            propertyFile = CBUtility.getPropertyConfigPath(configFileName);
            myProperties = CBUtility.readPropertyFile(propertyFile);
        } else {
            myProperties = suppliedProperties;
        }
        JXplorer.setDefaultProperty("url.defaultdirectory", "localhost", "default for empty connection screen GUI - rarely used");
        JXplorer.setDefaultProperty("url.defaultdirectory.port", "389", "default for empty connection screen GUI - rarely used");
        JXplorer.setDefaultProperty("url.defaultadmin", "localhost", "default value for a specific 3rd party plug in; rarely used");
        JXplorer.setDefaultProperty("url.defaultadminport", "3389", "default value for a specific 3rd party plug in; rarely used");
        JXplorer.setDefaultProperty("baseAdminDN", "cn=Management System", "default value for a specific 3rd party plug in; rarely used");
        JXplorer.setProperty("dir.comment", "this sets the directories that JXplorer reads its resources from.");
        JXplorer.setDefaultLocationProperty("dir.local", localDir);
        JXplorer.setDefaultLocationProperty("dir.htmldocs", localDir + "htmldocs" + File.separator);
        JXplorer.setDefaultLocationProperty("dir.templates", localDir + "templates" + File.separator);
        JXplorer.setDefaultLocationProperty("dir.icons", localDir + "icons" + File.separator);
        JXplorer.setDefaultLocationProperty("dir.images", localDir + "images" + File.separator);
        JXplorer.setDefaultLocationProperty("dir.help", localDir + "help" + File.separator);
        JXplorer.setDefaultLocationProperty("dir.plugins", localDir + "plugins" + File.separator);
        JXplorer.setDefaultProperty("width", "800", "set by client GUI - don't change");
        JXplorer.setDefaultProperty("height", "600", "set by client GUI - don't change");
        JXplorer.setDefaultProperty("baseDN", "c=au", "the default base DN for an empty connection - rarely used");
        JXplorer.setDefaultProperty("ldapversion", "3", "set by client GUI - don't change");
        JXplorer.setDefaultProperty(".level", "WARNING", "(java loggin variable) - allowable values are 'OFF', 'SEVERE', 'WARNING', 'INFO', 'FINE', 'FINER', 'FINEST' and 'ALL'");
        JXplorer.setDefaultProperty("com.ca.level", "UNUSED", " (java loggin variable) partial logging is also available.  Be warned that the Sun logging system is a very buggy partial reimplementation of log4j, and doesn't seem to do inheritance well.");
        JXplorer.setDefaultProperty("handlers", "java.util.logging.ConsoleHandler", "(java logging variable) This sets the log level for console reporting");
        JXplorer.setDefaultProperty("java.util.logging.ConsoleHandler.level", "ALL", "(java logging variable) This sets the log level for console reporting");
        JXplorer.setDefaultProperty("java.util.logging.ConsoleHandler.formatter", "java.util.logging.SimpleFormatter", "(java logging variable) This sets the built in formatter to use for console reporting");
        JXplorer.setDefaultProperty("java.util.logging.FileHandler.level", "ALL", "(java loggin variable) This sets the log level for log file reporting");
        JXplorer.setDefaultProperty("java.util.logging.FileHandler.pattern", "JX%u.log", "(java loggin variable) The name of the log file (see java.util.logging.FileHandler java doc)");
        JXplorer.setDefaultProperty("java.util.logging.FileHandler.formatter", "java.util.logging.SimpleFormatter", "(java loggin variable) This sets the built in formatter to use for file reporting");
        JXplorer.setDefaultProperty("null.entry.editor", "defaulteditor", "the editor displayed for null entries is pluggable and can be set to a custom java class");
        JXplorer.setDefaultProperty("plugins.ignoreUniqueness", "false", "whether to allow multiple plugins for the same object class: 'true' or 'false");
        JXplorer.setDefaultProperty("option.ignoreSchemaOnSubmission", "false", "Skip client side schema checks; useful if JXplorer is getting confused or the schema is inconsistent");
        JXplorer.setDefaultProperty("option.ldap.timeout", "0", "the maximum time to allow a query to run before cancelling - '0' = 'as long as the server allows'");
        JXplorer.setDefaultProperty("option.ldap.limit", "0", "The maximum number of entries to return - '0' = 'all the server allows'");
        JXplorer.setDefaultProperty("option.ldap.referral", "ignore", "this is a jdni variable determinning how referrals are handled: 'ignore','follow' or 'throw'");
        JXplorer.setDefaultProperty("option.ldap.browseAliasBehaviour", "finding", "jndi variable setting how aliases are handled while browsing: 'always','never','finding','searching'");
        JXplorer.setDefaultProperty("option.ldap.searchAliasBehaviour", "searching", "jndi variable setting how aliases are handled while searching: 'always','never','finding','searching'");
        JXplorer.setDefaultProperty("option.confirmTableEditorUpdates", "false", "whether the user is prompted before updates; usually set by GUI");
        JXplorer.setDefaultProperty("option.url.handling", "JXplorer", "override URL handling to launch JXplorer rather than default browser");
        JXplorer.setDefaultProperty("option.ldap.sendVerboseBinarySuffix", "false", "some directories require ';binary' to be explicitly appended to binary attribute names: 'true' or 'false'");
        JXplorer.setDefaultProperty("option.drag.and.drop", "true", "set to 'false' to disable drag and drop in the left hand tree view");
        JXplorer.setDefaultProperty("jxplorer.cache.passwords", "true", "whether JX should keep a (run time only) cache of passwords for reuse and reconnection");
        JXplorer.setDefaultProperty("sort.by.naming.attribute", "false", "if true, this sorts entries in the tree editor by naming attribute first, then by attribute value");
        if ("true".equals(JXplorer.getProperty("option.ldap.sendVerboseBinarySuffix"))) {
            log.fine("using verbose binary suffix ';binary'");
            DXAttribute.setVerboseBinary(true);
        }
        JXplorer.setDefaultProperty(CA_PATH_PROPERTY, localDir + "security" + File.separator + "cacerts");
        JXplorer.setDefaultProperty(CLIENT_PATH_PROPERTY, localDir + "security" + File.separator + "clientcerts");
        JXplorer.setDefaultProperty(CLIENT_TYPE_PROPERTY, "JKS");
        JXplorer.setDefaultProperty(CA_TYPE_PROPERTY, "JKS");
        JXplorer.setDefaultProperty(ALLOW_CONNECTION_CERT_IMPORT, "true");
        System.setProperty(ALLOW_CONNECTION_CERT_IMPORT, JXplorer.getProperty(ALLOW_CONNECTION_CERT_IMPORT));
        JXplorer.setDefaultProperty("securityProvider", "com.sun.net.ssl.internal.ssl.Provider");
        JXplorer.setProperty("securityProvider.comment", "the security provider can be changed, and three more can be added by creating 'securityProperty0', 'securityProperty1' and 'securityProperty2'.");
        JXplorer.setDefaultProperty("ldap.sslsocketfactory", "com.ca.commons.jndi.JndiSocketFactory");
        JXplorer.setProperty("ldap.sslsocketfactory.comment", "This is the built in ssl factory - it can be changed if required.");
        JXplorer.setDefaultProperty("gui.lookandfeel", UIManager.getSystemLookAndFeelClassName());
        JXplorer.setDefaultProperty("gui.lookandfeel.comment", "Can set to com.sun.java.swing.plaf.mac.MacLookAndFeel for OSX");
        JXplorer.setDefaultProperty("last.search.filter", "default");
        JXplorer.setDefaultProperty("getSystemEnvironment.comment", "Set this to true if you wish to add the system environment properties to the JX list (e.g. if you are setting JX properties via system variables)");
        JXplorer.setDefaultProperty("getSystemEnvironment", "false");
        if (JXplorer.getProperty("getSystemEnvironment").equalsIgnoreCase("true")) {
            CBSystemProperties.loadSystemProperties();
        }
        CertViewer.setProperties(myProperties);
        CertViewer.setupHelpLink("ssl.view");
        JXplorer.setDefaultProperty("xml.ldif.rfc", "false");
        JXplorer.setDefaultProperty("xml.ldif.rfc.comment", "Experimental support for saving XML in LDIF files in editable form (e.g. not base64 encoded)");
        if ("true".equals(JXplorer.getProperty("xml.ldif.rfc"))) {
            LdifUtility.setSupportXML_LDIF_RFC(true);
        }
        if (!new File(propertyFile).exists()) {
            JXplorer.writePropertyFile();
        }
    }

    protected static void setDefaultLocationProperty(String propName, String defaultLocation) {
        File test;
        JXplorer.setDefaultProperty(propName, defaultLocation);
        String newLocation = JXplorer.getProperty(propName);
        if (!newLocation.equals(defaultLocation) && !(test = new File(newLocation)).exists()) {
            log.warning("Uunable to find location '" + newLocation + "' -> reverting to '" + defaultLocation + "'");
            JXplorer.setProperty(propName, defaultLocation);
        }
    }

    public void initJNDIBroker() {
        this.jndiBroker = new JNDIBroker();
        if (CBUtility.getTrueLogLevel(log) == Level.ALL) {
            this.jndiBroker.setTracing(true);
        }
        this.jndiBroker.setTimeout(Integer.parseInt(JXplorer.getProperty("option.ldap.timeout")));
        this.jndiBroker.setLimit(Integer.parseInt(JXplorer.getProperty("option.ldap.limit")));
        this.jndiThread = new Thread((Runnable)this.jndiBroker, "jndiBroker Thread");
        this.jndiThread.start();
    }

    public void initSearchBroker() {
        this.searchBroker = new JNDIBroker(this.jndiBroker);
        this.searchThread = new Thread((Runnable)this.searchBroker, "searchBroker Thread");
        this.searchThread.start();
    }

    public void initSchemaBroker() {
        this.schemaBroker = new SchemaBroker(this.jndiBroker);
        this.schemaThread = new Thread((Runnable)this.schemaBroker, "schemaBroker Thread");
        this.schemaThread.start();
    }

    public void initOfflineBroker() {
        this.offlineBroker = new OfflineBroker(this);
        this.offlineThread = new Thread((Runnable)this.offlineBroker, "offlineBroker Thread");
        this.offlineThread.start();
    }

    public void initStopMonitor() {
        Broker[] brokerList = new Broker[]{this.jndiBroker, this.searchBroker, this.schemaBroker, this.offlineBroker};
        this.stopMonitor = new StopMonitor(brokerList, this);
    }

    public StopMonitor getStopMonitor() {
        return this.stopMonitor;
    }

    protected void setupGUI() {
        this.setupLookAndFeel();
        this.setupWindowButtons();
        this.setupHelp();
        this.setupMenu();
        this.setupMainPanel();
        this.setupStatusDisplay();
        this.setupFrills();
        this.positionBrowser();
    }

    protected void positionBrowser() {
        int ypos;
        int xpos;
        int height;
        int width;
        try {
            width = Integer.parseInt(JXplorer.getProperty("width"));
            height = Integer.parseInt(JXplorer.getProperty("height"));
            xpos = Integer.parseInt(JXplorer.getProperty("xpos"));
            ypos = Integer.parseInt(JXplorer.getProperty("ypos"));
        }
        catch (Exception e) {
            width = 800;
            height = 600;
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            xpos = (screen.width - width) / 2;
            ypos = (screen.height - height) / 2;
        }
        if (width < 100) {
            width = 100;
        }
        if (height < 100) {
            height = 100;
        }
        this.setBounds(xpos, ypos, width, height);
        this.setSize(width, height);
    }

    protected void setupLookAndFeel() {
        try {
            UIManager.setLookAndFeel(JXplorer.getProperty("gui.lookandfeel"));
        }
        catch (Exception exc) {
            log.warning("WARNING: Can't load Look and Feel: " + exc);
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                JXplorer.setProperty("gui.lookandfeel", UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exc2) {
                log.warning("ERRROR: Can't load sys Look and Feel either! : " + exc2);
            }
        }
    }

    protected void setupWindowButtons() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                JXplorer.this.shutdown();
            }
        });
    }

    protected void setupMenu() {
        if (JXplorer.getProperty("gui.menu", "true").equals("true")) {
            this.mainMenu = new MainMenu(this);
        }
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public JNDIBroker getSearchBroker() {
        return this.searchBroker;
    }

    public JTabbedPane getTreeTabPane() {
        return this.treeTabPane;
    }

    public JScrollPane getExplorePanel() {
        return this.explorePanel;
    }

    public JScrollPane getResultsPanel() {
        return this.resultsPanel;
    }

    public SmartTree getSearchTree() {
        return this.searchTree;
    }

    public SmartTree getTree() {
        return this.mrTree;
    }

    public SmartTree getSchemaTree() {
        return this.schemaTree;
    }

    public static JFrame getRootFrame() {
        return rootFrame;
    }

    public AttributeDisplay getAttributeDisplay() {
        return this.mainViewer;
    }

    protected void setupMainPanel() {
        this.setupToolBars();
        this.setupActiveComponents();
        this.setupMainWorkArea();
        this.mainPane.setBackground(Color.lightGray);
        this.mainViewer.registerClassLoader(this.classLoader);
        this.validate();
    }

    protected void setupToolBars() {
        this.topPanel = new CBPanel();
        this.searchBar = new SearchBar(this);
        this.buttonBar = new ButtonBar(this);
        this.topPanel.makeWide();
        this.topPanel.addln(this.buttonBar);
        this.topPanel.addln(this.searchBar);
        this.mainPane.add((Component)this.topPanel, "North");
        this.mainPane.setBackground(Color.white);
        if (JXplorer.getProperty("gui.buttonbar", "true").equals("false")) {
            this.buttonBar.setVisible(false);
        }
        if (JXplorer.getProperty("gui.searchbar", "true").equals("false")) {
            this.searchBar.setVisible(false);
        }
    }

    protected void setupActiveComponents() {
        this.mainViewer = new AttributeDisplay(myProperties, this, this.resourceLoader);
        this.mrTree = new SmartTree(this, CBIntText.get("Explore"), this.resourceLoader);
        this.mrTree.setBackground(new Color(0xF7F9FF));
        this.initialiseTree(this.mrTree, this.mainViewer, this);
        this.searchTree = new SmartTree(this, CBIntText.get("Results"), this.resourceLoader);
        this.searchTree.setBackground(new Color(0xEEFFFF));
        this.initialiseTree(this.searchTree, this.mainViewer, this);
        this.schemaTree = new SmartTree(this, CBIntText.get("Schema"), this.resourceLoader);
        this.schemaTree.setBackground(new Color(0xEEFFEE));
        this.schemaTree.getTree().setEditable(false);
        this.initialiseTree(this.schemaTree, this.mainViewer, this);
        this.mainViewer.registerComponents(this.mainMenu, this.buttonBar, this.mrTree.getTree(), this.mrTree.getPopupTool(), this);
    }

    public void initialiseTree(SmartTree tree, DataSink viewer, JXplorerEventGenerator gen) {
        if (viewer != null) {
            tree.registerDataSink(viewer);
        }
        if (gen != null) {
            tree.registerEventPublisher(gen);
        }
    }

    protected void setupStatusDisplay() {
        this.statusDisplay = new CBPanel();
        this.statusDisplay.makeHeavy();
        this.displayLabel = new JLabel(CBIntText.get("initialising..."));
        this.statusDisplay.addln(this.displayLabel);
        this.mainPane.add((Component)this.statusDisplay, "South");
    }

    public String getStatus() {
        return this.displayLabel.getText();
    }

    public void setStatus(String s) {
        this.displayLabel.setText(s);
        this.displayLabel.repaint();
    }

    public void pushStatus(String newMessage) {
        this.statusStack.push(this.displayLabel.getText());
        this.setStatus(newMessage);
    }

    public String popStatus() {
        String status = this.statusStack.empty() ? "" : (String)this.statusStack.pop();
        this.setStatus(status);
        return status;
    }

    protected void setupMainWorkArea() {
        JSplitPane splitPane = new JSplitPane(1, false);
        this.mainPane.add((Component)splitPane, "Center");
        this.treeTabPane = new JTabbedPane();
        this.treeTabPane.setMinimumSize(new Dimension(100, 100));
        if (JXplorer.isLinux()) {
            this.treeTabPane.setPreferredSize(new Dimension(265, 100));
        } else {
            this.treeTabPane.setPreferredSize(new Dimension(240, 100));
        }
        this.explorePanel = new JScrollPane(this.mrTree);
        this.resultsPanel = new JScrollPane(this.searchTree);
        this.schemaPanel = new JScrollPane(this.schemaTree);
        this.explorePanel.getVerticalScrollBar().setUnitIncrement(16);
        this.resultsPanel.getVerticalScrollBar().setUnitIncrement(16);
        this.schemaPanel.getVerticalScrollBar().setUnitIncrement(16);
        splitPane.add(this.treeTabPane, "left", 0);
        if (JXplorer.getProperty("gui.viewPanel", "true").equals("true")) {
            this.userViewPanel = new JPanel(new BorderLayout());
            this.userViewPanel.add((Component)this.mainViewer, "Center");
            splitPane.add(this.userViewPanel, "right", 1);
        }
        if (this.mrTree != null) {
            this.treeTabPane.addTab(this.mrTree.getName(), new ImageIcon("images" + File.separator + "explore.gif"), this.explorePanel, "Displays the directory tree, and allows the user to graphically browse the directory.");
        }
        if (this.searchTree != null) {
            this.treeTabPane.addTab(this.searchTree.getName(), new ImageIcon("images" + File.separator + "find.gif"), this.resultsPanel, "Displays the search results, and allows the user to graphically browse these results.");
        }
        if (this.schemaTree != null) {
            this.treeTabPane.addTab(this.schemaTree.getName(), new ImageIcon("icons" + File.separator + "schema.gif"), this.schemaPanel, "Displays the directory schema, and allows the user to graphically browse the schema.");
        }
        this.treeTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component treePane = JXplorer.this.treeTabPane.getSelectedComponent();
                ButtonRegister br = JXplorer.getButtonRegister();
                if (treePane == JXplorer.this.explorePanel) {
                    JXplorer.this.setStatus(CBIntText.get("Connected To ''{0}''", new String[]{JXplorer.this.url}));
                    if (br != null && JXplorer.this.isConnected()) {
                        br.setCommonState(true);
                    }
                    JXplorer.this.mrTree.refreshEditorPane();
                } else if (treePane == JXplorer.this.resultsPanel) {
                    JXplorer.this.setStatus("Number of search results: " + String.valueOf(JXplorer.this.searchTree.getNumOfResults()));
                    JXplorer.this.searchTree.refreshEditorPane();
                } else if (treePane == JXplorer.this.schemaPanel) {
                    JXplorer.this.setStatus(CBIntText.get("Connected To ''{0}''", new String[]{JXplorer.this.url}));
                    if (br != null) {
                        br.setCommonState(false);
                    }
                    JXplorer.this.schemaTree.refreshEditorPane();
                }
            }
        });
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public SmartTree getActiveTree() {
        int paneNumber = this.treeTabPane.getSelectedIndex();
        if (paneNumber == this.treeTabPane.indexOfTab(CBIntText.get("Explore"))) {
            return this.mrTree;
        }
        if (paneNumber == this.treeTabPane.indexOfTab(CBIntText.get("Results"))) {
            return this.searchTree;
        }
        if (paneNumber == this.treeTabPane.indexOfTab(CBIntText.get("Schema"))) {
            return this.schemaTree;
        }
        log.warning("ERROR: Unable to establish active tree - panel = " + paneNumber);
        return null;
    }

    protected void setupFrills() {
        this.setIconImage(JXplorer.getImageIcon("ODlogo.gif").getImage());
        this.setTitle("JXplorer");
    }

    public static ImageIcon getImageIcon(String name) {
        ImageIcon newIcon = new ImageIcon(JXplorer.getProperty("dir.images") + name);
        return newIcon;
    }

    protected void setupHelp() {
        this.helpSystem = new CBHelpSystem("JXplorerHelp.hs");
    }

    public CBHelpSystem getHelpSystem() {
        return this.helpSystem;
    }

    public void shutdown() {
        this.shutdown(null);
    }

    public void shutdown(String msg) {
        JXplorer.setProperty("width", String.valueOf((int)this.getSize().getWidth()));
        JXplorer.setProperty("height", String.valueOf((int)this.getSize().getHeight()));
        JXplorer.setProperty("xpos", String.valueOf(this.getX()));
        JXplorer.setProperty("ypos", String.valueOf(this.getY()));
        JXplorer.setProperty("last.search.filter", "default");
        JXplorer.writePropertyFile();
        if (msg != null) {
            log.severe("shutting down\n" + msg);
        } else {
            log.warning("shutting down");
        }
        System.exit(0);
    }

    public static void writePropertyFile() {
        CBUtility.writePropertyFile(propertyFile, myProperties, new String("# The property file location defaults to where JXplorer is installed\n# - this can be over-ridden with the system property 'jxplorer.config'\n#   with a config directory location, or set to user home using the\n#   flag 'user.home' (e.g. -Djxplorer.config='user.home' on the command line).\n"));
    }

    public String toString() {
        return "JXplorer version " + version;
    }

    public void preConnectionSetup() {
        if (this.mrTree == null) {
            return;
        }
        this.mrTree.clearTree();
        this.mrTree.setRoot(SmartTree.NODATA);
        this.treeTabPane.setSelectedIndex(0);
        if (this.searchTree == null) {
            return;
        }
        this.searchTree.clearTree();
        this.searchTree.setRoot(SmartTree.NODATA);
        if (this.schemaTree == null) {
            return;
        }
        this.schemaTree.clearTree();
        this.schemaTree.setRoot(SmartTree.NODATA);
    }

    public boolean postConnectionSetup(JNDIBroker.DataConnectionQuery request) {
        this.searchTree.clearTree();
        if (this.workOffline) {
            this.workOffline = false;
            this.offlineBroker.clear();
        }
        String baseDN = request.conData.baseDN;
        DN base = new DN(baseDN);
        DN[] namingContexts = null;
        int ldapV = request.conData.version;
        try {
            if (base == null || base.size() == 0 || !this.jndiBroker.getDirOp().exists(base)) {
                if (ldapV == 2) {
                    if (!this.jndiBroker.getDirOp().exists(base)) {
                        CBUtility.error("Error opening ldap v2 connection - bad base DN '" + (base == null ? "*null*" : base.toString()) + "' ");
                        this.disconnect();
                        return false;
                    }
                } else {
                    if (base != null && base.size() > 0) {
                        log.warning("The Base DN '" + base + "' cannot be found.");
                    }
                    base = null;
                    namingContexts = this.jndiBroker.readFallbackRoot();
                    if (baseDN.trim().length() > 0) {
                        if (namingContexts != null && namingContexts[0] != null) {
                            log.warning("Cannot find the user-specified Base DN - Using the fall back DN '" + namingContexts[0].toString() + "'");
                        } else {
                            log.warning("WARNING: Cannot find the user-specified Base DN, and cannot read alternative from directory.  Leaving unset for the present.");
                        }
                    }
                    if (namingContexts != null && namingContexts.length == 1) {
                        base = namingContexts[0];
                    }
                }
            }
            this.mrTree.clearTree();
            this.mrTree.registerDataSource(this.jndiBroker);
        }
        catch (Exception ex) {
            if (ldapV != 2) {
                CBUtility.error("Possible errors occurred while opening connection.", ex);
            }
            CBUtility.error("Error opening ldap v2 connection (possibly bad base DN?) ", ex);
            this.disconnect();
            return false;
        }
        if (base != null) {
            this.mrTree.setRoot(base);
            if (base.size() == 0) {
                this.mrTree.expandRoot();
                this.mrTree.getRootNode().setAlwaysRefresh(true);
            } else {
                this.mrTree.expandDN(base);
                this.makeDNAutoRefreshing(base);
            }
        } else if (namingContexts != null) {
            int i;
            this.mrTree.setRoot("");
            for (i = 0; i < namingContexts.length; ++i) {
                DN namingContext = namingContexts[i];
                SmartNode node = this.mrTree.addNode(namingContext);
                if (node.getChildCount() != 0) continue;
                node.add(new SmartNode());
            }
            for (i = 0; i < namingContexts.length; ++i) {
                this.mrTree.expandDN(namingContexts[i]);
                this.makeDNAutoRefreshing(namingContexts[i]);
            }
        } else {
            this.mrTree.expandRoot();
            this.mrTree.getRootNode().setAlwaysRefresh(true);
        }
        this.searchTree.clearTree();
        this.searchBroker.registerDirectoryConnection(this.jndiBroker);
        this.searchTree.registerDataSource(this.searchBroker);
        this.searchTree.setRoot(new DN(SmartTree.NODATA));
        this.schemaTree.clearTree();
        if (Integer.toString(ldapV) != null && ldapV > 2) {
            this.schemaBroker.registerDirectoryConnection(this.jndiBroker);
            this.schemaTree.registerDataSource(this.schemaBroker);
            this.schemaTree.setRoot(new DN("cn=schema"));
            DXAttribute.setDefaultSchema(this.jndiBroker.getSchemaOps());
            DXAttributes.setDefaultSchema(this.jndiBroker.getSchemaOps());
        } else {
            DXAttribute.setDefaultSchema(null);
            DXAttributes.setDefaultSchema(null);
        }
        if (base != null) {
            this.jndiBroker.getEntry(base);
            JXplorer.setDefaultProperty("baseDN", base.toString());
            this.url = request.conData.url;
            this.setStatus(CBIntText.get("Connected To ''{0}''", new String[]{this.url}));
        }
        JXplorer.getButtonRegister().setConnectedState();
        this.mainMenu.setConnected(true);
        this.setConnected(true);
        return true;
    }

    protected void makeDNAutoRefreshing(DN dn) {
        try {
            TreePath path = ((SmartModel)this.mrTree.getModel()).getPathForDN(dn);
            if (path == null) {
                throw new Exception("null path returned");
            }
            Object[] nodes = path.getPath();
            for (int j = 0; j < nodes.length - 1; ++j) {
                ((SmartNode)nodes[j]).setAlwaysRefresh(true);
            }
        }
        catch (Exception e) {
            log.info("INFO: messed up setting auto-expanding nodes for context '" + dn + "'");
        }
    }

    public void disconnect() {
        this.jndiBroker.disconnect();
        this.mrTree.clearTree();
        this.schemaTree.clearTree();
        this.searchTree.clearTree();
        this.searchTree.setNumOfResults(0);
        JXplorer.getButtonRegister().setDisconnectState();
        this.mainMenu.setDisconnected();
        this.setConnected(false);
        this.setStatus(CBIntText.get("Disconnected"));
    }

    public void setDisconnectView() {
        this.mainMenu.setDisconnected();
        JXplorer.getButtonRegister().setDisconnectState();
        this.setStatus(CBIntText.get("Disconnected"));
    }

    public synchronized void addJXplorerListener(JXplorerListener l) {
        if (l != null) {
            this.eventListeners.add(JXplorerListener.class, l);
        }
    }

    public synchronized void removeJXplorerListener(JXplorerListener l) {
        if (l != null) {
            this.eventListeners.remove(JXplorerListener.class, l);
        }
    }

    public void fireJXplorerEvent(JXplorerEvent e) {
        Object[] list = this.eventListeners.getListenerList();
        for (int index = list.length - 2; index >= 0; index -= 2) {
            if (list[index] != (class$com$ca$directory$jxplorer$event$JXplorerListener == null ? JXplorer.class$("com.ca.directory.jxplorer.event.JXplorerListener") : class$com$ca$directory$jxplorer$event$JXplorerListener)) continue;
            ((JXplorerListener)list[index + 1]).JXplorerDNSelected(e);
        }
    }

    public void showSplashScreen(JWindow splash) {
        ImageIcon splashIcon = new ImageIcon("templates" + File.separator + "JXsplash.gif");
        int width = splashIcon.getIconWidth();
        int height = splashIcon.getIconHeight();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        splash.setBounds((screen.width - width) / 2, (screen.height - height) / 2, width, height);
        JLabel pic = new JLabel(splashIcon);
        JPanel content = (JPanel)splash.getContentPane();
        content.add(pic);
        splash.setVisible(true);
    }

    public void setupResourceFiles() {
        this.resourceLoader = new CBResourceLoader();
        this.classLoader = new CBClassLoader(this.resourceLoader);
        String pluginPath = JXplorer.getProperty("dir.plugins");
        String[] pluginFiles = CBUtility.readFilteredDirectory(pluginPath, new String[]{"zip", "jar"});
        if (pluginFiles == null) {
            log.warning("Unable to access plugins directory: '" + pluginPath + "'");
            return;
        }
        for (int i = 0; i < pluginFiles.length; ++i) {
            this.resourceLoader.addResource(new CBJarResource(pluginPath + pluginFiles[i]));
        }
        this.setupSecurityProviders();
        this.setupGSSAPIConfig();
    }

    protected void setupGSSAPIConfig() {
        try {
            String sep = System.getProperty("line.separator");
            String defaultFileText = "com.ca.commons.jndi.JNDIOps {" + sep + "  com.sun.security.auth.module.Krb5LoginModule required client=TRUE" + sep + "  \t\t\t\t\t\t\t\t\t\t\t\t\t\tuseTicketCache=TRUE;" + sep + "};";
            String configFile = CBUtility.getPropertyConfigPath("gssapi.conf");
            File gssapi_conf = new File(configFile);
            if (!gssapi_conf.exists()) {
                FileWriter confWriter = new FileWriter(gssapi_conf);
                confWriter.write(defaultFileText);
                confWriter.close();
            }
            System.setProperty("java.security.auth.login.config", gssapi_conf.getCanonicalPath().toString());
        }
        catch (IOException e) {
            log.warning("ERROR: Unable to initialise GSSAPI config file " + e);
        }
    }

    protected void setupSecurityProviders() {
        String providerName = JXplorer.getProperty("securityProvider2", null);
        if (providerName != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXplorer.getProperty("securityProvider1", null)) != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXplorer.getProperty("securityProvider0", null)) != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXplorer.getProperty("securityProvider", null)) != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXplorer.getProperty("securityProvider3", null)) != null) {
            CBUtility.error(CBIntText.get("Too many security providers in config file."));
            JXplorer.printSecurityProviders();
        } else if (debugLevel >= 2) {
            JXplorer.printSecurityProviders();
        }
        JndiSocketFactory.setClassLoader(this.classLoader);
    }

    protected void addSecurityProvider(String providerName) {
        try {
            Class<?> providerClass = this.classLoader.loadClass(providerName);
            Object providerObject = providerClass.newInstance();
            Security.insertProviderAt((Provider)providerObject, 1);
        }
        catch (Exception e) {
            System.err.println("\n*** unable to load new security provider: " + (providerName == null ? "null" : providerName));
            System.err.println(e);
        }
    }

    protected static void printSecurityProviders() {
        log.fine("\n***\n*** LIST OF CURRENT SECURITY PROVIDERS\n***");
        Provider[] current = Security.getProviders();
        for (int i = 0; i < current.length; ++i) {
            log.fine("provider: " + i + " = " + current[i].getName() + " " + current[i].getInfo());
            log.fine("   (" + current[i].getClass().toString() + ")\n");
        }
        log.fine("\n***\n*** END LIST\n***\n");
    }

    public static boolean isSolaris() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        if ((os = os.toLowerCase()).indexOf("sun") > -1) {
            return true;
        }
        return os.indexOf("solaris") > -1;
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("linux") > -1;
    }

    public static boolean isMac() {
        String os = System.getProperty("mrj.version");
        return os != null;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("windows") > -1;
    }

    public static ButtonRegister getButtonRegister() {
        return buttonRegister;
    }

    static {
        debug = false;
        debugLevel = 0;
        buttonRegister = null;
        log = Logger.getLogger(JXplorer.class.getName());
    }
}

