untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24KyiCX3cI1VcaqktFGIEyrhryDBN4QvPPvY0hsMOAUX5ImldKbNP+eC7TYKZbxxr/GxpXPZb7LEMisQ07f3yEAE=

OpenBSD 6.6 errata 042, September 5, 2020:

Buffer overflow in amdgpu ioctl.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 042_amdgpu.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c,v
retrieving revision 1.5
diff -u -p -r1.5 amdgpu_kms.c
--- sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c	13 Aug 2019 22:02:28 -0000	1.5
+++ sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c	3 Sep 2020 13:51:19 -0000
@@ -609,8 +609,15 @@ static int amdgpu_info_ioctl(struct drm_
 		 * in the bitfields */
 		if (se_num == AMDGPU_INFO_MMR_SE_INDEX_MASK)
 			se_num = 0xffffffff;
+		else if (se_num >= AMDGPU_GFX_MAX_SE)
+			return -EINVAL;
 		if (sh_num == AMDGPU_INFO_MMR_SH_INDEX_MASK)
 			sh_num = 0xffffffff;
+		else if (sh_num >= AMDGPU_GFX_MAX_SH_PER_SE)
+			return -EINVAL;
+
+		if (info->read_mmr_reg.count > 128)
+			return -EINVAL;
 
 		regs = kmalloc_array(info->read_mmr_reg.count, sizeof(*regs), GFP_KERNEL);
 		if (!regs)
