/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.z.IntPredicateProxy;

final class PrecedingSiblingIterator
implements AxisIterator {
    private final TinyTree document;
    private final TinyNodeImpl startNode;
    private int nextNodeNr;
    private final NodeTest test;
    private final TinyNodeImpl parentNode;
    private final IntPredicateProxy matcher;

    PrecedingSiblingIterator(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest) {
        this.document = doc;
        this.document.ensurePriorIndex();
        this.test = nodeTest;
        this.startNode = node;
        this.nextNodeNr = node.nodeNr;
        this.parentNode = node.parent;
        this.matcher = nodeTest.getMatcher(doc);
    }

    @Override
    public NodeInfo next() {
        if (this.nextNodeNr < 0) {
            return null;
        }
        do {
            this.nextNodeNr = this.document.prior[this.nextNodeNr];
            if (this.nextNodeNr >= 0) continue;
            return null;
        } while (!this.matcher.test(this.nextNodeNr));
        TinyNodeImpl next = this.document.getNode(this.nextNodeNr);
        next.setParentNode(this.parentNode);
        return next;
    }
}

