/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.Domain;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.IPv6Address;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HostTest {
    @Test
    public void parseTest() throws GalimatiasParseException {
        Assertions.assertThat((Object)Host.parseHost("example.com")).isInstanceOf(Domain.class);
        Assertions.assertThat((Object)Host.parseHost("[2001:0db8:85a3:08d3:1319:8a2e:0370:7334]")).isInstanceOf(IPv6Address.class);
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseHostWithUnmatchedBracket() throws GalimatiasParseException {
        Host.parseHost("[2001:0db8:85a3:08d3:1319:8a2e:0370:7334");
    }

    @Test(expected=NullPointerException.class)
    public void parseNullHost() throws GalimatiasParseException {
        Host.parseHost(null);
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseEmptyHost() throws GalimatiasParseException {
        Host.parseHost("");
    }
}

