/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.logging.Handler;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;

public final class LogService {
    private static final Logger log = Logger.getLogger("org.jboss.logging.service");
    private static final Logger rootLogger = Logger.getLogger("");
    private Handler[] bootstrapHandlers;

    public void create() {
    }

    public void start() {
        log.info("Removing bootstrap log handlers");
        Handler[] bootstrapHandlers = rootLogger.clearHandlers();
        this.bootstrapHandlers = bootstrapHandlers;
        for (Handler handler : bootstrapHandlers) {
            LogService.safeFlush(handler);
        }
        log.info("Removed bootstrap log handlers");
    }

    public void stop() {
        log.info("Restoring bootstrap log handlers");
        for (Handler handler : rootLogger.clearHandlers()) {
            LogService.safeClose(handler);
        }
        Handler[] bootstrapHandlers = this.bootstrapHandlers;
        this.bootstrapHandlers = null;
        for (Handler handler : bootstrapHandlers) {
            rootLogger.addHandler(handler);
        }
        log.info("Restored bootstrap log handlers");
    }

    private static void safeFlush(Handler handler) {
        try {
            if (handler != null) {
                handler.flush();
            }
        }
        catch (Throwable t) {
            log.log((java.util.logging.Level)Level.ERROR, "Error flushing a log handler", t);
        }
    }

    private static void safeClose(Handler handler) {
        try {
            if (handler != null) {
                handler.close();
            }
        }
        catch (Throwable t) {
            log.log((java.util.logging.Level)Level.ERROR, "Error closing a log handler", t);
        }
    }

    public void destroy() {
    }
}

