/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.util.TreeUtils;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BalloonLayout<V, E>
extends TreeLayout<V, E> {
    protected LoadingCache<V, PolarPoint> polarLocations = CacheBuilder.newBuilder().build(new CacheLoader<V, PolarPoint>(){

        public PolarPoint load(V vertex) {
            return new PolarPoint();
        }
    });
    protected Map<V, Double> radii = new HashMap<V, Double>();

    public BalloonLayout(Forest<V, E> g) {
        super(g);
    }

    protected void setRootPolars() {
        List roots = TreeUtils.getRoots(this.graph);
        if (roots.size() == 1) {
            Object root = roots.get(0);
            this.setRootPolar(root);
            this.setPolars(new ArrayList(this.graph.getChildren(root)), this.getCenter(), this.getSize().width / 2);
        } else if (roots.size() > 1) {
            this.setPolars(roots, this.getCenter(), this.getSize().width / 2);
        }
    }

    protected void setRootPolar(V root) {
        PolarPoint pp = new PolarPoint(0.0, 0.0);
        Point2D p = this.getCenter();
        this.polarLocations.put(root, (Object)pp);
        this.locations.put(root, (Object)p);
    }

    protected void setPolars(List<V> kids, Point2D parentLocation, double parentRadius) {
        int childCount = kids.size();
        if (childCount == 0) {
            return;
        }
        double angle = Math.max(0.0, 1.5707963267948966 * (1.0 - 2.0 / (double)childCount));
        double childRadius = parentRadius * Math.cos(angle) / (1.0 + Math.cos(angle));
        double radius = parentRadius - childRadius;
        double rand = Math.random();
        for (int i = 0; i < childCount; ++i) {
            V child = kids.get(i);
            double theta = (double)(i * 2) * Math.PI / (double)childCount + rand;
            this.radii.put((Double)child, childRadius);
            PolarPoint pp = new PolarPoint(theta, radius);
            this.polarLocations.put(child, (Object)pp);
            Point2D p = PolarPoint.polarToCartesian(pp);
            p.setLocation(p.getX() + parentLocation.getX(), p.getY() + parentLocation.getY());
            this.locations.put(child, (Object)p);
            this.setPolars(new ArrayList<V>(this.graph.getChildren(child)), p, childRadius);
        }
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
        this.setRootPolars();
    }

    public Point2D getCenter(V v) {
        V parent = this.graph.getParent(v);
        if (parent == null) {
            return this.getCenter();
        }
        return (Point2D)this.locations.getUnchecked(parent);
    }

    @Override
    public void setLocation(V v, Point2D location) {
        Point2D c = this.getCenter(v);
        Point2D.Double pv = new Point2D.Double(location.getX() - c.getX(), location.getY() - c.getY());
        PolarPoint newLocation = PolarPoint.cartesianToPolar(pv);
        ((PolarPoint)this.polarLocations.getUnchecked(v)).setLocation(newLocation);
        Point2D center = this.getCenter(v);
        ((Point2D)pv).setLocation(((Point2D)pv).getX() + center.getX(), ((Point2D)pv).getY() + center.getY());
        this.locations.put(v, (Object)pv);
    }

    @Override
    public Point2D apply(V v) {
        return (Point2D)this.locations.getUnchecked(v);
    }

    public Map<V, Double> getRadii() {
        return this.radii;
    }
}

