/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class AnnotationRenderer
extends JLabel
implements Serializable {
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);

    public AnnotationRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getAnnotationRendererComponent(JComponent vv, Object value) {
        super.setForeground(vv.getForeground());
        super.setBackground(vv.getBackground());
        this.setFont(vv.getFont());
        this.setIcon(null);
        this.setBorder(noFocusBorder);
        this.setValue(value);
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }
}

