/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.pdb.classtype.PlaceholderVirtualFunctionTableEntry;
import ghidra.app.util.pdb.classtype.VirtualFunctionTable;
import ghidra.app.util.pdb.classtype.VirtualFunctionTableEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.gclass.ClassID;
import java.util.Iterator;
import java.util.List;

public class PlaceholderVirtualFunctionTable
extends VirtualFunctionTable {
    public PlaceholderVirtualFunctionTable(ClassID owner, List<ClassID> parentage) {
        super(owner, parentage);
    }

    public void setAddress(int tableIndex, Address address) throws PdbException {
        PlaceholderVirtualFunctionTableEntry entry = this.existing(tableIndex);
        entry.setAddress(address);
    }

    @Override
    public Address getAddress(int tableIndex) throws PdbException {
        PlaceholderVirtualFunctionTableEntry entry = this.existing(tableIndex);
        return entry.getAddress();
    }

    @Override
    protected VirtualFunctionTableEntry getNewEntry(SymbolPath originalMethodPath, SymbolPath overrideMethodPath, Pointer functionPointer) {
        return new PlaceholderVirtualFunctionTableEntry(originalMethodPath, overrideMethodPath, functionPointer);
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append("Placeholder VFT for the following classes within owner:\n   " + String.valueOf(this.owner) + "\n");
        builder.append(String.format("For Classes:\n", new Object[0]));
        for (ClassID id : this.parentage) {
            builder.append(String.format("   %-10s\n", id.toString()));
        }
        builder.append("VftPtrOffset within Owner" + this.ptrOffsetInClass + "\n");
        PlaceholderVirtualFunctionTableEntry.emitHeader(builder);
        Iterator<Object> iterator = this.entriesByTableIndex.keySet().iterator();
        while (iterator.hasNext()) {
            int tableIndex = (Integer)iterator.next();
            this.entry(tableIndex).emit(builder, this.ptrOffsetInClass);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.emit(builder);
        return builder.toString();
    }

    private PlaceholderVirtualFunctionTableEntry entry(int tableIndex) {
        return (PlaceholderVirtualFunctionTableEntry)this.entriesByTableIndex.get(tableIndex);
    }

    private PlaceholderVirtualFunctionTableEntry existing(int tableIndex) throws PdbException {
        PlaceholderVirtualFunctionTableEntry entry = this.entry(tableIndex);
        if (entry == null) {
            throw new PdbException("No entry in Virtual Function Table for table offset: " + tableIndex);
        }
        return entry;
    }
}

