/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import com.esotericsoftware.kryo.io.Input;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.impl.serialize.ParallelStringDecoder;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.graph.StringDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringDecoder;", "Lorg/gradle/internal/serialize/graph/StringDecoder;", "Ljava/lang/AutoCloseable;", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "reader", "Ljava/lang/Thread;", "strings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "close", "", "doReadString", "", "id", "readNullableString", "decoder", "Lorg/gradle/internal/serialize/Decoder;", "readString", "FutureString", "configuration-cache"})
public final class ParallelStringDecoder
implements StringDecoder,
AutoCloseable {
    @NotNull
    private final ConcurrentHashMap<Integer, Object> strings;
    @NotNull
    private final Thread reader;

    public ParallelStringDecoder(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.strings = new ConcurrentHashMap();
        this.reader = ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(stream, this){
            final /* synthetic */ InputStream $stream;
            final /* synthetic */ ParallelStringDecoder this$0;
            {
                this.$stream = $stream;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Closeable closeable = (Closeable)new Input(this.$stream);
                ParallelStringDecoder parallelStringDecoder = this.this$0;
                Throwable throwable = null;
                try {
                    int id2;
                    Input input = (Input)closeable;
                    boolean bl = false;
                    while ((id2 = input.readVarInt(true)) != 0) {
                        String string2 = input.readString();
                        ParallelStringDecoder.access$getStrings$p(parallelStringDecoder).compute(id2, new BiFunction(string2){
                            final /* synthetic */ String $string;
                            {
                                this.$string = $string;
                            }

                            public final Object apply(Integer n, Object value) {
                                Intrinsics.checkNotNullParameter((Object)n, (String)"<anonymous parameter 0>");
                                if (value instanceof FutureString) {
                                    FutureString futureString = (FutureString)value;
                                    String string2 = this.$string;
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"string");
                                    futureString.complete(string2);
                                } else if (!(value == null)) {
                                    String string3 = "Failed requirement.";
                                    throw new IllegalArgumentException(string3.toString());
                                }
                                return this.$string;
                            }
                        });
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }), (int)29, null);
    }

    @Nullable
    public String readNullableString(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        int id2 = decoder.readSmallInt();
        return id2 == 0 ? null : this.doReadString(id2);
    }

    @NotNull
    public String readString(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return this.doReadString(decoder.readSmallInt());
    }

    private final String doReadString(int id2) {
        String string2;
        Object object = this.strings.computeIfAbsent(id2, doReadString.it.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"strings.computeIfAbsent(id) { FutureString() }");
        Object it2 = object;
        if (it2 instanceof String) {
            string2 = (String)it2;
        } else if (it2 instanceof FutureString) {
            string2 = ((FutureString)it2).get();
        } else {
            throw new IllegalStateException((it2 + " is unexpected").toString());
        }
        return string2;
    }

    @Override
    public void close() {
        this.reader.join(TimeUnit.MINUTES.toMillis(1L));
    }

    public static final /* synthetic */ ConcurrentHashMap access$getStrings$p(ParallelStringDecoder $this) {
        return $this.strings;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringDecoder$FutureString;", "", "()V", "latch", "Ljava/util/concurrent/CountDownLatch;", "string", "", "complete", "", "s", "get", "configuration-cache"})
    private static final class FutureString {
        @NotNull
        private final CountDownLatch latch = new CountDownLatch(1);
        @Nullable
        private String string;

        public final void complete(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.string = s;
            this.latch.countDown();
        }

        @NotNull
        public final String get() {
            if (!this.latch.await(1L, TimeUnit.MINUTES)) {
                throw new TimeoutException("Timeout while waiting for string");
            }
            String string2 = this.string;
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }
    }
}

