/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DescribingAndSpec;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipOnlyIfTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipOnlyIfTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipOnlyIfTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        Spec<? super TaskInternal> unsatisfiedSpec = null;
        try {
            Spec<? super TaskInternal> onlyIf = task.getOnlyIf();
            if (onlyIf instanceof DescribingAndSpec) {
                DescribingAndSpec describingAndSpec = (DescribingAndSpec)((Object)Cast.uncheckedCast(onlyIf));
                unsatisfiedSpec = describingAndSpec.findUnsatisfiedSpec(task);
            } else if (!onlyIf.isSatisfiedBy((Object)task)) {
                unsatisfiedSpec = onlyIf;
            }
        }
        catch (Throwable t) {
            state.setOutcome((RuntimeException)new GradleException(String.format("Could not evaluate onlyIf predicate for %s.", task), t));
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
        if (unsatisfiedSpec != null) {
            if (unsatisfiedSpec instanceof SelfDescribingSpec) {
                SelfDescribingSpec selfDescribingSpec = (SelfDescribingSpec)Cast.uncheckedCast(unsatisfiedSpec);
                LOGGER.info("Skipping {} as task onlyIf '{}' is false.", (Object)task, (Object)selfDescribingSpec.getDisplayName());
                state.setSkipReasonMessage("'" + selfDescribingSpec.getDisplayName() + "' not satisfied");
            } else {
                LOGGER.info("Skipping {} as task onlyIf is false.", (Object)task);
                state.setSkipReasonMessage("onlyIf not satisfied");
            }
            state.setOutcome(TaskExecutionOutcome.SKIPPED);
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
        return this.executer.execute(task, state, context);
    }
}

