/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class, Scope.BuildTree.class})
public interface BuildActionRunner {
    public Result run(BuildAction var1, BuildTreeLifecycleController var2);

    public static class Result {
        private final boolean hasResult;
        private final Object result;
        private final Throwable buildFailure;
        private final Throwable clientFailure;
        private static final Result NOTHING = new Result(false, null, null, null);
        private static final Result NULL = new Result(true, null, null, null);

        private Result(boolean hasResult, @Nullable Object result, @Nullable Throwable buildFailure, @Nullable Throwable clientFailure) {
            this.hasResult = hasResult;
            this.result = result;
            this.buildFailure = buildFailure;
            this.clientFailure = clientFailure;
        }

        public static Result nothing() {
            return NOTHING;
        }

        public static Result of(@Nullable Object result) {
            if (result == null) {
                return NULL;
            }
            return new Result(true, result, null, null);
        }

        public static Result failed(Throwable buildFailure) {
            return new Result(true, null, buildFailure, buildFailure);
        }

        public static Result failed(Throwable buildFailure, RuntimeException clientFailure) {
            return new Result(true, null, buildFailure, clientFailure);
        }

        public boolean hasResult() {
            return this.hasResult;
        }

        @Nullable
        public Object getClientResult() {
            return this.result;
        }

        @Nullable
        public Throwable getBuildFailure() {
            return this.buildFailure;
        }

        @Nullable
        public Throwable getClientFailure() {
            return this.clientFailure;
        }

        public Result addFailures(List<Throwable> failures) {
            if (failures.isEmpty()) {
                return this;
            }
            ArrayList<Throwable> newFailures = new ArrayList<Throwable>(1 + failures.size());
            if (this.buildFailure != null) {
                if (this.buildFailure instanceof MultipleBuildFailures) {
                    MultipleBuildFailures multipleBuildFailures = (MultipleBuildFailures)((Object)this.buildFailure);
                    newFailures.addAll(multipleBuildFailures.getCauses());
                } else {
                    newFailures.add(this.buildFailure);
                }
            }
            newFailures.addAll(failures);
            if (newFailures.size() == 1) {
                return Result.failed((Throwable)newFailures.get(0));
            }
            return Result.failed((Throwable)((Object)new MultipleBuildFailures(newFailures)));
        }

        public Result addFailure(Throwable t) {
            return this.addFailures(Collections.singletonList(t));
        }
    }
}

