/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.api.NonNullApi;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

@NonNullApi
public class DoubleFromCharSequenceNotationConverter
implements NotationConverter<CharSequence, Double> {
    public void convert(CharSequence notation, NotationConvertResult<? super Double> result) throws TypeConversionException {
        try {
            result.converted((Object)Double.valueOf(notation.toString()));
        }
        catch (NumberFormatException ex) {
            throw new TypeConversionException(String.format("Cannot convert string value '%s' to a double.", notation), (Throwable)ex);
        }
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("A double.");
    }
}

