/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentMetaDataResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentGraphSpecificResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ExternalModuleComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueFactory;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.ResolveExceptionAnalyzer;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryChainComponentMetaDataResolver
implements ComponentMetaDataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryChainComponentMetaDataResolver.class);
    private final List<ModuleComponentRepository<ExternalModuleComponentGraphResolveState>> repositories = new ArrayList<ModuleComponentRepository<ExternalModuleComponentGraphResolveState>>();
    private final List<String> repositoryNames = new ArrayList<String>();
    private final VersionedComponentChooser versionedComponentChooser;
    private final CalculatedValueFactory calculatedValueFactory;
    private final Cache<ModuleComponentIdentifier, CalculatedValue<BuildableComponentResolveResult>> metadataValueContainerCache;

    public RepositoryChainComponentMetaDataResolver(VersionedComponentChooser componentChooser, CalculatedValueFactory calculatedValueFactory) {
        this.versionedComponentChooser = componentChooser;
        this.calculatedValueFactory = calculatedValueFactory;
        this.metadataValueContainerCache = CacheBuilder.newBuilder().weakValues().build();
    }

    public void add(ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository) {
        this.repositories.add(repository);
        this.repositoryNames.add(repository.getName());
    }

    @Override
    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
        if (!(identifier instanceof ModuleComponentIdentifier)) {
            throw new UnsupportedOperationException("Can resolve meta-data for module components only.");
        }
        try {
            CalculatedValue metadataValueContainer = (CalculatedValue)this.metadataValueContainerCache.get((Object)((ModuleComponentIdentifier)identifier), () -> this.createValueContainerFor(identifier, componentOverrideMetadata));
            metadataValueContainer.finalizeIfNotAlready();
            ((BuildableComponentResolveResult)metadataValueContainer.get()).applyTo(result);
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private CalculatedValue<BuildableComponentResolveResult> createValueContainerFor(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata) {
        return this.calculatedValueFactory.create(RepositoryChainComponentMetaDataResolver.toDisplayName(identifier), () -> this.resolveModule((ModuleComponentIdentifier)identifier, componentOverrideMetadata));
    }

    @Override
    public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
        if (identifier instanceof ModuleComponentIdentifier) {
            for (ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository : this.repositories) {
                ModuleComponentRepositoryAccess<ExternalModuleComponentGraphResolveState> localAccess = repository.getLocalAccess();
                MetadataFetchingCost fetchingCost = localAccess.estimateMetadataFetchingCost((ModuleComponentIdentifier)identifier);
                if (fetchingCost.isFast()) {
                    return true;
                }
                if (!fetchingCost.isExpensive()) continue;
                return false;
            }
        }
        return true;
    }

    private BuildableComponentResolveResult resolveModule(ModuleComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata) {
        LOGGER.debug("Attempting to resolve component for {} using repositories {}", (Object)identifier, this.repositoryNames);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        DefaultBuildableComponentResolveResult result = new DefaultBuildableComponentResolveResult();
        ArrayList<ComponentMetaDataResolveState> resolveStates = new ArrayList<ComponentMetaDataResolveState>();
        for (ModuleComponentRepository<ExternalModuleComponentGraphResolveState> moduleComponentRepository : this.repositories) {
            resolveStates.add(new ComponentMetaDataResolveState(identifier, componentOverrideMetadata, moduleComponentRepository, this.versionedComponentChooser));
        }
        RepositoryChainModuleResolution latestResolved = this.findBestMatch(resolveStates, errors);
        if (latestResolved != null) {
            LOGGER.debug("Using {} from {}", (Object)latestResolved.component.getId(), latestResolved.repository);
            for (Throwable error : errors) {
                LOGGER.debug("Discarding resolve failure.", error);
            }
            String string = latestResolved.repository.getName();
            result.resolved(latestResolved.component, new ModuleComponentGraphSpecificResolveState(string));
            return result;
        }
        if (!errors.isEmpty()) {
            result.failed(new ModuleVersionResolveException(identifier, errors));
        } else {
            for (ComponentMetaDataResolveState resolveState : resolveStates) {
                resolveState.applyTo(result);
            }
            result.notFound(identifier);
        }
        return result;
    }

    @Nullable
    private RepositoryChainModuleResolution findBestMatch(List<ComponentMetaDataResolveState> resolveStates, Collection<Throwable> failures) {
        LinkedList<ComponentMetaDataResolveState> queue = new LinkedList<ComponentMetaDataResolveState>(resolveStates);
        LinkedList<ComponentMetaDataResolveState> missing = new LinkedList<ComponentMetaDataResolveState>();
        RepositoryChainModuleResolution best = this.findBestMatch(queue, failures, missing);
        if (ResolveExceptionAnalyzer.hasCriticalFailure(failures)) {
            return null;
        }
        if (best != null) {
            return best;
        }
        queue.addAll(missing);
        missing.clear();
        return this.findBestMatch(queue, failures, missing);
    }

    @Nullable
    private RepositoryChainModuleResolution findBestMatch(LinkedList<ComponentMetaDataResolveState> queue, Collection<Throwable> failures, Collection<ComponentMetaDataResolveState> missing) {
        RepositoryChainModuleResolution best = null;
        block5: while (!queue.isEmpty()) {
            ComponentMetaDataResolveState request = queue.removeFirst();
            BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> metaDataResolveResult = request.resolve();
            switch (metaDataResolveResult.getState()) {
                case Failed: {
                    failures.add((Throwable)((Object)metaDataResolveResult.getFailure()));
                    if (!ResolveExceptionAnalyzer.isCriticalFailure((Throwable)((Object)metaDataResolveResult.getFailure()))) continue block5;
                    queue.clear();
                    continue block5;
                }
                case Missing: {
                    if (!request.canMakeFurtherAttempts()) continue block5;
                    missing.add(request);
                    continue block5;
                }
                case Resolved: {
                    RepositoryChainModuleResolution moduleResolution = new RepositoryChainModuleResolution(request.repository, metaDataResolveResult.getMetaData());
                    if (!metaDataResolveResult.getMetaData().getMetadata().isMissing()) {
                        return moduleResolution;
                    }
                    best = best != null ? best : moduleResolution;
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected state for resolution: " + (Object)((Object)metaDataResolveResult.getState()));
        }
        return best;
    }

    private static DisplayName toDisplayName(final ComponentIdentifier identifier) {
        if (DisplayName.class.isAssignableFrom(identifier.getClass())) {
            return (DisplayName)identifier;
        }
        return new DisplayName(){

            public String getDisplayName() {
                return identifier.getDisplayName();
            }

            public String getCapitalizedDisplayName() {
                return this.getDisplayName();
            }
        };
    }
}

