/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionServices;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.ResolvedVariantTransformer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ExcludingVariantArtifactSet;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class VariantResolvingArtifactSet
implements ArtifactSet {
    private final ComponentGraphResolveState component;
    private final VariantGraphResolveState variant;
    private final ImmutableAttributes overriddenAttributes;
    private final List<IvyArtifactName> requestedArtifacts;
    private final ExcludeSpec exclusions;
    private final Set<CapabilitySelector> capabilitySelectors;

    public VariantResolvingArtifactSet(ComponentGraphResolveState component, VariantGraphResolveState variant, ImmutableAttributes overriddenAttributes, List<IvyArtifactName> requestedArtifacts, ExcludeSpec exclusions, Set<CapabilitySelector> capabilitySelectors) {
        this.component = component;
        this.variant = variant;
        this.overriddenAttributes = overriddenAttributes;
        this.requestedArtifacts = requestedArtifacts;
        this.exclusions = exclusions;
        this.capabilitySelectors = capabilitySelectors;
    }

    @Override
    public ResolvedArtifactSet select(ArtifactSelectionServices consumerServices, ArtifactSelectionSpec spec) {
        ImmutableList<ResolvedVariant> variants;
        ComponentIdentifier componentId = this.component.getId();
        if (!spec.getComponentFilter().isSatisfiedBy((Object)componentId)) {
            return ResolvedArtifactSet.EMPTY;
        }
        if (spec.getSelectFromAllVariants() && !this.requestedArtifacts.isEmpty()) {
            return ResolvedArtifactSet.EMPTY;
        }
        try {
            variants = !spec.getSelectFromAllVariants() ? this.getOwnArtifacts(consumerServices) : this.getArtifactVariantsForReselection(spec.getRequestAttributes(), consumerServices);
        }
        catch (Exception e) {
            return new BrokenResolvedArtifactSet(e);
        }
        if (variants.isEmpty() && spec.getAllowNoMatchingVariants()) {
            return ResolvedArtifactSet.EMPTY;
        }
        ArtifactVariantSelector artifactVariantSelector = consumerServices.getArtifactVariantSelector();
        ResolvedVariantTransformer resolvedVariantTransformer = consumerServices.getResolvedVariantTransformer();
        ImmutableAttributesSchema producerSchema = this.component.getMetadata().getAttributesSchema();
        DefaultResolvedVariantSet variantSet = new DefaultResolvedVariantSet(componentId, producerSchema, this.overriddenAttributes, variants, resolvedVariantTransformer);
        return artifactVariantSelector.select(variantSet, spec.getRequestAttributes(), spec.getAllowNoMatchingVariants());
    }

    public ImmutableList<ResolvedVariant> getOwnArtifacts(ArtifactSelectionServices artifactSelectionServices) {
        VariantArtifactResolver variantArtifactResolver = artifactSelectionServices.getVariantArtifactResolver();
        if (this.requestedArtifacts.isEmpty()) {
            return this.getArtifactsForGraphVariant(this.variant, variantArtifactResolver);
        }
        ComponentArtifactResolveMetadata componentArtifactMetadata = this.component.prepareForArtifactResolution().getArtifactMetadata();
        VariantArtifactResolveState artifactState = this.variant.prepareForArtifactResolution();
        ImmutableList<ComponentArtifactMetadata> adhocArtifacts = artifactState.getAdhocArtifacts(this.requestedArtifacts);
        return ImmutableList.of((Object)variantArtifactResolver.resolveAdhocVariant(componentArtifactMetadata, adhocArtifacts));
    }

    private ImmutableList<ResolvedVariant> getArtifactVariantsForReselection(ImmutableAttributes requestAttributes, ArtifactSelectionServices artifactSelectionServices) {
        VariantGraphResolveState graphVariant = artifactSelectionServices.getGraphVariantSelector().selectByAttributeMatchingLenient(requestAttributes, this.capabilitySelectors, this.component, artifactSelectionServices.getConsumerSchema(), Collections.emptyList());
        if (graphVariant == null) {
            return ImmutableList.of();
        }
        return this.getArtifactsForGraphVariant(graphVariant, artifactSelectionServices.getVariantArtifactResolver());
    }

    private ImmutableList<ResolvedVariant> getArtifactsForGraphVariant(VariantGraphResolveState graphVariant, VariantArtifactResolver variantArtifactResolver) {
        ComponentArtifactResolveMetadata componentArtifacts = this.component.prepareForArtifactResolution().getArtifactMetadata();
        ImmutableList<ResolvedVariant> variantArtifactSets = VariantResolvingArtifactSet.resolveVariantArtifactSets(graphVariant, componentArtifacts, variantArtifactResolver);
        if (!this.exclusions.mayExcludeArtifacts()) {
            return variantArtifactSets;
        }
        ImmutableList.Builder excluded = ImmutableList.builderWithExpectedSize((int)variantArtifactSets.size());
        ModuleIdentifier moduleId = componentArtifacts.getModuleVersionId().getModule();
        for (ResolvedVariant artifactSet : variantArtifactSets) {
            excluded.add((Object)new ExcludingVariantArtifactSet(artifactSet, moduleId, this.exclusions));
        }
        return excluded.build();
    }

    private static ImmutableList<ResolvedVariant> resolveVariantArtifactSets(VariantGraphResolveState variant, ComponentArtifactResolveMetadata component, VariantArtifactResolver variantArtifactResolver) {
        Set<? extends VariantResolveMetadata> unresolved = variant.prepareForArtifactResolution().getArtifactVariants();
        ImmutableList.Builder resolved = ImmutableList.builderWithExpectedSize((int)unresolved.size());
        for (VariantResolveMetadata variantResolveMetadata : unresolved) {
            ResolvedVariant resolvedArtifactSet = variantArtifactResolver.resolveVariantArtifactSet(component, variantResolveMetadata);
            resolved.add((Object)resolvedArtifactSet);
        }
        return resolved.build();
    }
}

