/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ivyservice.DefaultUnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphPathResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.internal.resolve.ModuleVersionResolveException;

public class ResolutionFailureCollector
implements DependencyGraphVisitor {
    private final Map<ComponentSelector, BrokenDependency> failuresByRevisionId = new LinkedHashMap<ComponentSelector, BrokenDependency>();
    private final ComponentSelectorConverter componentSelectorConverter;
    private RootGraphNode root;

    public ResolutionFailureCollector(ComponentSelectorConverter componentSelectorConverter) {
        this.componentSelectorConverter = componentSelectorConverter;
    }

    @Override
    public void start(RootGraphNode root) {
        this.root = root;
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        for (DependencyGraphEdge dependencyGraphEdge : node.getOutgoingEdges()) {
            ModuleVersionResolveException failure = dependencyGraphEdge.getFailure();
            if (failure == null) continue;
            this.addUnresolvedDependency(dependencyGraphEdge, dependencyGraphEdge.getRequested(), failure);
        }
    }

    public Set<UnresolvedDependency> complete(Set<UnresolvedDependency> extraFailures) {
        if (extraFailures.isEmpty() && this.failuresByRevisionId.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(extraFailures);
        for (Map.Entry<ComponentSelector, BrokenDependency> entry : this.failuresByRevisionId.entrySet()) {
            Collection<List<ComponentIdentifier>> paths = DependencyGraphPathResolver.calculatePaths(entry.getValue().requiredBy, this.root);
            ComponentSelector key = entry.getKey();
            ModuleVersionSelector moduleVersionSelector = this.componentSelectorConverter.getSelector(key);
            builder.add((Object)new DefaultUnresolvedDependency(moduleVersionSelector, (Throwable)((Object)entry.getValue().failure.withIncomingPaths(paths))));
        }
        return builder.build();
    }

    private void addUnresolvedDependency(DependencyGraphEdge dependency, ComponentSelector selector, ModuleVersionResolveException failure) {
        BrokenDependency breakage = this.failuresByRevisionId.get(selector);
        if (breakage == null) {
            breakage = new BrokenDependency(failure);
            this.failuresByRevisionId.put(selector, breakage);
        }
        breakage.requiredBy.add(dependency.getFrom());
    }

    private static class BrokenDependency {
        final ModuleVersionResolveException failure;
        final List<DependencyGraphNode> requiredBy = new ArrayList<DependencyGraphNode>();

        private BrokenDependency(ModuleVersionResolveException failure) {
            this.failure = failure;
        }
    }
}

