/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependenciesMetadata;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.repositories.resolver.AbstractDependencyImpl;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public abstract class AbstractDependenciesMetadataAdapter<T extends DependencyMetadata<T>, E extends T>
extends ArrayList<T>
implements DependenciesMetadata<T> {
    private final Instantiator instantiator;
    private final NotationParser<Object, T> dependencyNotationParser;
    private final AttributesFactory attributesFactory;

    public AbstractDependenciesMetadataAdapter(AttributesFactory attributesFactory, Instantiator instantiator, NotationParser<Object, T> dependencyNotationParser) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
    }

    protected abstract Class<E> adapterImplementationType();

    protected abstract ModuleDependencyMetadata getAdapterMetadata(E var1);

    protected abstract boolean isConstraint();

    protected abstract boolean isEndorsingStrictVersions(T var1);

    public void add(String dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    public void add(Map<String, String> dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    public void add(String dependencyNotation, Action<? super T> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    public void add(Map<String, String> dependencyNotation, Action<? super T> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    private void doAdd(Object dependencyNotation, @Nullable Action<? super T> configureAction) {
        DependencyMetadata dependencyMetadata = (DependencyMetadata)this.dependencyNotationParser.parseNotation(dependencyNotation);
        if (dependencyMetadata instanceof AbstractDependencyImpl) {
            ((AbstractDependencyImpl)dependencyMetadata).setAttributes((AttributeContainer)this.attributesFactory.mutable());
        }
        E adapted = this.adapt(dependencyMetadata);
        if (configureAction != null) {
            configureAction.execute(adapted);
        }
        this.add(adapted);
    }

    public ImmutableList<ModuleDependencyMetadata> getMetadatas() {
        return (ImmutableList)this.stream().map(this::maybeAdapt).map(this::getAdapterMetadata).collect(ImmutableList.toImmutableList());
    }

    private E maybeAdapt(T details) {
        if (this.adapterImplementationType().isInstance(details)) {
            return (E)((DependencyMetadata)this.adapterImplementationType().cast(details));
        }
        return this.adapt(details);
    }

    private E adapt(T details) {
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(details.getModule(), DefaultImmutableVersionConstraint.of(details.getVersionConstraint()), details.getAttributes(), (Set<CapabilitySelector>)ImmutableSet.of());
        GradleDependencyMetadata dependencyMetadata = new GradleDependencyMetadata(selector, Collections.emptyList(), this.isConstraint(), this.isEndorsingStrictVersions(details), details.getReason(), false, null);
        return (E)((DependencyMetadata)this.instantiator.newInstance(this.adapterImplementationType(), new Object[]{this.attributesFactory, dependencyMetadata}));
    }
}

