/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;

public class DefaultAttributesSchema
implements AttributesSchemaInternal {
    private final InstantiatorFactory instantiatorFactory;
    private final IsolatableFactory isolatableFactory;
    private final Map<Attribute<?>, DefaultAttributeMatchingStrategy<?>> strategies = new HashMap();
    private final Set<Attribute<?>> precedence = new LinkedHashSet();

    @Inject
    public DefaultAttributesSchema(InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory) {
        this.instantiatorFactory = instantiatorFactory;
        this.isolatableFactory = isolatableFactory;
    }

    public <T> AttributeMatchingStrategy<T> getMatchingStrategy(Attribute<T> attribute) {
        DefaultAttributeMatchingStrategy<?> strategy = this.strategies.get(attribute);
        if (strategy == null) {
            throw new IllegalArgumentException("Unable to find matching strategy for " + attribute);
        }
        return strategy;
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute) {
        return this.attribute(attribute, null);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute, @Nullable Action<? super AttributeMatchingStrategy<T>> configureAction) {
        AttributeMatchingStrategy<T> strategy = this.getStrategy(attribute);
        if (configureAction != null) {
            configureAction.execute(strategy);
        }
        return strategy;
    }

    private <T> AttributeMatchingStrategy<T> getStrategy(Attribute<T> attribute) {
        DefaultAttributeMatchingStrategy strategy = this.strategies.get(attribute);
        if (strategy == null) {
            strategy = (DefaultAttributeMatchingStrategy)this.instantiatorFactory.decorateLenient().newInstance(DefaultAttributeMatchingStrategy.class, new Object[]{this.instantiatorFactory, this.isolatableFactory});
            this.strategies.put(attribute, strategy);
        }
        return strategy;
    }

    public Set<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    public boolean hasAttribute(Attribute<?> key) {
        return this.strategies.containsKey(key);
    }

    public void attributeDisambiguationPrecedence(Attribute<?> ... attributes) {
        for (Attribute<?> attribute : attributes) {
            if (this.precedence.add(attribute)) continue;
            throw new IllegalArgumentException(String.format("Attribute '%s' precedence has already been set.", attribute.getName()));
        }
    }

    public void setAttributeDisambiguationPrecedence(List<Attribute<?>> attributes) {
        this.precedence.clear();
        this.attributeDisambiguationPrecedence(attributes.toArray(new Attribute[0]));
    }

    public List<Attribute<?>> getAttributeDisambiguationPrecedence() {
        return Collections.unmodifiableList(new ArrayList(this.precedence));
    }

    @Override
    public Map<Attribute<?>, DefaultAttributeMatchingStrategy<?>> getStrategies() {
        return Collections.unmodifiableMap(this.strategies);
    }

    @Override
    public Set<Attribute<?>> getAttributePrecedence() {
        return Collections.unmodifiableSet(this.precedence);
    }
}

