/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.logging.progress.ProgressLoggingInputStream;
import org.gradle.internal.logging.progress.ResourceOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadBuildOperationType;
import org.gradle.internal.resource.ExternalResourceReadMetadataBuildOperationType;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;

public class ProgressLoggingExternalResourceAccessor
extends AbstractProgressLoggingHandler
implements ExternalResourceAccessor {
    private final ExternalResourceAccessor delegate;
    private final BuildOperationRunner buildOperationRunner;
    private static final ExternalResourceReadMetadataBuildOperationType.Result METADATA_RESULT = new ExternalResourceReadMetadataBuildOperationType.Result(){};

    public ProgressLoggingExternalResourceAccessor(ExternalResourceAccessor delegate, BuildOperationRunner buildOperationRunner) {
        this.delegate = delegate;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Nullable
    public <T> T withContent(ExternalResourceName location, boolean revalidate, ExternalResource.ContentAndMetadataAction<T> action) throws ResourceException {
        return (T)this.buildOperationRunner.call(new DownloadOperation<T>(location, revalidate, action));
    }

    @Nullable
    public ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) {
        return (ExternalResourceMetaData)this.buildOperationRunner.call((CallableBuildOperation)new MetadataOperation(location, revalidate));
    }

    private BuildOperationDescriptor.Builder createBuildOperationDetails(ExternalResourceName resourceName) {
        ReadOperationDetails operationDetails = new ReadOperationDetails(resourceName.getUri());
        return BuildOperationDescriptor.displayName((String)("Download " + resourceName.getUri())).progressDisplayName(resourceName.getShortDisplayName()).details((Object)operationDetails);
    }

    private class DownloadOperation<T>
    implements CallableBuildOperation<T> {
        private final ExternalResourceName location;
        private final boolean revalidate;
        private final ExternalResource.ContentAndMetadataAction<T> action;

        public DownloadOperation(ExternalResourceName location, boolean revalidate, ExternalResource.ContentAndMetadataAction<T> action) {
            this.location = location;
            this.revalidate = revalidate;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T call(BuildOperationContext context) {
            Object object;
            ResourceOperation downloadOperation = ProgressLoggingExternalResourceAccessor.this.createResourceOperation(context, ResourceOperation.Type.download);
            AtomicReference metadata = new AtomicReference();
            try {
                object = ProgressLoggingExternalResourceAccessor.this.delegate.withContent(this.location, this.revalidate, (inputStream, metaData) -> {
                    downloadOperation.setContentLength(metaData.getContentLength());
                    metadata.set(metaData);
                    if (metaData.wasMissing()) {
                        context.failed((Throwable)ResourceExceptions.getMissing((URI)metaData.getLocation()));
                        return null;
                    }
                    ProgressLoggingInputStream stream = new ProgressLoggingInputStream(inputStream, arg_0 -> ((ResourceOperation)downloadOperation).logProcessedBytes(arg_0));
                    return this.action.execute((InputStream)stream, metaData);
                });
            }
            catch (Throwable throwable) {
                ExternalResourceMetaData externalResourceMetaData = (ExternalResourceMetaData)metadata.get();
                context.setResult((Object)new ReadOperationResult(downloadOperation.getTotalProcessedBytes(), externalResourceMetaData != null && externalResourceMetaData.wasMissing()));
                throw throwable;
            }
            ExternalResourceMetaData externalResourceMetaData = (ExternalResourceMetaData)metadata.get();
            context.setResult((Object)new ReadOperationResult(downloadOperation.getTotalProcessedBytes(), externalResourceMetaData != null && externalResourceMetaData.wasMissing()));
            return (T)object;
        }

        public BuildOperationDescriptor.Builder description() {
            return ProgressLoggingExternalResourceAccessor.this.createBuildOperationDetails(this.location);
        }
    }

    private class MetadataOperation
    implements CallableBuildOperation<ExternalResourceMetaData> {
        private final ExternalResourceName location;
        private final boolean revalidate;

        public MetadataOperation(ExternalResourceName location, boolean revalidate) {
            this.location = location;
            this.revalidate = revalidate;
        }

        public ExternalResourceMetaData call(BuildOperationContext context) {
            try {
                ExternalResourceMetaData externalResourceMetaData = ProgressLoggingExternalResourceAccessor.this.delegate.getMetaData(this.location, this.revalidate);
                return externalResourceMetaData;
            }
            finally {
                context.setResult((Object)METADATA_RESULT);
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Metadata of " + this.location.getDisplayName())).details((Object)new MetadataOperationDetails(this.location.getUri()));
        }
    }

    private static class ReadOperationDetails
    extends AbstractProgressLoggingHandler.LocationDetails
    implements ExternalResourceReadBuildOperationType.Details {
        private ReadOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceReadBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class ReadOperationResult
    implements ExternalResourceReadBuildOperationType.Result {
        private final long bytesRead;
        private final boolean missing;

        private ReadOperationResult(long bytesRead, boolean missing) {
            this.bytesRead = bytesRead;
            this.missing = missing;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public boolean isMissing() {
            return this.missing;
        }

        public String toString() {
            return "ExternalResourceReadBuildOperationType.Result{bytesRead=" + this.bytesRead + ", missing=" + this.missing + '}';
        }
    }

    private static class MetadataOperationDetails
    extends AbstractProgressLoggingHandler.LocationDetails
    implements ExternalResourceReadMetadataBuildOperationType.Details {
        private MetadataOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceReadMetadataBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }
}

