/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.NonNullApi;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.internal.IdeaModuleSupport;
import org.gradle.plugins.ide.idea.internal.IdeaProjectInternal;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IdeaModelBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IdeaModelParameter;
import org.gradle.plugins.ide.internal.tooling.IdeaModuleBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaJavaLanguageSettings;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaLanguageLevel;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModule;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaProject;
import org.gradle.plugins.ide.internal.tooling.idea.IsolatedIdeaModuleInternal;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.internal.IntermediateToolingModelProvider;

@NonNullApi
public class IsolatedProjectsSafeIdeaModelBuilder
implements IdeaModelBuilderInternal,
ParameterizedToolingModelBuilder<IdeaModelParameter> {
    private static final String MODEL_NAME = IdeaProject.class.getName();
    private final IntermediateToolingModelProvider intermediateToolingModelProvider;
    private final GradleProjectBuilderInternal gradleProjectBuilder;

    public IsolatedProjectsSafeIdeaModelBuilder(IntermediateToolingModelProvider intermediateToolingModelProvider, GradleProjectBuilderInternal gradleProjectBuilder) {
        this.intermediateToolingModelProvider = intermediateToolingModelProvider;
        this.gradleProjectBuilder = gradleProjectBuilder;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(MODEL_NAME);
    }

    public Class<IdeaModelParameter> getParameterType() {
        return IdeaModelParameter.class;
    }

    public Object buildAll(String modelName, IdeaModelParameter parameter, Project project) {
        return this.buildForRoot(project, parameter.getOfflineDependencyResolution());
    }

    public DefaultIdeaProject buildAll(String modelName, Project project) {
        return this.buildForRoot(project, false);
    }

    @Override
    public DefaultIdeaProject buildForRoot(Project project, boolean offlineDependencyResolution) {
        IsolatedProjectsSafeIdeaModelBuilder.requireRootProject(project);
        this.applyIdeaPluginToBuildTree(project);
        IdeaModelParameter parameter = IsolatedProjectsSafeIdeaModelBuilder.createParameter(offlineDependencyResolution);
        return this.build(project, parameter);
    }

    private static void requireRootProject(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new IllegalArgumentException(String.format("%s can only be requested on the root project, got %s", MODEL_NAME, project));
        }
    }

    private void applyIdeaPluginToBuildTree(Project root) {
        this.applyIdeaPluginToBuildTree((ProjectInternal)root, new ArrayList<GradleInternal>());
    }

    private void applyIdeaPluginToBuildTree(ProjectInternal root, List<GradleInternal> alreadyProcessed) {
        this.intermediateToolingModelProvider.applyPlugin((Project)root, new ArrayList(root.getAllprojects()), IdeaPlugin.class);
        for (IncludedBuildInternal reference : root.getGradle().includedBuilds()) {
            GradleInternal build;
            BuildState target = reference.getTarget();
            if (!(target instanceof IncludedBuildState) || alreadyProcessed.contains(build = target.getMutableModel())) continue;
            alreadyProcessed.add(build);
            this.applyIdeaPluginToBuildTree(build.getRootProject(), alreadyProcessed);
        }
    }

    private DefaultIdeaProject build(Project rootProject, IdeaModelParameter parameter) {
        rootProject.getPluginManager().apply(IdeaPlugin.class);
        IdeaModel ideaModelExt = ((IdeaPlugin)rootProject.getPlugins().getPlugin(IdeaPlugin.class)).getModel();
        IdeaProjectInternal ideaProjectExt = (IdeaProjectInternal)ideaModelExt.getProject();
        ArrayList<Project> allProjects = new ArrayList<Project>(rootProject.getAllprojects());
        List<IsolatedIdeaModuleInternal> allIsolatedIdeaModules = this.getIsolatedIdeaModules(rootProject, allProjects, parameter);
        IdeaLanguageLevel languageLevel = IsolatedProjectsSafeIdeaModelBuilder.resolveRootLanguageLevel(ideaProjectExt, allIsolatedIdeaModules);
        JavaVersion targetBytecodeVersion = IsolatedProjectsSafeIdeaModelBuilder.resolveRootTargetBytecodeVersion(ideaProjectExt, allIsolatedIdeaModules);
        DefaultIdeaProject out = IsolatedProjectsSafeIdeaModelBuilder.buildWithoutChildren(ideaProjectExt, languageLevel, targetBytecodeVersion);
        DefaultGradleProject rootGradleProject = this.gradleProjectBuilder.buildForRoot(rootProject);
        IdeaModuleBuilder ideaModuleBuilder = new IdeaModuleBuilder(rootGradleProject, languageLevel, targetBytecodeVersion);
        out.setChildren(IsolatedProjectsSafeIdeaModelBuilder.createIdeaModules(out, ideaModuleBuilder, allProjects, allIsolatedIdeaModules));
        return out;
    }

    private static DefaultIdeaProject buildWithoutChildren(IdeaProjectInternal ideaProjectExt, IdeaLanguageLevel languageLevel, JavaVersion targetBytecodeVersion) {
        return new DefaultIdeaProject().setName(ideaProjectExt.getName()).setJdkName(ideaProjectExt.getJdkName()).setLanguageLevel((org.gradle.tooling.model.idea.IdeaLanguageLevel)new DefaultIdeaLanguageLevel(languageLevel.getLevel())).setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(IdeaModuleBuilderSupport.convertToJavaVersion(languageLevel)).setTargetBytecodeVersion(targetBytecodeVersion).setJdk(DefaultInstalledJdk.current()));
    }

    private static IdeaLanguageLevel resolveRootLanguageLevel(IdeaProjectInternal ideaProjectExt, List<IsolatedIdeaModuleInternal> isolatedModules) {
        IdeaLanguageLevel explicitLanguageLevel = ideaProjectExt.getRawLanguageLevel();
        if (explicitLanguageLevel != null) {
            return explicitLanguageLevel;
        }
        JavaVersion maxCompatibility = IsolatedProjectsSafeIdeaModelBuilder.getMaxCompatibility(isolatedModules, IsolatedIdeaModuleInternal::getJavaSourceCompatibility);
        return new IdeaLanguageLevel((Object)maxCompatibility);
    }

    private static JavaVersion resolveRootTargetBytecodeVersion(IdeaProjectInternal ideaProjectExt, List<IsolatedIdeaModuleInternal> isolatedModules) {
        JavaVersion explicitTargetBytecodeVersion = ideaProjectExt.getRawTargetBytecodeVersion();
        if (explicitTargetBytecodeVersion != null) {
            return explicitTargetBytecodeVersion;
        }
        return IsolatedProjectsSafeIdeaModelBuilder.getMaxCompatibility(isolatedModules, IsolatedIdeaModuleInternal::getJavaTargetCompatibility);
    }

    private List<IsolatedIdeaModuleInternal> getIsolatedIdeaModules(Project rootProject, List<Project> allProjects, IdeaModelParameter parameter) {
        return this.intermediateToolingModelProvider.getModels(rootProject, allProjects, IsolatedIdeaModuleInternal.class, (Object)parameter);
    }

    private static List<DefaultIdeaModule> createIdeaModules(DefaultIdeaProject parent, IdeaModuleBuilder ideaModuleBuilder, List<Project> projects, List<IsolatedIdeaModuleInternal> isolatedIdeaModules) {
        return Streams.zip(projects.stream(), isolatedIdeaModules.stream(), (x$0, x$1) -> ideaModuleBuilder.buildWithoutParent(x$0, x$1)).map(it -> it.setParent(parent)).collect(Collectors.toList());
    }

    private static JavaVersion getMaxCompatibility(List<IsolatedIdeaModuleInternal> isolatedIdeaModules, Function<IsolatedIdeaModuleInternal, JavaVersion> getCompatibilty) {
        return isolatedIdeaModules.stream().map(getCompatibilty).filter(Objects::nonNull).max(Enum::compareTo).orElse(IdeaModuleSupport.FALLBACK_MODULE_JAVA_COMPATIBILITY_VERSION);
    }

    private static IdeaModelParameter createParameter(boolean offlineDependencyResolution) {
        return () -> offlineDependencyResolution;
    }

    @NonNullApi
    private static class IdeaModuleBuilder {
        private final DefaultGradleProject rootGradleProject;
        private final IdeaLanguageLevel ideaProjectLanguageLevel;
        private final JavaVersion ideaProjectTargetBytecodeVersion;

        private IdeaModuleBuilder(DefaultGradleProject rootGradleProject, IdeaLanguageLevel ideaProjectLanguageLevel, JavaVersion ideaProjectTargetBytecodeVersion) {
            this.rootGradleProject = rootGradleProject;
            this.ideaProjectLanguageLevel = ideaProjectLanguageLevel;
            this.ideaProjectTargetBytecodeVersion = ideaProjectTargetBytecodeVersion;
        }

        private DefaultIdeaModule buildWithoutParent(Project project, IsolatedIdeaModuleInternal isolatedIdeaModule) {
            boolean javaExtensionAvailableOnModule;
            DefaultIdeaModule model = new DefaultIdeaModule().setName(isolatedIdeaModule.getName()).setGradleProject(this.rootGradleProject.findByPath(project.getPath())).setContentRoots(Collections.singletonList(isolatedIdeaModule.getContentRoot())).setJdkName(isolatedIdeaModule.getJdkName()).setCompilerOutput((IdeaCompilerOutput)isolatedIdeaModule.getCompilerOutput());
            boolean bl = javaExtensionAvailableOnModule = isolatedIdeaModule.getJavaSourceCompatibility() != null || isolatedIdeaModule.getJavaTargetCompatibility() != null;
            if (javaExtensionAvailableOnModule) {
                IdeaLanguageLevel languageLevel = IdeaModuleBuilder.resolveLanguageLevel(isolatedIdeaModule);
                IdeaLanguageLevel moduleLanguageLevelOverride = IdeaModuleBuilder.takeIfDifferent(this.ideaProjectLanguageLevel, languageLevel);
                JavaVersion targetBytecodeVersion = IdeaModuleBuilder.resolveTargetBytecodeVersion(isolatedIdeaModule);
                JavaVersion moduleTargetBytecodeVersionOverride = IdeaModuleBuilder.takeIfDifferent(this.ideaProjectTargetBytecodeVersion, targetBytecodeVersion);
                model.setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(IdeaModuleBuilderSupport.convertToJavaVersion(moduleLanguageLevelOverride)).setTargetBytecodeVersion(moduleTargetBytecodeVersionOverride));
            }
            model.setDependencies(isolatedIdeaModule.getDependencies());
            return model;
        }

        @Nullable
        private static JavaVersion resolveTargetBytecodeVersion(IsolatedIdeaModuleInternal isolatedIdeaModule) {
            JavaVersion targetBytecodeVersionConvention = isolatedIdeaModule.getJavaTargetCompatibility();
            JavaVersion explicitTargetBytecodeVersion = isolatedIdeaModule.getExplicitTargetBytecodeVersion();
            return IdeaModuleBuilder.getPropertyValue(explicitTargetBytecodeVersion, targetBytecodeVersionConvention);
        }

        private static IdeaLanguageLevel resolveLanguageLevel(IsolatedIdeaModuleInternal isolatedIdeaModule) {
            JavaVersion languageLevelConvention = isolatedIdeaModule.getJavaSourceCompatibility();
            IdeaLanguageLevel explicitLanguageLevel = isolatedIdeaModule.getExplicitSourceLanguageLevel();
            return IdeaModuleBuilder.getPropertyValue(explicitLanguageLevel, new IdeaLanguageLevel((Object)languageLevelConvention));
        }

        @Nullable
        private static <T> T takeIfDifferent(T commonValue, @Nullable T value) {
            return commonValue.equals(value) ? null : (T)value;
        }

        @Nullable
        private static <T> T getPropertyValue(@Nullable T value, @Nullable T convention) {
            return value != null ? value : convention;
        }
    }
}

