/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.internal.Actions;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.buildprocess.BuildProcessState;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.daemon.client.execution.ClientBuildRequestContext;
import org.gradle.internal.instrumentation.agent.AgentInitializer;
import org.gradle.internal.instrumentation.agent.AgentStatus;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.cli.CommandLineActionCreator;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.ReportDaemonStatusAction;
import org.gradle.launcher.cli.RunBuildAction;
import org.gradle.launcher.cli.StopDaemonAction;
import org.gradle.launcher.daemon.bootstrap.ForegroundDaemonAction;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonClientGlobalServices;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.client.ReportDaemonStatusClient;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.configuration.ForegroundDaemonConfiguration;
import org.gradle.launcher.daemon.context.DaemonCompatibilitySpec;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.context.DefaultDaemonContext;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecutor;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.process.internal.CurrentProcess;
import org.gradle.tooling.internal.provider.ForwardStdInToThisProcess;
import org.gradle.tooling.internal.provider.RunInProcess;

class BuildActionsFactory
implements CommandLineActionCreator {
    private final ServiceRegistry loggingServices;
    private final FileCollectionFactory fileCollectionFactory;
    private final ServiceRegistry basicServices;

    public BuildActionsFactory(ServiceRegistry loggingServices, ServiceRegistry basicServices) {
        this.basicServices = basicServices;
        this.loggingServices = loggingServices;
        this.fileCollectionFactory = (FileCollectionFactory)basicServices.get(FileCollectionFactory.class);
    }

    @Override
    public void configureCommandLineParser(CommandLineParser parser) {
    }

    @Override
    public Action<? super ExecutionListener> createAction(CommandLineParser parser, ParsedCommandLine commandLine, Parameters parameters) {
        StartParameterInternal startParameter = parameters.getStartParameter();
        DaemonParameters daemonParameters = parameters.getDaemonParameters();
        if (daemonParameters.isStop()) {
            return Actions.toAction((Runnable)this.stopAllDaemons(daemonParameters));
        }
        if (daemonParameters.isStatus()) {
            return Actions.toAction((Runnable)this.showDaemonStatus(daemonParameters));
        }
        if (daemonParameters.isForeground()) {
            ForegroundDaemonConfiguration conf = new ForegroundDaemonConfiguration(UUID.randomUUID().toString(), daemonParameters.getBaseDir(), daemonParameters.getIdleTimeout(), daemonParameters.getPeriodicCheckInterval(), this.fileCollectionFactory, daemonParameters.shouldApplyInstrumentationAgent(), daemonParameters.getNativeServicesMode());
            return Actions.toAction((Runnable)new ForegroundDaemonAction(this.loggingServices, (DaemonServerConfiguration)conf));
        }
        DaemonRequestContext requestContext = daemonParameters.toRequestContext();
        if (daemonParameters.isEnabled()) {
            return Actions.toAction((Runnable)this.runBuildWithDaemon(startParameter, daemonParameters, requestContext));
        }
        if (this.canUseCurrentProcess(daemonParameters, requestContext)) {
            return Actions.toAction((Runnable)this.runBuildInProcess(startParameter, daemonParameters));
        }
        return Actions.toAction((Runnable)this.runBuildInSingleUseDaemon(startParameter, daemonParameters, requestContext));
    }

    private Runnable stopAllDaemons(DaemonParameters daemonParameters) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices();
        ServiceRegistry clientServices = ((DaemonClientFactory)clientSharedServices.get(DaemonClientFactory.class)).createMessageDaemonServices((ServiceLookup)this.loggingServices, daemonParameters.getBaseDir());
        DaemonStopClient stopClient = (DaemonStopClient)clientServices.get(DaemonStopClient.class);
        return new StopDaemonAction(stopClient);
    }

    private Runnable showDaemonStatus(DaemonParameters daemonParameters) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices();
        ServiceRegistry clientServices = ((DaemonClientFactory)clientSharedServices.get(DaemonClientFactory.class)).createMessageDaemonServices((ServiceLookup)this.loggingServices, daemonParameters.getBaseDir());
        ReportDaemonStatusClient statusClient = (ReportDaemonStatusClient)clientServices.get(ReportDaemonStatusClient.class);
        return new ReportDaemonStatusAction(statusClient);
    }

    private Runnable runBuildWithDaemon(StartParameterInternal startParameter, DaemonParameters daemonParameters, DaemonRequestContext requestContext) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices();
        ServiceRegistry clientServices = ((DaemonClientFactory)clientSharedServices.get(DaemonClientFactory.class)).createBuildClientServices((ServiceLookup)this.loggingServices, daemonParameters, requestContext, System.in, Optional.empty());
        DaemonClient client = (DaemonClient)clientServices.get(DaemonClient.class);
        return this.runBuildAndCloseServices(startParameter, daemonParameters, (BuildActionExecutor<BuildActionParameters, ClientBuildRequestContext>)client, clientSharedServices, clientServices);
    }

    protected boolean canUseCurrentProcess(DaemonParameters daemonParameters, DaemonRequestContext requestContext) {
        CurrentProcess currentProcess = new CurrentProcess(this.fileCollectionFactory);
        DaemonContext contextForCurrentProcess = BuildActionsFactory.buildDaemonContextForCurrentProcess(requestContext, currentProcess);
        DaemonCompatibilitySpec comparison = new DaemonCompatibilitySpec(requestContext);
        if (!currentProcess.isLowMemoryProcess()) {
            return comparison.isSatisfiedBy(contextForCurrentProcess);
        }
        return false;
    }

    @VisibleForTesting
    static DaemonContext buildDaemonContextForCurrentProcess(DaemonRequestContext requestContext, CurrentProcess currentProcess) {
        return new DefaultDaemonContext(UUID.randomUUID().toString(), currentProcess.getJvm().getJavaHome(), JavaLanguageVersion.current(), Jvm.current().getVendor(), null, Long.valueOf(0L), Integer.valueOf(0), (Collection)currentProcess.getJvmOptions().getAllImmutableJvmArgs(), AgentStatus.allowed().isAgentInstrumentationEnabled(), requestContext.getNativeServicesMode(), requestContext.getPriority());
    }

    private Runnable runBuildInProcess(StartParameterInternal startParameter, DaemonParameters daemonParameters) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)daemonParameters.getEffectiveSystemProperties());
        System.setProperties(properties);
        BuildProcessState buildProcessState = new BuildProcessState(startParameter.isContinuous(), AgentStatus.of((boolean)daemonParameters.shouldApplyInstrumentationAgent()), ClassPath.EMPTY, new ServiceRegistry[]{this.loggingServices, NativeServices.getInstance()});
        ServiceRegistry globalServices = buildProcessState.getServices();
        ((AgentInitializer)globalServices.get(AgentInitializer.class)).maybeConfigureInstrumentationAgent();
        RunInProcess executor = new RunInProcess((BuildActionExecutor)new ForwardStdInToThisProcess((GlobalUserInputReceiver)globalServices.get(GlobalUserInputReceiver.class), (UserInputReader)globalServices.get(UserInputReader.class), System.in, (BuildActionExecutor)globalServices.get(BuildExecutor.class)));
        return this.runBuildAndCloseServices(startParameter, daemonParameters, (BuildActionExecutor<BuildActionParameters, ClientBuildRequestContext>)executor, buildProcessState.getServices(), buildProcessState);
    }

    private Runnable runBuildInSingleUseDaemon(StartParameterInternal startParameter, DaemonParameters daemonParameters, DaemonRequestContext requestContext) {
        int maxTimeout = 120000;
        if (daemonParameters.getIdleTimeout() > maxTimeout) {
            daemonParameters.setIdleTimeout(maxTimeout);
        }
        ServiceRegistry clientSharedServices = this.createGlobalClientServices();
        ServiceRegistry clientServices = ((DaemonClientFactory)clientSharedServices.get(DaemonClientFactory.class)).createSingleUseDaemonClientServices((ServiceLookup)clientSharedServices, daemonParameters, requestContext, System.in);
        DaemonClient client = (DaemonClient)clientServices.get(DaemonClient.class);
        return this.runBuildAndCloseServices(startParameter, daemonParameters, (BuildActionExecutor<BuildActionParameters, ClientBuildRequestContext>)client, clientSharedServices, clientServices);
    }

    private ServiceRegistry createGlobalClientServices() {
        ServiceRegistryBuilder builder = ServiceRegistryBuilder.builder().displayName("Daemon client global services").parent(NativeServices.getInstance());
        builder.parent(this.basicServices);
        return builder.provider((ServiceRegistrationProvider)new DaemonClientGlobalServices()).build();
    }

    private Runnable runBuildAndCloseServices(StartParameterInternal startParameter, DaemonParameters daemonParameters, BuildActionExecutor<BuildActionParameters, ClientBuildRequestContext> executor, ServiceRegistry sharedServices, Object ... stopBeforeSharedServices) {
        BuildActionParameters parameters = this.createBuildActionParameters((StartParameter)startParameter, daemonParameters);
        CompositeStoppable stoppable = new CompositeStoppable().add(stopBeforeSharedServices).add((Object)sharedServices);
        return new RunBuildAction(executor, startParameter, this.clientMetaData(), this.getBuildStartTime(), parameters, sharedServices, (Stoppable)stoppable);
    }

    private BuildActionParameters createBuildActionParameters(StartParameter startParameter, DaemonParameters daemonParameters) {
        return new DefaultBuildActionParameters(daemonParameters.getEffectiveSystemProperties(), daemonParameters.getEnvironmentVariables(), SystemProperties.getInstance().getCurrentDir(), startParameter.getLogLevel(), daemonParameters.isEnabled(), ClassPath.EMPTY);
    }

    private long getBuildStartTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }
}

