/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class NumberUtil {
    public static final int BASE_LOG2 = 10;
    public static final int KIB_BASE = 1024;
    private static final int FRACTIONAL_DIGIT_COUNT = 1;
    private static final MathContext MC = new MathContext(String.valueOf(1024).length() + 1, RoundingMode.FLOOR);
    private static final List<String> UNITS = Collections.unmodifiableList(Arrays.asList(" B", " KiB", " MiB", " GiB", " TiB", " PiB", " EiB"));
    private static final List<String> ORDINAL_SUFFIXES = Collections.unmodifiableList(Arrays.asList("th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"));

    public static int percentOf(long fraction, long total) {
        if (total < 0L || fraction < 0L) {
            throw new IllegalArgumentException("Unable to calculate percentage: " + fraction + " of " + total + ". All inputs must be >= 0");
        }
        if (total == 0L) {
            return 0;
        }
        float out = (float)fraction * 100.0f / (float)total;
        return (int)out;
    }

    public static String formatBytes(@Nullable Long bytes) {
        if (bytes == null) {
            return "unknown size";
        }
        if (bytes < 0L) {
            return "-" + NumberUtil.formatBytes(-bytes.longValue());
        }
        int baseExponent = (63 - Long.numberOfLeadingZeros(bytes)) / 10;
        BigDecimal roundedBase = BigDecimal.valueOf(1L << baseExponent * 10);
        BigDecimal result = BigDecimal.valueOf(bytes).divide(roundedBase, MC).setScale(1, RoundingMode.FLOOR).stripTrailingZeros();
        return result.toPlainString() + UNITS.get(baseExponent);
    }

    public static String ordinal(int value) {
        switch (value % 100) {
            case 11: 
            case 12: 
            case 13: {
                return value + ORDINAL_SUFFIXES.get(0);
            }
        }
        return value + ORDINAL_SUFFIXES.get(value % 10);
    }
}

