/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import com.google.common.annotations.VisibleForTesting;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.memory.Memory;
import net.rubygrapefruit.platform.memory.MemoryInfo;
import net.rubygrapefruit.platform.memory.WindowsMemoryInfo;
import org.gradle.api.NonNullApi;
import org.gradle.internal.nativeintegration.NativeIntegrationException;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusSnapshot;

@NonNullApi
public class WindowsOsMemoryInfo
implements OsMemoryInfo {
    @Override
    public OsMemoryStatus getOsSnapshot() {
        try {
            Memory memory = (Memory)NativeServices.getInstance().get(Memory.class);
            return WindowsOsMemoryInfo.snapshotFromMemoryInfo(memory.getMemoryInfo());
        }
        catch (NativeException ex) {
            throw new UnsupportedOperationException("Unable to get system memory", ex);
        }
        catch (NativeIntegrationException ex) {
            throw new UnsupportedOperationException("Unable to get system memory", ex);
        }
    }

    @VisibleForTesting
    static OsMemoryStatus snapshotFromMemoryInfo(MemoryInfo memoryInfo) {
        if (memoryInfo instanceof WindowsMemoryInfo) {
            WindowsMemoryInfo windowsMemoryInfo = (WindowsMemoryInfo)memoryInfo;
            return new OsMemoryStatusSnapshot(memoryInfo.getTotalPhysicalMemory(), memoryInfo.getAvailablePhysicalMemory(), windowsMemoryInfo.getCommitLimit(), WindowsOsMemoryInfo.availableCommitMemory(windowsMemoryInfo));
        }
        return new OsMemoryStatusSnapshot(memoryInfo.getTotalPhysicalMemory(), memoryInfo.getAvailablePhysicalMemory());
    }

    private static long availableCommitMemory(WindowsMemoryInfo windowsMemoryInfo) {
        return windowsMemoryInfo.getCommitLimit() - windowsMemoryInfo.getCommitTotal();
    }
}

