/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.plugins.ide.internal.tooling.model.BasicGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleBuild;
import org.gradle.plugins.ide.internal.tooling.model.PartialBasicGradleProject;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.internal.BuildScopeModelBuilder;

public class GradleBuildBuilder
implements BuildScopeModelBuilder {
    private final BuildStateRegistry buildStateRegistry;

    public GradleBuildBuilder(BuildStateRegistry buildStateRegistry) {
        this.buildStateRegistry = buildStateRegistry;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.GradleBuild");
    }

    public DefaultGradleBuild create(BuildState target) {
        target.ensureProjectsLoaded();
        return this.convert(target, new LinkedHashMap<BuildState, DefaultGradleBuild>());
    }

    private DefaultGradleBuild convert(BuildState targetBuild, Map<BuildState, DefaultGradleBuild> all) {
        DefaultGradleBuild model = all.get(targetBuild);
        if (model != null) {
            return model;
        }
        model = new DefaultGradleBuild();
        all.put(targetBuild, model);
        targetBuild.ensureProjectsLoaded();
        GradleInternal gradle = targetBuild.getMutableModel();
        this.addProjects(targetBuild, model);
        this.addIncludedBuilds(gradle, model, all);
        if (gradle.getParent() == null) {
            ArrayList<DefaultGradleBuild> allBuilds = new ArrayList<DefaultGradleBuild>();
            this.buildStateRegistry.visitBuilds(buildState -> {
                if (buildState != targetBuild && buildState.isImportableBuild()) {
                    allBuilds.add(this.convert((BuildState)buildState, all));
                }
            });
            model.addBuilds(allBuilds);
        }
        return model;
    }

    private void addIncludedBuilds(GradleInternal gradle, DefaultGradleBuild model, Map<BuildState, DefaultGradleBuild> all) {
        for (IncludedBuildInternal reference : gradle.includedBuilds()) {
            BuildState target = reference.getTarget();
            if (target instanceof IncludedBuildState) {
                IncludedBuildState includedBuildState = (IncludedBuildState)target;
                DefaultGradleBuild convertedIncludedBuild = this.convert((BuildState)includedBuildState, all);
                model.addIncludedBuild(convertedIncludedBuild);
                continue;
            }
            if (target instanceof RootBuildState) {
                DefaultGradleBuild rootBuild = this.convert(target, all);
                model.addIncludedBuild(rootBuild);
                continue;
            }
            throw new IllegalStateException("Unknown build type: " + reference.getClass().getName());
        }
    }

    private void addProjects(BuildState target, DefaultGradleBuild model) {
        LinkedHashMap<ProjectState, BasicGradleProject> convertedProjects = new LinkedHashMap<ProjectState, BasicGradleProject>();
        ProjectState rootProject = target.getProjects().getRootProject();
        BasicGradleProject convertedRootProject = this.convert(target, rootProject, convertedProjects);
        model.setRootProject(convertedRootProject);
        for (ProjectState project : target.getProjects().getAllProjects()) {
            model.addProject((PartialBasicGradleProject)convertedProjects.get(project));
        }
    }

    private BasicGradleProject convert(BuildState owner, ProjectState project, Map<ProjectState, BasicGradleProject> convertedProjects) {
        DefaultProjectIdentifier id = new DefaultProjectIdentifier(owner.getBuildRootDir(), project.getProjectPath().getPath());
        BasicGradleProject converted = new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id).setBuildTreePath(project.getIdentityPath().getPath()).setProjectDirectory(project.getProjectDir());
        if (project.getBuildParent() != null) {
            converted.setParent(convertedProjects.get(project.getBuildParent()));
        }
        convertedProjects.put(project, converted);
        for (ProjectState child : project.getChildProjects()) {
            converted.addChild(this.convert(owner, child, convertedProjects));
        }
        return converted;
    }
}

