/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.evaluation;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.evaluation.CircularEvaluationException;
import org.gradle.internal.evaluation.EvaluationOwner;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.gradle.internal.evaluation.ScopedEvaluation;

public final class EvaluationContext {
    private static final int EXPECTED_MAX_CONTEXT_SIZE = 64;
    private static final EvaluationContext INSTANCE = new EvaluationContext();
    private final ThreadLocal<PerThreadContext> threadLocalContext = ThreadLocal.withInitial(() -> new PerThreadContext(null));

    public static EvaluationContext current() {
        return INSTANCE;
    }

    private EvaluationContext() {
    }

    public EvaluationScopeContext open(EvaluationOwner owner) {
        return this.getContext().open(owner);
    }

    @Nullable
    public EvaluationOwner getOwner() {
        return this.getContext().getOwner();
    }

    public boolean isEvaluating() {
        return this.getOwner() != null;
    }

    public <R, E extends Exception> R evaluate(EvaluationOwner owner, ScopedEvaluation<? extends R, E> evaluation) throws E {
        try (EvaluationScopeContext ignored = this.open(owner);){
            R r = evaluation.evaluate();
            return r;
        }
    }

    public <R, E extends Exception> R tryEvaluate(EvaluationOwner owner, R fallbackValue, ScopedEvaluation<? extends R, E> evaluation) throws E {
        if (this.getContext().isInScope(owner)) {
            return fallbackValue;
        }
        return this.evaluate(owner, evaluation);
    }

    public <R, E extends Exception> R evaluateNested(ScopedEvaluation<? extends R, E> evaluation) throws E {
        try (EvaluationScopeContext ignored = this.nested();){
            R r = evaluation.evaluate();
            return r;
        }
    }

    private PerThreadContext getContext() {
        return this.threadLocalContext.get();
    }

    private PerThreadContext setContext(PerThreadContext newContext) {
        this.threadLocalContext.set(newContext);
        return newContext;
    }

    EvaluationScopeContext nested() {
        return this.getContext().nested();
    }

    private final class PerThreadContext
    implements EvaluationScopeContext {
        private final Set<EvaluationOwner> objectsInScope = new ReferenceOpenHashSet(64);
        private final List<EvaluationOwner> evaluationStack = new ReferenceArrayList(64);
        @Nullable
        private final PerThreadContext parent;

        public PerThreadContext(PerThreadContext parent) {
            this.parent = parent;
        }

        private void push(EvaluationOwner owner) {
            if (!this.objectsInScope.add(owner)) {
                throw this.prepareException(owner);
            }
            this.evaluationStack.add(owner);
        }

        private void pop() {
            EvaluationOwner removed = this.evaluationStack.remove(this.evaluationStack.size() - 1);
            this.objectsInScope.remove(removed);
        }

        public PerThreadContext open(EvaluationOwner owner) {
            this.push(owner);
            return this;
        }

        @Override
        public EvaluationScopeContext nested() {
            return EvaluationContext.this.setContext(new PerThreadContext(this));
        }

        @Override
        public void close() {
            if (this.parent != null && this.evaluationStack.isEmpty()) {
                EvaluationContext.this.setContext(this.parent);
                return;
            }
            this.pop();
        }

        public boolean isInScope(EvaluationOwner owner) {
            return this.objectsInScope.contains(owner);
        }

        @Override
        @Nullable
        public EvaluationOwner getOwner() {
            if (this.evaluationStack.isEmpty()) {
                return null;
            }
            return this.evaluationStack.get(this.evaluationStack.size() - 1);
        }

        private CircularEvaluationException prepareException(EvaluationOwner circular) {
            int i = this.evaluationStack.indexOf(circular);
            assert (i >= 0);
            List<EvaluationOwner> preCycleList = this.evaluationStack.subList(i, this.evaluationStack.size());
            ImmutableList evaluationCycle = ImmutableList.builderWithExpectedSize((int)(preCycleList.size() + 1)).addAll(preCycleList).add((Object)circular).build();
            return new CircularEvaluationException((List<EvaluationOwner>)evaluationCycle);
        }
    }
}

