/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.NonNullApi;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.buildtree.BuildTreeModelController;
import org.gradle.internal.buildtree.BuildTreeModelSideEffect;
import org.gradle.internal.buildtree.BuildTreeModelSideEffectExecutor;
import org.gradle.internal.buildtree.BuildTreeModelTarget;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.tooling.internal.gradle.GradleBuildIdentity;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalActionAwareBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalStreamedValueRelay;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.serialization.StreamedValue;
import org.gradle.tooling.provider.model.UnknownModelException;

@NonNullApi
class DefaultBuildController
implements InternalBuildController,
InternalBuildControllerVersion2,
InternalActionAwareBuildController,
InternalStreamedValueRelay {
    private final WorkerThreadRegistry workerThreadRegistry;
    private final BuildTreeModelController controller;
    private final BuildCancellationToken cancellationToken;
    private final BuildEventConsumer buildEventConsumer;
    private final BuildTreeModelSideEffectExecutor sideEffectExecutor;
    private final PayloadSerializer payloadSerializer;

    public DefaultBuildController(BuildTreeModelController controller, WorkerThreadRegistry workerThreadRegistry, BuildCancellationToken cancellationToken, BuildEventConsumer buildEventConsumer, BuildTreeModelSideEffectExecutor sideEffectExecutor, PayloadSerializer payloadSerializer) {
        this.workerThreadRegistry = workerThreadRegistry;
        this.controller = controller;
        this.cancellationToken = cancellationToken;
        this.buildEventConsumer = buildEventConsumer;
        this.sideEffectExecutor = sideEffectExecutor;
        this.payloadSerializer = payloadSerializer;
    }

    @Deprecated
    public BuildResult<?> getBuildModel() throws BuildExceptionVersion1 {
        this.assertCanQuery();
        return new ProviderBuildResult((Object)this.controller.getConfiguredModel());
    }

    @Deprecated
    public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        return this.getModel(target, modelIdentifier, null);
    }

    public BuildResult<?> getModel(@Nullable Object target, ModelIdentifier modelIdentifier, Object parameter) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        this.assertCanQuery();
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException(String.format("Could not build '%s' model. Build cancelled.", modelIdentifier.getName()));
        }
        BuildTreeModelTarget scopedTarget = DefaultBuildController.resolveTarget(target);
        try {
            Object model = this.controller.getModel(scopedTarget, modelIdentifier.getName(), parameter);
            return new ProviderBuildResult(model);
        }
        catch (UnknownModelException e) {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
        }
    }

    private static BuildTreeModelTarget resolveTarget(@Nullable Object target) {
        if (target == null) {
            return BuildTreeModelTarget.ofDefault();
        }
        if (target instanceof GradleProjectIdentity) {
            GradleProjectIdentity projectIdentity = (GradleProjectIdentity)target;
            return BuildTreeModelTarget.ofProject((File)projectIdentity.getRootDir(), (String)projectIdentity.getProjectPath());
        }
        if (target instanceof GradleBuildIdentity) {
            GradleBuildIdentity buildIdentity = (GradleBuildIdentity)target;
            return BuildTreeModelTarget.ofBuild((File)buildIdentity.getRootDir());
        }
        throw new IllegalArgumentException("Don't know how to build models for " + target);
    }

    public boolean getCanQueryProjectModelInParallel(Class<?> modelType) {
        return this.controller.queryModelActionsRunInParallel();
    }

    public <T> List<T> run(List<Supplier<T>> actions) {
        this.assertCanQuery();
        return this.controller.runQueryModelActions(actions);
    }

    private void assertCanQuery() {
        if (!this.workerThreadRegistry.isWorkerThread()) {
            throw new IllegalStateException("A build controller cannot be used from a thread that is not managed by Gradle.");
        }
    }

    public void dispatch(Object value) {
        SerializedPayload serializedModel = this.payloadSerializer.serialize(value);
        StreamedValue streamedValue = new StreamedValue(serializedModel);
        BuildEventConsumer buildEventConsumer = this.buildEventConsumer;
        this.sideEffectExecutor.runIsolatableSideEffect((BuildTreeModelSideEffect & Serializable)() -> buildEventConsumer.dispatch((Object)streamedValue));
    }
}

