/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.AbstractListSnapshot;
import org.gradle.internal.snapshot.impl.ListValueSnapshot;

public class IsolatedList
extends AbstractListSnapshot<Isolatable<?>>
implements Isolatable<List<Object>> {
    public static final IsolatedList EMPTY = new IsolatedList((ImmutableList<Isolatable<?>>)ImmutableList.of());

    public IsolatedList(ImmutableList<Isolatable<?>> elements) {
        super(elements);
    }

    public ValueSnapshot asSnapshot() {
        if (this.elements.isEmpty()) {
            return ListValueSnapshot.EMPTY;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.elements.size());
        for (Isolatable element : this.elements) {
            builder.add((Object)element.asSnapshot());
        }
        return new ListValueSnapshot((ImmutableList<ValueSnapshot>)builder.build());
    }

    public List<Object> isolate() {
        ArrayList<Object> list = new ArrayList<Object>(this.elements.size());
        for (Isolatable element : this.elements) {
            list.add(element.isolate());
        }
        return list;
    }

    @Nullable
    public <S> S coerce(Class<S> type) {
        Object result = null;
        if (List.class.isAssignableFrom(type)) {
            try {
                result = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Isolatable element : this.elements) {
                    ((List)result).add(element.isolate());
                }
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }
}

