/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.DefaultBuildOperationIdFactory;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.internal.consumer.ConnectionFactory;
import org.gradle.tooling.internal.consumer.DefaultCancellationTokenSource;
import org.gradle.tooling.internal.consumer.DefaultExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.ExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.SynchronizedLogging;
import org.gradle.tooling.internal.consumer.loader.CachingToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.DefaultToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.SynchronizedToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class ConnectorServices {
    private static CloseableServiceRegistry singletonRegistry = ConnectorServiceRegistry.access$000();

    public static DefaultGradleConnector createConnector() {
        return (DefaultGradleConnector)singletonRegistry.getFactory(DefaultGradleConnector.class).create();
    }

    public static CancellationTokenSource createCancellationTokenSource() {
        return new DefaultCancellationTokenSource();
    }

    public static void close() {
        singletonRegistry.close();
    }

    public static void reset() {
        singletonRegistry.close();
        singletonRegistry = ConnectorServiceRegistry.create();
    }

    private static class ConnectorServiceRegistry
    implements ServiceRegistrationProvider {
        private ConnectorServiceRegistry() {
        }

        private static CloseableServiceRegistry create() {
            return ServiceRegistryBuilder.builder().displayName("connector services").provider((ServiceRegistrationProvider)new ConnectorServiceRegistry()).build();
        }

        @Provides
        protected Factory<DefaultGradleConnector> createConnectorFactory(final ConnectionFactory connectionFactory, final DistributionFactory distributionFactory) {
            return new Factory<DefaultGradleConnector>(){

                public DefaultGradleConnector create() {
                    return new DefaultGradleConnector(connectionFactory, distributionFactory);
                }
            };
        }

        @Provides
        protected ExecutorFactory createExecutorFactory() {
            return new DefaultExecutorFactory();
        }

        @Provides
        protected ExecutorServiceFactory createExecutorServiceFactory() {
            return new DefaultExecutorServiceFactory();
        }

        @Provides
        protected Clock createTimeProvider() {
            return Time.clock();
        }

        @Provides
        protected DistributionFactory createDistributionFactory(Clock clock) {
            return new DistributionFactory(clock);
        }

        @Provides
        protected ToolingImplementationLoader createToolingImplementationLoader() {
            return new SynchronizedToolingImplementationLoader(new CachingToolingImplementationLoader(new DefaultToolingImplementationLoader()));
        }

        @Provides
        protected BuildOperationIdFactory createBuildOperationIdFactory() {
            return new DefaultBuildOperationIdFactory();
        }

        @Provides
        protected LoggingProvider createLoggingProvider(Clock clock, BuildOperationIdFactory buildOperationIdFactory) {
            return new SynchronizedLogging(clock, buildOperationIdFactory);
        }

        @Provides
        protected ConnectionFactory createConnectionFactory(ToolingImplementationLoader toolingImplementationLoader, ExecutorFactory executorFactory, LoggingProvider loggingProvider) {
            return new ConnectionFactory(toolingImplementationLoader, executorFactory, loggingProvider);
        }
    }
}

