/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.util.Collection;
import java.util.Objects;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongSpliterators;

public interface LongCollection
extends LongIterable,
Collection<Long> {
    @Override
    public LongIterator iterator();

    @Override
    default public LongSpliterator spliterator() {
        return LongSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(long var1);

    public boolean contains(long var1);

    public boolean rem(long var1);

    @Override
    @Deprecated
    default public boolean add(Long key) {
        return this.add((long)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Long)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Long)key);
    }

    public long[] toLongArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Long> filter) {
        return this.removeIf(filter instanceof LongPredicate ? (LongPredicate)((Object)filter) : key -> filter.test(key));
    }

    default public boolean removeIf(LongPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        LongIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextLong())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Long> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Long> parallelStream() {
        return Collection.super.parallelStream();
    }
}

