/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.ReferenceTracker;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedLocalFunctionDeclarationsKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00122\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UnusedInstanceCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "<init>", "()V", "tracker", "Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "removableDeclarations", "", "getRemovableDeclarations", "()Ljava/util/List;", "visit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isLocalFunctionDeclaration", "jsVar", "js.translator"})
@SourceDebugExtension(value={"SMAP\nremoveUnusedLocalFunctionDeclarations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 removeUnusedLocalFunctionDeclarations.kt\norg/jetbrains/kotlin/js/inline/clean/UnusedInstanceCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1863#2,2:100\n1#3:102\n*S KotlinDebug\n*F\n+ 1 removeUnusedLocalFunctionDeclarations.kt\norg/jetbrains/kotlin/js/inline/clean/UnusedInstanceCollector\n*L\n58#1:100,2\n*E\n"})
final class UnusedInstanceCollector
extends JsVisitorWithContextImpl {
    @NotNull
    private final ReferenceTracker<JsName, JsStatement> tracker = new ReferenceTracker();

    @NotNull
    public final List<JsStatement> getRemovableDeclarations() {
        return this.tracker.getRemovable();
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        JsStatement currentStatement;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (!this.isLocalFunctionDeclaration(x)) {
            return super.visit(x, ctx);
        }
        JsName jsName = x.getName();
        Intrinsics.checkNotNull((Object)jsName);
        JsName name2 = jsName;
        JsContext<JsStatement> jsContext = this.getLastStatementLevelContext();
        Intrinsics.checkNotNullExpressionValue(jsContext, (String)"getLastStatementLevelContext(...)");
        JsContext<JsStatement> statementContext = jsContext;
        JsStatement jsStatement = currentStatement = statementContext.getCurrentNode();
        Intrinsics.checkNotNull((Object)jsStatement);
        this.tracker.addCandidateForRemoval(name2, (JsStatement)((JsNode)jsStatement));
        Set<JsName> references = CollectUtilsKt.collectUsedNames(x);
        Iterable $this$forEach$iv = references;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName it = (JsName)element$iv;
            boolean bl = false;
            this.tracker.addRemovableReference(name2, it);
        }
        return false;
    }

    public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsNameRef q = x;
        while (q != null) {
            if (q.getName() != null) {
                JsName it;
                boolean bl = false;
                this.tracker.markReachable(it);
            }
            JsExpression jsExpression = q.getQualifier();
            q = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLocalFunctionDeclaration(JsVars.JsVar jsVar) {
        JsName name2 = jsVar.getName();
        JsExpression expr = jsVar.getInitExpression();
        if (expr instanceof JsNameRef) {
            boolean bl;
            JsName jsName = ((JsNameRef)expr).getName();
            if (jsName != null) {
                JsName it = jsName;
                boolean bl2 = false;
                bl = this.tracker.isReferenceToRemovableCandidate(it);
            } else {
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        JsName jsName = name2;
        if (jsName == null) return false;
        JsNode jsNode = MetadataProperties.getStaticRef(jsName);
        JsNode staticRef = jsNode;
        if (staticRef == null) return false;
        if (!Intrinsics.areEqual((Object)staticRef, (Object)expr)) return false;
        Intrinsics.checkNotNull((Object)expr);
        if (!RemoveUnusedLocalFunctionDeclarationsKt.access$isFunctionReference(expr)) return false;
        return true;
    }
}

