/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml.acs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.onelogin.saml2.Auth;
import com.onelogin.saml2.authn.AuthnRequestParams;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.exception.ValidationError;
import com.onelogin.saml2.settings.Saml2Settings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.saml.acs.AssertedIdentity;
import org.apache.guacamole.auth.saml.acs.SAMLAuthenticationSession;
import org.apache.guacamole.auth.saml.acs.SAMLAuthenticationSessionManager;
import org.apache.guacamole.auth.saml.conf.ConfigurationService;
import org.apache.guacamole.net.auth.IdentifierGenerator;
import org.xml.sax.SAXException;

@Singleton
public class SAMLService {
    @Inject
    private ConfigurationService confService;
    @Inject
    private SAMLAuthenticationSessionManager sessionManager;

    public URI createRequest() throws GuacamoleException {
        Saml2Settings samlSettings = this.confService.getSamlSettings();
        try {
            Auth auth = new Auth(samlSettings, null, null);
            String identifier = IdentifierGenerator.generateIdentifier();
            String requestUrl = auth.login(identifier, new AuthnRequestParams(false, false, true), Boolean.valueOf(true));
            SAMLAuthenticationSession session = new SAMLAuthenticationSession(auth.getLastRequestId(), (long)this.confService.getAuthenticationTimeout() * 60000L);
            this.sessionManager.defer(session, identifier);
            return new URI(requestUrl);
        }
        catch (IOException e) {
            throw new GuacamoleServerException("SAML authentication request could not be encoded: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new GuacamoleServerException("SAML IdP redirect could not be generated due to an error in the URI syntax: " + e.getMessage());
        }
        catch (SettingsException e) {
            throw new GuacamoleServerException("Error while attempting to sign request using provided private key / certificate: " + e.getMessage(), (Throwable)e);
        }
    }

    public SAMLAuthenticationSession processResponse(String url, String relayState, String encodedResponse) throws GuacamoleException {
        if (relayState == null) {
            throw new GuacamoleSecurityException("\"RelayState\" value is missing from SAML response.");
        }
        SAMLAuthenticationSession session = (SAMLAuthenticationSession)this.sessionManager.resume(relayState);
        if (session == null) {
            throw new GuacamoleSecurityException("\"RelayState\" value included with SAML response is not valid.");
        }
        try {
            SamlResponse response = new SamlResponse(this.confService.getSamlSettings(), url, encodedResponse);
            if (!response.isValid(session.getRequestID())) {
                Exception validationException = response.getValidationException();
                throw new GuacamoleSecurityException("SAML response did not pass validation: " + validationException.getMessage(), (Throwable)validationException);
            }
            session.setIdentity(new AssertedIdentity(response));
            return session;
        }
        catch (ValidationError e) {
            throw new GuacamoleSecurityException("SAML response did not pass validation: " + e.getMessage(), (Throwable)e);
        }
        catch (SettingsException e) {
            throw new GuacamoleServerException("Current SAML settings are insufficient to decrypt/parse the received SAML response.", (Throwable)e);
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new GuacamoleServerException("XML contents of SAML response could not be parsed.", (Throwable)e);
        }
        catch (IOException e) {
            throw new GuacamoleServerException("Contents of SAML response could not be decrypted/read.", (Throwable)e);
        }
    }
}

